%------------------------------------------------------------------------------
% File     : LCL949_4 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Set Theory
% Problem  : Goedel translation of SET054+1
% Version  : [QMLTP] axioms.
% English  : 

% Refs     : [Goe69] Goedel (1969), An Interpretation of the Intuitionistic
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : GSE054+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :  124 (   3 unt;  36 typ;   0 def)
%            Number of atoms       :  975 (   0 equ)
%            Maximal formula atoms :   24 (  11 avg)
%            Number of connectives :  895 (   8   ~;   5   |;  73   &)
%                                         (   0 <=>; 809  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   24 (  15 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   51 (  29   >;  22   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   8 usr;   0 prp; 2-3 aty)
%            Number of functors    :   27 (  27 usr;   6 con; 0-3 aty)
%            Number of variables   :  735 (; 729   !;   6   ?; 735   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S4, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_reflexive,axiom,
    ! [W: '$ki_world'] : '$ki_accessible'(W,W) ).

tff(mrel_transitive,axiom,
    ! [W: '$ki_world',V: '$ki_world',U: '$ki_world'] :
      ( ( '$ki_accessible'(W,V)
        & '$ki_accessible'(V,U) )
     => '$ki_accessible'(W,U) ) ).

tff(universal_class_decl,type,
    universal_class: $i ).

tff(identity_relation_decl,type,
    identity_relation: $i ).

tff(successor_relation_decl,type,
    successor_relation: $i ).

tff(element_relation_decl,type,
    element_relation: $i ).

tff(null_class_decl,type,
    null_class: $i ).

tff(qmltpeq_decl,type,
    qmltpeq: ( '$ki_world' * $i * $i ) > $o ).

tff(inductive_decl,type,
    inductive: ( '$ki_world' * $i ) > $o ).

tff(disjoint_decl,type,
    disjoint: ( '$ki_world' * $i * $i ) > $o ).

tff(function_decl,type,
    function: ( '$ki_world' * $i ) > $o ).

tff(member_decl,type,
    member: ( '$ki_world' * $i * $i ) > $o ).

tff(subclass_decl,type,
    subclass: ( '$ki_world' * $i * $i ) > $o ).

tff(singleton_decl,type,
    singleton: $i > $i ).

tff(image_decl,type,
    image: ( $i * $i ) > $i ).

tff(inverse_decl,type,
    inverse: $i > $i ).

tff(rotate_decl,type,
    rotate: $i > $i ).

tff(unordered_pair_decl,type,
    unordered_pair: ( $i * $i ) > $i ).

tff(successor_decl,type,
    successor: $i > $i ).

tff(apply_decl,type,
    apply: ( $i * $i ) > $i ).

tff(power_class_decl,type,
    power_class: $i > $i ).

tff(range_of_decl,type,
    range_of: $i > $i ).

tff(union_decl,type,
    union: ( $i * $i ) > $i ).

tff(restrict_decl,type,
    restrict: ( $i * $i * $i ) > $i ).

tff(second_decl,type,
    second: $i > $i ).

tff(ordered_pair_decl,type,
    ordered_pair: ( $i * $i ) > $i ).

tff(domain_of_decl,type,
    domain_of: $i > $i ).

tff(sum_class_decl,type,
    sum_class: $i > $i ).

tff(compose_decl,type,
    compose: ( $i * $i ) > $i ).

tff(intersection_decl,type,
    intersection: ( $i * $i ) > $i ).

tff(cross_product_decl,type,
    cross_product: ( $i * $i ) > $i ).

tff(complement_decl,type,
    complement: $i > $i ).

tff(flip_decl,type,
    flip: $i > $i ).

tff(first_decl,type,
    first: $i > $i ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_const',axiom,
    ! [W: '$ki_world',X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(reflexivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,X,X) ) ) ) ).

tff(symmetry,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,X,Y) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,Y,X) ) ) ) ) ) ) ) ).

tff(transitivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,X,Y) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,Y,Z) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,X,Z) ) ) ) ) ) ) ) ) ) ).

tff(apply_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,apply(A,C),apply(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(apply_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,apply(C,A),apply(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(complement_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,complement(A),complement(B)) ) ) ) ) ) ) ) ).

tff(compose_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,compose(A,C),compose(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(compose_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,compose(C,A),compose(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(cross_product_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,cross_product(A,C),cross_product(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(cross_product_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,cross_product(C,A),cross_product(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(domain_of_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,domain_of(A),domain_of(B)) ) ) ) ) ) ) ) ).

tff(first_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,first(A),first(B)) ) ) ) ) ) ) ) ).

tff(flip_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,flip(A),flip(B)) ) ) ) ) ) ) ) ).

tff(image_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,image(A,C),image(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(image_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,image(C,A),image(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(intersection_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,intersection(A,C),intersection(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(intersection_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,intersection(C,A),intersection(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(inverse_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,inverse(A),inverse(B)) ) ) ) ) ) ) ) ).

tff(ordered_pair_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,ordered_pair(A,C),ordered_pair(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(ordered_pair_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,ordered_pair(C,A),ordered_pair(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(power_class_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,power_class(A),power_class(B)) ) ) ) ) ) ) ) ).

tff(range_of_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,range_of(A),range_of(B)) ) ) ) ) ) ) ) ).

tff(restrict_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => qmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => qmltpeq(W4,restrict(A,C,D),restrict(B,C,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(restrict_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => qmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => qmltpeq(W4,restrict(C,A,D),restrict(C,B,D)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(restrict_substitution_3,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => qmltpeq(W4,A,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => qmltpeq(W4,restrict(C,D,A),restrict(C,D,B)) ) ) ) ) ) ) ) ) ) ) ) ).

tff(rotate_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,rotate(A),rotate(B)) ) ) ) ) ) ) ) ).

tff(second_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,second(A),second(B)) ) ) ) ) ) ) ) ).

tff(singleton_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,singleton(A),singleton(B)) ) ) ) ) ) ) ) ).

tff(successor_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,successor(A),successor(B)) ) ) ) ) ) ) ) ).

tff(sum_class_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,sum_class(A),sum_class(B)) ) ) ) ) ) ) ) ).

tff(union_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,union(A,C),union(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(union_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,union(C,A),union(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(unordered_pair_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,unordered_pair(A,C),unordered_pair(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(unordered_pair_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,unordered_pair(C,A),unordered_pair(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(disjoint_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => disjoint(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => disjoint(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(disjoint_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => disjoint(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => disjoint(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(function_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,A,B) )
                          & ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => function(W2,A) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => function(W2,B) ) ) ) ) ) ) ) ).

tff(inductive_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,A,B) )
                          & ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => inductive(W2,A) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => inductive(W2,B) ) ) ) ) ) ) ) ).

tff(member_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => member(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(member_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => member(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(subclass_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => subclass(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => subclass(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(subclass_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => subclass(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => subclass(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(subclass_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subclass(W2,X,Y) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [U: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,U)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,U,X) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,U,Y) ) ) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [U: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,U)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,U,X) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,U,Y) ) ) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subclass(W2,X,Y) ) ) ) ) ) ) ) ) ).

tff(class_elements_are_sets,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => subclass(W0,X,universal_class) ) ) ) ).

tff(extensionality,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,X,Y) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subclass(W2,X,Y) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subclass(W2,Y,X) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subclass(W2,X,Y) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subclass(W2,Y,X) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,X,Y) ) ) ) ) ) ) ) ) ).

tff(unordered_pair_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [U: $i] :
          ( '$ki_exists_in_world_$i'(W,U)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,U,unordered_pair(X,Y)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,U,universal_class) )
                                    & ( ! [W3: '$ki_world'] :
                                          ( '$ki_accessible'(W2,W3)
                                         => qmltpeq(W3,U,X) )
                                      | ! [W3: '$ki_world'] :
                                          ( '$ki_accessible'(W2,W3)
                                         => qmltpeq(W3,U,Y) ) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,U,universal_class) )
                                    & ( ! [W3: '$ki_world'] :
                                          ( '$ki_accessible'(W2,W3)
                                         => qmltpeq(W3,U,X) )
                                      | ! [W3: '$ki_world'] :
                                          ( '$ki_accessible'(W2,W3)
                                         => qmltpeq(W3,U,Y) ) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,U,unordered_pair(X,Y)) ) ) ) ) ) ) ) ) ) ) ).

tff(unordered_pair_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => member(W1,unordered_pair(X,Y),universal_class) ) ) ) ) ) ).

tff(singleton_set_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,singleton(X),unordered_pair(X,X)) ) ) ) ).

tff(ordered_pair_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => qmltpeq(W1,ordered_pair(X,Y),unordered_pair(singleton(X),unordered_pair(X,singleton(Y)))) ) ) ) ) ) ).

tff(cross_product_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [U: $i] :
          ( '$ki_exists_in_world_$i'(W,U)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [V: $i] :
                  ( '$ki_exists_in_world_$i'(W0,V)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [X: $i] :
                          ( '$ki_exists_in_world_$i'(W1,X)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Y: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Y)
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(U,V),cross_product(X,Y)) )
                                         => ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,U,X) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,V,Y) ) ) ) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,U,X) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,V,Y) ) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(U,V),cross_product(X,Y)) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(cross_product_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => member(W3,Z,cross_product(X,Y)) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,Z,ordered_pair(first(Z),second(Z))) ) ) ) ) ) ) ) ) ) ).

tff(element_relation_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,ordered_pair(X,Y),element_relation) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Y,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,X,Y) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Y,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,X,Y) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,ordered_pair(X,Y),element_relation) ) ) ) ) ) ) ) ) ).

tff(element_relation_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => subclass(W,element_relation,cross_product(universal_class,universal_class)) ) ).

tff(intersection_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,Z,intersection(X,Y)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,X) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,Y) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,X) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,Y) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,Z,intersection(X,Y)) ) ) ) ) ) ) ) ) ) ) ).

tff(complement_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Z: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Z)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,Z,complement(X)) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Z,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ~ ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,Z,X) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Z,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ~ ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,Z,X) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,Z,complement(X)) ) ) ) ) ) ) ) ) ).

tff(restrict_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [XR: $i] :
                  ( '$ki_exists_in_world_$i'(W0,XR)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Y: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Y)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,restrict(XR,X,Y),intersection(XR,cross_product(X,Y))) ) ) ) ) ) ) ) ).

tff(null_class_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ~ ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => member(W1,X,null_class) ) ) ) ) ).

tff(domain_of_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Z: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Z)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,Z,domain_of(X)) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Z,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ~ ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,restrict(X,singleton(Z),universal_class),null_class) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Z,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ~ ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,restrict(X,singleton(Z),universal_class),null_class) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,Z,domain_of(X)) ) ) ) ) ) ) ) ) ).

tff(rotate_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [U: $i] :
                  ( '$ki_exists_in_world_$i'(W0,U)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [V: $i] :
                          ( '$ki_exists_in_world_$i'(W1,V)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [W: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,W)
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(ordered_pair(U,V),W),rotate(X)) )
                                         => ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(U,V),W),cross_product(cross_product(universal_class,universal_class),universal_class)) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(V,W),U),X) ) ) ) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(U,V),W),cross_product(cross_product(universal_class,universal_class),universal_class)) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(V,W),U),X) ) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(ordered_pair(U,V),W),rotate(X)) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(rotate_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => subclass(W0,rotate(X),cross_product(cross_product(universal_class,universal_class),universal_class)) ) ) ) ).

tff(flip_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [U: $i] :
          ( '$ki_exists_in_world_$i'(W,U)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [V: $i] :
                  ( '$ki_exists_in_world_$i'(W0,V)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [W: $i] :
                          ( '$ki_exists_in_world_$i'(W1,W)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [X: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,X)
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(ordered_pair(U,V),W),flip(X)) )
                                         => ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(U,V),W),cross_product(cross_product(universal_class,universal_class),universal_class)) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(V,U),W),X) ) ) ) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(U,V),W),cross_product(cross_product(universal_class,universal_class),universal_class)) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,ordered_pair(ordered_pair(V,U),W),X) ) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(ordered_pair(U,V),W),flip(X)) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(flip_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => subclass(W0,flip(X),cross_product(cross_product(universal_class,universal_class),universal_class)) ) ) ) ).

tff(union_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,Z,union(X,Y)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,X) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,Y) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,X) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,Z,Y) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,Z,union(X,Y)) ) ) ) ) ) ) ) ) ) ) ).

tff(successor_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,successor(X),union(X,singleton(X))) ) ) ) ).

tff(successor_relation_defn1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => subclass(W,successor_relation,cross_product(universal_class,universal_class)) ) ).

tff(successor_relation_defn2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,ordered_pair(X,Y),successor_relation) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,X,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Y,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => qmltpeq(W2,successor(X),Y) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,X,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,Y,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => qmltpeq(W2,successor(X),Y) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,ordered_pair(X,Y),successor_relation) ) ) ) ) ) ) ) ) ).

tff(inverse_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [Y: $i] :
          ( '$ki_exists_in_world_$i'(W,Y)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,inverse(Y),domain_of(flip(cross_product(Y,universal_class)))) ) ) ) ).

tff(range_of_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [Z: $i] :
          ( '$ki_exists_in_world_$i'(W,Z)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,range_of(Z),domain_of(inverse(Z))) ) ) ) ).

tff(image_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [XR: $i] :
                  ( '$ki_exists_in_world_$i'(W0,XR)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => qmltpeq(W1,image(XR,X),range_of(restrict(XR,X,universal_class))) ) ) ) ) ) ).

tff(inductive_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ( ! [W0: '$ki_world'] :
                ( '$ki_accessible'(W,W0)
               => ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => inductive(W1,X) )
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => member(W1,null_class,X) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => subclass(W1,image(successor_relation,X),X) ) ) ) )
            & ! [W0: '$ki_world'] :
                ( '$ki_accessible'(W,W0)
               => ( ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => member(W1,null_class,X) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => subclass(W1,image(successor_relation,X),X) ) )
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => inductive(W1,X) ) ) ) ) ) ) ).

tff(infinity,axiom,
    ? [X: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',X)
      & ! [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
         => member(W,X,universal_class) )
      & ! [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
         => inductive(W,X) )
      & ! [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
         => ! [Y: $i] :
              ( '$ki_exists_in_world_$i'(W,Y)
             => ! [W0: '$ki_world'] :
                  ( '$ki_accessible'(W,W0)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => inductive(W1,Y) )
                   => ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => subclass(W1,X,Y) ) ) ) ) ) ) ).

tff(sum_class_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [U: $i] :
          ( '$ki_exists_in_world_$i'(W,U)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,U,sum_class(X)) )
                         => ? [Y: $i] :
                              ( '$ki_exists_in_world_$i'(W1,Y)
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,U,Y) )
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,Y,X) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ? [Y: $i] :
                              ( '$ki_exists_in_world_$i'(W1,Y)
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,U,Y) )
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,Y,X) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,U,sum_class(X)) ) ) ) ) ) ) ) ) ).

tff(sum_class_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => member(W1,X,universal_class) )
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => member(W1,sum_class(X),universal_class) ) ) ) ) ) ).

tff(power_class_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [U: $i] :
          ( '$ki_exists_in_world_$i'(W,U)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [X: $i] :
                  ( '$ki_exists_in_world_$i'(W0,X)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,U,power_class(X)) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,U,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subclass(W2,U,X) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => member(W2,U,universal_class) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subclass(W2,U,X) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,U,power_class(X)) ) ) ) ) ) ) ) ) ).

tff(power_class_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [U: $i] :
          ( '$ki_exists_in_world_$i'(W,U)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => member(W1,U,universal_class) )
               => ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => member(W1,power_class(U),universal_class) ) ) ) ) ) ).

tff(compose_defn1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [XR: $i] :
          ( '$ki_exists_in_world_$i'(W,XR)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [YR: $i] :
                  ( '$ki_exists_in_world_$i'(W0,YR)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => subclass(W1,compose(YR,XR),cross_product(universal_class,universal_class)) ) ) ) ) ) ).

tff(compose_defn2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [XR: $i] :
          ( '$ki_exists_in_world_$i'(W,XR)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [YR: $i] :
                  ( '$ki_exists_in_world_$i'(W0,YR)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [U: $i] :
                          ( '$ki_exists_in_world_$i'(W1,U)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [V: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,V)
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(U,V),compose(YR,XR)) )
                                         => ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,U,universal_class) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,V,image(YR,image(YR,singleton(U)))) ) ) ) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ( ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,U,universal_class) )
                                            & ! [W4: '$ki_world'] :
                                                ( '$ki_accessible'(W3,W4)
                                               => member(W4,V,image(YR,image(YR,singleton(U)))) ) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,ordered_pair(U,V),compose(YR,XR)) ) ) ) ) ) ) ) ) ) ) ) ) ).

tff(function_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [XF: $i] :
          ( '$ki_exists_in_world_$i'(W,XF)
         => ( ! [W0: '$ki_world'] :
                ( '$ki_accessible'(W,W0)
               => ( ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => function(W1,XF) )
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => subclass(W1,XF,cross_product(universal_class,universal_class)) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => subclass(W1,compose(XF,inverse(XF)),identity_relation) ) ) ) )
            & ! [W0: '$ki_world'] :
                ( '$ki_accessible'(W,W0)
               => ( ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => subclass(W1,XF,cross_product(universal_class,universal_class)) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => subclass(W1,compose(XF,inverse(XF)),identity_relation) ) )
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => function(W1,XF) ) ) ) ) ) ) ).

tff(replacement,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [XF: $i] :
                  ( '$ki_exists_in_world_$i'(W0,XF)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,universal_class) )
                          & ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => function(W2,XF) ) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => member(W2,image(XF,X),universal_class) ) ) ) ) ) ) ) ).

tff(disjoint_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => disjoint(W2,X,Y) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [U: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,U)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ~ ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,U,X) )
                                          & ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,U,Y) ) ) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [U: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,U)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ~ ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,U,X) )
                                          & ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,U,Y) ) ) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => disjoint(W2,X,Y) ) ) ) ) ) ) ) ) ).

tff(regularity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ( ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => ~ ! [W2: '$ki_world'] :
                          ( '$ki_accessible'(W1,W2)
                         => qmltpeq(W2,X,null_class) ) )
               => ? [U: $i] :
                    ( '$ki_exists_in_world_$i'(W0,U)
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => member(W1,U,universal_class) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => member(W1,U,X) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => disjoint(W1,U,X) ) ) ) ) ) ) ).

tff(apply_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [XF: $i] :
          ( '$ki_exists_in_world_$i'(W,XF)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => qmltpeq(W1,apply(XF,Y),sum_class(image(XF,singleton(Y)))) ) ) ) ) ) ).

tff(choice,axiom,
    ? [XF: $i] :
      ( '$ki_exists_in_world_$i'('$ki_local_world',XF)
      & ! [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
         => function(W,XF) )
      & ! [W: '$ki_world'] :
          ( '$ki_accessible'('$ki_local_world',W)
         => ! [Y: $i] :
              ( '$ki_exists_in_world_$i'(W,Y)
             => ! [W0: '$ki_world'] :
                  ( '$ki_accessible'(W,W0)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => member(W1,Y,universal_class) )
                   => ( ! [W1: '$ki_world'] :
                          ( '$ki_accessible'(W0,W1)
                         => qmltpeq(W1,Y,null_class) )
                      | ! [W1: '$ki_world'] :
                          ( '$ki_accessible'(W0,W1)
                         => member(W1,apply(XF,Y),Y) ) ) ) ) ) ) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => subclass(W0,X,X) ) ) ) ).

%------------------------------------------------------------------------------
