%------------------------------------------------------------------------------
% File     : LCL948_10 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Set Theory
% Problem  : Goedel translation of SET002+4
% Version  : [QMLTP] axioms.
% English  : 

% Refs     : [Goe69] Goedel (1969), An Interpretation of the Intuitionistic
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : GSE002+1 [QMLTP]

% Status   : CounterSatisfiable
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   53 (   2 unt;  17 typ;   0 def)
%            Number of atoms       :  438 (   0 equ)
%            Maximal formula atoms :   24 (  12 avg)
%            Number of connectives :  405 (   3   ~;   4   |;  28   &)
%                                         (   0 <=>; 370  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (  16 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   28 (  14   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   6 usr;   0 prp; 2-3 aty)
%            Number of functors    :   10 (  10 usr;   2 con; 0-2 aty)
%            Number of variables   :  333 (; 330   !;   3   ?; 333   :)
% SPC      : TF0_CSA_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant,
%            modal_system_S4, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_reflexive,axiom,
    ! [W: '$ki_world'] : '$ki_accessible'(W,W) ).

tff(mrel_transitive,axiom,
    ! [W: '$ki_world',V: '$ki_world',U: '$ki_world'] :
      ( ( '$ki_accessible'(W,V)
        & '$ki_accessible'(V,U) )
     => '$ki_accessible'(W,U) ) ).

tff(empty_set_decl,type,
    empty_set: $i ).

tff(qmltpeq_decl,type,
    qmltpeq: ( '$ki_world' * $i * $i ) > $o ).

tff(equal_set_decl,type,
    equal_set: ( '$ki_world' * $i * $i ) > $o ).

tff(member_decl,type,
    member: ( '$ki_world' * $i * $i ) > $o ).

tff(subset_decl,type,
    subset: ( '$ki_world' * $i * $i ) > $o ).

tff(singleton_decl,type,
    singleton: $i > $i ).

tff(product_decl,type,
    product: $i > $i ).

tff(unordered_pair_decl,type,
    unordered_pair: ( $i * $i ) > $i ).

tff(intersection_decl,type,
    intersection: ( $i * $i ) > $i ).

tff(difference_decl,type,
    difference: ( $i * $i ) > $i ).

tff(sum_decl,type,
    sum: $i > $i ).

tff(union_decl,type,
    union: ( $i * $i ) > $i ).

tff(power_set_decl,type,
    power_set: $i > $i ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(reflexivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,X,X) ) ) ) ).

tff(symmetry,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,X,Y) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,Y,X) ) ) ) ) ) ) ) ).

tff(transitivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,X,Y) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,Y,Z) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,X,Z) ) ) ) ) ) ) ) ) ) ).

tff(difference_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,difference(A,C),difference(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(difference_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,difference(C,A),difference(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(intersection_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,intersection(A,C),intersection(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(intersection_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,intersection(C,A),intersection(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(power_set_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,power_set(A),power_set(B)) ) ) ) ) ) ) ) ).

tff(product_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,product(A),product(B)) ) ) ) ) ) ) ) ).

tff(singleton_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,singleton(A),singleton(B)) ) ) ) ) ) ) ) ).

tff(sum_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,A,B) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,sum(A),sum(B)) ) ) ) ) ) ) ) ).

tff(union_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,union(A,C),union(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(union_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,union(C,A),union(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(unordered_pair_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,unordered_pair(A,C),unordered_pair(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(unordered_pair_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,unordered_pair(C,A),unordered_pair(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(equal_set_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => equal_set(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => equal_set(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(equal_set_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => equal_set(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => equal_set(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(member_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => member(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(member_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => member(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(subset_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => subset(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => subset(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(subset_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => subset(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => subset(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(subset_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subset(W2,A,B) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [X: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,X)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,X,A) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,X,B) ) ) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [X: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,X)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,X,A) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,X,B) ) ) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subset(W2,A,B) ) ) ) ) ) ) ) ) ).

tff(equal_set_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => equal_set(W2,A,B) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,A,B) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,B,A) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,A,B) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,B,A) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => equal_set(W2,A,B) ) ) ) ) ) ) ) ) ).

tff(power_set_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,power_set(A)) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subset(W2,X,A) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subset(W2,X,A) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,power_set(A)) ) ) ) ) ) ) ) ) ).

tff(intersection_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [B: $i] :
                          ( '$ki_exists_in_world_$i'(W1,B)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,X,intersection(A,B)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,A) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,B) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,A) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,B) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,X,intersection(A,B)) ) ) ) ) ) ) ) ) ) ) ).

tff(union_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [B: $i] :
                          ( '$ki_exists_in_world_$i'(W1,B)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,X,union(A,B)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,A) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,B) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,A) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,X,B) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,X,union(A,B)) ) ) ) ) ) ) ) ) ) ) ).

tff(empty_set_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ~ ! [W1: '$ki_world'] :
                    ( '$ki_accessible'(W0,W1)
                   => member(W1,X,empty_set) ) ) ) ) ).

tff(difference_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [E: $i] :
                          ( '$ki_exists_in_world_$i'(W1,E)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,B,difference(E,A)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,B,E) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ~ ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,B,A) ) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,B,E) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ~ ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,B,A) ) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,B,difference(E,A)) ) ) ) ) ) ) ) ) ) ) ).

tff(singleton_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,singleton(A)) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,X,A) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,X,A) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,singleton(A)) ) ) ) ) ) ) ) ) ).

tff(unordered_pair_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [B: $i] :
                          ( '$ki_exists_in_world_$i'(W1,B)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,X,unordered_pair(A,B)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => qmltpeq(W3,X,A) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => qmltpeq(W3,X,B) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => qmltpeq(W3,X,A) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => qmltpeq(W3,X,B) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,X,unordered_pair(A,B)) ) ) ) ) ) ) ) ) ) ) ).

tff(sum_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,sum(A)) )
                         => ? [Y: $i] :
                              ( '$ki_exists_in_world_$i'(W1,Y)
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,Y,A) )
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,X,Y) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ? [Y: $i] :
                              ( '$ki_exists_in_world_$i'(W1,Y)
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,Y,A) )
                              & ! [W2: '$ki_world'] :
                                  ( '$ki_accessible'(W1,W2)
                                 => member(W2,X,Y) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,sum(A)) ) ) ) ) ) ) ) ) ).

tff(product_0,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [A: $i] :
                  ( '$ki_exists_in_world_$i'(W0,A)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,product(A)) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Y: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Y)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,Y,A) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,X,Y) ) ) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [Y: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,Y)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,Y,A) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,X,Y) ) ) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => member(W2,X,product(A)) ) ) ) ) ) ) ) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => equal_set(W0,union(A,A),A) ) ) ) ).

%------------------------------------------------------------------------------
