%------------------------------------------------------------------------------
% File     : LCL947_10 : TPTP v9.2.0. Released v8.2.0.
% Domain   : Set Theory
% Problem  : Goedel translation of SET002+3
% Version  : [QMLTP] axioms.
% English  : 

% Refs     : [Goe69] Goedel (1969), An Interpretation of the Intuitionistic
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : GSE002+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v8.2.0
% Syntax   : Number of formulae    :   28 (   2 unt;   8 typ;   0 def)
%            Number of atoms       :  224 (   0 equ)
%            Maximal formula atoms :   34 (  11 avg)
%            Number of connectives :  204 (   0   ~;   2   |;  14   &)
%                                         (   0 <=>; 188  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   23 (  14 avg)
%            Maximal term depth    :    2 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   15 (   6   >;   9   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   5 usr;   0 prp; 2-3 aty)
%            Number of functors    :    2 (   2 usr;   1 con; 0-2 aty)
%            Number of variables   :  170 (; 169   !;   1   ?; 170   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant,
%            modal_system_S4, TFF embedding.
%------------------------------------------------------------------------------
tff('$ki_world_type',type,
    '$ki_world': $tType ).

tff('$ki_local_world_decl',type,
    '$ki_local_world': '$ki_world' ).

tff('$ki_accessible_decl',type,
    '$ki_accessible': ( '$ki_world' * '$ki_world' ) > $o ).

tff(mrel_reflexive,axiom,
    ! [W: '$ki_world'] : '$ki_accessible'(W,W) ).

tff(mrel_transitive,axiom,
    ! [W: '$ki_world',V: '$ki_world',U: '$ki_world'] :
      ( ( '$ki_accessible'(W,V)
        & '$ki_accessible'(V,U) )
     => '$ki_accessible'(W,U) ) ).

tff(qmltpeq_decl,type,
    qmltpeq: ( '$ki_world' * $i * $i ) > $o ).

tff(member_decl,type,
    member: ( '$ki_world' * $i * $i ) > $o ).

tff(subset_decl,type,
    subset: ( '$ki_world' * $i * $i ) > $o ).

tff(union_decl,type,
    union: ( $i * $i ) > $i ).

tff('$ki_exists_in_world_$i_decl',type,
    '$ki_exists_in_world_$i': ( '$ki_world' * $i ) > $o ).

tff('$ki_exists_in_world_$i_nonempty',axiom,
    ! [W: '$ki_world'] :
    ? [X: $i] : '$ki_exists_in_world_$i'(W,X) ).

tff(reflexivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,X,X) ) ) ) ).

tff(symmetry,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,X,Y) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,Y,X) ) ) ) ) ) ) ) ).

tff(transitivity,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [X: $i] :
          ( '$ki_exists_in_world_$i'(W,X)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [Y: $i] :
                  ( '$ki_exists_in_world_$i'(W0,Y)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [Z: $i] :
                          ( '$ki_exists_in_world_$i'(W1,Z)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,X,Y) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,Y,Z) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,X,Z) ) ) ) ) ) ) ) ) ) ).

tff(union_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,union(A,C),union(B,C)) ) ) ) ) ) ) ) ) ) ).

tff(union_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,A,B) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => qmltpeq(W3,union(C,A),union(C,B)) ) ) ) ) ) ) ) ) ) ).

tff(member_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => member(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(member_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => member(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(subset_substitution_1,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => subset(W3,A,C) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => subset(W3,B,C) ) ) ) ) ) ) ) ) ) ).

tff(subset_substitution_2,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [A: $i] :
          ( '$ki_exists_in_world_$i'(W,A)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [B: $i] :
                  ( '$ki_exists_in_world_$i'(W0,B)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [C: $i] :
                          ( '$ki_exists_in_world_$i'(W1,C)
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ( ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => qmltpeq(W3,A,B) )
                                  & ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => subset(W3,C,A) ) )
                               => ! [W3: '$ki_world'] :
                                    ( '$ki_accessible'(W2,W3)
                                   => subset(W3,C,B) ) ) ) ) ) ) ) ) ) ).

tff(subset_union,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ( ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => subset(W2,B,C) )
                       => ! [W2: '$ki_world'] :
                            ( '$ki_accessible'(W1,W2)
                           => qmltpeq(W2,union(B,C),C) ) ) ) ) ) ) ) ).

tff(union_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => ! [D: $i] :
                          ( '$ki_exists_in_world_$i'(W1,D)
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,D,union(B,C)) )
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,D,B) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,D,C) ) ) ) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => ( ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,D,B) )
                                    | ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => member(W3,D,C) ) )
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => member(W3,D,union(B,C)) ) ) ) ) ) ) ) ) ) ) ).

tff(equal_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,B,C) )
                         => ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,B,C) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,C,B) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ( ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,B,C) )
                            & ! [W2: '$ki_world'] :
                                ( '$ki_accessible'(W1,W2)
                               => subset(W2,C,B) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,B,C) ) ) ) ) ) ) ) ) ).

tff(commutativity_of_union,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ! [W1: '$ki_world'] :
                      ( '$ki_accessible'(W0,W1)
                     => qmltpeq(W1,union(B,C),union(C,B)) ) ) ) ) ) ).

tff(subset_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subset(W2,B,C) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,D,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,D,C) ) ) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ! [W3: '$ki_world'] :
                                      ( '$ki_accessible'(W2,W3)
                                     => ( ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,D,B) )
                                       => ! [W4: '$ki_world'] :
                                            ( '$ki_accessible'(W3,W4)
                                           => member(W4,D,C) ) ) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => subset(W2,B,C) ) ) ) ) ) ) ) ) ).

tff(reflexivity_of_subset,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => subset(W0,B,B) ) ) ) ).

tff(equal_member_defn,axiom,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => ! [C: $i] :
                  ( '$ki_exists_in_world_$i'(W0,C)
                 => ( ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,B,C) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,B) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,C) ) ) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,C) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,B) ) ) ) ) ) ) ) )
                    & ! [W1: '$ki_world'] :
                        ( '$ki_accessible'(W0,W1)
                       => ( ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => ! [D: $i] :
                                  ( '$ki_exists_in_world_$i'(W2,D)
                                 => ( ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,B) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,C) ) ) )
                                    & ! [W3: '$ki_world'] :
                                        ( '$ki_accessible'(W2,W3)
                                       => ( ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,C) )
                                         => ! [W4: '$ki_world'] :
                                              ( '$ki_accessible'(W3,W4)
                                             => member(W4,D,B) ) ) ) ) ) )
                         => ! [W2: '$ki_world'] :
                              ( '$ki_accessible'(W1,W2)
                             => qmltpeq(W2,B,C) ) ) ) ) ) ) ) ) ).

tff(verify,conjecture,
    ! [W: '$ki_world'] :
      ( '$ki_accessible'('$ki_local_world',W)
     => ! [B: $i] :
          ( '$ki_exists_in_world_$i'(W,B)
         => ! [W0: '$ki_world'] :
              ( '$ki_accessible'(W,W0)
             => qmltpeq(W0,union(B,B),B) ) ) ) ).

%------------------------------------------------------------------------------
