%------------------------------------------------------------------------------
% File     : LCL946_10 : TPTP v9.2.0. Bugfixed v9.0.0.
% Domain   : Natural Language Processing
% Problem  : Goedel translation of NLP009+1
% Version  : [QMLTP] axioms.
% English  : 

% Refs     : [Goe69] Goedel (1969), An Interpretation of the Intuitionistic
%          : [RO12]  Raths & Otten (2012), The QMLTP Problem Library for Fi
% Source   : [QMLTP]
% Names    : GNL009+1 [QMLTP]

% Status   : Theorem
% Rating   : 0.00 v9.1.0, 0.67 v9.0.0
% Syntax   : Number of formulae    :   53 (   1 unt;  24 typ;   0 def)
%            Number of atoms       :  467 (   0 equ)
%            Maximal formula atoms :  230 (  16 avg)
%            Number of connectives :  442 (   4   ~;   0   |; 134   &)
%                                         (   0 <=>; 304  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   44 (  14 avg)
%            Maximal term depth    :    1 (   1 avg)
%            Number of types       :    3 (   1 usr)
%            Number of type conns  :   48 (  22   >;  26   *;   0   +;   0  <<)
%            Number of predicates  :   22 (  22 usr;   0 prp; 2-3 aty)
%            Number of functors    :    1 (   1 usr;   1 con; 0-0 aty)
%            Number of variables   :  375 ( 339   !;  36   ?; 375   :)
% SPC      : TF0_THM_NEQ_NAR

% Comments : Generated by embedproblem, version 1.7.14, rigid constant, 
%            modal_system_S4, TFF embedding.
% Bugfixes : v9.0.0 - Fixed embedding variables
%------------------------------------------------------------------------------
%----Meta-logical definitions of the embedding
tff('$world_type',type,
    '$world': $tType ).

tff('$local_world_decl',type,
    '$local_world': '$world' ).

tff('$accessible_world_decl',type,
    '$accessible_world': ( '$world' * '$world' ) > $o ).

tff(mrel_reflexive,axiom,
    ! [W: '$world'] : '$accessible_world'(W,W) ).

tff(mrel_transitive,axiom,
    ! [W: '$world',V: '$world',U: '$world'] :
      ( ( '$accessible_world'(W,V)
        & '$accessible_world'(V,U) )
     => '$accessible_world'(W,U) ) ).

%----Converted user type declarations
tff(chevy_type,type,
    chevy: ( '$world' * $i ) > $o ).

tff(dirty_type,type,
    dirty: ( '$world' * $i ) > $o ).

tff(barrel_type,type,
    barrel: ( '$world' * $i * $i ) > $o ).

tff(hollywood_type,type,
    hollywood: ( '$world' * $i ) > $o ).

tff(city_type,type,
    city: ( '$world' * $i ) > $o ).

tff(in_type,type,
    in: ( '$world' * $i * $i ) > $o ).

tff(young_type,type,
    young: ( '$world' * $i ) > $o ).

tff(old_type,type,
    old: ( '$world' * $i ) > $o ).

tff(down_type,type,
    down: ( '$world' * $i * $i ) > $o ).

tff(way_type,type,
    way: ( '$world' * $i ) > $o ).

tff(qmltpeq_type,type,
    qmltpeq: ( '$world' * $i * $i ) > $o ).

tff(seat_type,type,
    seat: ( '$world' * $i ) > $o ).

tff(white_type,type,
    white: ( '$world' * $i ) > $o ).

tff(car_type,type,
    car: ( '$world' * $i ) > $o ).

tff(furniture_type,type,
    furniture: ( '$world' * $i ) > $o ).

tff(street_type,type,
    street: ( '$world' * $i ) > $o ).

tff(fellow_type,type,
    fellow: ( '$world' * $i ) > $o ).

tff(front_type,type,
    front: ( '$world' * $i ) > $o ).

tff(man_type,type,
    man: ( '$world' * $i ) > $o ).

tff(event_type,type,
    event: ( '$world' * $i ) > $o ).

tff(lonely_type,type,
    lonely: ( '$world' * $i ) > $o ).

%----Converted problem
tff(reflexivity,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [X: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => qmltpeq(W0,X,X) ) ) ).

tff(symmetry,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [X: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [Y: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => qmltpeq(W2,X,Y) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => qmltpeq(W2,Y,X) ) ) ) ) ) ).

tff(transitivity,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [X: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [Y: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ! [Z: $i,W2: '$world'] :
                  ( '$accessible_world'(W1,W2)
                 => ( ( ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,X,Y) )
                      & ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,Y,Z) ) )
                   => ! [W3: '$world'] :
                        ( '$accessible_world'(W2,W3)
                       => qmltpeq(W3,X,Z) ) ) ) ) ) ) ).

tff(barrel_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ! [C: $i,W2: '$world'] :
                  ( '$accessible_world'(W1,W2)
                 => ( ( ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,A,B) )
                      & ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => barrel(W3,A,C) ) )
                   => ! [W3: '$world'] :
                        ( '$accessible_world'(W2,W3)
                       => barrel(W3,B,C) ) ) ) ) ) ) ).

tff(barrel_substitution_2,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ! [C: $i,W2: '$world'] :
                  ( '$accessible_world'(W1,W2)
                 => ( ( ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,A,B) )
                      & ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => barrel(W3,C,A) ) )
                   => ! [W3: '$world'] :
                        ( '$accessible_world'(W2,W3)
                       => barrel(W3,C,B) ) ) ) ) ) ) ).

tff(car_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => car(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => car(W2,B) ) ) ) ) ) ).

tff(chevy_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => chevy(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => chevy(W2,B) ) ) ) ) ) ).

tff(city_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => city(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => city(W2,B) ) ) ) ) ) ).

tff(dirty_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => dirty(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => dirty(W2,B) ) ) ) ) ) ).

tff(down_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ! [C: $i,W2: '$world'] :
                  ( '$accessible_world'(W1,W2)
                 => ( ( ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,A,B) )
                      & ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => down(W3,A,C) ) )
                   => ! [W3: '$world'] :
                        ( '$accessible_world'(W2,W3)
                       => down(W3,B,C) ) ) ) ) ) ) ).

tff(down_substitution_2,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ! [C: $i,W2: '$world'] :
                  ( '$accessible_world'(W1,W2)
                 => ( ( ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,A,B) )
                      & ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => down(W3,C,A) ) )
                   => ! [W3: '$world'] :
                        ( '$accessible_world'(W2,W3)
                       => down(W3,C,B) ) ) ) ) ) ) ).

tff(event_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => event(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => event(W2,B) ) ) ) ) ) ).

tff(fellow_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => fellow(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => fellow(W2,B) ) ) ) ) ) ).

tff(front_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => front(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => front(W2,B) ) ) ) ) ) ).

tff(furniture_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => furniture(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => furniture(W2,B) ) ) ) ) ) ).

tff(hollywood_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => hollywood(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => hollywood(W2,B) ) ) ) ) ) ).

tff(in_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ! [C: $i,W2: '$world'] :
                  ( '$accessible_world'(W1,W2)
                 => ( ( ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,A,B) )
                      & ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => in(W3,A,C) ) )
                   => ! [W3: '$world'] :
                        ( '$accessible_world'(W2,W3)
                       => in(W3,B,C) ) ) ) ) ) ) ).

tff(in_substitution_2,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ! [C: $i,W2: '$world'] :
                  ( '$accessible_world'(W1,W2)
                 => ( ( ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => qmltpeq(W3,A,B) )
                      & ! [W3: '$world'] :
                          ( '$accessible_world'(W2,W3)
                         => in(W3,C,A) ) )
                   => ! [W3: '$world'] :
                        ( '$accessible_world'(W2,W3)
                       => in(W3,C,B) ) ) ) ) ) ) ).

tff(lonely_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => lonely(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => lonely(W2,B) ) ) ) ) ) ).

tff(man_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => man(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => man(W2,B) ) ) ) ) ) ).

tff(old_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => old(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => old(W2,B) ) ) ) ) ) ).

tff(seat_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => seat(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => seat(W2,B) ) ) ) ) ) ).

tff(street_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => street(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => street(W2,B) ) ) ) ) ) ).

tff(way_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => way(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => way(W2,B) ) ) ) ) ) ).

tff(white_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => white(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => white(W2,B) ) ) ) ) ) ).

tff(young_substitution_1,axiom,
    ! [W: '$world'] :
      ( '$accessible_world'('$local_world',W)
     => ! [A: $i,W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ! [B: $i,W1: '$world'] :
              ( '$accessible_world'(W0,W1)
             => ( ( ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => qmltpeq(W2,A,B) )
                  & ! [W2: '$world'] :
                      ( '$accessible_world'(W1,W2)
                     => young(W2,A) ) )
               => ! [W2: '$world'] :
                    ( '$accessible_world'(W1,W2)
                   => young(W2,B) ) ) ) ) ) ).

tff(co1,conjecture,
    ! [W: '$world'] :
      ( ! [W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ( ? [U: $i,V: $i,WW: $i,X: $i,Y: $i,Z: $i,X1: $i,X2: $i,X3: $i] :
                ( ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => hollywood(W1,U) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => city(W1,U) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => event(W1,V) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => street(W1,WW) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => way(W1,WW) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => lonely(W1,WW) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => chevy(W1,X) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => car(W1,X) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => white(W1,X) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => dirty(W1,X) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => old(W1,X) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => barrel(W1,V,X) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => down(W1,V,WW) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,V,U) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => seat(W1,X1) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => furniture(W1,X1) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => front(W1,X1) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => ~ ! [W2: '$world'] :
                          ( '$accessible_world'(W1,W2)
                         => qmltpeq(W2,Y,Z) ) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,Y) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,Y) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,Y) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,Z) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,Z) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,Z) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,Y,X2) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X2,X1) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,Z,X3) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X3,X1) ) )
           => ? [X4: $i,X5: $i,X6: $i,X7: $i,X8: $i,X9: $i,X10: $i,X11: $i,X12: $i] :
                ( ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => hollywood(W1,X4) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => city(W1,X4) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => event(W1,X5) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => chevy(W1,X6) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => car(W1,X6) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => white(W1,X6) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => dirty(W1,X6) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => old(W1,X6) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => street(W1,X7) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => way(W1,X7) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => lonely(W1,X7) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => barrel(W1,X5,X6) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => down(W1,X5,X7) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X5,X4) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => seat(W1,X10) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => furniture(W1,X10) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => front(W1,X10) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => ~ ! [W2: '$world'] :
                          ( '$accessible_world'(W1,W2)
                         => qmltpeq(W2,X8,X9) ) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,X8) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,X8) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,X8) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,X9) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,X9) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,X9) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,X8,X11) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X11,X10) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,X9,X12) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X12,X10) ) ) ) )
      & ! [W0: '$world'] :
          ( '$accessible_world'(W,W0)
         => ( ? [X13: $i,X14: $i,X15: $i,X16: $i,X17: $i,X18: $i,X19: $i,X20: $i,X21: $i] :
                ( ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => hollywood(W1,X13) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => city(W1,X13) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => event(W1,X14) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => chevy(W1,X15) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => car(W1,X15) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => white(W1,X15) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => dirty(W1,X15) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => old(W1,X15) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => street(W1,X16) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => way(W1,X16) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => lonely(W1,X16) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => barrel(W1,X14,X15) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => down(W1,X14,X16) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X14,X13) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => seat(W1,X19) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => furniture(W1,X19) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => front(W1,X19) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => ~ ! [W2: '$world'] :
                          ( '$accessible_world'(W1,W2)
                         => qmltpeq(W2,X17,X18) ) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,X17) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,X17) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,X17) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,X18) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,X18) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,X18) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,X17,X20) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X20,X19) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,X18,X21) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X21,X19) ) )
           => ? [X22: $i,X23: $i,X24: $i,X25: $i,X26: $i,X27: $i,X28: $i,X29: $i,X30: $i] :
                ( ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => hollywood(W1,X22) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => city(W1,X22) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => event(W1,X23) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => street(W1,X24) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => way(W1,X24) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => lonely(W1,X24) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => chevy(W1,X25) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => car(W1,X25) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => white(W1,X25) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => dirty(W1,X25) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => old(W1,X25) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => barrel(W1,X23,X25) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => down(W1,X23,X24) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X23,X22) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => seat(W1,X28) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => furniture(W1,X28) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => front(W1,X28) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => ~ ! [W2: '$world'] :
                          ( '$accessible_world'(W1,W2)
                         => qmltpeq(W2,X26,X27) ) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,X26) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,X26) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,X26) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => fellow(W1,X27) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => man(W1,X27) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => young(W1,X27) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,X26,X29) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X29,X28) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => qmltpeq(W1,X27,X30) )
                & ! [W1: '$world'] :
                    ( '$accessible_world'(W0,W1)
                   => in(W1,X30,X28) ) ) ) ) ) ).

%------------------------------------------------------------------------------
