%------------------------------------------------------------------------------
% File     : LCL843_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 252
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_252 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  147 (  53 unt;  44 typ;   0 def)
%            Number of atoms       :  199 ( 111 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  139 (  43   ~;   3   |;  15   &)
%                                         (  15 <=>;  63  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   58 (  27   >;  31   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-4 aty)
%            Number of functors    :   35 (  35 usr;  10 con; 0-5 aty)
%            Number of variables   :  371 ( 346   !;   7   ?; 371   :)
%                                         (  18  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:48
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(dB,fun(dB,T4)) * fun(dB,T4) * dB ) > T4 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(dB,fun(dB,fun(T4,fun(T4,T4)))) * fun(dB,fun(T4,T4)) * dB ) > T4 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun(A,fun(list(A),T4)) * list(A) ) > T4 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: ( type * type ) > type ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,T4)) * type ) > T4 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T,type,
    t: type ).

tff(sy_v_Ta______,type,
    ta: type ).

tff(sy_v_e,type,
    e: fun(nat,type) ).

tff(sy_v_env______,type,
    env: nat > type ).

tff(sy_v_t,type,
    t1: dB ).

tff(sy_v_x______,type,
    x: nat ).

%----Relevant facts (99)
tff(fact_0_Var,axiom,
    env(x) = ta ).

tff(fact_1_Var__IT,axiom,
    ! [N2: nat] : pp(aa(dB,bool,it,var(N2))) ).

tff(fact_2_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_3_subst__Var__IT,axiom,
    ! [J1: nat,I1: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,subst(R3,var(I1),J1))) ) ).

tff(fact_4_app__Var__IT,axiom,
    ! [I1: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),var(I1)))) ) ).

tff(fact_5_lift__IT,axiom,
    ! [I1: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,lift(T1,I1))) ) ).

tff(fact_6_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_7_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_8_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_9_beta__cases_I1_J,axiom,
    ! [T1: dB,I1: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I1)),T1)) ).

tff(fact_10_typing_OVar,axiom,
    ! [Tb: type,Xa: nat,Enva: fun(nat,type)] :
      ( ( aa(nat,type,Enva,Xa) = Tb )
     => typing(Enva,var(Xa),Tb) ) ).

tff(fact_11_typing__elims_I1_J,axiom,
    ! [Tb: type,I: nat,Ea: fun(nat,type)] :
      ( typing(Ea,var(I),Tb)
     => ( aa(nat,type,Ea,I) = Tb ) ) ).

tff(fact_12_subst__eq,axiom,
    ! [U2: dB,K: nat] : ( subst(var(K),U2,K) = U2 ) ).

tff(fact_13_dB_Osimps_I7_J,axiom,
    ! [Nat1: nat,DB3: dB] : ( abs(DB3) != var(Nat1) ) ).

tff(fact_14_assms,axiom,
    typing(e,t1,t) ).

tff(fact_15_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB12 = DB14 )
        & ( DB22 = DB24 ) ) ) ).

tff(fact_16_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB4: dB] :
      ( ( abs(DB4) = abs(DB5) )
    <=> ( DB4 = DB5 ) ) ).

tff(fact_17_appL,axiom,
    ! [U2: dB,T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S3),U2)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2))) ) ).

tff(fact_18_appR,axiom,
    ! [U2: dB,T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U2),S3)),aa(dB,dB,aa(dB,fun(dB,dB),app,U2),T1))) ) ).

tff(fact_19_subst__App,axiom,
    ! [K: nat,S3: dB,U2: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2),S3,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S3,K)),subst(U2,S3,K)) ) ).

tff(fact_20_abs,axiom,
    ! [T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S3)),abs(T1))) ) ).

tff(fact_21_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S3: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S3,K)),lift(T1,K)) ) ).

tff(fact_22_dB_Osimps_I9_J,axiom,
    ! [DB23: dB,DB13: dB,DB3: dB] : ( abs(DB3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_23_dB_Osimps_I8_J,axiom,
    ! [DB3: dB,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != abs(DB3) ) ).

tff(fact_24_subst__lift,axiom,
    ! [S3: dB,K: nat,T1: dB] : ( subst(lift(T1,K),S3,K) = T1 ) ).

tff(fact_25_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB4)) = aa(dB,A,F3,DB4) ) ).

tff(fact_26_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB4)) = aa(A,A,aa(dB,fun(A,A),F3,DB4),dB_rec(A,F1,F2,F3,DB4)) ) ).

tff(fact_27_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB22: dB,DB12: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB12),DB22) ) ).

tff(fact_28_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB22: dB,DB12: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB12),DB22),dB_rec(A,F1,F2,F3,DB12)),dB_rec(A,F1,F2,F3,DB22)) ) ).

tff(fact_29_lift__preserves__beta,axiom,
    ! [I1: nat,S3: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S3))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,lift(R3,I1)),lift(S3,I1))) ) ).

tff(fact_30_subst__preserves__beta,axiom,
    ! [I1: nat,T1: dB,S3: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S3))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R3,T1,I1)),subst(S3,T1,I1))) ) ).

tff(fact_31_subject__reduction,axiom,
    ! [T3: dB,Tb: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,Ta,Tb)
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T3))
       => typing(Ea,T3,Tb) ) ) ).

tff(fact_32_dB_Osimps_I5_J,axiom,
    ! [Nat1: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat1) ) ).

tff(fact_33_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat1: nat] : ( var(Nat1) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_34_dB_Osimps_I6_J,axiom,
    ! [DB3: dB,Nat1: nat] : ( var(Nat1) != abs(DB3) ) ).

tff(fact_35_beta__cases_I2_J,axiom,
    ! [S3: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S3))
     => ~ ! [T: dB] :
            ( ( S3 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T)) ) ) ).

tff(fact_36_beta,axiom,
    ! [T1: dB,S3: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S3)),T1)),subst(S3,T1,zero_zero(nat)))) ).

tff(fact_37_subst__type__IT,axiom,
    ! [U4: dB,Tb: type,U1: type,I: nat,Ea: fun(nat,type),Ta: dB] :
      ( pp(aa(dB,bool,it,Ta))
     => ( typing(shift(type,Ea,I,U1),Ta,Tb)
       => ( pp(aa(dB,bool,it,U4))
         => ( typing(Ea,U4,U1)
           => pp(aa(dB,bool,it,subst(Ta,U4,I))) ) ) ) ) ).

tff(fact_38_lift__type,axiom,
    ! [U1: type,I: nat,Tb: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,Ta,Tb)
     => typing(shift(type,Ea,I,U1),lift(Ta,I),Tb) ) ).

tff(fact_39_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat: nat] : ( Y != var(Nat) )
     => ( ! [DB1: dB,DB2: dB] : ( Y != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) )
       => ~ ! [DB: dB] : ( Y != abs(DB) ) ) ) ).

tff(fact_40_App,axiom,
    ! [Ta: dB,U1: type,Tb: type,S: dB,Enva: fun(nat,type)] :
      ( typing(Enva,S,fun1(Tb,U1))
     => ( typing(Enva,Ta,Tb)
       => typing(Enva,aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta),U1) ) ) ).

tff(fact_41_substn_Osimps_I2_J,axiom,
    ! [K: nat,S3: dB,U2: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2),S3,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S3,K)),substn(U2,S3,K)) ) ).

tff(fact_42_subst__lemma,axiom,
    ! [I: nat,U1: type,U4: dB,E: fun(nat,type),Tb: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,Ta,Tb)
     => ( typing(E,U4,U1)
       => ( ( Ea = shift(type,E,I,U1) )
         => typing(E,subst(Ta,U4,I),Tb) ) ) ) ).

tff(fact_43_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S3: dB,N2: nat] : ( liftn(N2,aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N2,S3,K)),liftn(N2,T1,K)) ) ).

tff(fact_44_type_Osimps_I2_J,axiom,
    ! [Type23: type,Type13: type,Type22: type,Type12: type] :
      ( ( fun1(Type12,Type22) = fun1(Type13,Type23) )
    <=> ( ( Type12 = Type13 )
        & ( Type22 = Type23 ) ) ) ).

tff(fact_45_substn__subst__n,axiom,
    ! [N2: nat,S3: dB,T1: dB] : ( substn(T1,S3,N2) = subst(T1,liftn(N2,S3,zero_zero(nat)),N2) ) ).

tff(fact_46_Abs,axiom,
    ! [U1: type,Ta: dB,Tb: type,Enva: fun(nat,type)] :
      ( typing(shift(type,Enva,zero_zero(nat),Tb),Ta,U1)
     => typing(Enva,abs(Ta),fun1(Tb,U1)) ) ).

tff(fact_47_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_48_shift__eq,axiom,
    ! [A: $tType,Tb: A,Ea: fun(nat,A),J: nat,I: nat] :
      ( ( I = J )
     => ( aa(nat,A,shift(A,Ea,I,Tb),J) = Tb ) ) ).

tff(fact_49_substn__subst__0,axiom,
    ! [S3: dB,T1: dB] : ( substn(T1,S3,zero_zero(nat)) = subst(T1,S3,zero_zero(nat)) ) ).

tff(fact_50_typing__elims_I3_J,axiom,
    ! [Tb: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,abs(Ta),Tb)
     => ~ ! [T2: type,U3: type] :
            ( ( Tb = fun1(T2,U3) )
           => ~ typing(shift(type,Ea,zero_zero(nat),T2),Ta,U3) ) ) ).

tff(fact_51_typing__elims_I2_J,axiom,
    ! [Tb: type,U4: dB,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),U4),Tb)
     => ~ ! [T2: type] :
            ( typing(Ea,Ta,fun1(T2,Tb))
           => ~ typing(Ea,U4,T2) ) ) ).

tff(fact_52_abs__typeE,axiom,
    ! [Tb: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,abs(Ta),Tb)
     => ~ ! [U3: type,V2: type] : ~ typing(shift(type,Ea,zero_zero(nat),U3),Ta,V2) ) ).

tff(fact_53_beta__cases_I3_J,axiom,
    ! [U2: dB,T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T1)),U2))
     => ( ! [S1: dB] :
            ( ( U2 = subst(S1,T1,zero_zero(nat)) )
           => ( S3 != abs(S1) ) )
       => ( ! [T: dB] :
              ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T)) )
         => ~ ! [T: dB] :
                ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_54_dB_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( dB_size(var(Nat1)) = zero_zero(nat) ) ).

tff(fact_55_Beta,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss))) ) ) ).

tff(fact_56_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,fun1(Type12,Type22)) = aa(type,A,aa(type,fun(type,A),F2,Type12),Type22) ) ).

tff(fact_57_var__app__type__eq,axiom,
    ! [U1: type,Tb: type,Ts: list(dB),I: nat,Ea: fun(nat,type)] :
      ( typing(Ea,foldl(dB,dB,app,var(I),Ts),Tb)
     => ( typing(Ea,foldl(dB,dB,app,var(I),Ts),U1)
       => ( Tb = U1 ) ) ) ).

tff(fact_58_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [Xa: A] :
          ( ( zero_zero(A) = Xa )
        <=> ( Xa = zero_zero(A) ) ) ) ).

tff(fact_59_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( R = S )
        & ( Rs = Ss ) ) ) ).

tff(fact_60_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss) )
    <=> ( ( M = N )
        & ( Rs = Ss ) ) ) ).

tff(fact_61_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_62_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss) ) ).

tff(fact_63_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),R: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R),Ss) ) ).

tff(fact_64_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Ss)),foldl(dB,dB,app,S,Ss))) ) ).

tff(fact_65_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_66_dB_Osize_I4_J,axiom,
    ! [Nat1: nat] : ( size_size(dB,var(Nat1)) = zero_zero(nat) ) ).

tff(fact_67_IT_Osimps,axiom,
    ! [A3: dB] :
      ( pp(aa(dB,bool,it,A3))
    <=> ( ? [Rs2: list(dB),N1: nat] :
            ( ( A3 = foldl(dB,dB,app,var(N1),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R2: dB] :
            ( ( A3 = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S2: dB,Ss2: list(dB)] :
            ( ( A3 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S2),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R2,S2,zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S2)) ) ) ) ).

tff(fact_68_apps__preserves__betas,axiom,
    ! [R: dB,Ss: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),foldl(dB,dB,app,R,Ss))) ) ).

tff(fact_69_type_Osimps_I5_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_70_type_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( atom(Nat2) = atom(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_71_type_Osimps_I4_J,axiom,
    ! [Nat1: nat,Type21: type,Type11: type] : ( fun1(Type11,Type21) != atom(Nat1) ) ).

tff(fact_72_type_Osimps_I3_J,axiom,
    ! [Type21: type,Type11: type,Nat1: nat] : ( atom(Nat1) != fun1(Type11,Type21) ) ).

tff(fact_73_head__Var__reduction,axiom,
    ! [V1: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V1))
     => ? [Ss1: list(dB)] :
          ( step1(dB,beta,Rs,Ss1)
          & ( V1 = foldl(dB,dB,app,var(N),Ss1) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_type_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( type_size(atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_76_type_Osize_I3_J,axiom,
    ! [Nat1: nat] : ( size_size(type,atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_77_type_Oexhaust,axiom,
    ! [Y: type] :
      ( ! [Nat: nat] : ( Y != atom(Nat) )
     => ~ ! [Type1: type,Type2: type] : ( Y != fun1(Type1,Type2) ) ) ).

tff(fact_78_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,R,Rs1) ) )
         => ~ ! [T: dB] :
                ( ( R = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rs = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,subst(T,U,zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_79_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),Xa: A,Ys1: list(A),Y2: A,R: fun(A,fun(A,bool))] :
      ( step1(A,R,cons(A,Y2,Ys1),cons(A,Xa,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R,Y2),Xa))
          & ( Xs = Ys1 ) )
        | ( ( Xa = Y2 )
          & step1(A,R,Ys1,Xs) ) ) ) ).

tff(fact_80_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A4: A,List1: list(A),A3: A] :
      ( ( cons(A,A3,List1) = cons(A,A4,List2) )
    <=> ( ( A3 = A4 )
        & ( List1 = List2 ) ) ) ).

tff(fact_81_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_82_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_83_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),Xa: B,A3: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A3,cons(B,Xa,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A3),Xa),Xs) ) ).

tff(fact_84_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),Xa: A,Ys1: list(A),R: fun(A,fun(A,bool))] :
      ( step1(A,R,Ys1,cons(A,Xa,Xs))
     => ( ! [Y1: A] :
            ( ( Ys1 = cons(A,Y1,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),R,Y1),Xa)) )
       => ~ ! [Zs: list(A)] :
              ( ( Ys1 = cons(A,Xa,Zs) )
             => ~ step1(A,R,Zs,Xs) ) ) ) ).

tff(fact_85_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,Xa: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X1: A,Y1: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X1)),Y1) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y1)),X1) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),Xa) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),Xa),Xs) ) ) ).

tff(fact_86_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A3: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A3,List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A3),List1) ) ).

tff(fact_87_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs1: list(A),X: A] : ( splice(A,cons(A,X,Xs1),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs1,Ys))) ) ).

tff(fact_88_Abs__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( ( abs(R) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( abs(R) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_89_apps__eq__Abs__conv,axiom,
    ! [R: dB,Ss: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss) = abs(R) )
    <=> ( ( S = abs(R) )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_90_listsp_ONil,axiom,
    ! [A: $tType,A2: fun(A,bool)] : listsp(A,A2,nil(A)) ).

tff(fact_91_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( var(M) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_92_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_93_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_94_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_95_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_96_list_Osimps_I2_J,axiom,
    ! [A: $tType,List: list(A),A1: A] : ( nil(A) != cons(A,A1,List) ) ).

tff(fact_97_list_Osimps_I3_J,axiom,
    ! [A: $tType,List: list(A),A1: A] : ( cons(A,A1,List) != nil(A) ) ).

tff(fact_98_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),R: fun(A,fun(A,bool))] : ~ step1(A,R,nil(A),Xs) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,var(x))) ).

%------------------------------------------------------------------------------
