%------------------------------------------------------------------------------
% File     : LCL842_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 250
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_250 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  145 (  48 unt;  42 typ;   0 def)
%            Number of atoms       :  209 ( 113 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  155 (  49   ~;   4   |;  18   &)
%                                         (  18 <=>;  66  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   57 (  27   >;  30   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-4 aty)
%            Number of functors    :   32 (  32 usr;   8 con; 0-5 aty)
%            Number of variables   :  372 ( 342   !;  11   ?; 372   :)
%                                         (  19  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (36)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A1: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A1: $tType] : A1 ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(dB,fun(dB,T4)) * fun(dB,T4) * dB ) > T4 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A1: $tType] : ( ( fun(A1,fun(A1,bool)) * list(A1) * list(A1) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A1: $tType] : ( ( fun(B,fun(A1,B)) * B * list(A1) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A1: $tType] : list(A1) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T4: $tType,A1: $tType] : ( ( T4 * fun(A1,fun(list(A1),T4)) * list(A1) ) > T4 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A1: $tType] : ( ( fun(A1,bool) * list(A1) ) > $o ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A1: $tType] : ( ( list(A1) * fun(nat,bool) ) > list(A1) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A1: $tType] : ( A1 > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A1: $tType] : ( ( fun(nat,A1) * nat * A1 ) > fun(nat,A1) ) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: ( type * type ) > type ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,T4)) * type ) > T4 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,B) * A1 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T,type,
    t1: type ).

tff(sy_v_e,type,
    e: fun(nat,type) ).

tff(sy_v_t,type,
    t: dB ).

%----Relevant facts (99)
tff(fact_0_assms,axiom,
    typing(e,t,t1) ).

tff(fact_1_lift__IT,axiom,
    ! [I1: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,lift(T1,I1))) ) ).

tff(fact_2_Var__IT,axiom,
    ! [N2: nat] : pp(aa(dB,bool,it,var(N2))) ).

tff(fact_3_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_4_subst__Var__IT,axiom,
    ! [J1: nat,I1: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,subst(R3,var(I1),J1))) ) ).

tff(fact_5_subst__type__IT,axiom,
    ! [U3: dB,Ta1: type,U2: type,I: nat,Ea: fun(nat,type),Ta: dB] :
      ( pp(aa(dB,bool,it,Ta))
     => ( typing(shift(type,Ea,I,U2),Ta,Ta1)
       => ( pp(aa(dB,bool,it,U3))
         => ( typing(Ea,U3,U2)
           => pp(aa(dB,bool,it,subst(Ta,U3,I))) ) ) ) ) ).

tff(fact_6_app__Var__IT,axiom,
    ! [I1: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),var(I1)))) ) ).

tff(fact_7_lift__type,axiom,
    ! [U2: type,I: nat,Ta1: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,Ta,Ta1)
     => typing(shift(type,Ea,I,U2),lift(Ta,I),Ta1) ) ).

tff(fact_8_typing_OVar,axiom,
    ! [Ta1: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta1 )
     => typing(Env,var(X),Ta1) ) ).

tff(fact_9_typing__elims_I1_J,axiom,
    ! [Ta1: type,I: nat,Ea: fun(nat,type)] :
      ( typing(Ea,var(I),Ta1)
     => ( aa(nat,type,Ea,I) = Ta1 ) ) ).

tff(fact_10_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S3: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S3,K)),lift(T1,K)) ) ).

tff(fact_11_subst__App,axiom,
    ! [K: nat,S3: dB,U1: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S3,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S3,K)),subst(U1,S3,K)) ) ).

tff(fact_12_subst__lemma,axiom,
    ! [I: nat,U2: type,U3: dB,E: fun(nat,type),Ta1: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,Ta,Ta1)
     => ( typing(E,U3,U2)
       => ( ( Ea = shift(type,E,I,U2) )
         => typing(E,subst(Ta,U3,I),Ta1) ) ) ) ).

tff(fact_13_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB: dB] :
      ( ( abs(DB) = abs(DB5) )
    <=> ( DB = DB5 ) ) ).

tff(fact_14_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_15_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB1 = DB14 )
        & ( DB2 = DB24 ) ) ) ).

tff(fact_16_subst__lift,axiom,
    ! [S3: dB,K: nat,T1: dB] : ( subst(lift(T1,K),S3,K) = T1 ) ).

tff(fact_17_shift__eq,axiom,
    ! [A1: $tType,Ta1: A1,Ea: fun(nat,A1),J: nat,I: nat] :
      ( ( I = J )
     => ( aa(nat,A1,shift(A1,Ea,I,Ta1),J) = Ta1 ) ) ).

tff(fact_18_dB_Osimps_I5_J,axiom,
    ! [Nat1: nat,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != var(Nat1) ) ).

tff(fact_19_dB_Osimps_I4_J,axiom,
    ! [DB23: dB,DB13: dB,Nat1: nat] : ( var(Nat1) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_20_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != abs(DB4) ) ).

tff(fact_21_dB_Osimps_I9_J,axiom,
    ! [DB22: dB,DB12: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_22_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat1: nat] : ( var(Nat1) != abs(DB4) ) ).

tff(fact_23_dB_Osimps_I7_J,axiom,
    ! [Nat1: nat,DB4: dB] : ( abs(DB4) != var(Nat1) ) ).

tff(fact_24_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( subst(var(K),U1,K) = U1 ) ).

tff(fact_25_dB_Oexhaust,axiom,
    ! [Y2: dB] :
      ( ! [Nat: nat] : ( Y2 != var(Nat) )
     => ( ! [DB11: dB,DB21: dB] : ( Y2 != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) )
       => ~ ! [DB3: dB] : ( Y2 != abs(DB3) ) ) ) ).

tff(fact_26_App,axiom,
    ! [Ta: dB,U2: type,Ta1: type,S: dB,Env: fun(nat,type)] :
      ( typing(Env,S,fun1(Ta1,U2))
     => ( typing(Env,Ta,Ta1)
       => typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta),U2) ) ) ).

tff(fact_27_dB_Osimps_I12_J,axiom,
    ! [A1: $tType,DB: dB,F3: fun(dB,A1),F2: fun(dB,fun(dB,A1)),F1: fun(nat,A1)] : ( dB_case(A1,F1,F2,F3,abs(DB)) = aa(dB,A1,F3,DB) ) ).

tff(fact_28_dB_Osimps_I10_J,axiom,
    ! [A1: $tType,Nat2: nat,F3: fun(dB,A1),F2: fun(dB,fun(dB,A1)),F1: fun(nat,A1)] : ( dB_case(A1,F1,F2,F3,var(Nat2)) = aa(nat,A1,F1,Nat2) ) ).

tff(fact_29_dB_Osimps_I11_J,axiom,
    ! [A1: $tType,DB2: dB,DB1: dB,F3: fun(dB,A1),F2: fun(dB,fun(dB,A1)),F1: fun(nat,A1)] : ( dB_case(A1,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A1,aa(dB,fun(dB,A1),F2,DB1),DB2) ) ).

tff(fact_30_substn_Osimps_I2_J,axiom,
    ! [K: nat,S3: dB,U1: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S3,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S3,K)),substn(U1,S3,K)) ) ).

tff(fact_31_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S3: dB,N2: nat] : ( liftn(N2,aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N2,S3,K)),liftn(N2,T1,K)) ) ).

tff(fact_32_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,abs(Ta),Ta1)
     => ~ ! [U4: type,V1: type] : ~ typing(shift(type,Ea,zero_zero(nat),U4),Ta,V1) ) ).

tff(fact_33_type_Osimps_I2_J,axiom,
    ! [Type23: type,Type13: type,Type22: type,Type12: type] :
      ( ( fun1(Type12,Type22) = fun1(Type13,Type23) )
    <=> ( ( Type12 = Type13 )
        & ( Type22 = Type23 ) ) ) ).

tff(fact_34_substn__subst__n,axiom,
    ! [N2: nat,S3: dB,T1: dB] : ( substn(T1,S3,N2) = subst(T1,liftn(N2,S3,zero_zero(nat)),N2) ) ).

tff(fact_35_Abs,axiom,
    ! [U2: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),Ta1),Ta,U2)
     => typing(Env,abs(Ta),fun1(Ta1,U2)) ) ).

tff(fact_36_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_37_substn__subst__0,axiom,
    ! [S3: dB,T1: dB] : ( substn(T1,S3,zero_zero(nat)) = subst(T1,S3,zero_zero(nat)) ) ).

tff(fact_38_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,abs(Ta),Ta1)
     => ~ ! [T3: type,U4: type] :
            ( ( Ta1 = fun1(T3,U4) )
           => ~ typing(shift(type,Ea,zero_zero(nat),T3),Ta,U4) ) ) ).

tff(fact_39_typing__elims_I2_J,axiom,
    ! [Ta1: type,U3: dB,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),U3),Ta1)
     => ~ ! [T3: type] :
            ( typing(Ea,Ta,fun1(T3,Ta1))
           => ~ typing(Ea,U3,T3) ) ) ).

tff(fact_40_dB_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( dB_size(var(Nat1)) = zero_zero(nat) ) ).

tff(fact_41_Beta,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss1))) ) ) ).

tff(fact_42_beta,axiom,
    ! [T1: dB,S3: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S3)),T1)),subst(S3,T1,zero_zero(nat)))) ).

tff(fact_43_appR,axiom,
    ! [U1: dB,T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S3)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T1))) ) ).

tff(fact_44_appL,axiom,
    ! [U1: dB,T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S3),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1))) ) ).

tff(fact_45_beta__cases_I1_J,axiom,
    ! [T1: dB,I1: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I1)),T1)) ).

tff(fact_46_abs,axiom,
    ! [T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S3)),abs(T1))) ) ).

tff(fact_47_subject__reduction,axiom,
    ! [T2: dB,Ta1: type,Ta: dB,Ea: fun(nat,type)] :
      ( typing(Ea,Ta,Ta1)
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T2))
       => typing(Ea,T2,Ta1) ) ) ).

tff(fact_48_subst__preserves__beta,axiom,
    ! [I1: nat,T1: dB,S3: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S3))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R3,T1,I1)),subst(S3,T1,I1))) ) ).

tff(fact_49_lift__preserves__beta,axiom,
    ! [I1: nat,S3: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S3))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,lift(R3,I1)),lift(S3,I1))) ) ).

tff(fact_50_var__app__type__eq,axiom,
    ! [U2: type,Ta1: type,Ts: list(dB),I: nat,Ea: fun(nat,type)] :
      ( typing(Ea,foldl(dB,dB,app,var(I),Ts),Ta1)
     => ( typing(Ea,foldl(dB,dB,app,var(I),Ts),U2)
       => ( Ta1 = U2 ) ) ) ).

tff(fact_51_zero__reorient,axiom,
    ! [A1: $tType] :
      ( zero(A1)
     => ! [X: A1] :
          ( ( zero_zero(A1) = X )
        <=> ( X = zero_zero(A1) ) ) ) ).

tff(fact_52_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( R = S )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_53_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss1) )
    <=> ( ( M = N )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_54_beta__cases_I2_J,axiom,
    ! [S3: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S3))
     => ~ ! [T: dB] :
            ( ( S3 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T)) ) ) ).

tff(fact_55_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_56_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss1) ) ).

tff(fact_57_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R),Ss1) ) ).

tff(fact_58_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_59_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T1)),U1))
     => ( ! [S1: dB] :
            ( ( U1 = subst(S1,T1,zero_zero(nat)) )
           => ( S3 != abs(S1) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S3),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S3),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_60_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_61_IT_Osimps,axiom,
    ! [A3: dB] :
      ( pp(aa(dB,bool,it,A3))
    <=> ( ? [Rs2: list(dB),N1: nat] :
            ( ( A3 = foldl(dB,dB,app,var(N1),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R2: dB] :
            ( ( A3 = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S2: dB,Ss2: list(dB)] :
            ( ( A3 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S2),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R2,S2,zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S2)) ) ) ) ).

tff(fact_62_type_Osimps_I6_J,axiom,
    ! [A1: $tType,Type22: type,Type12: type,F2: fun(type,fun(type,A1)),F1: fun(nat,A1)] : ( type_case(A1,F1,F2,fun1(Type12,Type22)) = aa(type,A1,aa(type,fun(type,A1),F2,Type12),Type22) ) ).

tff(fact_63_dB_Osize_I4_J,axiom,
    ! [Nat1: nat] : ( size_size(dB,var(Nat1)) = zero_zero(nat) ) ).

tff(fact_64_apps__preserves__betas,axiom,
    ! [R: dB,Ss1: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss1)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),foldl(dB,dB,app,R,Ss1))) ) ).

tff(fact_65_type_Osimps_I5_J,axiom,
    ! [A1: $tType,Nat2: nat,F2: fun(type,fun(type,A1)),F1: fun(nat,A1)] : ( type_case(A1,F1,F2,atom(Nat2)) = aa(nat,A1,F1,Nat2) ) ).

tff(fact_66_apps__eq__Abs__conv,axiom,
    ! [R: dB,Ss1: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss1) = abs(R) )
    <=> ( ( S = abs(R) )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_67_type_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( atom(Nat2) = atom(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_68_Var__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( var(M) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_69_Abs__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( ( abs(R) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( abs(R) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_70_type_Osimps_I3_J,axiom,
    ! [Type21: type,Type11: type,Nat1: nat] : ( atom(Nat1) != fun1(Type11,Type21) ) ).

tff(fact_71_type_Osimps_I4_J,axiom,
    ! [Nat1: nat,Type21: type,Type11: type] : ( fun1(Type11,Type21) != atom(Nat1) ) ).

tff(fact_72_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rs,Ss)
          & ( V = foldl(dB,dB,app,var(N),Ss) ) ) ) ).

tff(fact_73_listsp_ONil,axiom,
    ! [A1: $tType,A: fun(A1,bool)] : listsp(A1,A,nil(A1)) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A1: $tType,G: fun(A1,B),F: fun(A1,B)] :
      ( ! [X2: A1] : ( aa(A1,B,F,X2) = aa(A1,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A1: $tType,A: fun(A1,bool),X: A1] :
      ( member(A1,X,A)
    <=> pp(aa(A1,bool,A,X)) ) ).

tff(fact_76_type_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( type_size(atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_77_foldl__Nil,axiom,
    ! [B: $tType,A1: $tType,A3: A1,F: fun(A1,fun(B,A1))] : ( foldl(A1,B,F,A3,nil(B)) = A3 ) ).

tff(fact_78_type_Osize_I3_J,axiom,
    ! [Nat1: nat] : ( size_size(type,atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_79_not__Nil__step1,axiom,
    ! [A1: $tType,Xs: list(A1),R: fun(A1,fun(A1,bool))] : ~ step1(A1,R,nil(A1),Xs) ).

tff(fact_80_not__step1__Nil,axiom,
    ! [A1: $tType,Xs: list(A1),R: fun(A1,fun(A1,bool))] : ~ step1(A1,R,Xs,nil(A1)) ).

tff(fact_81_type_Oexhaust,axiom,
    ! [Y2: type] :
      ( ! [Nat: nat] : ( Y2 != atom(Nat) )
     => ~ ! [Type1: type,Type2: type] : ( Y2 != fun1(Type1,Type2) ) ) ).

tff(fact_82_foldl__fun__comm,axiom,
    ! [B: $tType,A1: $tType,X: A1,Xs: list(A1),S: B,F: fun(B,fun(A1,B))] :
      ( ! [X2: A1,Y: A1,S1: B] : ( aa(A1,B,aa(B,fun(A1,B),F,aa(A1,B,aa(B,fun(A1,B),F,S1),X2)),Y) = aa(A1,B,aa(B,fun(A1,B),F,aa(A1,B,aa(B,fun(A1,B),F,S1),Y)),X2) )
     => ( aa(A1,B,aa(B,fun(A1,B),F,foldl(B,A1,F,S,Xs)),X) = foldl(B,A1,F,aa(A1,B,aa(B,fun(A1,B),F,S),X),Xs) ) ) ).

tff(fact_83_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,R,Rs1) ) )
         => ~ ! [T: dB] :
                ( ( R = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rs = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,subst(T,U,zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_84_list_Osimps_I4_J,axiom,
    ! [B: $tType,A1: $tType,F2: fun(B,fun(list(B),A1)),F1: A1] : ( list_case(A1,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_85_list_Oinject,axiom,
    ! [A1: $tType,List3: list(A1),A6: A1,List1: list(A1),A3: A1] :
      ( ( cons(A1,A3,List1) = cons(A1,A6,List3) )
    <=> ( ( A3 = A6 )
        & ( List1 = List3 ) ) ) ).

tff(fact_86_Cons__step1__Cons,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1,Ys: list(A1),Y3: A1,R: fun(A1,fun(A1,bool))] :
      ( step1(A1,R,cons(A1,Y3,Ys),cons(A1,X,Xs))
    <=> ( ( pp(aa(A1,bool,aa(A1,fun(A1,bool),R,Y3),X))
          & ( Xs = Ys ) )
        | ( ( X = Y3 )
          & step1(A1,R,Ys,Xs) ) ) ) ).

tff(fact_87_list_Osimps_I3_J,axiom,
    ! [A1: $tType,List2: list(A1),A5: A1] : ( cons(A1,A5,List2) != nil(A1) ) ).

tff(fact_88_list_Osimps_I2_J,axiom,
    ! [A1: $tType,List2: list(A1),A5: A1] : ( nil(A1) != cons(A1,A5,List2) ) ).

tff(fact_89_not__Cons__self,axiom,
    ! [A1: $tType,X1: A1,Xs1: list(A1)] : ( Xs1 != cons(A1,X1,Xs1) ) ).

tff(fact_90_not__Cons__self2,axiom,
    ! [A1: $tType,Xs1: list(A1),X1: A1] : ( cons(A1,X1,Xs1) != Xs1 ) ).

tff(fact_91_list_Osimps_I5_J,axiom,
    ! [A1: $tType,B: $tType,List1: list(B),A3: B,F2: fun(B,fun(list(B),A1)),F1: A1] : ( list_case(A1,B,F1,F2,cons(B,A3,List1)) = aa(list(B),A1,aa(B,fun(list(B),A1),F2,A3),List1) ) ).

tff(fact_92_foldl__Cons,axiom,
    ! [A1: $tType,B: $tType,Xs: list(B),X: B,A3: A1,F: fun(A1,fun(B,A1))] : ( foldl(A1,B,F,A3,cons(B,X,Xs)) = foldl(A1,B,F,aa(B,A1,aa(A1,fun(B,A1),F,A3),X),Xs) ) ).

tff(fact_93_listsp_Osimps,axiom,
    ! [A1: $tType,A3: list(A1),A: fun(A1,bool)] :
      ( listsp(A1,A,A3)
    <=> ( ( A3 = nil(A1) )
        | ? [A4: A1,L: list(A1)] :
            ( ( A3 = cons(A1,A4,L) )
            & pp(aa(A1,bool,A,A4))
            & listsp(A1,A,L) ) ) ) ).

tff(fact_94_list_Oexhaust,axiom,
    ! [A1: $tType,Y2: list(A1)] :
      ( ( Y2 != nil(A1) )
     => ~ ! [A2: A1,List: list(A1)] : ( Y2 != cons(A1,A2,List) ) ) ).

tff(fact_95_neq__Nil__conv,axiom,
    ! [A1: $tType,Xs: list(A1)] :
      ( ( Xs != nil(A1) )
    <=> ? [Y1: A1,Ys1: list(A1)] : ( Xs = cons(A1,Y1,Ys1) ) ) ).

tff(fact_96_Cons__step1E,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1,Ys: list(A1),R: fun(A1,fun(A1,bool))] :
      ( step1(A1,R,Ys,cons(A1,X,Xs))
     => ( ! [Y: A1] :
            ( ( Ys = cons(A1,Y,Xs) )
           => ~ pp(aa(A1,bool,aa(A1,fun(A1,bool),R,Y),X)) )
       => ~ ! [Zs: list(A1)] :
              ( ( Ys = cons(A1,X,Zs) )
             => ~ step1(A1,R,Zs,Xs) ) ) ) ).

tff(fact_97_insert__Nil,axiom,
    ! [A1: $tType,X1: A1] : ( insert(A1,X1,nil(A1)) = cons(A1,X1,nil(A1)) ) ).

tff(fact_98_sublist__singleton,axiom,
    ! [A1: $tType,X: A1,A: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A)
       => ( sublist(A1,cons(A1,X,nil(A1)),A) = cons(A1,X,nil(A1)) ) )
      & ( ~ member(nat,zero_zero(nat),A)
       => ( sublist(A1,cons(A1,X,nil(A1)),A) = nil(A1) ) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,t)) ).

%------------------------------------------------------------------------------
