%------------------------------------------------------------------------------
% File     : LCL841_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 238
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_238 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  161 (  55 unt;  51 typ;   0 def)
%            Number of atoms       :  213 (  95 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  138 (  35   ~;   6   |;  12   &)
%                                         (  17 <=>;  68  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   41 (  20   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-3 aty)
%            Number of functors    :   40 (  40 usr;  21 con; 0-5 aty)
%            Number of variables   :  341 ( 307   !;   9   ?; 341   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:45
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_r____,type,
    r: dB ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (98)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_1_Beta_I6_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_Beta_I3_J,axiom,
    pp(aa(dB,bool,it,a)) ).

tff(fact_3_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_4_Beta_I1_J,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as))) ).

tff(fact_5_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_6_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S2: dB,Rs1: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs1) = foldl(dB,dB,app,abs(S2),Ss1) )
    <=> ( ( Ra = S2 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_7_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_8_subst__App,axiom,
    ! [K1: nat,S: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),K1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S),K1)) ) ).

tff(fact_9_apps__eq__tail__conv,axiom,
    ! [S2: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S2,Ts) )
    <=> ( Ra = S2 ) ) ).

tff(fact_10_IT_OBeta,axiom,
    ! [Ss1: list(dB),S2: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S2),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S2))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S2),Ss1))) ) ) ).

tff(fact_11__096IT_A_IAbs_A_Ir_091lift_Au_A0_PSuc_Ai_093_J_A_092_060degree_062_Aa_091u_Pi_093_A_092_060degree_062_092_060degree_062_Amap_A_I_Ft_O_At_091u_Pi_093_J_Aas_J_096,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),suc(i)))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),as)))) ).

tff(fact_12_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB4: dB] :
      ( ( abs(DB4) = abs(DB5) )
    <=> ( DB4 = DB5 ) ) ).

tff(fact_13_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_14_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB3: dB] : ( abs(DB3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_15_dB_Osimps_I8_J,axiom,
    ! [DB3: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB3) ) ).

tff(fact_16_T,axiom,
    typing(shift(type,e,i,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t1) ).

tff(fact_17_uT,axiom,
    typing(e,u,t) ).

tff(fact_18_Beta_I7_J,axiom,
    typing(ea,ua,t) ).

tff(fact_19_lift_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T)),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S),K1)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)) ) ).

tff(fact_20_SI2,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t),a,T_b)
     => ( pp(aa(dB,bool,it,Ub))
       => ( typing(Eb,Ub,t)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),Ub),Ib))) ) ) ) ).

tff(fact_21_SI1,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as),T_b)
     => ( pp(aa(dB,bool,it,Ub))
       => ( typing(Eb,Ub,t)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),Ub),Ib))) ) ) ) ).

tff(fact_22_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_23_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_24_Beta_I5_J,axiom,
    typing(shift(type,ea,ia,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t_a) ).

tff(fact_25_subst__lift,axiom,
    ! [S: dB,K1: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)),S),K1) = T ) ).

tff(fact_26_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( typing(shift(type,Eb,Ib,T2),Ta,Ta1)
         => ( pp(aa(dB,bool,it,Ub))
           => ( typing(Eb,Ub,T2)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_27_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( typing(shift(type,Eb,Ib,T11),Ta,Ta1)
         => ( pp(aa(dB,bool,it,Ub))
           => ( typing(Eb,Ub,T11)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_28_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta,Ta1)
     => typing(shift(type,Eb,Ib,Ua),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),Ta1) ) ).

tff(fact_29_shift__commute,axiom,
    ! [A: $tType,Ta1: A,Ua: A,Ib: nat,Eb: fun(nat,A)] : ( shift(A,shift(A,Eb,Ib,Ua),zero_zero(nat),Ta1) = shift(A,shift(A,Eb,zero_zero(nat),Ta1),suc(Ib),Ua) ) ).

tff(fact_30_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta,Ta1)
     => ( typing(E,Ub,Ua)
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => typing(E,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),Ta1) ) ) ) ).

tff(fact_31_map__ident,axiom,
    ! [A: $tType,X2: list(A)] : ( map(A,A,combi(A),X2) = X2 ) ).

tff(fact_32_nat_Oinject,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( suc(Nat1) = suc(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_33_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_34_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S2: dB,Env: fun(nat,type)] :
      ( typing(Env,S2,aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua))
     => ( typing(Env,Ta,Ta1)
       => typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),Ta),Ua) ) ) ).

tff(fact_35_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),Ta1),Ta,Ua)
     => typing(Env,abs(Ta),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)) ) ).

tff(fact_36_Suc__inject,axiom,
    ! [Y: nat,X3: nat] :
      ( ( suc(X3) = suc(Y) )
     => ( X3 = Y ) ) ).

tff(fact_37_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_38_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_39_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J1) = Ta1 ) ) ).

tff(fact_40_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_41_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_42_nat_Osimps_I3_J,axiom,
    ! [Nat5: nat] : ( suc(Nat5) != zero_zero(nat) ) ).

tff(fact_43_Suc__not__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_44_nat_Osimps_I2_J,axiom,
    ! [Nat4: nat] : ( zero_zero(nat) != suc(Nat4) ) ).

tff(fact_45_Zero__not__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_46_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_47_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta),Ta1)
     => ~ ! [T1: type,U1: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T1),U1) )
           => ~ typing(shift(type,Eb,zero_zero(nat),T1),Ta,U1) ) ) ).

tff(fact_48_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub),Ta1)
     => ~ ! [T1: type] :
            ( typing(Eb,Ta,aa(type,type,aa(type,fun(type,type),fun1,T1),Ta1))
           => ~ typing(Eb,Ub,T1) ) ) ).

tff(fact_49_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta),Ta1)
     => ~ ! [U1: type,V: type] : ~ typing(shift(type,Eb,zero_zero(nat),U1),Ta,V) ) ).

tff(fact_50_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat3: nat] : ( Y != suc(Nat3) ) ) ).

tff(fact_51_zero__induct,axiom,
    ! [K: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K))
     => ( ! [N3: nat] :
            ( pp(aa(nat,bool,P1,suc(N3)))
           => pp(aa(nat,bool,P1,N3)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_52_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_53_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ? [M2: nat] : ( N = suc(M2) ) ) ).

tff(fact_54_nat__induct,axiom,
    ! [N1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N3: nat] :
            ( pp(aa(nat,bool,P1,N3))
           => pp(aa(nat,bool,P1,suc(N3))) )
       => pp(aa(nat,bool,P1,N1)) ) ) ).

tff(fact_55_substs__lemma,axiom,
    ! [Ts2: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ub,Ta1)
     => ( typings(shift(type,Eb,Ib,Ta1),Ts,Ts2)
       => typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts),Ts2) ) ) ).

tff(fact_56_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_57_listsp__conj__eq,axiom,
    ! [A: $tType,B2: fun(A,bool),A1: fun(A,bool),X2: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B2),X2)
    <=> ( listsp(A,A1,X2)
        & listsp(A,B2,X2) ) ) ).

tff(fact_58_lift__types,axiom,
    ! [Ua: type,Ib: nat,Ts2: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Ts2)
     => typings(shift(type,Eb,Ib,Ua),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts),Ts2) ) ).

tff(fact_59_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Ts2: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta,foldr(type,type,fun1,Ts2,Ta1))
     => ( typings(Eb,Ts,Ts2)
       => typing(Eb,foldl(dB,dB,app,Ta,Ts),Ta1) ) ) ).

tff(fact_60_IT_OVar,axiom,
    ! [N1: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs1))) ) ).

tff(fact_61_liftn__lift,axiom,
    ! [K1: nat,T: dB,N: nat] : ( liftn(suc(N),T,K1) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N,T,K1)),K1) ) ).

tff(fact_62_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_63_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,var(Ib),Ta1)
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_64_typing_OVar,axiom,
    ! [Ta1: type,X1: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X1) = Ta1 )
     => typing(Env,var(X1),Ta1) ) ).

tff(fact_65_liftn_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S,K1)),liftn(N,T,K1)) ) ).

tff(fact_66_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N1: nat,Rs1: list(dB),M1: nat] :
      ( ( foldl(dB,dB,app,var(M1),Rs1) = foldl(dB,dB,app,var(N1),Ss1) )
    <=> ( ( M1 = N1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_67_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_68_subst__eq,axiom,
    ! [U: dB,K1: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K1)),U),K1) = U ) ).

tff(fact_69_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB3: dB] : ( abs(DB3) != var(Nat) ) ).

tff(fact_70_dB_Osimps_I6_J,axiom,
    ! [DB3: dB,Nat: nat] : ( var(Nat) != abs(DB3) ) ).

tff(fact_71_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_72_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_74_liftn__0,axiom,
    ! [K1: nat,T: dB] : ( liftn(zero_zero(nat),T,K1) = T ) ).

tff(fact_75_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_76_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),var(I)),J))) ) ).

tff(fact_77_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ta1)
     => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ua)
       => ( Ta1 = Ua ) ) ) ).

tff(fact_78_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),Ra: dB,Ts: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts) != foldl(dB,dB,app,abs(Ra),Ss1) ) ).

tff(fact_79_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N1: nat,Ta: dB,S2: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),Ta) != foldl(dB,dB,app,var(N1),Ss1) ) ).

tff(fact_80_var__app__types,axiom,
    ! [Ua: type,Ts2: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us),Ta1)
     => ( typings(Eb,Ts,Ts2)
       => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ua)
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta1) )
              & typings(Eb,Us,Us1) ) ) ) ) ).

tff(fact_81_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ta1)
     => ~ ! [Ts1: list(type)] :
            ( typing(Eb,var(Ib),foldr(type,type,fun1,Ts1,Ta1))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_82_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,Ta,Ts),Ta1)
     => ~ ! [Ts1: list(type)] :
            ( typing(Eb,Ta,foldr(type,type,fun1,Ts1,Ta1))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_83_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,Ta,Ts),Ta1)
     => ? [Ts1: list(type)] :
          ( typing(Eb,Ta,foldr(type,type,fun1,Ts1,Ta1))
          & typings(Eb,Ts,Ts1) ) ) ).

tff(fact_84_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs: list(dB),N2: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N2),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R1: dB] :
            ( ( Aa = abs(R1) )
            & pp(aa(dB,bool,it,R1)) )
        | ? [R1: dB,S1: dB,Ss: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S1),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S1),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S1)) ) ) ) ).

tff(fact_85_substn__subst__n,axiom,
    ! [N: nat,S: dB,T: dB] : ( substn(T,S,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N,S,zero_zero(nat))),N) ) ).

tff(fact_86_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_87_substn_Osimps_I2_J,axiom,
    ! [K1: nat,S: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S,K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S,K1)),substn(U,S,K1)) ) ).

tff(fact_88_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_89_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = plus_plus(nat,dB_size(DB),suc(zero_zero(nat))) ) ).

tff(fact_90_dB_Osize_I2_J,axiom,
    ! [DB2: dB,DB1: dB] : ( dB_size(aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = plus_plus(nat,plus_plus(nat,dB_size(DB1),dB_size(DB2)),suc(zero_zero(nat))) ) ).

tff(fact_91_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,B1: A] :
          ( ( plus_plus(A,B1,Aa) = plus_plus(A,C1,Aa) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_92_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,Aa: A] :
          ( ( plus_plus(A,Aa,B1) = plus_plus(A,Aa,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_93_nat__add__right__cancel,axiom,
    ! [N1: nat,K: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K) = plus_plus(nat,N1,K) )
    <=> ( M1 = N1 ) ) ).

tff(fact_94_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K: nat] :
      ( ( plus_plus(nat,K,M1) = plus_plus(nat,K,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_95_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_96_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_97_add__Suc,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = suc(plus_plus(nat,M,N)) ) ).

%----Arities (2)
tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as)),u),i))) ).

%------------------------------------------------------------------------------
