%------------------------------------------------------------------------------
% File     : LCL840_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 236
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_236 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.25 v7.1.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  158 (  54 unt;  49 typ;   0 def)
%            Number of atoms       :  212 (  78 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  145 (  42   ~;   6   |;  10   &)
%                                         (  11 <=>;  76  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   35 (  18   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-3 aty)
%            Number of functors    :   39 (  39 usr;  23 con; 0-5 aty)
%            Number of variables   :  319 ( 289   !;   8   ?; 319   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:38
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H_H____,type,
    t2: type ).

tff(sy_v_T_H____,type,
    t: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t1: type ).

tff(sy_v_Ua____,type,
    ua1: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_r____,type,
    r: dB ).

tff(sy_v_t____,type,
    t3: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (98)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t3)) ).

tff(fact_1_Beta_I6_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_uT,axiom,
    typing(e,u,t1) ).

tff(fact_4_Beta_I3_J,axiom,
    pp(aa(dB,bool,it,a)) ).

tff(fact_5__096e_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_H_096,axiom,
    typing(shift(type,e,i,t1),a,t2) ).

tff(fact_6__096_B_Bthesis_O_A_I_B_BT_H_H_O_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_H_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [T4: type] : ~ typing(shift(type,e,i,t1),a,T4) ).

tff(fact_7_MI1,axiom,
    ! [Ub1: dB,Ta: type,Ib: nat,Eb: fun(nat,type),Ta1: dB,T21: type,T11: type] :
      ( ( t1 = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( typing(shift(type,Eb,Ib,T11),Ta1,Ta)
         => ( pp(aa(dB,bool,it,Ub1))
           => ( typing(Eb,Ub1,T11)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub1),Ib))) ) ) ) ) ) ).

tff(fact_8_MI2,axiom,
    ! [Ub1: dB,Ta: type,Ib: nat,Eb: fun(nat,type),Ta1: dB,T21: type,T11: type] :
      ( ( t1 = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( typing(shift(type,Eb,Ib,T21),Ta1,Ta)
         => ( pp(aa(dB,bool,it,Ub1))
           => ( typing(Eb,Ub1,T21)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub1),Ib))) ) ) ) ) ) ).

tff(fact_9_subst__Var__IT,axiom,
    ! [J1: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),var(I)),J1))) ) ).

tff(fact_10_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_11__096IT_A_I_Ir_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_J_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),u),i))) ).

tff(fact_12_SI2,axiom,
    ! [Ub1: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t1),a,T_b)
     => ( pp(aa(dB,bool,it,Ub1))
       => ( typing(Eb,Ub1,t1)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),Ub1),Ib))) ) ) ) ).

tff(fact_13_Var__IT,axiom,
    ! [N3: nat] : pp(aa(dB,bool,it,var(N3))) ).

tff(fact_14_subst__lemma,axiom,
    ! [Ib: nat,Ub: type,Ub1: dB,E: fun(nat,type),Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,Ta)
     => ( typing(E,Ub1,Ub)
       => ( ( Eb = shift(type,E,Ib,Ub) )
         => typing(E,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub1),Ib),Ta) ) ) ) ).

tff(fact_15__096e_060i_058T_062_A_092_060turnstile_062_AAbs_Ar_A_092_060degree_062_Aa_A_058_AU_096,axiom,
    typing(shift(type,e,i,t1),aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),ua1) ).

tff(fact_16__096_B_Bthesis_O_A_I_B_BU_O_Ae_060i_058T_062_A_092_060turnstile_062_AAbs_Ar_A_092_060degree_062_Aa_A_058_AU_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [U1: type] : ~ typing(shift(type,e,i,t1),aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),U1) ).

tff(fact_17_Beta_I1_J,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as))) ).

tff(fact_18_Beta_I7_J,axiom,
    typing(ea,ua,t1) ).

tff(fact_19_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_20_typing_OVar,axiom,
    ! [Ta: type,X1: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X1) = Ta )
     => typing(Env,var(X1),Ta) ) ).

tff(fact_21_typing__elims_I1_J,axiom,
    ! [Ta: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,var(Ib),Ta)
     => ( aa(nat,type,Eb,Ib) = Ta ) ) ).

tff(fact_22_App,axiom,
    ! [Ta1: dB,Ub: type,Ta: type,S3: dB,Env: fun(nat,type)] :
      ( typing(Env,S3,aa(type,type,aa(type,fun(type,type),fun1,Ta),Ub))
     => ( typing(Env,Ta1,Ta)
       => typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S3),Ta1),Ub) ) ) ).

tff(fact_23_T,axiom,
    typing(shift(type,e,i,t1),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t) ).

tff(fact_24_lift__type,axiom,
    ! [Ub: type,Ib: nat,Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,Ta)
     => typing(shift(type,Eb,Ib,Ub),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta1),Ib),Ta) ) ).

tff(fact_25_SI1,axiom,
    ! [Ub1: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t1),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as),T_b)
     => ( pp(aa(dB,bool,it,Ub1))
       => ( typing(Eb,Ub1,t1)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),Ub1),Ib))) ) ) ) ).

tff(fact_26_Abs,axiom,
    ! [Ub: type,Ta1: dB,Ta: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),Ta),Ta1,Ub)
     => typing(Env,abs(Ta1),aa(type,type,aa(type,fun(type,type),fun1,Ta),Ub)) ) ).

tff(fact_27_Beta_I5_J,axiom,
    typing(shift(type,ea,ia,t1),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t_a) ).

tff(fact_28__096e_060i_058T_062_A_092_060turnstile_062_Ar_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    typing(shift(type,e,i,t1),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as),t) ).

tff(fact_29_shift__eq,axiom,
    ! [A: $tType,Ta: A,Eb: fun(nat,A),J: nat,Ib: nat] :
      ( ( Ib = J )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta),J) = Ta ) ) ).

tff(fact_30_var__app__type__eq,axiom,
    ! [Ub: type,Ta: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ta)
     => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ub)
       => ( Ta = Ub ) ) ) ).

tff(fact_31_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_32_IT_OBeta,axiom,
    ! [Ss1: list(dB),S3: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S3),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S3))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S3),Ss1))) ) ) ).

tff(fact_33_typing__elims_I3_J,axiom,
    ! [Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta1),Ta)
     => ~ ! [T3: type,U1: type] :
            ( ( Ta = aa(type,type,aa(type,fun(type,type),fun1,T3),U1) )
           => ~ typing(shift(type,Eb,zero_zero(nat),T3),Ta1,U1) ) ) ).

tff(fact_34_typing__elims_I2_J,axiom,
    ! [Ta: type,Ub1: dB,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta1),Ub1),Ta)
     => ~ ! [T3: type] :
            ( typing(Eb,Ta1,aa(type,type,aa(type,fun(type,type),fun1,T3),Ta))
           => ~ typing(Eb,Ub1,T3) ) ) ).

tff(fact_35__096Abs_Ar_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_092_060rightarrow_062_092_060_094sub_062_092_060beta_062r_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_096,axiom,
    beta(foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)) ).

tff(fact_36_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N1: nat,Rs1: list(dB),M2: nat] :
      ( ( foldl(dB,dB,app,var(M2),Rs1) = foldl(dB,dB,app,var(N1),Ss1) )
    <=> ( ( M2 = N1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_37_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S3: dB,Rs1: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs1) = foldl(dB,dB,app,abs(S3),Ss1) )
    <=> ( ( Ra = S3 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_38_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_39_lift_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T)),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K1)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)) ) ).

tff(fact_40_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_41_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_42_dB_Osimps_I1_J,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( var(Nat4) = var(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_43_apps__eq__tail__conv,axiom,
    ! [S3: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S3,Ts) )
    <=> ( Ra = S3 ) ) ).

tff(fact_44_appR,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S1),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_45_appL,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_46_subst__App,axiom,
    ! [K1: nat,S1: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S1),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S1),K1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S1),K1)) ) ).

tff(fact_47_abs,axiom,
    ! [T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(abs(S1),abs(T)) ) ).

tff(fact_48_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ beta(var(I),T) ).

tff(fact_49_beta,axiom,
    ! [T: dB,S1: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T),zero_zero(nat))) ).

tff(fact_50_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S1: dB,R2: dB] :
      ( beta(R2,S1)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),T),I),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T),I)) ) ).

tff(fact_51_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R2: dB] :
      ( beta(R2,S1)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),lift,R2),I),aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),I)) ) ).

tff(fact_52_subject__reduction,axiom,
    ! [T2: dB,Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,Ta)
     => ( beta(Ta1,T2)
       => typing(Eb,T2,Ta) ) ) ).

tff(fact_53_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB) ) ).

tff(fact_54_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_55_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != var(Nat) ) ).

tff(fact_56_dB_Osimps_I4_J,axiom,
    ! [DB2: dB,DB1: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_57_subst__eq,axiom,
    ! [U: dB,K1: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K1)),U),K1) = U ) ).

tff(fact_58_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_59_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_60_subst__lift,axiom,
    ! [S1: dB,K1: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)),S1),K1) = T ) ).

tff(fact_61_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),Ra: dB,Ts: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts) != foldl(dB,dB,app,abs(Ra),Ss1) ) ).

tff(fact_62_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N1: nat,Ta1: dB,S3: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S3)),Ta1) != foldl(dB,dB,app,var(N1),Ss1) ) ).

tff(fact_63_beta__cases_I2_J,axiom,
    ! [S1: dB,R2: dB] :
      ( beta(abs(R2),S1)
     => ~ ! [T1: dB] :
            ( ( S1 = abs(T1) )
           => ~ beta(R2,T1) ) ) ).

tff(fact_64_abs__typeE,axiom,
    ! [Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta1),Ta)
     => ~ ! [U1: type,V: type] : ~ typing(shift(type,Eb,zero_zero(nat),U1),Ta1,V) ) ).

tff(fact_65_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S3: dB,Ra: dB] :
      ( beta(Ra,S3)
     => beta(foldl(dB,dB,app,Ra,Ss1),foldl(dB,dB,app,S3,Ss1)) ) ).

tff(fact_66__096IT_A_Ir_091lift_Au_A0_PSuc_Ai_093_091a_091u_Pi_093_P0_093_A_092_060degree_062_092_060degree_062_Amap_A_I_Ft_O_At_091u_Pi_093_J_Aas_J_096,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),suc(i))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),as)))) ).

tff(fact_67_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),U)
     => ( ! [S2: dB] :
            ( ( U = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T),zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ beta(S1,T1) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1) )
               => ~ beta(T,T1) ) ) ) ) ).

tff(fact_68_shift__commute,axiom,
    ! [A: $tType,Ta: A,Ub: A,Ib: nat,Eb: fun(nat,A)] : ( shift(A,shift(A,Eb,Ib,Ub),zero_zero(nat),Ta) = shift(A,shift(A,Eb,zero_zero(nat),Ta),suc(Ib),Ub) ) ).

tff(fact_69_subst__map,axiom,
    ! [Ib: nat,Ub1: dB,Ts: list(dB),Ta1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta1,Ts)),Ub1),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub1),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub1),Ib),Ts)) ) ).

tff(fact_70_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta1,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta1),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_71_map__ident,axiom,
    ! [A: $tType,X: list(A)] : ( map(A,A,combi(A),X) = X ) ).

tff(fact_72_nat_Oinject,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( suc(Nat4) = suc(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_73_Suc__inject,axiom,
    ! [Y: nat,X3: nat] :
      ( ( suc(X3) = suc(Y) )
     => ( X3 = Y ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_Suc__n__not__n,axiom,
    ! [N3: nat] : ( suc(N3) != N3 ) ).

tff(fact_76_n__not__Suc__n,axiom,
    ! [N3: nat] : ( N3 != suc(N3) ) ).

tff(fact_77_Zero__not__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_78_nat_Osimps_I2_J,axiom,
    ! [Nat3: nat] : ( zero_zero(nat) != suc(Nat3) ) ).

tff(fact_79_Suc__not__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_80_nat_Osimps_I3_J,axiom,
    ! [Nat2: nat] : ( suc(Nat2) != zero_zero(nat) ) ).

tff(fact_81_Zero__neq__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_82_Suc__neq__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_83_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_84_not0__implies__Suc,axiom,
    ! [N3: nat] :
      ( ( N3 != zero_zero(nat) )
     => ? [M: nat] : ( N3 = suc(M) ) ) ).

tff(fact_85_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_86_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat1: nat] : ( Y != suc(Nat1) ) ) ).

tff(fact_87_zero__induct,axiom,
    ! [K: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,suc(N2)))
           => pp(aa(nat,bool,P1,N2)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_88_nat__induct,axiom,
    ! [N1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,N2))
           => pp(aa(nat,bool,P1,suc(N2))) )
       => pp(aa(nat,bool,P1,N1)) ) ) ).

tff(fact_89_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_90_IT_OVar,axiom,
    ! [N1: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs1))) ) ).

tff(fact_91_substs__lemma,axiom,
    ! [Ts1: list(type),Ts: list(dB),Ib: nat,Ta: type,Ub1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ub1,Ta)
     => ( typings(shift(type,Eb,Ib,Ta),Ts,Ts1)
       => typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub1),Ib),Ts),Ts1) ) ) ).

tff(fact_92_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X)
    <=> ( listsp(A,A1,X)
        & listsp(A,B1,X) ) ) ).

tff(fact_93_lift__types,axiom,
    ! [Ub: type,Ib: nat,Ts1: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Ts1)
     => typings(shift(type,Eb,Ib,Ub),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts),Ts1) ) ).

tff(fact_94_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_95_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs: list(dB),N: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R1: dB] :
            ( ( Aa = abs(R1) )
            & pp(aa(dB,bool,it,R1)) )
        | ? [R1: dB,S: dB,Ss: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S)) ) ) ) ).

tff(fact_96_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta: type,Ts1: list(type),Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,foldr(type,type,fun1,Ts1,Ta))
     => ( typings(Eb,Ts,Ts1)
       => typing(Eb,foldl(dB,dB,app,Ta1,Ts),Ta) ) ) ).

tff(fact_97_var__app__types,axiom,
    ! [Ub: type,Ts1: list(type),Ta: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us),Ta)
     => ( typings(Eb,Ts,Ts1)
       => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ub)
         => ? [Us1: list(type)] :
              ( ( Ub = foldr(type,type,fun1,Us1,Ta) )
              & typings(Eb,Us,Us1) ) ) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i))) ).

%------------------------------------------------------------------------------
