%------------------------------------------------------------------------------
% File     : LCL839_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 235
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_235 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  158 (  51 unt;  48 typ;   0 def)
%            Number of atoms       :  220 (  77 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  154 (  44   ~;   6   |;  11   &)
%                                         (  11 <=>;  82  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   34 (  17   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   1 prp; 0-3 aty)
%            Number of functors    :   37 (  37 usr;  22 con; 0-5 aty)
%            Number of variables   :  333 ( 302   !;   9   ?; 333   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:36
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_Ua____,type,
    ua1: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_r____,type,
    r: dB ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_thesis____,type,
    thesis: $o ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (98)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_1_Beta_I3_J,axiom,
    pp(aa(dB,bool,it,a)) ).

tff(fact_2_uT,axiom,
    typing(e,u,t) ).

tff(fact_3__096e_060i_058T_062_A_092_060turnstile_062_AAbs_Ar_A_092_060degree_062_Aa_A_058_AU_096,axiom,
    typing(shift(type,e,i,t),aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),ua1) ).

tff(fact_4__096_B_Bthesis_O_A_I_B_BU_O_Ae_060i_058T_062_A_092_060turnstile_062_AAbs_Ar_A_092_060degree_062_Aa_A_058_AU_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [U1: type] : ~ typing(shift(type,e,i,t),aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),U1) ).

tff(fact_5_T,axiom,
    typing(shift(type,e,i,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t1) ).

tff(fact_6_Beta_I6_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_7_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J1) = Ta1 ) ) ).

tff(fact_8__096e_060i_058T_062_A_092_060turnstile_062_Ar_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    typing(shift(type,e,i,t),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as),t1) ).

tff(fact_9_lift__type,axiom,
    ! [Ub: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta,Ta1)
     => typing(shift(type,Eb,Ib,Ub),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),Ta1) ) ).

tff(fact_10_MI1,axiom,
    ! [Ub1: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( typing(shift(type,Eb,Ib,T11),Ta,Ta1)
         => ( pp(aa(dB,bool,it,Ub1))
           => ( typing(Eb,Ub1,T11)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib))) ) ) ) ) ) ).

tff(fact_11_MI2,axiom,
    ! [Ub1: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( typing(shift(type,Eb,Ib,T21),Ta,Ta1)
         => ( pp(aa(dB,bool,it,Ub1))
           => ( typing(Eb,Ub1,T21)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib))) ) ) ) ) ) ).

tff(fact_12_SI2,axiom,
    ! [Ub1: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t),a,T_b)
     => ( pp(aa(dB,bool,it,Ub1))
       => ( typing(Eb,Ub1,t)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),Ub1),Ib))) ) ) ) ).

tff(fact_13_subst__lemma,axiom,
    ! [Ib: nat,Ub: type,Ub1: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta,Ta1)
     => ( typing(E,Ub1,Ub)
       => ( ( Eb = shift(type,E,Ib,Ub) )
         => typing(E,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib),Ta1) ) ) ) ).

tff(fact_14_Beta_I7_J,axiom,
    typing(ea,ua,t) ).

tff(fact_15_Beta_I5_J,axiom,
    typing(shift(type,ea,ia,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t_a) ).

tff(fact_16_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_17_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_18_Beta_I1_J,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as))) ).

tff(fact_19_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),I))) ) ).

tff(fact_20_App,axiom,
    ! [Ta: dB,Ub: type,Ta1: type,S1: dB,Env: fun(nat,type)] :
      ( typing(Env,S1,aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ub))
     => ( typing(Env,Ta,Ta1)
       => typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),Ta),Ub) ) ) ).

tff(fact_21__096IT_A_I_Ir_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_J_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),u),i))) ).

tff(fact_22_SI1,axiom,
    ! [Ub1: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as),T_b)
     => ( pp(aa(dB,bool,it,Ub1))
       => ( typing(Eb,Ub1,t)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),Ub1),Ib))) ) ) ) ).

tff(fact_23_Abs,axiom,
    ! [Ub: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),Ta1),Ta,Ub)
     => typing(Env,abs(Ta),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ub)) ) ).

tff(fact_24_IT_OBeta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S1),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S1))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S1),Ss1))) ) ) ).

tff(fact_25_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta),Ta1)
     => ~ ! [T4: type,U1: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T4),U1) )
           => ~ typing(shift(type,Eb,zero_zero(nat),T4),Ta,U1) ) ) ).

tff(fact_26_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub1: dB,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub1),Ta1)
     => ~ ! [T4: type] :
            ( typing(Eb,Ta,aa(type,type,aa(type,fun(type,type),fun1,T4),Ta1))
           => ~ typing(Eb,Ub1,T4) ) ) ).

tff(fact_27__096Abs_Ar_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_092_060rightarrow_062_092_060_094sub_062_092_060beta_062r_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_096,axiom,
    beta(foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)) ).

tff(fact_28_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S1: dB,Rs1: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs1) = foldl(dB,dB,app,abs(S1),Ss1) )
    <=> ( ( Ra = S1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_29_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_30_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)) ) ).

tff(fact_31_subst__App,axiom,
    ! [K: nat,S2: dB,U: dB,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U)),S2),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S2),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S2),K)) ) ).

tff(fact_32_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_33_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_34_apps__eq__tail__conv,axiom,
    ! [S1: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S1,Ts) )
    <=> ( Ra = S1 ) ) ).

tff(fact_35_appR,axiom,
    ! [U: dB,T1: dB,S2: dB] :
      ( beta(S2,T1)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S2),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T1)) ) ).

tff(fact_36_appL,axiom,
    ! [U: dB,T1: dB,S2: dB] :
      ( beta(S2,T1)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U)) ) ).

tff(fact_37_abs,axiom,
    ! [T1: dB,S2: dB] :
      ( beta(S2,T1)
     => beta(abs(S2),abs(T1)) ) ).

tff(fact_38_beta,axiom,
    ! [T1: dB,S2: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T1),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T1),zero_zero(nat))) ).

tff(fact_39_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S2: dB,R2: dB] :
      ( beta(R2,S2)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),T1),I),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T1),I)) ) ).

tff(fact_40_lift__preserves__beta,axiom,
    ! [I: nat,S2: dB,R2: dB] :
      ( beta(R2,S2)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),lift,R2),I),aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),I)) ) ).

tff(fact_41_subject__reduction,axiom,
    ! [T3: dB,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta,Ta1)
     => ( beta(Ta,T3)
       => typing(Eb,T3,Ta1) ) ) ).

tff(fact_42_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB) ) ).

tff(fact_43_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_44_subst__lift,axiom,
    ! [S2: dB,K: nat,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)),S2),K) = T1 ) ).

tff(fact_45_beta__cases_I2_J,axiom,
    ! [S2: dB,R2: dB] :
      ( beta(abs(R2),S2)
     => ~ ! [T2: dB] :
            ( ( S2 = abs(T2) )
           => ~ beta(R2,T2) ) ) ).

tff(fact_46_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta),Ta1)
     => ~ ! [U1: type,V: type] : ~ typing(shift(type,Eb,zero_zero(nat),U1),Ta,V) ) ).

tff(fact_47_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( beta(Ra,S1)
     => beta(foldl(dB,dB,app,Ra,Ss1),foldl(dB,dB,app,S1,Ss1)) ) ).

tff(fact_48__096IT_A_Ir_091lift_Au_A0_PSuc_Ai_093_091a_091u_Pi_093_P0_093_A_092_060degree_062_092_060degree_062_Amap_A_I_Ft_O_At_091u_Pi_093_J_Aas_J_096,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),suc(i))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),as)))) ).

tff(fact_49_beta__cases_I3_J,axiom,
    ! [U: dB,T1: dB,S2: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1),U)
     => ( ! [S3: dB] :
            ( ( U = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S3),T1),zero_zero(nat)) )
           => ( S2 != abs(S3) ) )
       => ( ! [T2: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T2),T1) )
             => ~ beta(S2,T2) )
         => ~ ! [T2: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2) )
               => ~ beta(T1,T2) ) ) ) ) ).

tff(fact_50_shift__commute,axiom,
    ! [A: $tType,Ta1: A,Ub: A,Ib: nat,Eb: fun(nat,A)] : ( shift(A,shift(A,Eb,Ib,Ub),zero_zero(nat),Ta1) = shift(A,shift(A,Eb,zero_zero(nat),Ta1),suc(Ib),Ub) ) ).

tff(fact_51_subst__map,axiom,
    ! [Ib: nat,Ub1: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub1),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub1),Ib),Ts)) ) ).

tff(fact_52_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_53_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_54_map__ident,axiom,
    ! [A: $tType,X2: list(A)] : ( map(A,A,combi(A),X2) = X2 ) ).

tff(fact_55_nat_Oinject,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( suc(Nat1) = suc(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_56_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_57_Suc__inject,axiom,
    ! [Y: nat,X3: nat] :
      ( ( suc(X3) = suc(Y) )
     => ( X3 = Y ) ) ).

tff(fact_58_Suc__n__not__n,axiom,
    ! [N2: nat] : ( suc(N2) != N2 ) ).

tff(fact_59_n__not__Suc__n,axiom,
    ! [N2: nat] : ( N2 != suc(N2) ) ).

tff(fact_60_Zero__not__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_61_nat_Osimps_I2_J,axiom,
    ! [Nat5: nat] : ( zero_zero(nat) != suc(Nat5) ) ).

tff(fact_62_Suc__not__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_63_nat_Osimps_I3_J,axiom,
    ! [Nat4: nat] : ( suc(Nat4) != zero_zero(nat) ) ).

tff(fact_64_Zero__neq__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_65_Suc__neq__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_66_not0__implies__Suc,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ? [M1: nat] : ( N2 = suc(M1) ) ) ).

tff(fact_67_nat__induct,axiom,
    ! [N1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N3: nat] :
            ( pp(aa(nat,bool,P1,N3))
           => pp(aa(nat,bool,P1,suc(N3))) )
       => pp(aa(nat,bool,P1,N1)) ) ) ).

tff(fact_68_zero__induct,axiom,
    ! [K1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K1))
     => ( ! [N3: nat] :
            ( pp(aa(nat,bool,P1,suc(N3)))
           => pp(aa(nat,bool,P1,N3)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_69_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat3: nat] : ( Y != suc(Nat3) ) ) ).

tff(fact_70_substs__lemma,axiom,
    ! [Ts2: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ub1,Ta1)
     => ( typings(shift(type,Eb,Ib,Ta1),Ts,Ts2)
       => typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub1),Ib),Ts),Ts2) ) ) ).

tff(fact_71_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_72_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X2)
    <=> ( listsp(A,A1,X2)
        & listsp(A,B1,X2) ) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_lift__types,axiom,
    ! [Ub: type,Ib: nat,Ts2: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Ts2)
     => typings(shift(type,Eb,Ib,Ub),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts),Ts2) ) ).

tff(fact_75_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Ts2: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta,foldr(type,type,fun1,Ts2,Ta1))
     => ( typings(Eb,Ts,Ts2)
       => typing(Eb,foldl(dB,dB,app,Ta,Ts),Ta1) ) ) ).

tff(fact_76_IT_OVar,axiom,
    ! [N1: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs1))) ) ).

tff(fact_77_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_78_typing_OVar,axiom,
    ! [Ta1: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta1 )
     => typing(Env,var(X),Ta1) ) ).

tff(fact_79_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,var(Ib),Ta1)
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_80_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ beta(var(I),T1) ).

tff(fact_81_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N1: nat,Rs1: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs1) = foldl(dB,dB,app,var(N1),Ss1) )
    <=> ( ( M = N1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_82_Var__IT,axiom,
    ! [N2: nat] : pp(aa(dB,bool,it,var(N2))) ).

tff(fact_83_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_84_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_85_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_86_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != var(Nat) ) ).

tff(fact_87_dB_Osimps_I4_J,axiom,
    ! [DB2: dB,DB1: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_88_app__Var__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),var(I)))) ) ).

tff(fact_89_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),var(I)),J))) ) ).

tff(fact_90_var__app__type__eq,axiom,
    ! [Ub: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ta1)
     => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ub)
       => ( Ta1 = Ub ) ) ) ).

tff(fact_91_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N1: nat,Ta: dB,S1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),Ta) != foldl(dB,dB,app,var(N1),Ss1) ) ).

tff(fact_92_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),Ra: dB,Ts: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts) != foldl(dB,dB,app,abs(Ra),Ss1) ) ).

tff(fact_93_var__app__types,axiom,
    ! [Ub: type,Ts2: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us),Ta1)
     => ( typings(Eb,Ts,Ts2)
       => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ub)
         => ? [Us1: list(type)] :
              ( ( Ub = foldr(type,type,fun1,Us1,Ta1) )
              & typings(Eb,Us,Us1) ) ) ) ) ).

tff(fact_94_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ta1)
     => ~ ! [Ts1: list(type)] :
            ( typing(Eb,var(Ib),foldr(type,type,fun1,Ts1,Ta1))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_95_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,Ta,Ts),Ta1)
     => ~ ! [Ts1: list(type)] :
            ( typing(Eb,Ta,foldr(type,type,fun1,Ts1,Ta1))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_96_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,Ta,Ts),Ta1)
     => ? [Ts1: list(type)] :
          ( typing(Eb,Ta,foldr(type,type,fun1,Ts1,Ta1))
          & typings(Eb,Ts,Ts1) ) ) ).

tff(fact_97_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs: list(dB),N: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R1: dB] :
            ( ( Aa = abs(R1) )
            & pp(aa(dB,bool,it,R1)) )
        | ? [R1: dB,S: dB,Ss: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S)) ) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [T: type] :
      ( typing(shift(type,e,i,t),a,T)
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
