%------------------------------------------------------------------------------
% File     : LCL837_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 232
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_232 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  157 (  54 unt;  48 typ;   0 def)
%            Number of atoms       :  207 (  80 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  138 (  40   ~;   4   |;   6   &)
%                                         (  10 <=>;  78  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   40 (  19   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-3 aty)
%            Number of functors    :   38 (  38 usr;  21 con; 0-5 aty)
%            Number of variables   :  332 ( 308   !;   2   ?; 332   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:33
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_r____,type,
    r: dB ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (98)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_1_Beta_I6_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_Beta_I3_J,axiom,
    pp(aa(dB,bool,it,a)) ).

tff(fact_3_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_4_Beta_I1_J,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as))) ).

tff(fact_5__096IT_A_I_Ir_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_J_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),u),i))) ).

tff(fact_6_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_7_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta1,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta1),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_8_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta1,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_9_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)) ) ).

tff(fact_10_subst__App,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S1),K)) ) ).

tff(fact_11_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( Ra = S ) ) ).

tff(fact_12_map__ident,axiom,
    ! [A: $tType,X2: list(A)] : ( map(A,A,combi(A),X2) = X2 ) ).

tff(fact_13_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_14_nat_Oinject,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( suc(Nat1) = suc(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_15_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_16_subst__lift,axiom,
    ! [S1: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S1),K) = T ) ).

tff(fact_17_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_18_Suc__inject,axiom,
    ! [Y: nat,X3: nat] :
      ( ( suc(X3) = suc(Y) )
     => ( X3 = Y ) ) ).

tff(fact_19_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_20_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_21_Suc__neq__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_22_Zero__neq__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_23_nat_Osimps_I3_J,axiom,
    ! [Nat5: nat] : ( suc(Nat5) != zero_zero(nat) ) ).

tff(fact_24_Suc__not__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_25_nat_Osimps_I2_J,axiom,
    ! [Nat4: nat] : ( zero_zero(nat) != suc(Nat4) ) ).

tff(fact_26_Zero__not__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_27_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat3: nat] : ( Y != suc(Nat3) ) ) ).

tff(fact_28_zero__induct,axiom,
    ! [K1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K1))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,suc(N2)))
           => pp(aa(nat,bool,P1,N2)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_29_nat__induct,axiom,
    ! [N: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,N2))
           => pp(aa(nat,bool,P1,suc(N2))) )
       => pp(aa(nat,bool,P1,N)) ) ) ).

tff(fact_30_not0__implies__Suc,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ? [M1: nat] : ( N1 = suc(M1) ) ) ).

tff(fact_31__096Abs_Ar_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_092_060rightarrow_062_092_060_094sub_062_092_060beta_062r_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_096,axiom,
    beta(foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)) ).

tff(fact_32_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_33_SI1,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as),T_b)
     => ( pp(aa(dB,bool,it,Ub))
       => ( typing(Eb,Ub,t)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),Ub),Ib))) ) ) ) ).

tff(fact_34_liftn__lift,axiom,
    ! [K: nat,T: dB,N1: nat] : ( liftn(suc(N1),T,K) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N1,T,K)),K) ) ).

tff(fact_35_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_36_Beta_I7_J,axiom,
    typing(ea,ua,t) ).

tff(fact_37_uT,axiom,
    typing(e,u,t) ).

tff(fact_38_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X2)
    <=> ( listsp(A,A1,X2)
        & listsp(A,B1,X2) ) ) ).

tff(fact_39_appL,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_40_appR,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S1),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_41_SI2,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(shift(type,Eb,Ib,t),a,T_b)
     => ( pp(aa(dB,bool,it,Ub))
       => ( typing(Eb,Ub,t)
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),Ub),Ib))) ) ) ) ).

tff(fact_42_abs,axiom,
    ! [T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(abs(S1),abs(T)) ) ).

tff(fact_43_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S1,K)),liftn(N1,T,K)) ) ).

tff(fact_44_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( Ra = S )
        & ( Rs = Ss ) ) ) ).

tff(fact_45_beta,axiom,
    ! [T: dB,S1: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T),zero_zero(nat))) ).

tff(fact_46_Beta_I5_J,axiom,
    typing(shift(type,ea,ia,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t_a) ).

tff(fact_47_T,axiom,
    typing(shift(type,e,i,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as),t1) ).

tff(fact_48_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_49_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB) ) ).

tff(fact_50_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S1: dB,R1: dB] :
      ( beta(R1,S1)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),T),I),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T),I)) ) ).

tff(fact_51_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R1: dB] :
      ( beta(R1,S1)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),lift,R1),I),aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),I)) ) ).

tff(fact_52_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_53__096e_060i_058T_062_A_092_060turnstile_062_Ar_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    typing(shift(type,e,i,t),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as),t1) ).

tff(fact_54_IT_OBeta,axiom,
    ! [Ss: list(dB),S: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S),zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S),Ss))) ) ) ).

tff(fact_55_MI1,axiom,
    ! [Ub: dB,Ta: type,Ib: nat,Eb: fun(nat,type),Ta1: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( typing(shift(type,Eb,Ib,T11),Ta1,Ta)
         => ( pp(aa(dB,bool,it,Ub))
           => ( typing(Eb,Ub,T11)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub),Ib))) ) ) ) ) ) ).

tff(fact_56_MI2,axiom,
    ! [Ub: dB,Ta: type,Ib: nat,Eb: fun(nat,type),Ta1: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( typing(shift(type,Eb,Ib,T21),Ta1,Ta)
         => ( pp(aa(dB,bool,it,Ub))
           => ( typing(Eb,Ub,T21)
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub),Ib))) ) ) ) ) ) ).

tff(fact_57_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,Ta)
     => typing(shift(type,Eb,Ib,Ua),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta1),Ib),Ta) ) ).

tff(fact_58_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_59_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_60_shift__commute,axiom,
    ! [A: $tType,Ta: A,Ua: A,Ib: nat,Eb: fun(nat,A)] : ( shift(A,shift(A,Eb,Ib,Ua),zero_zero(nat),Ta) = shift(A,shift(A,Eb,zero_zero(nat),Ta),suc(Ib),Ua) ) ).

tff(fact_61_App,axiom,
    ! [Ta1: dB,Ua: type,Ta: type,S: dB,Env: fun(nat,type)] :
      ( typing(Env,S,aa(type,type,aa(type,fun(type,type),fun1,Ta),Ua))
     => ( typing(Env,Ta1,Ta)
       => typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta1),Ua) ) ) ).

tff(fact_62_Abs,axiom,
    ! [Ua: type,Ta1: dB,Ta: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),Ta),Ta1,Ua)
     => typing(Env,abs(Ta1),aa(type,type,aa(type,fun(type,type),fun1,Ta),Ua)) ) ).

tff(fact_63_shift__eq,axiom,
    ! [A: $tType,Ta: A,Eb: fun(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta),J1) = Ta ) ) ).

tff(fact_64_subject__reduction,axiom,
    ! [T3: dB,Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,Ta)
     => ( beta(Ta1,T3)
       => typing(Eb,T3,Ta) ) ) ).

tff(fact_65_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,Ta)
     => ( typing(E,Ub,Ua)
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => typing(E,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),Ub),Ib),Ta) ) ) ) ).

tff(fact_66_typing__elims_I3_J,axiom,
    ! [Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta1),Ta)
     => ~ ! [T2: type,U1: type] :
            ( ( Ta = aa(type,type,aa(type,fun(type,type),fun1,T2),U1) )
           => ~ typing(shift(type,Eb,zero_zero(nat),T2),Ta1,U1) ) ) ).

tff(fact_67_typing__elims_I2_J,axiom,
    ! [Ta: type,Ub: dB,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta1),Ub),Ta)
     => ~ ! [T2: type] :
            ( typing(Eb,Ta1,aa(type,type,aa(type,fun(type,type),fun1,T2),Ta))
           => ~ typing(Eb,Ub,T2) ) ) ).

tff(fact_68_beta__cases_I2_J,axiom,
    ! [S1: dB,R1: dB] :
      ( beta(abs(R1),S1)
     => ~ ! [T1: dB] :
            ( ( S1 = abs(T1) )
           => ~ beta(R1,T1) ) ) ).

tff(fact_69_abs__typeE,axiom,
    ! [Ta: type,Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,abs(Ta1),Ta)
     => ~ ! [U1: type,V: type] : ~ typing(shift(type,Eb,zero_zero(nat),U1),Ta1,V) ) ).

tff(fact_70_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S: dB,Ra: dB] :
      ( beta(Ra,S)
     => beta(foldl(dB,dB,app,Ra,Ss),foldl(dB,dB,app,S,Ss)) ) ).

tff(fact_71_substn__subst__n,axiom,
    ! [N1: nat,S1: dB,T: dB] : ( substn(T,S1,N1) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N1,S1,zero_zero(nat))),N1) ) ).

tff(fact_72_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S1,K)),substn(U,S1,K)) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_substn__subst__0,axiom,
    ! [S1: dB,T: dB] : ( substn(T,S1,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S1),zero_zero(nat)) ) ).

tff(fact_75_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),U)
     => ( ! [S2: dB] :
            ( ( U = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T),zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ beta(S1,T1) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1) )
               => ~ beta(T,T1) ) ) ) ) ).

tff(fact_76_substs__lemma,axiom,
    ! [Ts2: list(type),Ts: list(dB),Ib: nat,Ta: type,Ub: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ub,Ta)
     => ( typings(shift(type,Eb,Ib,Ta),Ts,Ts2)
       => typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts),Ts2) ) ) ).

tff(fact_77_lift__types,axiom,
    ! [Ua: type,Ib: nat,Ts2: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Ts2)
     => typings(shift(type,Eb,Ib,Ua),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts),Ts2) ) ).

tff(fact_78_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta: type,Ts2: list(type),Ta1: dB,Eb: fun(nat,type)] :
      ( typing(Eb,Ta1,foldr(type,type,fun1,Ts2,Ta))
     => ( typings(Eb,Ts,Ts2)
       => typing(Eb,foldl(dB,dB,app,Ta1,Ts),Ta) ) ) ).

tff(fact_79_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_80_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_81_typing_OVar,axiom,
    ! [Ta: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta )
     => typing(Env,var(X),Ta) ) ).

tff(fact_82_typing__elims_I1_J,axiom,
    ! [Ta: type,Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,var(Ib),Ta)
     => ( aa(nat,type,Eb,Ib) = Ta ) ) ).

tff(fact_83_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ beta(var(I),T) ).

tff(fact_84_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss) )
    <=> ( ( M = N )
        & ( Rs = Ss ) ) ) ).

tff(fact_85_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_86_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_87_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_88_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_89_dB_Osimps_I4_J,axiom,
    ! [DB2: dB,DB1: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_90_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != var(Nat) ) ).

tff(fact_91_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_92_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),var(I)),J))) ) ).

tff(fact_93_var__app__type__eq,axiom,
    ! [Ua: type,Ta: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ta)
     => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ua)
       => ( Ta = Ua ) ) ) ).

tff(fact_94_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),Ra: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(Ra),Ss) ) ).

tff(fact_95_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),N: nat,Ta1: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta1) != foldl(dB,dB,app,var(N),Ss) ) ).

tff(fact_96_var__app__types,axiom,
    ! [Ua: type,Ts2: list(type),Ta: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us),Ta)
     => ( typings(Eb,Ts,Ts2)
       => ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ua)
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta) )
              & typings(Eb,Us,Us1) ) ) ) ) ).

tff(fact_97_var__app__typesE,axiom,
    ! [Ta: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( typing(Eb,foldl(dB,dB,app,var(Ib),Ts),Ta)
     => ~ ! [Ts1: list(type)] :
            ( typing(Eb,var(Ib),foldr(type,type,fun1,Ts1,Ta))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),suc(i))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),as)))) ).

%------------------------------------------------------------------------------
