%------------------------------------------------------------------------------
% File     : LCL836_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 230
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_230 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.4.0, 0.50 v7.3.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  165 (  52 unt;  53 typ;   0 def)
%            Number of atoms       :  237 (  98 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  165 (  40   ~;   8   |;  19   &)
%                                         (  15 <=>;  83  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   48 (  23   >;  25   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-4 aty)
%            Number of functors    :   45 (  45 usr;  22 con; 0-5 aty)
%            Number of variables   :  408 ( 367   !;  13   ?; 408   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:26
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun(A,fun(list(A),T4)) * list(A) ) > T4 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,T4)) * type ) > T4 ) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB ) > fun(type,bool) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) ) > fun(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_r____,type,
    r: dB ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_1_Beta_I6_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_Beta_I3_J,axiom,
    pp(aa(dB,bool,it,a)) ).

tff(fact_4_uT,axiom,
    pp(aa(type,bool,typing(e,u),t)) ).

tff(fact_5_Beta_I1_J,axiom,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as))) ).

tff(fact_6__096e_060i_058T_062_A_092_060turnstile_062_Ar_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),t1)) ).

tff(fact_7_subst__App,axiom,
    ! [K: nat,S: dB,U1: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U1)),S),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U1),S),K)) ) ).

tff(fact_8_apps__eq__tail__conv,axiom,
    ! [S1: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S1,Ts) )
    <=> ( Ra = S1 ) ) ).

tff(fact_9_T,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as)),t1)) ).

tff(fact_10_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_11__096Abs_Ar_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_092_060rightarrow_062_092_060_094sub_062_092_060beta_062r_091a_P0_093_A_092_060degree_062_092_060degree_062_Aas_096,axiom,
    pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as)),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as))) ).

tff(fact_12_SI1,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Eb,Ib,t),foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),T_b))
     => ( pp(aa(dB,bool,it,Ub))
       => ( pp(aa(type,bool,typing(Eb,Ub),t))
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),Ub),Ib))) ) ) ) ).

tff(fact_13_IT_OBeta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S1),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S1))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S1),Ss1))) ) ) ).

tff(fact_14_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_15_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T11),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_16_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T21),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T21))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_17_subst__Var__IT,axiom,
    ! [J1: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),var(I)),J1))) ) ).

tff(fact_18_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_19_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_20_Beta_I7_J,axiom,
    pp(aa(type,bool,typing(ea,ua),t)) ).

tff(fact_21_appR,axiom,
    ! [U1: dB,T: dB,S: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T))) ) ).

tff(fact_22_appL,axiom,
    ! [U1: dB,T: dB,S: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U1))) ) ).

tff(fact_23_SI2,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Eb,Ib,t),a),T_b))
     => ( pp(aa(dB,bool,it,Ub))
       => ( pp(aa(type,bool,typing(Eb,Ub),t))
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),Ub),Ib))) ) ) ) ).

tff(fact_24_abs,axiom,
    ! [T: dB,S: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S)),abs(T))) ) ).

tff(fact_25_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T)) ).

tff(fact_26_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_27_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N1: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N1),Ss1) )
    <=> ( ( M = N1 )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_28_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S1: dB,Rs: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs) = foldl(dB,dB,app,abs(S1),Ss1) )
    <=> ( ( Ra = S1 )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_29_beta,axiom,
    ! [T: dB,S: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),zero_zero(nat)))) ).

tff(fact_30_Beta_I5_J,axiom,
    pp(aa(type,bool,typing(shift(type,ea,ia,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as)),t_a)) ).

tff(fact_31_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_32_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_33_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_34_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_35_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_36_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_37_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),T),I)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),I))) ) ).

tff(fact_38_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U1),K) = U1 ) ).

tff(fact_39_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),Ra: dB,Ts: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts) != foldl(dB,dB,app,abs(Ra),Ss1) ) ).

tff(fact_40_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N1: nat,Ta: dB,S1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),Ta) != foldl(dB,dB,app,var(N1),Ss1) ) ).

tff(fact_41_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_42_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_43_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Env,zero_zero(nat),Ta1),Ta),Ua))
     => pp(aa(type,bool,typing(Env,abs(Ta)),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua))) ) ).

tff(fact_44_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S1: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Env,S1),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,typing(Env,Ta),Ta1))
       => pp(aa(type,bool,typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),Ta)),Ua)) ) ) ).

tff(fact_45_beta__cases_I2_J,axiom,
    ! [S: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S))
     => ~ ! [T1: dB] :
            ( ( S = abs(T1) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T1)) ) ) ).

tff(fact_46_typing_OVar,axiom,
    ! [Ta1: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta1 )
     => pp(aa(type,bool,typing(Env,var(X)),Ta1)) ) ).

tff(fact_47_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_48_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_49_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta)),Ta1))
     => ~ ! [T2: type,U2: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T2),U2) )
           => ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),T2),Ta),U2)) ) ) ).

tff(fact_50_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => ( pp(aa(type,bool,typing(E,Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,typing(E,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib)),Ta1)) ) ) ) ).

tff(fact_51_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_52_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J: nat,Ib: nat] :
      ( ( Ib = J )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J) = Ta1 ) ) ).

tff(fact_53_subject__reduction,axiom,
    ! [T3: dB,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T3))
       => pp(aa(type,bool,typing(Eb,T3),Ta1)) ) ) ).

tff(fact_54_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T2: type] :
            ( pp(aa(type,bool,typing(Eb,Ta),aa(type,type,aa(type,fun(type,type),fun1,T2),Ta1)))
           => ~ pp(aa(type,bool,typing(Eb,Ub),T2)) ) ) ).

tff(fact_55_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta)),Ta1))
     => ~ ! [U2: type,V1: type] : ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),U2),Ta),V1)) ) ).

tff(fact_56_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Ss1)),foldl(dB,dB,app,S1,Ss1))) ) ).

tff(fact_57_beta__cases_I3_J,axiom,
    ! [U1: dB,T: dB,S: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T)),U1))
     => ( ! [S2: dB] :
            ( ( U1 = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T),zero_zero(nat)) )
           => ( S != abs(S2) ) )
       => ( ! [T1: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S),T1)) )
         => ~ ! [T1: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S),T1) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T),T1)) ) ) ) ) ).

tff(fact_58_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_59_IT_OVar,axiom,
    ! [N1: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs))) ) ).

tff(fact_60_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_61_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X1: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A2),B1),X1)
    <=> ( listsp(A,A2,X1)
        & listsp(A,B1,X1) ) ) ).

tff(fact_62_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs2: list(dB),N2: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N2),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R2: dB] :
            ( ( Aa = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S3: dB,Ss2: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),S3),zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_63_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_64_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S1: B,F: fun(B,fun(A,B))] :
      ( ! [X3: A,Y1: A,S2: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),X3)),Y1) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),Y1)),X3) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S1,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S1),X),Xs) ) ) ).

tff(fact_65_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_66_apps__preserves__betas,axiom,
    ! [Ra: dB,Ss1: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss1)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),foldl(dB,dB,app,Ra,Ss1))) ) ).

tff(fact_67_substn_Osimps_I2_J,axiom,
    ! [K: nat,S: dB,U1: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U1),S,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S,K)),substn(U1,S,K)) ) ).

tff(fact_68_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N1: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N1),Rs)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rs,Ss)
          & ( V = foldl(dB,dB,app,var(N1),Ss) ) ) ) ).

tff(fact_69_substn__subst__n,axiom,
    ! [N: nat,S: dB,T: dB] : ( substn(T,S,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N,S,zero_zero(nat))),N) ) ).

tff(fact_70_apps__betasE,axiom,
    ! [S1: dB,Rs: list(dB),Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),S1))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),R1))
           => ( S1 != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S1 != foldl(dB,dB,app,Ra,Rs1) ) )
         => ~ ! [T1: dB] :
                ( ( Ra = abs(T1) )
               => ! [U: dB,Us2: list(dB)] :
                    ( ( Rs = cons(dB,U,Us2) )
                   => ( S1 != foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),U),zero_zero(nat)),Us2) ) ) ) ) ) ) ).

tff(fact_71_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A1: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A1,List1) )
    <=> ( ( Aa = A1 )
        & ( List = List1 ) ) ) ).

tff(fact_72_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S,K)),liftn(N,T,K)) ) ).

tff(fact_73_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,cons(B,X,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,Aa),X),Xs) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_76_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] : ( cons(A,X2,Xs1) != Xs1 ) ).

tff(fact_77_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs1: list(A)] : ( Xs1 != cons(A,X2,Xs1) ) ).

tff(fact_78_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Y: A,Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,cons(A,Y,Ys),cons(A,X,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y),X))
          & ( Xs = Ys ) )
        | ( ( X = Y )
          & step1(A,Ra,Ys,Xs) ) ) ) ).

tff(fact_79_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_80_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,Ys,cons(A,X,Xs))
     => ( ! [Y1: A] :
            ( ( Ys = cons(A,Y1,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y1),X)) )
       => ~ ! [Zs1: list(A)] :
              ( ( Ys = cons(A,X,Zs1) )
             => ~ step1(A,Ra,Zs1,Xs) ) ) ) ).

tff(fact_81_typings_Osimps_I2_J,axiom,
    ! [Ts1: list(type),Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,cons(dB,Ta,Ts)),Ts1))
    <=> pp(list_case(bool,type,fFalse,combc(type,fun(list(type),bool),fun(list(type),bool),aa(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool))),aa(fun(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool))),fun(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool)))),combb(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun(type,bool),fun(type,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(type,bool),fun(type,fun(bool,bool))),combb(bool,fun(bool,bool),type),fconj),typing(Eb,Ta))),typings(Eb,Ts)),Ts1)) ) ).

tff(fact_82_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Ts1: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts1,Ta1)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Ts1))
       => pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_83_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts2: list(type)] :
            ( pp(aa(type,bool,typing(Eb,var(Ib)),foldr(type,type,fun1,Ts2,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts2)) ) ) ).

tff(fact_84_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs: list(B),X: B,F: fun(B,fun(A,A))] : ( foldr(B,A,F,cons(B,X,Xs),Aa) = aa(A,A,aa(B,fun(A,A),F,X),foldr(B,A,F,Xs,Aa)) ) ).

tff(fact_85_var__app__types,axiom,
    ! [Ua: type,Ts1: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us)),Ta1))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Ts1))
       => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta1) )
              & pp(aa(list(type),bool,typings(Eb,Us),Us1)) ) ) ) ) ).

tff(fact_86_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts2: list(type)] :
            ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts2,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts2)) ) ) ).

tff(fact_87_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts2: list(type)] :
          ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts2,Ta1)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts2)) ) ) ).

tff(fact_88_substs__lemma,axiom,
    ! [Ts1: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ub),Ta1))
     => ( pp(aa(list(type),bool,typings(shift(type,Eb,Ib,Ta1),Ts),Ts1))
       => pp(aa(list(type),bool,typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)),Ts1)) ) ) ).

tff(fact_89_map__ident,axiom,
    ! [A: $tType,X1: list(A)] : ( map(A,A,combi(A),X1) = X1 ) ).

tff(fact_90_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X,Xs)) = cons(A,aa(B,A,F,X),map(B,A,F,Xs)) ) ).

tff(fact_91_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_92_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_93_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xs: list(A),X: A] :
      ( ( cons(A,X,Xs) = map(B,A,F,Ys) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys = cons(B,Z,Zs) )
          & ( X = aa(B,A,F,Z) )
          & ( Xs = map(B,A,F,Zs) ) ) ) ).

tff(fact_94_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y: A,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = cons(A,Y,Ys) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xs = cons(B,Z,Zs) )
          & ( aa(B,A,F,Z) = Y )
          & ( map(B,A,F,Zs) = Ys ) ) ) ).

tff(fact_95_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_96_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_97_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)) ) ).

tff(fact_98_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),a),zero_zero(nat)),as)),u),i))) ).

%------------------------------------------------------------------------------
