%------------------------------------------------------------------------------
% File     : LCL834_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 226
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_226 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.25 v7.1.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  161 (  50 unt;  51 typ;   0 def)
%            Number of atoms       :  228 ( 101 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  167 (  49   ~;   6   |;  14   &)
%                                         (  17 <=>;  81  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   51 (  24   >;  27   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-4 aty)
%            Number of functors    :   42 (  42 usr;  19 con; 0-5 aty)
%            Number of variables   :  386 ( 357   !;   5   ?; 386   :)
%                                         (  24  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:22
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (45)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun(A,fun(list(A),T4)) * list(A) ) > T4 ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,T4)) * type ) > T4 ) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB ) > fun(type,bool) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) ) > fun(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_r____,type,
    r: dB ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    it(t2) ).

tff(fact_1_Beta_I3_J,axiom,
    it(a) ).

tff(fact_2_Beta_I1_J,axiom,
    it(foldl(dB,dB,app,subst(r,a,zero_zero(nat)),as)) ).

tff(fact_3_beta,axiom,
    ! [T: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T)),subst(S2,T,zero_zero(nat)))) ).

tff(fact_4_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rs: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( Ra = S )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_5_abs,axiom,
    ! [T: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S2)),abs(T))) ) ).

tff(fact_6_subst__App,axiom,
    ! [K: nat,S2: dB,U: dB,T: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T,S2,K)),subst(U,S2,K)) ) ).

tff(fact_7_appL,axiom,
    ! [U: dB,T: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U)),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U))) ) ).

tff(fact_8_appR,axiom,
    ! [U: dB,T: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U),S2)),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T))) ) ).

tff(fact_9_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( Ra = S ) ) ).

tff(fact_10_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_11_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_12_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_13_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S2: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R1,T,I)),subst(S2,T,I))) ) ).

tff(fact_14_Beta_I6_J,axiom,
    it(ua) ).

tff(fact_15_uIT,axiom,
    it(u) ).

tff(fact_16_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_17_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB) ) ).

tff(fact_18_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_19_IT_OBeta,axiom,
    ! [Ss1: list(dB),S: dB,Ra: dB] :
      ( it(foldl(dB,dB,app,subst(Ra,S,zero_zero(nat)),Ss1))
     => ( it(S)
       => it(foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S),Ss1)) ) ) ).

tff(fact_20_beta__cases_I2_J,axiom,
    ! [S2: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R1)),S2))
     => ~ ! [T1: dB] :
            ( ( S2 = abs(T1) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),T1)) ) ) ).

tff(fact_21_Lambda,axiom,
    ! [R1: dB] :
      ( it(R1)
     => it(abs(R1)) ) ).

tff(fact_22_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T)),U))
     => ( ! [S1: dB] :
            ( ( U = subst(S1,T,zero_zero(nat)) )
           => ( S2 != abs(S1) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1)) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T),T1)) ) ) ) ) ).

tff(fact_23_substn__subst__0,axiom,
    ! [S2: dB,T: dB] : ( substn(T,S2,zero_zero(nat)) = subst(T,S2,zero_zero(nat)) ) ).

tff(fact_24_apps__preserves__betas,axiom,
    ! [Ra: dB,Ss1: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss1)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),foldl(dB,dB,app,Ra,Ss1))) ) ).

tff(fact_25_T,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as)),t1)) ).

tff(fact_26_apps__eq__Abs__conv,axiom,
    ! [Ra: dB,Ss1: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss1) = abs(Ra) )
    <=> ( ( S = abs(Ra) )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_27_uT,axiom,
    pp(aa(type,bool,typing(e,u),t)) ).

tff(fact_28_substn_Osimps_I2_J,axiom,
    ! [K: nat,S2: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S2,K)),substn(U,S2,K)) ) ).

tff(fact_29_Abs__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Ra: dB] :
      ( ( abs(Ra) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( abs(Ra) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_30_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( it(Ta)
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T21),Ta),Ta1))
         => ( it(Ub)
           => ( pp(aa(type,bool,typing(Eb,Ub),T21))
             => it(subst(Ta,Ub,Ib)) ) ) ) ) ) ).

tff(fact_31_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( it(Ta)
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T11),Ta),Ta1))
         => ( it(Ub)
           => ( pp(aa(type,bool,typing(Eb,Ub),T11))
             => it(subst(Ta,Ub,Ib)) ) ) ) ) ) ).

tff(fact_32_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => ( pp(aa(type,bool,typing(E,Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,typing(E,subst(Ta,Ub,Ib)),Ta1)) ) ) ) ).

tff(fact_33_SI1,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Eb,Ib,t),foldl(dB,dB,app,subst(r,a,zero_zero(nat)),as)),T_b))
     => ( it(Ub)
       => ( pp(aa(type,bool,typing(Eb,Ub),t))
         => it(subst(foldl(dB,dB,app,subst(r,a,zero_zero(nat)),as),Ub,Ib)) ) ) ) ).

tff(fact_34_substn__subst__n,axiom,
    ! [N1: nat,S2: dB,T: dB] : ( substn(T,S2,N1) = subst(T,liftn(N1,S2,zero_zero(nat)),N1) ) ).

tff(fact_35_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta)),Ta1))
     => ~ ! [U2: type,V1: type] : ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),U2),Ta),V1)) ) ).

tff(fact_36_Beta_I7_J,axiom,
    pp(aa(type,bool,typing(ea,ua),t)) ).

tff(fact_37_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_38_SI2,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Eb,Ib,t),a),T_b))
     => ( it(Ub)
       => ( pp(aa(type,bool,typing(Eb,Ub),t))
         => it(subst(a,Ub,Ib)) ) ) ) ).

tff(fact_39_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S2: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S2,K)),liftn(N1,T,K)) ) ).

tff(fact_40_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Env,S),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,typing(Env,Ta),Ta1))
       => pp(aa(type,bool,typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta)),Ua)) ) ) ).

tff(fact_41_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Env,zero_zero(nat),Ta1),Ta),Ua))
     => pp(aa(type,bool,typing(Env,abs(Ta)),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua))) ) ).

tff(fact_42_Beta_I5_J,axiom,
    pp(aa(type,bool,typing(shift(type,ea,ia,t),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as)),t_a)) ).

tff(fact_43_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_44_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J1) = Ta1 ) ) ).

tff(fact_45_subject__reduction,axiom,
    ! [T3: dB,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T3))
       => pp(aa(type,bool,typing(Eb,T3),Ta1)) ) ) ).

tff(fact_46_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta)),Ta1))
     => ~ ! [T2: type,U2: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T2),U2) )
           => ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),T2),Ta),U2)) ) ) ).

tff(fact_47_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T2: type] :
            ( pp(aa(type,bool,typing(Eb,Ta),aa(type,type,aa(type,fun(type,type),fun1,T2),Ta1)))
           => ~ pp(aa(type,bool,typing(Eb,Ub),T2)) ) ) ).

tff(fact_48_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),Ra: fun(A,fun(A,bool))] : ~ step1(A,Ra,nil(A),Xs) ).

tff(fact_49_not__step1__Nil,axiom,
    ! [A: $tType,Xs: list(A),Ra: fun(A,fun(A,bool))] : ~ step1(A,Ra,Xs,nil(A)) ).

tff(fact_50_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,nil(B)) = Aa ) ).

tff(fact_51_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_52_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X1: A,Y: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X1)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y)),X1) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X),Xs) ) ) ).

tff(fact_53_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),S))
     => ( ! [R2: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),R2))
           => ( S != foldl(dB,dB,app,R2,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,Ra,Rs1) ) )
         => ~ ! [T1: dB] :
                ( ( Ra = abs(T1) )
               => ! [U1: dB,Us2: list(dB)] :
                    ( ( Rs = cons(dB,U1,Us2) )
                   => ( S != foldl(dB,dB,app,subst(T1,U1,zero_zero(nat)),Us2) ) ) ) ) ) ) ).

tff(fact_54_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_55_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A4: A,List2: list(A),Aa: A] :
      ( ( cons(A,Aa,List2) = cons(A,A4,List3) )
    <=> ( ( Aa = A4 )
        & ( List2 = List3 ) ) ) ).

tff(fact_56_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Y3: A,Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,cons(A,Y3,Ys),cons(A,X,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y3),X))
          & ( Xs = Ys ) )
        | ( ( X = Y3 )
          & step1(A,Ra,Ys,Xs) ) ) ) ).

tff(fact_57_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,cons(B,X,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,Aa),X),Xs) ) ).

tff(fact_58_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List2) ) ).

tff(fact_59_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X2: A] : ( cons(A,X2,Xs1) != Xs1 ) ).

tff(fact_60_not__Cons__self,axiom,
    ! [A: $tType,X2: A,Xs1: list(A)] : ( Xs1 != cons(A,X2,Xs1) ) ).

tff(fact_61_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( nil(A) != cons(A,A3,List1) ) ).

tff(fact_62_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( cons(A,A3,List1) != nil(A) ) ).

tff(fact_63_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y2: A,Ys1: list(A)] : ( Xs = cons(A,Y2,Ys1) ) ) ).

tff(fact_64_list_Oexhaust,axiom,
    ! [A: $tType,Y1: list(A)] :
      ( ( Y1 != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y1 != cons(A,A2,List) ) ) ).

tff(fact_65_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,Ys,cons(A,X,Xs))
     => ( ! [Y: A] :
            ( ( Ys = cons(A,Y,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y),X)) )
       => ~ ! [Zs: list(A)] :
              ( ( Ys = cons(A,X,Zs) )
             => ~ step1(A,Ra,Zs,Xs) ) ) ) ).

tff(fact_66_insert__Nil,axiom,
    ! [A: $tType,X2: A] : ( insert(A,X2,nil(A)) = cons(A,X2,nil(A)) ) ).

tff(fact_67_sublist__singleton,axiom,
    ! [A: $tType,X: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X,nil(A)),A1) = cons(A,X,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_68_typings_Osimps_I2_J,axiom,
    ! [Ts2: list(type),Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,cons(dB,Ta,Ts)),Ts2))
    <=> pp(list_case(bool,type,fFalse,combc(type,fun(list(type),bool),fun(list(type),bool),aa(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool))),aa(fun(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool))),fun(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool)))),combb(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun(type,bool),fun(type,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(type,bool),fun(type,fun(bool,bool))),combb(bool,fun(bool,bool),type),fconj),typing(Eb,Ta))),typings(Eb,Ts)),Ts2)) ) ).

tff(fact_69_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_70_typings_Osimps_I1_J,axiom,
    ! [Ts2: list(type),Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,nil(dB)),Ts2))
    <=> ( Ts2 = nil(type) ) ) ).

tff(fact_71_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Ts2: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts2,Ta1)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Ts2))
       => pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_72_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts1,Ta1)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_73_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( member(A,X,A1)
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_76_foldr_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,F: fun(B,fun(A,A))] : ( foldr(B,A,F,nil(B),Aa) = Aa ) ).

tff(fact_77_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs: list(B),X: B,F: fun(B,fun(A,A))] : ( foldr(B,A,F,cons(B,X,Xs),Aa) = aa(A,A,aa(B,fun(A,A),F,X),foldr(B,A,F,Xs,Aa)) ) ).

tff(fact_78_var__app__types,axiom,
    ! [Ua: type,Ts2: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us)),Ta1))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Ts2))
       => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta1) )
              & pp(aa(list(type),bool,typings(Eb,Us),Us1)) ) ) ) ) ).

tff(fact_79_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,var(Ib)),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_80_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_81_typing_OVar,axiom,
    ! [Ta1: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta1 )
     => pp(aa(type,bool,typing(Env,var(X)),Ta1)) ) ).

tff(fact_82_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_83_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T)) ).

tff(fact_84_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss1) )
    <=> ( ( M = N )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_85_Var__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( var(M) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_86_dB_Osimps_I4_J,axiom,
    ! [DB2: dB,DB1: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_87_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != var(Nat) ) ).

tff(fact_88_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_89_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_90_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_91_Var__IT,axiom,
    ! [N1: nat] : it(var(N1)) ).

tff(fact_92_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( it(T)
     => it(aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I))) ) ).

tff(fact_93_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R1: dB] :
      ( it(R1)
     => it(subst(R1,var(I),J)) ) ).

tff(fact_94_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_95_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),Ra: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(Ra),Ss1) ) ).

tff(fact_96_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss1) ) ).

tff(fact_97_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rs,Ss)
          & ( V = foldl(dB,dB,app,var(N),Ss) ) ) ) ).

tff(fact_98_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),a),as)),foldl(dB,dB,app,subst(r,a,zero_zero(nat)),as))) ).

%------------------------------------------------------------------------------
