%------------------------------------------------------------------------------
% File     : LCL832_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 217
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_217 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  165 (  55 unt;  54 typ;   0 def)
%            Number of atoms       :  212 (  86 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  137 (  36   ~;   7   |;  11   &)
%                                         (  11 <=>;  72  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   55 (  26   >;  29   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-3 aty)
%            Number of functors    :   45 (  45 usr;  19 con; 0-5 aty)
%            Number of variables   :  400 ( 364   !;   8   ?; 400   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:25:14
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (48)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(dB,fun(dB,T4)) * fun(dB,T4) * dB ) > T4 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(dB,fun(dB,fun(T4,fun(T4,T4)))) * fun(dB,fun(T4,T4)) * dB ) > T4 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,T4)) * type ) > T4 ) ).

tff(sy_c_Type_Otype_Otype__rec,type,
    type_rec: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,fun(T4,fun(T4,T4)))) * type ) > T4 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: fun(nat,type) > fun(dB,fun(type,bool)) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_r____,type,
    r: dB ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_1_Lambda_I4_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_uT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),typing(e),u),t)) ).

tff(fact_4_Lambda_I1_J,axiom,
    pp(aa(dB,bool,it,r)) ).

tff(fact_5__096e_060i_058T_062_A_092_060turnstile_062_AAbs_Ar_A_058_AT_H_096,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,e,i,t)),abs(r)),t1)) ).

tff(fact_6_IT_OLambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_7_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_8_Lambda_I2_J,axiom,
    ! [Ub: dB,T_b: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Eb,Ib,t)),r),T_b))
     => ( pp(aa(dB,bool,it,Ub))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ub),t))
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,r),Ub),Ib))) ) ) ) ).

tff(fact_9_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Eb,Ib,T11)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ub),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_10_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Eb,Ib,T21)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ub),T21))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_11_subst__Var__IT,axiom,
    ! [J1: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),var(I)),J1))) ) ).

tff(fact_12_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_13_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB3)) = aa(dB,A,F3,DB3) ) ).

tff(fact_14_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_15_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ta),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib)),Ta1)) ) ) ) ).

tff(fact_16_Lambda_I3_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,ea,ia,t)),abs(r)),t_a)) ).

tff(fact_17_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB3)) = aa(A,A,aa(dB,fun(A,A),F3,DB3),dB_rec(A,F1,F2,F3,DB3)) ) ).

tff(fact_18_Lambda_I5_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),typing(ea),ua),t)) ).

tff(fact_19_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_20_type_Osimps_I2_J,axiom,
    ! [Type23: type,Type13: type,Type22: type,Type12: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type12),Type22) = aa(type,type,aa(type,fun(type,type),fun1,Type13),Type23) )
    <=> ( ( Type12 = Type13 )
        & ( Type22 = Type23 ) ) ) ).

tff(fact_21_typing_OVar,axiom,
    ! [Ta1: type,X2: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X2) = Ta1 )
     => pp(aa(type,bool,aa(dB,fun(type,bool),typing(Env),var(X2)),Ta1)) ) ).

tff(fact_22_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_23_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ta),Ta1))
     => pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Eb,Ib,Ua)),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib)),Ta1)) ) ).

tff(fact_24_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_25_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_26_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J: nat,Ib: nat] :
      ( ( Ib = J )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J) = Ta1 ) ) ).

tff(fact_27_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat1: nat] : ( var(Nat1) != abs(DB) ) ).

tff(fact_28_dB_Osimps_I7_J,axiom,
    ! [Nat1: nat,DB: dB] : ( abs(DB) != var(Nat1) ) ).

tff(fact_29_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_30_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S),K) = T ) ).

tff(fact_31_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Env,zero_zero(nat),Ta1)),Ta),Ua))
     => pp(aa(type,bool,aa(dB,fun(type,bool),typing(Env),abs(Ta)),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua))) ) ).

tff(fact_32_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type12),Type22)) = aa(type,A,aa(type,fun(type,A),F2,Type12),Type22) ) ).

tff(fact_33_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),abs(Ta)),Ta1))
     => ~ ! [T3: type,U1: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T3),U1) )
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Eb,zero_zero(nat),T3)),Ta),U1)) ) ) ).

tff(fact_34_type_Orecs_I2_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun(type,fun(type,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( type_rec(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type12),Type22)) = aa(A,A,aa(A,fun(A,A),aa(type,fun(A,fun(A,A)),aa(type,fun(type,fun(A,fun(A,A))),F2,Type12),Type22),type_rec(A,F1,F2,Type12)),type_rec(A,F1,F2,Type22)) ) ).

tff(fact_35_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),abs(Ta)),Ta1))
     => ~ ! [U1: type,V: type] : ~ pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Eb,zero_zero(nat),U1)),Ta),V)) ) ).

tff(fact_36_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S1: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Env),S1),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Env),Ta),Ta1))
       => pp(aa(type,bool,aa(dB,fun(type,bool),typing(Env),aa(dB,dB,aa(dB,fun(dB,dB),app,S1),Ta)),Ua)) ) ) ).

tff(fact_37_type_Osimps_I3_J,axiom,
    ! [Type21: type,Type11: type,Nat1: nat] : ( atom(Nat1) != aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) ) ).

tff(fact_38_type_Osimps_I4_J,axiom,
    ! [Nat1: nat,Type21: type,Type11: type] : ( aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) != atom(Nat1) ) ).

tff(fact_39_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB1 = DB13 )
        & ( DB2 = DB23 ) ) ) ).

tff(fact_40_type_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( atom(Nat2) = atom(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_41_subst__App,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S),K)) ) ).

tff(fact_42_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)) ) ).

tff(fact_43_type_Orecs_I1_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun(type,fun(type,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( type_rec(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_44_type_Osimps_I5_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_45_dB_Osimps_I5_J,axiom,
    ! [Nat1: nat,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != var(Nat1) ) ).

tff(fact_46_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat1: nat] : ( var(Nat1) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_47_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_48_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB) ) ).

tff(fact_49_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB1),DB2),dB_rec(A,F1,F2,F3,DB1)),dB_rec(A,F1,F2,F3,DB2)) ) ).

tff(fact_50_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_51_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_52_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T3: type] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ta),aa(type,type,aa(type,fun(type,type),fun1,T3),Ta1)))
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ub),T3)) ) ) ).

tff(fact_53_type_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( type_size(atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_54_type_Osize_I3_J,axiom,
    ! [Nat1: nat] : ( size_size(type,atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_55_dB_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( dB_size(var(Nat1)) = zero_zero(nat) ) ).

tff(fact_56_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_57_Beta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S1),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S1))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S1),Ss1))) ) ) ).

tff(fact_58_beta,axiom,
    ! [T: dB,S: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),zero_zero(nat))) ).

tff(fact_59_dB_Osize_I4_J,axiom,
    ! [Nat1: nat] : ( size_size(dB,var(Nat1)) = zero_zero(nat) ) ).

tff(fact_60_appR,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_61_appL,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_62_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ beta(var(I),T) ).

tff(fact_63_abs,axiom,
    ! [T: dB,S: dB] :
      ( beta(S,T)
     => beta(abs(S),abs(T)) ) ).

tff(fact_64_subject__reduction,axiom,
    ! [T2: dB,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ta),Ta1))
     => ( beta(Ta,T2)
       => pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),T2),Ta1)) ) ) ).

tff(fact_65_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S: dB,R2: dB] :
      ( beta(R2,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),T),I),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),I)) ) ).

tff(fact_66_lift__preserves__beta,axiom,
    ! [I: nat,S: dB,R2: dB] :
      ( beta(R2,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),lift,R2),I),aa(nat,dB,aa(dB,fun(nat,dB),lift,S),I)) ) ).

tff(fact_67_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_68_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S1: dB,Rs1: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs1) = foldl(dB,dB,app,abs(S1),Ss1) )
    <=> ( ( Ra = S1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_69_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N2: nat,Rs1: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs1) = foldl(dB,dB,app,var(N2),Ss1) )
    <=> ( ( M = N2 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_70_beta__cases_I2_J,axiom,
    ! [S: dB,R2: dB] :
      ( beta(abs(R2),S)
     => ~ ! [T1: dB] :
            ( ( S = abs(T1) )
           => ~ beta(R2,T1) ) ) ).

tff(fact_71_apps__eq__tail__conv,axiom,
    ! [S1: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S1,Ts) )
    <=> ( Ra = S1 ) ) ).

tff(fact_72_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N2: nat,Ta: dB,S1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),Ta) != foldl(dB,dB,app,var(N2),Ss1) ) ).

tff(fact_73_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),Ra: dB,Ts: list(dB),N2: nat] : ( foldl(dB,dB,app,var(N2),Ts) != foldl(dB,dB,app,abs(Ra),Ss1) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( beta(Ra,S1)
     => beta(foldl(dB,dB,app,Ra,Ss1),foldl(dB,dB,app,S1,Ss1)) ) ).

tff(fact_76_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),U)
     => ( ! [S2: dB] :
            ( ( U = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T),zero_zero(nat)) )
           => ( S != abs(S2) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ beta(S,T1) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S),T1) )
               => ~ beta(T,T1) ) ) ) ) ).

tff(fact_77_IT_OVar,axiom,
    ! [N2: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N2),Rs1))) ) ).

tff(fact_78_type_Oexhaust,axiom,
    ! [Y1: type] :
      ( ! [Nat: nat] : ( Y1 != atom(Nat) )
     => ~ ! [Type1: type,Type2: type] : ( Y1 != aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) ) ) ).

tff(fact_79_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X1: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A2),B1),X1)
    <=> ( listsp(A,A2,X1)
        & listsp(A,B1,X1) ) ) ).

tff(fact_80_IT_Osimps,axiom,
    ! [A1: dB] :
      ( pp(aa(dB,bool,it,A1))
    <=> ( ? [Rs: list(dB),N1: nat] :
            ( ( A1 = foldl(dB,dB,app,var(N1),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R1: dB] :
            ( ( A1 = abs(R1) )
            & pp(aa(dB,bool,it,R1)) )
        | ? [R1: dB,S3: dB,Ss: list(dB)] :
            ( ( A1 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S3),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S3),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_81_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X2: A,Xs: list(A),S1: B,F: fun(B,fun(A,B))] :
      ( ! [X3: A,Y: A,S2: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),X3)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),Y)),X3) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S1,Xs)),X2) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S1),X2),Xs) ) ) ).

tff(fact_82_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_83_map__ident,axiom,
    ! [A: $tType,X1: list(A)] : ( map(A,A,combi(A),X1) = X1 ) ).

tff(fact_84_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_85_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_86_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A1: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A1,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),A1,Xs) ) ).

tff(fact_87_substs__lemma,axiom,
    ! [Ts1: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ub),Ta1))
     => ( typings(shift(type,Eb,Ib,Ta1),Ts,Ts1)
       => typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts),Ts1) ) ) ).

tff(fact_88_lift__types,axiom,
    ! [Ua: type,Ib: nat,Ts1: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Ts1)
     => typings(shift(type,Eb,Ib,Ua),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts),Ts1) ) ).

tff(fact_89_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Ts1: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ta),foldr(type,type,fun1,Ts1,Ta1)))
     => ( typings(Eb,Ts,Ts1)
       => pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_90_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts2: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),var(Ib)),foldr(type,type,fun1,Ts2,Ta1)))
           => ~ typings(Eb,Ts,Ts2) ) ) ).

tff(fact_91_var__app__types,axiom,
    ! [Ua: type,Ts1: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us)),Ta1))
     => ( typings(Eb,Ts,Ts1)
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta1) )
              & typings(Eb,Us,Us1) ) ) ) ) ).

tff(fact_92_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts2: list(type)] :
          ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ta),foldr(type,type,fun1,Ts2,Ta1)))
          & typings(Eb,Ts,Ts2) ) ) ).

tff(fact_93_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts2: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(Eb),Ta),foldr(type,type,fun1,Ts2,Ta1)))
           => ~ typings(Eb,Ts,Ts2) ) ) ).

tff(fact_94_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_95_substn_Osimps_I2_J,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S,K)),substn(U,S,K)) ) ).

tff(fact_96_substn__subst__n,axiom,
    ! [N: nat,S: dB,T: dB] : ( substn(T,S,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N,S,zero_zero(nat))),N) ) ).

tff(fact_97_lists__typings,axiom,
    ! [Ts1: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Ts1)
     => listsp(dB,aa(fun(dB,fun(type,bool)),fun(dB,bool),aa(fun(fun(type,bool),bool),fun(fun(dB,fun(type,bool)),fun(dB,bool)),combb(fun(type,bool),bool,dB),fEx(type)),typing(Eb)),Ts) ) ).

tff(fact_98_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S,K)),liftn(N,T,K)) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (10)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,abs(r)),u),i))) ).

%------------------------------------------------------------------------------
