%------------------------------------------------------------------------------
% File     : LCL829_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 207
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_207 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  179 (  74 unt;  63 typ;   0 def)
%            Number of atoms       :  180 ( 118 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :   91 (  27   ~;  10   |;  15   &)
%                                         (  17 <=>;  22  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   63 (  34   >;  29   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   50 (  50 usr;  14 con; 0-5 aty)
%            Number of variables   :  375 ( 313   !;  12   ?; 375   :)
%                                         (  50  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:33
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (58)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : fun(A,fun(B,A)) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Enum_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( ( nat * list(A) ) > list(list(A)) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,fun(T1,fun(T1,T1)))) * fun(dB,fun(T1,T1)) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_OListMem,type,
    listMem: 
      !>[A: $tType] : ( ( A * list(A) ) > $o ) ).

tff(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( list(list(A)) > list(A) ) ).

tff(sy_c_List_Ofilter,type,
    filter: 
      !>[A: $tType] : ( fun(A,bool) > fun(list(A),list(A)) ) ).

tff(sy_c_List_Ohd,type,
    hd: 
      !>[A: $tType] : fun(list(A),A) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) ) > fun(list(A),T1) ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),fun(T1,T1))) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : fun(fun(A,B),fun(list(A),list(B))) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omember,type,
    member1: 
      !>[A: $tType] : ( ( list(A) * A ) > $o ) ).

tff(sy_c_List_Omonoid__add__class_Olistsum,type,
    monoid_add_listsum: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : fun(list(A),list(A)) ).

tff(sy_c_List_Otranspose,type,
    transpose: 
      !>[A: $tType] : ( list(list(A)) > list(list(A)) ) ).

tff(sy_c_List_Otranspose__rel,type,
    transpose_rel: 
      !>[A: $tType] : fun(list(list(A)),fun(list(list(A)),bool)) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Wellfounded_Oaccp,type,
    accp: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_t____,type,
    t: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t)) ).

tff(fact_1_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_False,axiom,
    n != i ).

tff(fact_3_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_4__096IT_A_Ia_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i))) ).

tff(fact_5_Cons_I3_J,axiom,
    listsp(dB,it,aa(list(dB),list(dB),aa(fun(dB,dB),fun(list(dB),list(dB)),map(dB,dB),aa(nat,fun(dB,dB),combc(dB,nat,dB,aa(dB,fun(dB,fun(nat,dB)),combc(dB,dB,fun(nat,dB),subst),u)),i)),as)) ).

tff(fact_6_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,F: fun(B,A)] : ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xs)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(B,A,F,X1)),aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xs)) ) ).

tff(fact_7_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,A1),B1),X3)
    <=> ( listsp(A,A1,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_8_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( aa(list(A),list(A),aa(fun(A,A),fun(list(A),list(A)),map(A,A),combi(A)),X3) = X3 ) ).

tff(fact_9_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List2: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Aa),List2) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List3) )
    <=> ( ( Aa = A5 )
        & ( List2 = List3 ) ) ) ).

tff(fact_10_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys2: list(B),F: fun(B,A),Xs: list(A),X1: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Ys2) )
    <=> ? [Z1: B,Zs1: list(B)] :
          ( ( Ys2 = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z1),Zs1) )
          & ( X1 = aa(B,A,F,Z1) )
          & ( Xs = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs1) ) ) ) ).

tff(fact_11_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys2: list(A),Y1: A,Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys2) )
    <=> ? [Z1: B,Zs1: list(B)] :
          ( ( Xs = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z1),Zs1) )
          & ( aa(B,A,F,Z1) = Y1 )
          & ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs1) = Ys2 ) ) ) ).

tff(fact_12_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) ) ).

tff(fact_13_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) != Xs1 ) ).

tff(fact_14_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),var(I)),J))) ) ).

tff(fact_15_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,aa(list(dB),list(dB),aa(fun(dB,dB),fun(list(dB),list(dB)),map(dB,dB),aa(nat,fun(dB,dB),combc(dB,nat,dB,lift),zero_zero(nat))),Ts)) ) ).

tff(fact_16_Cons__eq__map__D,axiom,
    ! [A: $tType,B: $tType,Ys2: list(B),F: fun(B,A),Xs: list(A),X1: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Ys2) )
     => ? [Z: B,Zs: list(B)] :
          ( ( Ys2 = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( X1 = aa(B,A,F,Z) )
          & ( Xs = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs) ) ) ) ).

tff(fact_17_map__eq__Cons__D,axiom,
    ! [B: $tType,A: $tType,Ys2: list(A),Y1: A,Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys2) )
     => ? [Z: B,Zs: list(B)] :
          ( ( Xs = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs) )
          & ( aa(B,A,F,Z) = Y1 )
          & ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Zs) = Ys2 ) ) ) ).

tff(fact_18_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_19_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_20_dB_Osimps_I1_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_21_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S),K) = T ) ).

tff(fact_22_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_23_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Aa),List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List2) ) ).

tff(fact_24_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs1: list(A),X: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys1)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),splice(A,Xs1,Ys1))) ) ).

tff(fact_25_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Aa),List2)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,Aa),List2),list_rec(A,B,F1,F2,List2)) ) ).

tff(fact_26_listsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(B)] : ( monoid_add_listsum(A,aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),aa(A,fun(B,A),combk(A,B),zero_zero(A))),Xs)) = zero_zero(A) ) ) ).

tff(fact_27_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_28_dB_Osize_I1_J,axiom,
    ! [Nat2: nat] : ( dB_size(var(Nat2)) = zero_zero(nat) ) ).

tff(fact_29_dB_Osize_I4_J,axiom,
    ! [Nat2: nat] : ( size_size(dB,var(Nat2)) = zero_zero(nat) ) ).

tff(fact_30_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_31_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_32_null__rec_I1_J,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ~ null(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) ).

tff(fact_33_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_34_substn__subst__n,axiom,
    ! [N: nat,S: dB,T: dB] : ( substn(T,S,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N,S,zero_zero(nat))),N) ) ).

tff(fact_35_listsum__simps_I1_J,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ( monoid_add_listsum(A,nil(A)) = zero_zero(A) ) ) ).

tff(fact_36_insert,axiom,
    ! [A: $tType,Y: A,Xs1: list(A),X: A] :
      ( listMem(A,X,Xs1)
     => listMem(A,X,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Xs1)) ) ).

tff(fact_37_member__rec_I1_J,axiom,
    ! [A: $tType,Y1: A,Xs: list(A),X1: A] :
      ( member1(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs),Y1)
    <=> ( ( X1 = Y1 )
        | member1(A,Xs,Y1) ) ) ).

tff(fact_38_elem,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : listMem(A,X,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) ).

tff(fact_39_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_40_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),nil(B)) = nil(A) ) ).

tff(fact_41_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_42_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_43_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] : ~ member1(A,nil(A),Y) ).

tff(fact_44_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) ) ).

tff(fact_45_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) != nil(A) ) ).

tff(fact_46_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( aa(list(B),A,list_case(A,B,F1,F2),nil(B)) = F1 ) ).

tff(fact_47_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_48_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_49_null__rec_I2_J,axiom,
    ! [B: $tType] : null(B,nil(B)) ).

tff(fact_50_List_Onull__def,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( null(A,Xs)
    <=> ( Xs = nil(A) ) ) ).

tff(fact_51_eq__Nil__null,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs = nil(A) )
    <=> null(A,Xs) ) ).

tff(fact_52_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_53_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_54_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

tff(fact_55_listsp_Osimps,axiom,
    ! [A: $tType,Aa: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,Aa)
    <=> ( ( Aa = nil(A) )
        | ? [A3: A,L: list(A)] :
            ( ( Aa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),L) )
            & pp(aa(A,bool,A1,A3))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_56_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List) ) ) ).

tff(fact_57_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y2: A,Ys: list(A)] : ( Xs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys) ) ) ).

tff(fact_58_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) ).

tff(fact_59_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)),A1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_60_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_61_equal__Nil__null,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( equal_equal(list(A),Xs,nil(A))
    <=> null(A,Xs) ) ).

tff(fact_62_concat__map__singleton,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] : ( concat(A,aa(list(B),list(list(A)),aa(fun(B,list(A)),fun(list(B),list(list(A))),map(B,list(A)),aa(list(A),fun(B,list(A)),combc(B,list(A),list(A),combb(A,fun(list(A),list(A)),B,cons(A),F)),nil(A))),Xs)) = aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xs) ) ).

tff(fact_63_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_64_concat_Osimps_I1_J,axiom,
    ! [A: $tType] : ( concat(A,nil(list(A))) = nil(A) ) ).

tff(fact_65_map__concat,axiom,
    ! [A: $tType,B: $tType,Xs: list(list(B)),F: fun(B,A)] : ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),concat(B,Xs)) = concat(A,aa(list(list(B)),list(list(A)),aa(fun(list(B),list(A)),fun(list(list(B)),list(list(A))),map(list(B),list(A)),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F)),Xs)) ) ).

tff(fact_66_equal__list__def,axiom,
    ! [A: $tType,Y1: list(A),X1: list(A)] :
      ( equal_equal(list(A),X1,Y1)
    <=> ( X1 = Y1 ) ) ).

tff(fact_67_transpose_Osimps_I3_J,axiom,
    ! [A: $tType,Xss: list(list(A)),Xs: list(A),X1: A] : ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs)),Xss)) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),concat(A,aa(list(list(A)),list(list(A)),aa(fun(list(A),list(A)),fun(list(list(A)),list(list(A))),map(list(A),list(A)),list_case(list(A),A,nil(A),combb(list(A),fun(list(A),list(A)),A,combk(list(A),list(A)),aa(list(A),fun(A,list(A)),combc(A,list(A),list(A),cons(A)),nil(A))))),Xss)))),transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),Xs),concat(list(A),aa(list(list(A)),list(list(list(A))),aa(fun(list(A),list(list(A))),fun(list(list(A)),list(list(list(A)))),map(list(A),list(list(A))),list_case(list(list(A)),A,nil(list(A)),aa(fun(list(A),list(list(A))),fun(A,fun(list(A),list(list(A)))),combk(fun(list(A),list(list(A))),A),aa(list(list(A)),fun(list(A),list(list(A))),combc(list(A),list(list(A)),list(list(A)),cons(list(A))),nil(list(A)))))),Xss))))) ) ).

tff(fact_68_concat__map__maps,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,list(A))] : ( concat(A,aa(list(B),list(list(A)),aa(fun(B,list(A)),fun(list(B),list(list(A))),map(B,list(A)),F),Xs)) = maps(B,A,F,Xs) ) ).

tff(fact_69_maps__def,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,list(A))] : ( maps(B,A,F,Xs) = concat(A,aa(list(B),list(list(A)),aa(fun(B,list(A)),fun(list(B),list(list(A))),map(B,list(A)),F),Xs)) ) ).

tff(fact_70_transpose_Osimps_I1_J,axiom,
    ! [A: $tType] : ( transpose(A,nil(list(A))) = nil(list(A)) ) ).

tff(fact_71_transpose_Osimps_I2_J,axiom,
    ! [A: $tType,Xss1: list(list(A))] : ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),Xss1)) = transpose(A,Xss1) ) ).

tff(fact_72_transpose__map__map,axiom,
    ! [A: $tType,B: $tType,Xs: list(list(B)),F: fun(B,A)] : ( transpose(A,aa(list(list(B)),list(list(A)),aa(fun(list(B),list(A)),fun(list(list(B)),list(list(A))),map(list(B),list(A)),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F)),Xs)) = aa(list(list(B)),list(list(A)),aa(fun(list(B),list(A)),fun(list(list(B)),list(list(A))),map(list(B),list(A)),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F)),transpose(B,Xs)) ) ).

tff(fact_73_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_76_transpose_Opsimps_I3_J,axiom,
    ! [A: $tType,Xss: list(list(A)),Xs: list(A),X1: A] :
      ( accp(list(list(A)),transpose_rel(A),aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs)),Xss))
     => ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs)),Xss)) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),concat(A,aa(list(list(A)),list(list(A)),aa(fun(list(A),list(A)),fun(list(list(A)),list(list(A))),map(list(A),list(A)),list_case(list(A),A,nil(A),combb(list(A),fun(list(A),list(A)),A,combk(list(A),list(A)),aa(list(A),fun(A,list(A)),combc(A,list(A),list(A),cons(A)),nil(A))))),Xss)))),transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),Xs),concat(list(A),aa(list(list(A)),list(list(list(A))),aa(fun(list(A),list(list(A))),fun(list(list(A)),list(list(list(A)))),map(list(A),list(list(A))),list_case(list(list(A)),A,nil(list(A)),aa(fun(list(A),list(list(A))),fun(A,fun(list(A),list(list(A)))),combk(fun(list(A),list(list(A))),A),aa(list(list(A)),fun(list(A),list(list(A))),combc(list(A),list(list(A)),list(list(A)),cons(list(A))),nil(list(A)))))),Xss))))) ) ) ).

tff(fact_77_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs1: list(A)] : ( n_lists(A,zero_zero(nat),Xs1) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),nil(list(A))) ) ).

tff(fact_78_n__lists__Nil,axiom,
    ! [A: $tType,N: nat] :
      ( ( ( N = zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),nil(list(A))) ) )
      & ( ( N != zero_zero(nat) )
       => ( n_lists(A,N,nil(A)) = nil(list(A)) ) ) ) ).

tff(fact_79_transpose_Opsimps_I1_J,axiom,
    ! [A: $tType] :
      ( accp(list(list(A)),transpose_rel(A),nil(list(A)))
     => ( transpose(A,nil(list(A))) = nil(list(A)) ) ) ).

tff(fact_80_transpose_Opsimps_I2_J,axiom,
    ! [A: $tType,Xss: list(list(A))] :
      ( accp(list(list(A)),transpose_rel(A),aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),Xss))
     => ( transpose(A,aa(list(list(A)),list(list(A)),aa(list(A),fun(list(list(A)),list(list(A))),cons(list(A)),nil(A)),Xss)) = transpose(A,Xss) ) ) ).

tff(fact_81_n__lists_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),Na: nat] : ( n_lists(A,suc(Na),Xs) = concat(list(A),aa(list(list(A)),list(list(list(A))),aa(fun(list(A),list(list(A))),fun(list(list(A)),list(list(list(A)))),map(list(A),list(list(A))),aa(list(A),fun(list(A),list(list(A))),combc(list(A),list(A),list(list(A)),combb(fun(A,list(A)),fun(list(A),list(list(A))),list(A),map(A,list(A)),combc(A,list(A),list(A),cons(A)))),Xs)),n_lists(A,Na,Xs))) ) ).

tff(fact_82_transpose__aux__filter__tail,axiom,
    ! [A: $tType,Xss: list(list(A))] : ( concat(list(A),aa(list(list(A)),list(list(list(A))),aa(fun(list(A),list(list(A))),fun(list(list(A)),list(list(list(A)))),map(list(A),list(list(A))),list_case(list(list(A)),A,nil(list(A)),aa(fun(list(A),list(list(A))),fun(A,fun(list(A),list(list(A)))),combk(fun(list(A),list(list(A))),A),aa(list(list(A)),fun(list(A),list(list(A))),combc(list(A),list(list(A)),list(list(A)),cons(list(A))),nil(list(A)))))),Xss)) = aa(list(list(A)),list(list(A)),aa(fun(list(A),list(A)),fun(list(list(A)),list(list(A))),map(list(A),list(A)),tl(A)),aa(list(list(A)),list(list(A)),filter(list(A),combb(bool,bool,list(A),fNot,aa(list(A),fun(list(A),bool),combc(list(A),list(A),bool,fequal(list(A))),nil(A)))),Xss)) ) ).

tff(fact_83_filter__filter,axiom,
    ! [A: $tType,Xs: list(A),Q1: fun(A,bool),P2: fun(A,bool)] : ( aa(list(A),list(A),filter(A,P2),aa(list(A),list(A),filter(A,Q1),Xs)) = aa(list(A),list(A),filter(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,Q1),P2)),Xs) ) ).

tff(fact_84_filter_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,P2: fun(A,bool)] :
      ( ( pp(aa(A,bool,P2,X1))
       => ( aa(list(A),list(A),filter(A,P2),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),aa(list(A),list(A),filter(A,P2),Xs)) ) )
      & ( ~ pp(aa(A,bool,P2,X1))
       => ( aa(list(A),list(A),filter(A,P2),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs)) = aa(list(A),list(A),filter(A,P2),Xs) ) ) ) ).

tff(fact_85_filter_Osimps_I1_J,axiom,
    ! [A: $tType,P2: fun(A,bool)] : ( aa(list(A),list(A),filter(A,P2),nil(A)) = nil(A) ) ).

tff(fact_86_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( aa(list(A),list(A),tl(A),nil(A)) = nil(A) ) ).

tff(fact_87_liftn__lift,axiom,
    ! [K: nat,T: dB,N: nat] : ( liftn(suc(N),T,K) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N,T,K)),K) ) ).

tff(fact_88_tl_Osimps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),list(A),tl(A),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = Xs1 ) ).

tff(fact_89_map__tl,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] : ( aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),aa(list(B),list(B),tl(B),Xs)) = aa(list(A),list(A),tl(A),aa(list(B),list(A),aa(fun(B,A),fun(list(B),list(A)),map(B,A),F),Xs)) ) ).

tff(fact_90_filter__concat,axiom,
    ! [A: $tType,Xs: list(list(A)),P1: fun(A,bool)] : ( aa(list(A),list(A),filter(A,P1),concat(A,Xs)) = concat(A,aa(list(list(A)),list(list(A)),aa(fun(list(A),list(A)),fun(list(list(A)),list(list(A))),map(list(A),list(A)),filter(A,P1)),Xs)) ) ).

tff(fact_91_transpose__aux__filter__head,axiom,
    ! [A: $tType,Xss: list(list(A))] : ( concat(A,aa(list(list(A)),list(list(A)),aa(fun(list(A),list(A)),fun(list(list(A)),list(list(A))),map(list(A),list(A)),list_case(list(A),A,nil(A),combb(list(A),fun(list(A),list(A)),A,combk(list(A),list(A)),aa(list(A),fun(A,list(A)),combc(A,list(A),list(A),cons(A)),nil(A))))),Xss)) = aa(list(list(A)),list(A),aa(fun(list(A),A),fun(list(list(A)),list(A)),map(list(A),A),hd(A)),aa(list(list(A)),list(list(A)),filter(list(A),combb(bool,bool,list(A),fNot,aa(list(A),fun(list(A),bool),combc(list(A),list(A),bool,fequal(list(A))),nil(A)))),Xss)) ) ).

tff(fact_92_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_93_hd_Osimps,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),A,hd(A),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = X ) ).

tff(fact_94_hd__map,axiom,
    ! [B: $tType,A: $tType,F: fun(A,B),Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( aa(list(B),B,hd(B),aa(list(A),list(B),aa(fun(A,B),fun(list(A),list(B)),map(A,B),F),Xs)) = aa(A,B,F,aa(list(A),A,hd(A),Xs)) ) ) ).

tff(fact_95_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_96_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_97_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_98_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

%----Arities (2)
tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,aa(A,fun(B,A),combk(A,B),P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    listsp(dB,it,aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),aa(list(dB),list(dB),aa(fun(dB,dB),fun(list(dB),list(dB)),map(dB,dB),aa(nat,fun(dB,dB),combc(dB,nat,dB,aa(dB,fun(dB,fun(nat,dB)),combc(dB,dB,fun(nat,dB),subst),u)),i)),as))) ).

%------------------------------------------------------------------------------
