%------------------------------------------------------------------------------
% File     : LCL828_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 205
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_205 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  173 (  53 unt;  58 typ;   0 def)
%            Number of atoms       :  233 (  77 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  162 (  44   ~;  12   |;  13   &)
%                                         (  10 <=>;  83  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   28 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   37 (  18   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-4 aty)
%            Number of functors    :   49 (  49 usr;  27 con; 0-5 aty)
%            Number of variables   :  374 ( 336   !;  10   ?; 374   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:24:26
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (52)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : fun(fun(nat,A),fun(nat,fun(A,fun(nat,A)))) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T5: $tType] : ( ( fun(nat,T5) * fun(type,fun(type,T5)) * type ) > T5 ) ).

tff(sy_c_Type_Otyping,type,
    typing: fun(fun(nat,type),fun(dB,fun(type,bool))) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_Ts____,type,
    ts: list(type) ).

tff(sy_v_Ua____,type,
    ua1: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_1_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_uT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,e),u),t)) ).

tff(fact_4_False,axiom,
    n != i ).

tff(fact_5_I,axiom,
    ! [E1: fun(nat,type),T4: type,U3: dB,I1: nat] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),E1),I1),t)),a),T4))
     => ( pp(aa(dB,bool,it,U3))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E1),U3),t))
         => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),U3),I1))) ) ) ) ).

tff(fact_6__096e_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AU_096,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),a),ua1)) ).

tff(fact_7_Cons_I1_J,axiom,
    ( ! [E1: fun(nat,type),T4: type,U3: dB,I1: nat] :
        ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),E1),I1),t)),a),T4))
       => ( pp(aa(dB,bool,it,U3))
         => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E1),U3),t))
           => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),U3),I1))) ) ) )
    & ? [X11: type] : pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),a),X11)) ) ).

tff(fact_8__096_B_Bthesis_O_A_I_B_BU_O_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AU_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [U2: type] : ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),a),U2)) ).

tff(fact_9_MI1,axiom,
    ! [Ub1: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T11)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub1))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub1),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib))) ) ) ) ) ) ).

tff(fact_10_MI2,axiom,
    ! [Ub1: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T21)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub1))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub1),T21))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib))) ) ) ) ) ) ).

tff(fact_11_subst__Var__IT,axiom,
    ! [J1: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),var(I)),J1))) ) ).

tff(fact_12_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),I))) ) ).

tff(fact_13_Cons_I3_J,axiom,
    listsp(dB,it,map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),aa(dB,fun(dB,fun(nat,dB)),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,dB))),combc(dB,dB,fun(nat,dB)),subst),u)),i),as)) ).

tff(fact_14__096e_060i_058T_062_A_124_124_N_Ars_A_058_ATs_096,axiom,
    typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t),rs,ts) ).

tff(fact_15_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_16_subst__lemma,axiom,
    ! [Ib: nat,Ub: type,Ub1: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E),Ub1),Ub))
       => ( ( Eb = aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),E),Ib),Ub) )
         => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib)),Ta1)) ) ) ) ).

tff(fact_17__096_B_Bthesis_O_A_I_B_BTs_O_Ae_060i_058T_062_A_124_124_N_Ars_A_058_ATs_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ts1: list(type)] : ~ typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t),rs,Ts1) ).

tff(fact_18_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_19_Var_I4_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,ea),ua),t)) ).

tff(fact_20_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_21_typing_OVar,axiom,
    ! [Ta1: type,X1: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X1) = Ta1 )
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),var(X1)),Ta1)) ) ).

tff(fact_22_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_23_lift__type,axiom,
    ! [Ub: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ub)),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib)),Ta1)) ) ).

tff(fact_24_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J: nat,Ib: nat] :
      ( ( Ib = J )
     => ( aa(nat,A,aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),Eb),Ib),Ta1),J) = Ta1 ) ) ).

tff(fact_25_lift__types,axiom,
    ! [Ub: type,Ib: nat,Tsa: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Tsa)
     => typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ub),map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),lift),Ib),Ts),Tsa) ) ).

tff(fact_26_substs__lemma,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub1: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub1),Ta1))
     => ( typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ta1),Ts,Tsa)
       => typings(Eb,map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),aa(dB,fun(dB,fun(nat,dB)),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,dB))),combc(dB,dB,fun(nat,dB)),subst),Ub1)),Ib),Ts),Tsa) ) ) ).

tff(fact_27__096listsp_A_I_Ft_O_AEX_AT_H_O_Ae_060i_058T_062_A_092_060turnstile_062_At_A_058_AT_H_J_Ars_096,axiom,
    listsp(dB,aa(fun(dB,fun(type,bool)),fun(dB,bool),aa(fun(fun(type,bool),bool),fun(fun(dB,fun(type,bool)),fun(dB,bool)),combb(fun(type,bool),bool,dB),fEx(type)),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t))),rs) ).

tff(fact_28_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X3: list(A)] :
      ( listsp(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1)),B1),X3)
    <=> ( listsp(A,A1,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_29_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_30_nT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),foldl(dB,dB,app,var(n),rs)),t1)) ).

tff(fact_31_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_32_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_33_subst__lift,axiom,
    ! [S1: dB,K: nat,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)),S1),K) = T1 ) ).

tff(fact_34_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_35_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_36_subst__App,axiom,
    ! [K: nat,S1: dB,U1: dB,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1)),S1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U1),S1),K)) ) ).

tff(fact_37_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)) ) ).

tff(fact_38_App,axiom,
    ! [Ta: dB,Ub: type,Ta1: type,S: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),S),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ub)))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),Ta),Ta1))
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta)),Ub)) ) ) ).

tff(fact_39_Var_I2_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),ea),ia),t)),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_40_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_41_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_42_dB_Osimps_I4_J,axiom,
    ! [DB2: dB,DB1: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_43_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB) ) ).

tff(fact_44_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != var(Nat) ) ).

tff(fact_45_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,aa(fun(C,B),fun(A,fun(C,A)),aa(fun(A,fun(fun(C,B),fun(C,A))),fun(fun(C,B),fun(A,fun(C,A))),combc(A,fun(C,B),fun(C,A)),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G)),F),Aa,Xs) ) ).

tff(fact_46_var__app__type__eq,axiom,
    ! [Ub: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ub))
       => ( Ta1 = Ub ) ) ) ).

tff(fact_47_app__Var__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),var(I)))) ) ).

tff(fact_48_lists__typings,axiom,
    ! [Tsa: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Tsa)
     => listsp(dB,aa(fun(dB,fun(type,bool)),fun(dB,bool),aa(fun(fun(type,bool),bool),fun(fun(dB,fun(type,bool)),fun(dB,bool)),combb(fun(type,bool),bool,dB),fEx(type)),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb)),Ts) ) ).

tff(fact_49_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U1),K) = U1 ) ).

tff(fact_50_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_51_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),lift),Ib),Ts)) ) ).

tff(fact_52_subst__map,axiom,
    ! [Ib: nat,Ub1: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub1),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub1),Ib),map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),aa(dB,fun(dB,fun(nat,dB)),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,dB))),combc(dB,dB,fun(nat,dB)),subst),Ub1)),Ib),Ts)) ) ).

tff(fact_53_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub1: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub1)),Ta1))
     => ~ ! [T3: type] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),aa(type,type,aa(type,fun(type,type),fun1,T3),Ta1)))
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub1),T3)) ) ) ).

tff(fact_54_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rsa: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rsa) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( R1 = S )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_55_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_56_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_57_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R1: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R1),Ss1) ) ).

tff(fact_58_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_59_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Tsa: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Tsa,Ta1)))
     => ( typings(Eb,Ts,Tsa)
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_60_Beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss1))) ) ) ).

tff(fact_61_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_62_Abs,axiom,
    ! [Ub: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Env),zero_zero(nat)),Ta1)),Ta),Ub))
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),abs(Ta)),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ub))) ) ).

tff(fact_63_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),lift),zero_zero(nat)),Ts)) ) ).

tff(fact_64_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),abs(Ta)),Ta1))
     => ~ ! [T3: type,U2: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T3),U2) )
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),zero_zero(nat)),T3)),Ta),U2)) ) ) ).

tff(fact_65_var__app__types,axiom,
    ! [Ub: type,Tsa: list(type),Ta1: type,Us1: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us1)),Ta1))
     => ( typings(Eb,Ts,Tsa)
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ub))
         => ? [Us2: list(type)] :
              ( ( Ub = foldr(type,type,fun1,Us2,Ta1) )
              & typings(Eb,Us1,Us2) ) ) ) ) ).

tff(fact_66_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_67_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts1,Ta1)))
          & typings(Eb,Ts,Ts1) ) ) ).

tff(fact_68_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),abs(Ta)),Ta1))
     => ~ ! [U2: type,V1: type] : ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),zero_zero(nat)),U2)),Ta),V1)) ) ).

tff(fact_69_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs1: list(dB),N1: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N1),Rs1) )
            & listsp(dB,it,Rs1) )
        | ? [R4: dB] :
            ( ( Aa = abs(R4) )
            & pp(aa(dB,bool,it,R4)) )
        | ? [R4: dB,S3: dB,Ss2: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R4)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R4),S3),zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_70_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_71_Cons_I2_J,axiom,
    listsp(dB,aa(fun(dB,bool),fun(dB,bool),aa(fun(dB,fun(bool,bool)),fun(fun(dB,bool),fun(dB,bool)),combs(dB,bool,bool),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst)))))))))),aa(fun(dB,fun(type,bool)),fun(dB,bool),aa(fun(fun(type,bool),bool),fun(fun(dB,fun(type,bool)),fun(dB,bool)),combb(fun(type,bool),bool,dB),fEx(type)),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)))),as) ).

tff(fact_72_Var_Ohyps,axiom,
    listsp(dB,aa(fun(dB,bool),fun(dB,bool),aa(fun(dB,fun(bool,bool)),fun(fun(dB,bool),fun(dB,bool)),combs(dB,bool,bool),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it)),aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst))))))))),rs) ).

tff(fact_73__096listsp_A_I_Ft_O_AALL_Ae_AT_H_Au_Ai_O_Ae_060i_058T_062_A_092_060turnstile_062_At_A_058_AT_H_A_N_N_062_AIT_Au_A_N_N_062_Ae_A_092_060turnstile_062_Au_A_058_AT_A_N_N_062_AIT_A_It_091u_Pi_093_J_J_Ars_096,axiom,
    listsp(dB,aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst)))))))),rs) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75__096listsp_A_I_Ft_O_A_IALL_Ae_AT_H_Au_Ai_O_Ae_060i_058T_062_A_092_060turnstile_062_At_A_058_AT_H_A_N_N_062_AIT_Au_A_N_N_062_Ae_A_092_060turnstile_062_Au_A_058_AT_A_N_N_062_AIT_A_It_091u_Pi_093_J_J_A_G_A_IEX_AT_H_O_Ae_060i_058T_062_A_092_060turnstile_062_At_A_058_AT_H_J_J_Ars_096,axiom,
    listsp(dB,aa(fun(dB,bool),fun(dB,bool),aa(fun(dB,fun(bool,bool)),fun(fun(dB,bool),fun(dB,bool)),combs(dB,bool,bool),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst)))))))))),aa(fun(dB,fun(type,bool)),fun(dB,bool),aa(fun(fun(type,bool),bool),fun(fun(dB,fun(type,bool)),fun(dB,bool)),combb(fun(type,bool),bool,dB),fEx(type)),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)))),rs) ).

tff(fact_76_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_77_beta,axiom,
    ! [T1: dB,S1: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T1),zero_zero(nat)))) ).

tff(fact_78_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_79_appL,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1))) ) ).

tff(fact_80_appR,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S1)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T1))) ) ).

tff(fact_81_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T1)) ).

tff(fact_82_abs,axiom,
    ! [T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S1)),abs(T1))) ) ).

tff(fact_83_subject__reduction,axiom,
    ! [T2: dB,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T2))
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),T2),Ta1)) ) ) ).

tff(fact_84_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),T1),I)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T1),I))) ) ).

tff(fact_85_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),lift,R3),I)),aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),I))) ) ).

tff(fact_86_beta__cases_I2_J,axiom,
    ! [S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S1))
     => ~ ! [T: dB] :
            ( ( S1 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T)) ) ) ).

tff(fact_87_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_88_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),U1))
     => ( ! [S2: dB] :
            ( ( U1 = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T1),zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_89_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_90_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X1: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y: A,S2: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),X2)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),Y)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X1) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X1),Xs) ) ) ).

tff(fact_91_substn__subst__0,axiom,
    ! [S1: dB,T1: dB] : ( substn(T1,S1,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S1),zero_zero(nat)) ) ).

tff(fact_92_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U1: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S1,K)),substn(U1,S1,K)) ) ).

tff(fact_93_substn__subst__n,axiom,
    ! [N: nat,S1: dB,T1: dB] : ( substn(T1,S1,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),liftn(N,S1,zero_zero(nat))),N) ) ).

tff(fact_94_apps__preserves__betas,axiom,
    ! [R1: dB,Ss1: list(dB),Rsa: list(dB)] :
      ( step1(dB,beta,Rsa,Ss1)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),foldl(dB,dB,app,R1,Ss1))) ) ).

tff(fact_95_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S1,K)),liftn(N,T1,K)) ) ).

tff(fact_96_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_97_head__Var__reduction,axiom,
    ! [V: dB,Rsa: list(dB),Na: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(Na),Rsa)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rsa,Ss)
          & ( V = foldl(dB,dB,app,var(Na),Ss) ) ) ) ).

tff(fact_98_apps__betasE,axiom,
    ! [S: dB,Rsa: list(dB),R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),S))
     => ( ! [R2: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),R2))
           => ( S != foldl(dB,dB,app,R2,Rsa) ) )
       => ( ! [Rs: list(dB)] :
              ( step1(dB,beta,Rsa,Rs)
             => ( S != foldl(dB,dB,app,R1,Rs) ) )
         => ~ ! [T: dB] :
                ( ( R1 = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rsa = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),U),zero_zero(nat)),Us) ) ) ) ) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i))) ).

%------------------------------------------------------------------------------
