%------------------------------------------------------------------------------
% File     : LCL821_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 193
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_193 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  164 (  43 unt;  48 typ;   0 def)
%            Number of atoms       :  243 (  77 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  180 (  53   ~;  12   |;   7   &)
%                                         (  18 <=>;  90  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   26 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   25 (  14   >;  11   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   1 prp; 0-3 aty)
%            Number of functors    :   37 (  37 usr;  21 con; 0-5 aty)
%            Number of variables   :  304 ( 276   !;   6   ?; 304   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:23:22
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (42)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : fun(fun(nat,A),fun(nat,fun(A,fun(nat,A)))) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otyping,type,
    typing: fun(fun(nat,type),fun(dB,fun(type,bool))) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_thesis____,type,
    thesis: $o ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (98)
tff(fact_0_False,axiom,
    n != i ).

tff(fact_1__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_2_uT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,e),u),t)) ).

tff(fact_3_nT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),foldl(dB,dB,app,var(n),rs)),t1)) ).

tff(fact_4_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_5_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_6_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J3: nat,Ib: nat] :
      ( ( Ib = J3 )
     => ( aa(nat,A,aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),Eb),Ib),Ta1),J3) = Ta1 ) ) ).

tff(fact_7_Var_I2_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),ea),ia),t)),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_8_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T11)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_9_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T2)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T2))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_10_Var_I4_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,ea),ua),t)) ).

tff(fact_11_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ua)),lift(Ta,Ib)),Ta1)) ) ).

tff(fact_12_shift__gt,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),Ib: nat,J3: nat] :
      ( ord_less(nat,J3,Ib)
     => ( aa(nat,A,aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),Eb),Ib),Ta1),J3) = aa(nat,A,Eb,J3) ) ) ).

tff(fact_13_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E),Ub),Ua))
       => ( ( Eb = aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),E),Ib),Ua) )
         => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib)),Ta1)) ) ) ) ).

tff(fact_14_Var_Ohyps,axiom,
    listsp(dB,aa(fun(dB,bool),fun(dB,bool),aa(fun(dB,fun(bool,bool)),fun(fun(dB,bool),fun(dB,bool)),combs(dB,bool,bool),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it)),aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst))))))))),rs) ).

tff(fact_15_shift__commute,axiom,
    ! [A: $tType,Ta1: A,Ua: A,Ib: nat,Eb: fun(nat,A)] : ( aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),Eb),Ib),Ua)),zero_zero(nat)),Ta1) = aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),Eb),zero_zero(nat)),Ta1)),suc(Ib)),Ua) ) ).

tff(fact_16_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_17_typing_OVar,axiom,
    ! [Ta1: type,X1: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X1) = Ta1 )
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),var(X1)),Ta1)) ) ).

tff(fact_18_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_19_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,lift(T,I))) ) ).

tff(fact_20_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),S),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),Ta),Ta1))
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta)),Ua)) ) ) ).

tff(fact_21_calculation,axiom,
    listsp(dB,aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst)))))))),rs) ).

tff(fact_22_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_23_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_24_subst__Var__IT,axiom,
    ! [J1: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),var(I)),J1))) ) ).

tff(fact_25_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts1: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts1)),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts1)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_26_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_27_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T1: type] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),aa(type,type,aa(type,fun(type,type),fun1,T1),Ta1)))
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T1)) ) ) ).

tff(fact_28_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),Na: nat,Rsa: list(dB),M1: nat] :
      ( ( foldl(dB,dB,app,var(M1),Rsa) = foldl(dB,dB,app,var(Na),Ss) )
    <=> ( ( M1 = Na )
        & ( Rsa = Ss ) ) ) ).

tff(fact_29_zero__less__Suc,axiom,
    ! [N1: nat] : ord_less(nat,zero_zero(nat),suc(N1)) ).

tff(fact_30_less__Suc0,axiom,
    ! [Na: nat] :
      ( ord_less(nat,Na,suc(zero_zero(nat)))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_31_lift_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S1: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S1,K1)),lift(T,K1)) ) ).

tff(fact_32_subst__App,axiom,
    ! [K1: nat,S1: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S1),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S1),K1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S1),K1)) ) ).

tff(fact_33_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts1: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts1) = foldl(dB,dB,app,S,Ts1) )
    <=> ( R1 = S ) ) ).

tff(fact_34_nat_Oinject,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( suc(Nat4) = suc(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_35_dB_Osimps_I2_J,axiom,
    ! [DB22: dB,DB12: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) )
    <=> ( ( DB11 = DB12 )
        & ( DB21 = DB22 ) ) ) ).

tff(fact_36_dB_Osimps_I1_J,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( var(Nat4) = var(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_37_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_38_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_39_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_40_Suc__mono,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less(nat,M3,N1)
     => ord_less(nat,suc(M3),suc(N1)) ) ).

tff(fact_41_Suc__less__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less(nat,suc(M1),suc(Na))
    <=> ord_less(nat,M1,Na) ) ).

tff(fact_42_not__less__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ~ ord_less(nat,M1,Na)
    <=> ord_less(nat,Na,suc(M1)) ) ).

tff(fact_43_lessI,axiom,
    ! [N1: nat] : ord_less(nat,N1,suc(N1)) ).

tff(fact_44_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_45_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_46_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_47_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( ord_less(nat,M1,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( ord_less(nat,Na,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_48_less__not__refl3,axiom,
    ! [T: nat,S1: nat] :
      ( ord_less(nat,S1,T)
     => ( S1 != T ) ) ).

tff(fact_49_less__not__refl2,axiom,
    ! [M3: nat,N1: nat] :
      ( ord_less(nat,N1,M3)
     => ( M3 != N1 ) ) ).

tff(fact_50_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_51_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_52_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( ord_less(nat,M1,Na)
        | ord_less(nat,Na,M1) ) ) ).

tff(fact_53_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_54_Suc__neq__Zero,axiom,
    ! [M3: nat] : ( suc(M3) != zero_zero(nat) ) ).

tff(fact_55_Zero__neq__Suc,axiom,
    ! [M3: nat] : ( zero_zero(nat) != suc(M3) ) ).

tff(fact_56_nat_Osimps_I3_J,axiom,
    ! [Nat3: nat] : ( suc(Nat3) != zero_zero(nat) ) ).

tff(fact_57_Suc__not__Zero,axiom,
    ! [M3: nat] : ( suc(M3) != zero_zero(nat) ) ).

tff(fact_58_nat_Osimps_I2_J,axiom,
    ! [Nat2: nat] : ( zero_zero(nat) != suc(Nat2) ) ).

tff(fact_59_Zero__not__Suc,axiom,
    ! [M3: nat] : ( zero_zero(nat) != suc(M3) ) ).

tff(fact_60_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_61_gr__implies__not0,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less(nat,M3,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_62_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_63_Suc__less__SucD,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less(nat,suc(M3),suc(N1))
     => ord_less(nat,M3,N1) ) ).

tff(fact_64_Suc__lessD,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less(nat,suc(M3),N1)
     => ord_less(nat,M3,N1) ) ).

tff(fact_65_less__SucE,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less(nat,M3,suc(N1))
     => ( ~ ord_less(nat,M3,N1)
       => ( M3 = N1 ) ) ) ).

tff(fact_66_less__trans__Suc,axiom,
    ! [K1: nat,J1: nat,I: nat] :
      ( ord_less(nat,I,J1)
     => ( ord_less(nat,J1,K1)
       => ord_less(nat,suc(I),K1) ) ) ).

tff(fact_67_Suc__lessI,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less(nat,M3,N1)
     => ( ( suc(M3) != N1 )
       => ord_less(nat,suc(M3),N1) ) ) ).

tff(fact_68_less__SucI,axiom,
    ! [N1: nat,M3: nat] :
      ( ord_less(nat,M3,N1)
     => ord_less(nat,M3,suc(N1)) ) ).

tff(fact_69_less__antisym,axiom,
    ! [M3: nat,N1: nat] :
      ( ~ ord_less(nat,N1,M3)
     => ( ord_less(nat,N1,suc(M3))
       => ( M3 = N1 ) ) ) ).

tff(fact_70_not__less__less__Suc__eq,axiom,
    ! [M1: nat,Na: nat] :
      ( ~ ord_less(nat,Na,M1)
     => ( ord_less(nat,Na,suc(M1))
      <=> ( Na = M1 ) ) ) ).

tff(fact_71_less__Suc__eq,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less(nat,M1,suc(Na))
    <=> ( ord_less(nat,M1,Na)
        | ( M1 = Na ) ) ) ).

tff(fact_72_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != var(Nat) ) ).

tff(fact_73_dB_Osimps_I4_J,axiom,
    ! [DB2: dB,DB1: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_74_subst__eq,axiom,
    ! [U: dB,K1: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K1)),U),K1) = U ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_76_subst__lift,axiom,
    ! [S1: dB,K1: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,lift(T,K1)),S1),K1) = T ) ).

tff(fact_77_less__Suc__eq__0__disj,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less(nat,M1,suc(Na))
    <=> ( ( M1 = zero_zero(nat) )
        | ? [J2: nat] :
            ( ( M1 = suc(J2) )
            & ord_less(nat,J2,Na) ) ) ) ).

tff(fact_78_gr0__conv__Suc,axiom,
    ! [Na: nat] :
      ( ord_less(nat,zero_zero(nat),Na)
    <=> ? [M2: nat] : ( Na = suc(M2) ) ) ).

tff(fact_79_subst__lt,axiom,
    ! [U: dB,I: nat,J1: nat] :
      ( ord_less(nat,J1,I)
     => ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(J1)),U),I) = var(J1) ) ) ).

tff(fact_80_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: list(A)] :
      ( listsp(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1)),B1),X2)
    <=> ( listsp(A,A1,X2)
        & listsp(A,B1,X2) ) ) ).

tff(fact_81_gr0__implies__Suc,axiom,
    ! [N1: nat] :
      ( ord_less(nat,zero_zero(nat),N1)
     => ? [M: nat] : ( N1 = suc(M) ) ) ).

tff(fact_82_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [N2: nat,Na: nat,F: fun(nat,A)] :
          ( ! [N: nat] : ord_less(A,aa(nat,A,F,N),aa(nat,A,F,suc(N)))
         => ( ord_less(nat,Na,N2)
           => ord_less(A,aa(nat,A,F,Na),aa(nat,A,F,N2)) ) ) ) ).

tff(fact_83_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [M1: nat,Na: nat,F: fun(nat,A)] :
          ( ! [N: nat] : ord_less(A,aa(nat,A,F,N),aa(nat,A,F,suc(N)))
         => ( ord_less(A,aa(nat,A,F,Na),aa(nat,A,F,M1))
          <=> ord_less(nat,Na,M1) ) ) ) ).

tff(fact_84_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_85_lessE,axiom,
    ! [K1: nat,I: nat] :
      ( ord_less(nat,I,K1)
     => ( ( K1 != suc(I) )
       => ~ ! [J: nat] :
              ( ord_less(nat,I,J)
             => ( K1 != suc(J) ) ) ) ) ).

tff(fact_86_Suc__lessE,axiom,
    ! [K1: nat,I: nat] :
      ( ord_less(nat,suc(I),K1)
     => ~ ! [J: nat] :
            ( ord_less(nat,I,J)
           => ( K1 != suc(J) ) ) ) ).

tff(fact_87_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat1: nat] : ( Y != suc(Nat1) ) ) ).

tff(fact_88_zero__induct,axiom,
    ! [K: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K))
     => ( ! [N: nat] :
            ( pp(aa(nat,bool,P1,suc(N)))
           => pp(aa(nat,bool,P1,N)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_89_not0__implies__Suc,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ? [M: nat] : ( N1 = suc(M) ) ) ).

tff(fact_90_nat__induct,axiom,
    ! [Na: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N: nat] :
            ( pp(aa(nat,bool,P1,N))
           => pp(aa(nat,bool,P1,suc(N))) )
       => pp(aa(nat,bool,P1,Na)) ) ) ).

tff(fact_91_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_92_list__app__typeI,axiom,
    ! [Ts1: list(dB),Ta1: type,Ts3: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts3,Ta1)))
     => ( typings(Eb,Ts1,Ts3)
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts1)),Ta1)) ) ) ).

tff(fact_93_var__app__typesE,axiom,
    ! [Ta1: type,Ts1: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts1)),Ta1))
     => ~ ! [Ts2: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),foldr(type,type,fun1,Ts2,Ta1)))
           => ~ typings(Eb,Ts1,Ts2) ) ) ).

tff(fact_94_var__app__types,axiom,
    ! [Ua: type,Ts3: list(type),Ta1: type,Us: list(dB),Ts1: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts1),Us)),Ta1))
     => ( typings(Eb,Ts1,Ts3)
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts1)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta1) )
              & typings(Eb,Us,Us1) ) ) ) ) ).

tff(fact_95_list__app__typeE,axiom,
    ! [Ta1: type,Ts1: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts1)),Ta1))
     => ~ ! [Ts2: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts2,Ta1)))
           => ~ typings(Eb,Ts1,Ts2) ) ) ).

tff(fact_96_list__app__typeD,axiom,
    ! [Ta1: type,Ts1: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts1)),Ta1))
     => ? [Ts2: list(type)] :
          ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts2,Ta1)))
          & typings(Eb,Ts1,Ts2) ) ) ).

tff(fact_97_Beta,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss))) ) ) ).

%----Arities (4)
tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

%----Helper facts (12)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    ! [Ts: list(type)] :
      ( typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t),rs,Ts)
     => thesis ) ).

tff(conj_1,conjecture,
    thesis ).

%------------------------------------------------------------------------------
