%------------------------------------------------------------------------------
% File     : LCL820_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 191
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_191 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  169 (  55 unt;  55 typ;   0 def)
%            Number of atoms       :  213 (  94 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  133 (  34   ~;  11   |;  14   &)
%                                         (  17 <=>;  57  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   26 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   40 (  20   >;  20   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-3 aty)
%            Number of functors    :   46 (  46 usr;  22 con; 0-5 aty)
%            Number of variables   :  390 ( 355   !;   8   ?; 390   :)
%                                         (  27  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:23:20
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (49)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(dB,fun(dB,T3)) * fun(dB,T3) * dB ) > T3 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : fun(fun(nat,A),fun(nat,fun(A,fun(nat,A)))) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(type,fun(type,T3)) * type ) > T3 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: fun(fun(nat,type),fun(dB,fun(type,bool))) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_1__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_Var_I4_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,ea),ua),t)) ).

tff(fact_4_uT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,e),u),t)) ).

tff(fact_5_Var_Ohyps,axiom,
    listsp(dB,aa(fun(dB,bool),fun(dB,bool),aa(fun(dB,fun(bool,bool)),fun(fun(dB,bool),fun(dB,bool)),combs(dB,bool,bool),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it)),aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst))))))))),rs) ).

tff(fact_6_Var_I2_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),ea),ia),t)),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_7_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T11)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_8_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T2)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T2))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_9_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X3: list(A)] :
      ( listsp(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A2)),B1),X3)
    <=> ( listsp(A,A2,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_10_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E),Ub),Ua))
       => ( ( Eb = aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),E),Ib),Ua) )
         => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib)),Ta1)) ) ) ) ).

tff(fact_11_subst__Var__IT,axiom,
    ! [J1: nat,I: nat,R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),var(I)),J1))) ) ).

tff(fact_12_nT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),foldl(dB,dB,app,var(n),rs)),t1)) ).

tff(fact_13_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_14_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J: nat,Ib: nat] :
      ( ( Ib = J )
     => ( aa(nat,A,aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),Eb),Ib),Ta1),J) = Ta1 ) ) ).

tff(fact_15_typing_OVar,axiom,
    ! [Ta1: type,X2: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X2) = Ta1 )
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),var(X2)),Ta1)) ) ).

tff(fact_16_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_17_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_18_subst__App,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S),K)) ) ).

tff(fact_19_False,axiom,
    n != i ).

tff(fact_20_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB11 = DB13 )
        & ( DB21 = DB23 ) ) ) ).

tff(fact_21_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_22_type_Osimps_I2_J,axiom,
    ! [Type23: type,Type13: type,Type22: type,Type12: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type12),Type22) = aa(type,type,aa(type,fun(type,type),fun1,Type13),Type23) )
    <=> ( ( Type12 = Type13 )
        & ( Type22 = Type23 ) ) ) ).

tff(fact_23_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S2: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),S2),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),Ta),Ta1))
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),aa(dB,dB,aa(dB,fun(dB,dB),app,S2),Ta)),Ua)) ) ) ).

tff(fact_24_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_25_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != var(Nat) ) ).

tff(fact_26_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_27_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_28_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_29_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T1: type] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),aa(type,type,aa(type,fun(type,type),fun1,T1),Ta1)))
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T1)) ) ) ).

tff(fact_30_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_31_apps__eq__tail__conv,axiom,
    ! [S2: dB,Ts: list(dB),R3: dB] :
      ( ( foldl(dB,dB,app,R3,Ts) = foldl(dB,dB,app,S2,Ts) )
    <=> ( R3 = S2 ) ) ).

tff(fact_32_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type12),Type22)) = aa(type,A,aa(type,fun(type,A),F2,Type12),Type22) ) ).

tff(fact_33_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X2: A,Xs: list(A),S2: B,F: fun(B,fun(A,B))] :
      ( ! [X1: A,Y1: A,S3: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S3),X1)),Y1) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S3),Y1)),X1) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S2,Xs)),X2) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S2),X2),Xs) ) ) ).

tff(fact_34_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_35_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ua)),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib)),Ta1)) ) ).

tff(fact_36_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)) ) ).

tff(fact_37_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_38_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S),K) = T ) ).

tff(fact_39_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB11),DB21) ) ).

tff(fact_40_type_Osimps_I5_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_41_Var__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S2: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S2,Ss1) )
    <=> ( ( var(M) = S2 )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_42_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),lift),Ib),Ts)) ) ).

tff(fact_43_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),aa(dB,fun(dB,fun(nat,dB)),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,dB))),combc(dB,dB,fun(nat,dB)),subst),Ub)),Ib),Ts)) ) ).

tff(fact_44_substn_Osimps_I2_J,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S,K)),substn(U,S,K)) ) ).

tff(fact_45_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_46_type_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( atom(Nat2) = atom(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_47_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_48_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_49_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_50_listsp_ONil,axiom,
    ! [A: $tType,A2: fun(A,bool)] : listsp(A,A2,nil(A)) ).

tff(fact_51_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A1: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A1,nil(B)) = A1 ) ).

tff(fact_52_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A1: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A1,map(C,B,F,Xs)) = foldl(A,C,aa(fun(C,B),fun(A,fun(C,A)),aa(fun(A,fun(fun(C,B),fun(C,A))),fun(fun(C,B),fun(A,fun(C,A))),combc(A,fun(C,B),fun(C,A)),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G)),F),A1,Xs) ) ).

tff(fact_53_type_Osimps_I3_J,axiom,
    ! [Type21: type,Type11: type,Nat: nat] : ( atom(Nat) != aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) ) ).

tff(fact_54_type_Osimps_I4_J,axiom,
    ! [Nat: nat,Type21: type,Type11: type] : ( aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) != atom(Nat) ) ).

tff(fact_55_substs__lemma,axiom,
    ! [Ts2: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),Ta1))
     => ( typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ta1),Ts,Ts2)
       => typings(Eb,map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),aa(dB,fun(dB,fun(nat,dB)),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,dB))),combc(dB,dB,fun(nat,dB)),subst),Ub)),Ib),Ts),Ts2) ) ) ).

tff(fact_56_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),lift),zero_zero(nat)),Ts)) ) ).

tff(fact_57_lift__types,axiom,
    ! [Ua: type,Ib: nat,Ts2: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( typings(Eb,Ts,Ts2)
     => typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ua),map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),lift),Ib),Ts),Ts2) ) ).

tff(fact_58_type_Oexhaust,axiom,
    ! [Y: type] :
      ( ! [Nat1: nat] : ( Y != atom(Nat1) )
     => ~ ! [Type1: type,Type2: type] : ( Y != aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) ) ) ).

tff(fact_59_typings_Osimps_I1_J,axiom,
    ! [Ts2: list(type),Eb: fun(nat,type)] :
      ( typings(Eb,nil(dB),Ts2)
    <=> ( Ts2 = nil(type) ) ) ).

tff(fact_60_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_61_type_Osize_I1_J,axiom,
    ! [Nat: nat] : ( type_size(atom(Nat)) = zero_zero(nat) ) ).

tff(fact_62_type_Osize_I3_J,axiom,
    ! [Nat: nat] : ( size_size(type,atom(Nat)) = zero_zero(nat) ) ).

tff(fact_63_substn__subst__n,axiom,
    ! [N1: nat,S: dB,T: dB] : ( substn(T,S,N1) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N1,S,zero_zero(nat))),N1) ) ).

tff(fact_64_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S,K)),liftn(N1,T,K)) ) ).

tff(fact_65_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_66_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_67_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Ts2: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts2,Ta1)))
     => ( typings(Eb,Ts,Ts2)
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_68_foldr_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,A1: A,F: fun(B,fun(A,A))] : ( foldr(B,A,F,nil(B),A1) = A1 ) ).

tff(fact_69_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_70_var__app__types,axiom,
    ! [Ua: type,Ts2: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us)),Ta1))
     => ( typings(Eb,Ts,Ts2)
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta1) )
              & typings(Eb,Us,Us1) ) ) ) ) ).

tff(fact_71_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_72_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ typings(Eb,Ts,Ts1) ) ) ).

tff(fact_73_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts1,Ta1)))
          & typings(Eb,Ts,Ts1) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_Beta,axiom,
    ! [Ss1: list(dB),S2: dB,R3: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),S2),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S2))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R3)),S2),Ss1))) ) ) ).

tff(fact_76_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_77_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_78_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S2: dB,Rsa: list(dB),R3: dB] :
      ( ( foldl(dB,dB,app,abs(R3),Rsa) = foldl(dB,dB,app,abs(S2),Ss1) )
    <=> ( ( R3 = S2 )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_79_apps__eq__Abs__conv,axiom,
    ! [R3: dB,Ss1: list(dB),S2: dB] :
      ( ( foldl(dB,dB,app,S2,Ss1) = abs(R3) )
    <=> ( ( S2 = abs(R3) )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_80_Abs__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S2: dB,R3: dB] :
      ( ( abs(R3) = foldl(dB,dB,app,S2,Ss1) )
    <=> ( ( abs(R3) = S2 )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_81_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Env),zero_zero(nat)),Ta1)),Ta),Ua))
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),abs(Ta)),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua))) ) ).

tff(fact_82_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB3)) = aa(dB,A,F3,DB3) ) ).

tff(fact_83_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_84_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_85_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_86_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_87_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R3: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R3),Ss1) ) ).

tff(fact_88_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta: dB,S2: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),Ta) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_89_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),abs(Ta)),Ta1))
     => ~ ! [T1: type,U1: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T1),U1) )
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),zero_zero(nat)),T1)),Ta),U1)) ) ) ).

tff(fact_90_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),abs(Ta)),Ta1))
     => ~ ! [U1: type,V: type] : ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),zero_zero(nat)),U1)),Ta),V)) ) ).

tff(fact_91_IT_Osimps,axiom,
    ! [A1: dB] :
      ( pp(aa(dB,bool,it,A1))
    <=> ( ? [Rs: list(dB),N: nat] :
            ( ( A1 = foldl(dB,dB,app,var(N),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R2: dB] :
            ( ( A1 = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S1: dB,Ss: list(dB)] :
            ( ( A1 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S1),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),S1),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S1)) ) ) ) ).

tff(fact_92_beta,axiom,
    ! [T: dB,S: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),zero_zero(nat))) ).

tff(fact_93_appL,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_94_appR,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_95_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ beta(var(I),T) ).

tff(fact_96_abs,axiom,
    ! [T: dB,S: dB] :
      ( beta(S,T)
     => beta(abs(S),abs(T)) ) ).

tff(fact_97_lift__preserves__beta,axiom,
    ! [I: nat,S: dB,R1: dB] :
      ( beta(R1,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),lift,R1),I),aa(nat,dB,aa(dB,fun(nat,dB),lift,S),I)) ) ).

tff(fact_98_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S: dB,R1: dB] :
      ( beta(R1,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),T),I),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),I)) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (13)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    listsp(dB,aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst)))))))),rs) ).

%------------------------------------------------------------------------------
