%------------------------------------------------------------------------------
% File     : LCL812_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 172
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_172 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.50 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  158 (  63 unt;  48 typ;   0 def)
%            Number of atoms       :  202 ( 118 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  130 (  38   ~;   8   |;  22   &)
%                                         (  21 <=>;  41  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   44 (  23   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-4 aty)
%            Number of functors    :   40 (  40 usr;  16 con; 0-5 aty)
%            Number of variables   :  374 ( 328   !;  15   ?; 374   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:39
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( list(list(A)) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),T2)) * list(A) ) > T2 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t)) ).

tff(fact_1_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_True,axiom,
    n = i ).

tff(fact_4__096listsp_AIT_A_Imap_A_I_Ft_O_Alift_At_A0_J_A_Imap_A_I_Ft_O_At_091u_Pi_093_J_Aas_J_J_096,axiom,
    listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),as))) ).

tff(fact_5_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),I))) ) ).

tff(fact_6_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_7_app__Var__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),var(I)))) ) ).

tff(fact_8_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),var(I)),J))) ) ).

tff(fact_9__096IT_A_I_Ilift_Au_A0_A_092_060degree_062_AVar_A0_J_091a_091u_Pi_093_P0_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat)))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),zero_zero(nat)))) ).

tff(fact_10__096IT_A_Iu_A_092_060degree_062_Aa_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,u),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)))) ).

tff(fact_11_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_12_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_13_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss) )
    <=> ( ( M = Na )
        & ( Rsa = Ss ) ) ) ).

tff(fact_14_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_15_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)) ) ).

tff(fact_16_subst__App,axiom,
    ! [K: nat,S1: dB,U1: dB,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1)),S1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U1),S1),K)) ) ).

tff(fact_17_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_18_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_19_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_20_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_21_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_22_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X3)
    <=> ( listsp(A,A1,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_23_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_24_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_25_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U1),K) = U1 ) ).

tff(fact_26_subst__lift,axiom,
    ! [S1: dB,K: nat,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)),S1),K) = T1 ) ).

tff(fact_27_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_28_Cons,axiom,
    rs = aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),a),as) ).

tff(fact_29_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_30_Beta,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss))) ) ) ).

tff(fact_31_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_32_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y: A,S2: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),X2)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),Y)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X),Xs) ) ) ).

tff(fact_33_substn__subst__0,axiom,
    ! [S1: dB,T1: dB] : ( substn(T1,S1,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S1),zero_zero(nat)) ) ).

tff(fact_34_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List2: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Aa),List2) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List3) )
    <=> ( ( Aa = A5 )
        & ( List2 = List3 ) ) ) ).

tff(fact_35_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_36_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,F: fun(B,A)] : ( map(B,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X),Xs)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(B,A,F,X)),map(B,A,F,Xs)) ) ).

tff(fact_37_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_38_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U1: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S1,K)),substn(U1,S1,K)) ) ).

tff(fact_39_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rsa: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rsa) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( R1 = S )
        & ( Rsa = Ss ) ) ) ).

tff(fact_40_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1) ) ).

tff(fact_41_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1) != Xs1 ) ).

tff(fact_42_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X),Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,Aa),X),Xs) ) ).

tff(fact_43_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_44_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_45_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_46_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_47_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_48_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),Na: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(Na),Ss) ) ).

tff(fact_49_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),R1: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R1),Ss) ) ).

tff(fact_50_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs1: list(dB),N1: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N1),Rs1) )
            & listsp(dB,it,Rs1) )
        | ? [R4: dB] :
            ( ( Aa = abs(R4) )
            & pp(aa(dB,bool,it,R4)) )
        | ? [R4: dB,S3: dB,Ss2: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R4)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R4),S3),zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_51_substn__subst__n,axiom,
    ! [N: nat,S1: dB,T1: dB] : ( substn(T1,S1,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),liftn(N,S1,zero_zero(nat))),N) ) ).

tff(fact_52_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xs: list(A),X: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) = map(B,A,F,Ys) )
    <=> ? [Z: B,Zs1: list(B)] :
          ( ( Ys = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs1) )
          & ( X = aa(B,A,F,Z) )
          & ( Xs = map(B,A,F,Zs1) ) ) ) ).

tff(fact_53_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y3: A,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y3),Ys) )
    <=> ? [Z: B,Zs1: list(B)] :
          ( ( Xs = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs1) )
          & ( aa(B,A,F,Z) = Y3 )
          & ( map(B,A,F,Zs1) = Ys ) ) ) ).

tff(fact_54_beta,axiom,
    ! [T1: dB,S1: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T1),zero_zero(nat)))) ).

tff(fact_55_appR,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S1)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T1))) ) ).

tff(fact_56_appL,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1))) ) ).

tff(fact_57_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T1)) ).

tff(fact_58_abs,axiom,
    ! [T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S1)),abs(T1))) ) ).

tff(fact_59_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S1,K)),liftn(N,T1,K)) ) ).

tff(fact_60_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),T1),I)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T1),I))) ) ).

tff(fact_61_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),lift,R3),I)),aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),I))) ) ).

tff(fact_62_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_63_beta__cases_I2_J,axiom,
    ! [S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S1))
     => ~ ! [T: dB] :
            ( ( S1 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T)) ) ) ).

tff(fact_64_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Ss)),foldl(dB,dB,app,S,Ss))) ) ).

tff(fact_65_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),U1))
     => ( ! [S2: dB] :
            ( ( U1 = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T1),zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_66_apps__betasE,axiom,
    ! [S: dB,Rsa: list(dB),R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),S))
     => ( ! [R2: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),R2))
           => ( S != foldl(dB,dB,app,R2,Rsa) ) )
       => ( ! [Rs: list(dB)] :
              ( step1(dB,beta,Rsa,Rs)
             => ( S != foldl(dB,dB,app,R1,Rs) ) )
         => ~ ! [T: dB] :
                ( ( R1 = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rsa = aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),U),Us) )
                   => ( S != foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),U),zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_67_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Aa),List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List2) ) ).

tff(fact_68_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys2: list(A),Y1: A,Xs1: list(A),X1: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys2)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),splice(A,Xs1,Ys2))) ) ).

tff(fact_69_apps__preserves__betas,axiom,
    ! [R1: dB,Ss: list(dB),Rsa: list(dB)] :
      ( step1(dB,beta,Rsa,Ss)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),foldl(dB,dB,app,R1,Ss))) ) ).

tff(fact_70_head__Var__reduction,axiom,
    ! [V1: dB,Rsa: list(dB),Na: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(Na),Rsa)),V1))
     => ? [Ss1: list(dB)] :
          ( step1(dB,beta,Rsa,Ss1)
          & ( V1 = foldl(dB,dB,app,var(Na),Ss1) ) ) ) ).

tff(fact_71_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Y3: A,R1: fun(A,fun(A,bool))] :
      ( step1(A,R1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y3),Ys),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R1,Y3),X))
          & ( Xs = Ys ) )
        | ( ( X = Y3 )
          & step1(A,R1,Ys,Xs) ) ) ) ).

tff(fact_72_apps__eq__Abs__conv,axiom,
    ! [R1: dB,Ss: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss) = abs(R1) )
    <=> ( ( S = abs(R1) )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_73_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( member(A,X,A1)
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_76_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_77_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_78_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_79_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( var(M) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_80_Abs__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( ( abs(R1) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( abs(R1) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_81_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(A,fun(A,bool))] : ~ step1(A,R1,nil(A),Xs) ).

tff(fact_82_not__step1__Nil,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(A,fun(A,bool))] : ~ step1(A,R1,Xs,nil(A)) ).

tff(fact_83_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_84_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_85_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys2: list(A)] : ( splice(A,nil(A),Ys2) = Ys2 ) ).

tff(fact_86_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) != nil(A) ) ).

tff(fact_87_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List1) ) ).

tff(fact_88_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,nil(B)) = Aa ) ).

tff(fact_89_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

tff(fact_90_listsp_Osimps,axiom,
    ! [A: $tType,Aa: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,Aa)
    <=> ( ( Aa = nil(A) )
        | ? [A3: A,L: list(A)] :
            ( ( Aa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),L) )
            & pp(aa(A,bool,A1,A3))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_91_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y2: A,Ys1: list(A)] : ( Xs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys1) ) ) ).

tff(fact_92_list_Oexhaust,axiom,
    ! [A: $tType,Y1: list(A)] :
      ( ( Y1 != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List) ) ) ).

tff(fact_93_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),R1: fun(A,fun(A,bool))] :
      ( step1(A,R1,Ys,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs))
     => ( ! [Y: A] :
            ( ( Ys = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),R1,Y),X)) )
       => ~ ! [Zs: list(A)] :
              ( ( Ys = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Zs) )
             => ~ step1(A,R1,Zs,Xs) ) ) ) ).

tff(fact_94_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)) ) ).

tff(fact_95_sublist__singleton,axiom,
    ! [A: $tType,X: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)),A1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_96_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_97_concat__map__singleton,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] : ( concat(A,map(B,list(A),combc(B,list(A),list(A),aa(fun(B,A),fun(B,fun(list(A),list(A))),aa(fun(A,fun(list(A),list(A))),fun(fun(B,A),fun(B,fun(list(A),list(A)))),combb(A,fun(list(A),list(A)),B),cons(A)),F),nil(A)),Xs)) = map(B,A,F,Xs) ) ).

tff(fact_98_app__last,axiom,
    ! [Ub: dB,Ts: list(dB),Ta: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,Ta,Ts)),Ub) = foldl(dB,dB,app,Ta,append(dB,Ts,aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),Ub),nil(dB)))) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,foldl(dB,dB,app,var(zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),as))))) ).

%------------------------------------------------------------------------------
