%------------------------------------------------------------------------------
% File     : LCL810_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 169
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_169 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  164 (  72 unt;  52 typ;   0 def)
%            Number of atoms       :  182 ( 122 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :   98 (  28   ~;   6   |;  18   &)
%                                         (  19 <=>;  27  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   47 (  25   >;  22   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-3 aty)
%            Number of functors    :   42 (  42 usr;  17 con; 0-5 aty)
%            Number of variables   :  338 ( 288   !;  15   ?; 338   :)
%                                         (  35  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:16
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),fun(T1,T1))) * list(A) ) > T1 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omonoid__add__class_Olistsum,type,
    monoid_add_listsum: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_b____,type,
    b: dB ).

tff(sy_v_bs____,type,
    bs: list(dB) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (98)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t)) ).

tff(fact_1_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_True,axiom,
    n = i ).

tff(fact_4__096IT_A_Ilift_A_Ib_091u_Pi_093_J_A0_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,b),u),i)),zero_zero(nat)))) ).

tff(fact_5_Cons_I3_J,axiom,
    listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),bs))) ).

tff(fact_6__096IT_A_Ib_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,b),u),i))) ).

tff(fact_7_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_8_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_9_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X2: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X2,Xs1)) = cons(A,aa(B,A,F,X2),map(B,A,F,Xs1)) ) ).

tff(fact_10_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A2),B1),X3)
    <=> ( listsp(A,A2,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_11_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_12_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A1: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A1,List1) )
    <=> ( ( Aa = A1 )
        & ( List = List1 ) ) ) ).

tff(fact_13_subst__lift,axiom,
    ! [S2: dB,K1: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)),S2),K1) = T ) ).

tff(fact_14__096IT_A_Iu_A_092_060degree_062_Aa_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,u),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)))) ).

tff(fact_15__096IT_A_I_Ilift_Au_A0_A_092_060degree_062_AVar_A0_J_091a_091u_Pi_093_P0_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat)))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),zero_zero(nat)))) ).

tff(fact_16_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xs1: list(A),X2: A] :
      ( ( cons(A,X2,Xs1) = map(B,A,F,Ys) )
    <=> ? [Z1: B,Zs1: list(B)] :
          ( ( Ys = cons(B,Z1,Zs1) )
          & ( X2 = aa(B,A,F,Z1) )
          & ( Xs1 = map(B,A,F,Zs1) ) ) ) ).

tff(fact_17_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y1: A,Xs1: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs1) = cons(A,Y1,Ys) )
    <=> ? [Z1: B,Zs1: list(B)] :
          ( ( Xs1 = cons(B,Z1,Zs1) )
          & ( aa(B,A,F,Z1) = Y1 )
          & ( map(B,A,F,Zs1) = Ys ) ) ) ).

tff(fact_18_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_19_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_20_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB11 = DB13 )
        & ( DB21 = DB23 ) ) ) ).

tff(fact_21_dB_Osimps_I1_J,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( var(Nat4) = var(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_22_subst__App,axiom,
    ! [K1: nat,S2: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S2),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S2),K1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S2),K1)) ) ).

tff(fact_23_lift_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T)),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),K1)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)) ) ).

tff(fact_24_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat3: nat] : ( var(Nat3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_25_dB_Osimps_I5_J,axiom,
    ! [Nat3: nat,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != var(Nat3) ) ).

tff(fact_26_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_27_subst__eq,axiom,
    ! [U: dB,K1: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K1)),U),K1) = U ) ).

tff(fact_28_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_29_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),var(I)),J))) ) ).

tff(fact_30_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_31__096rs_A_061_Aa_A_D_Aas_096,axiom,
    rs = cons(dB,a,as) ).

tff(fact_32_dB_Osize_I1_J,axiom,
    ! [Nat3: nat] : ( dB_size(var(Nat3)) = zero_zero(nat) ) ).

tff(fact_33_dB_Osize_I4_J,axiom,
    ! [Nat3: nat] : ( size_size(dB,var(Nat3)) = zero_zero(nat) ) ).

tff(fact_34_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_35_substn__subst__0,axiom,
    ! [S2: dB,T: dB] : ( substn(T,S2,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S2),zero_zero(nat)) ) ).

tff(fact_36_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys1)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys1))) ) ).

tff(fact_37_map__eq__Cons__D,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y1: A,Xs1: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs1) = cons(A,Y1,Ys) )
     => ? [Z: B,Zs: list(B)] :
          ( ( Xs1 = cons(B,Z,Zs) )
          & ( aa(B,A,F,Z) = Y1 )
          & ( map(B,A,F,Zs) = Ys ) ) ) ).

tff(fact_38_substn_Osimps_I2_J,axiom,
    ! [K1: nat,S2: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S2,K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S2,K1)),substn(U,S2,K1)) ) ).

tff(fact_39_substn__subst__n,axiom,
    ! [N: nat,S2: dB,T: dB] : ( substn(T,S2,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N,S2,zero_zero(nat))),N) ) ).

tff(fact_40_Cons__eq__map__D,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xs1: list(A),X2: A] :
      ( ( cons(A,X2,Xs1) = map(B,A,F,Ys) )
     => ? [Z: B,Zs: list(B)] :
          ( ( Ys = cons(B,Z,Zs) )
          & ( X2 = aa(B,A,F,Z) )
          & ( Xs1 = map(B,A,F,Zs) ) ) ) ).

tff(fact_41_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat4: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat4)) = aa(nat,A,F1,Nat4) ) ).

tff(fact_42_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB11),DB21) ) ).

tff(fact_43_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,Aa,List)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,Aa),List),list_rec(A,B,F1,F2,List)) ) ).

tff(fact_44_liftn_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S2: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S2,K1)),liftn(N,T,K1)) ) ).

tff(fact_45_liftn__0,axiom,
    ! [K1: nat,T: dB] : ( liftn(zero_zero(nat),T,K1) = T ) ).

tff(fact_46_listsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( monoid_add(A)
     => ! [Xs1: list(B)] : ( monoid_add_listsum(A,map(B,A,combk(A,B,zero_zero(A)),Xs1)) = zero_zero(A) ) ) ).

tff(fact_47_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_48_liftn__lift,axiom,
    ! [K1: nat,T: dB,N: nat] : ( liftn(suc(N),T,K1) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N,T,K1)),K1) ) ).

tff(fact_49_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ~ null(A,cons(A,X,Xs)) ).

tff(fact_50_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X2: B,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,cons(B,X2,Xs1)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,Aa),X2),Xs1) ) ).

tff(fact_51_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs1: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs1)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs1) ) ).

tff(fact_52_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_53_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_54_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M1: nat] :
      ( ( foldl(dB,dB,app,var(M1),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M1 = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_55_apps__eq__tail__conv,axiom,
    ! [S1: dB,Ts: list(dB),R2: dB] :
      ( ( foldl(dB,dB,app,R2,Ts) = foldl(dB,dB,app,S1,Ts) )
    <=> ( R2 = S1 ) ) ).

tff(fact_56_nat_Oinject,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( suc(Nat4) = suc(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_57_Beta,axiom,
    ! [Ss1: list(dB),S1: dB,R2: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),S1),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S1))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S1),Ss1))) ) ) ).

tff(fact_58_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB5) )
    <=> ( DB3 = DB5 ) ) ).

tff(fact_59_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_60_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S1: dB,Rsa: list(dB),R2: dB] :
      ( ( foldl(dB,dB,app,abs(R2),Rsa) = foldl(dB,dB,app,abs(S1),Ss1) )
    <=> ( ( R2 = S1 )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_61_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_62_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB4) ) ).

tff(fact_63_dB_Osimps_I7_J,axiom,
    ! [Nat3: nat,DB4: dB] : ( abs(DB4) != var(Nat3) ) ).

tff(fact_64_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat3: nat] : ( var(Nat3) != abs(DB4) ) ).

tff(fact_65_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB3)) = aa(dB,A,F3,DB3) ) ).

tff(fact_66_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_67_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_68_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_69_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta: dB,S1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),Ta) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_70_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R2: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R2),Ss1) ) ).

tff(fact_71_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_72_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_nat_Osimps_I3_J,axiom,
    ! [Nat2: nat] : ( suc(Nat2) != zero_zero(nat) ) ).

tff(fact_75_Suc__not__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_76_nat_Osimps_I2_J,axiom,
    ! [Nat1: nat] : ( zero_zero(nat) != suc(Nat1) ) ).

tff(fact_77_Zero__not__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_78_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs: list(dB),N2: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N2),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R1: dB] :
            ( ( Aa = abs(R1) )
            & pp(aa(dB,bool,it,R1)) )
        | ? [R1: dB,S: dB,Ss: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S)) ) ) ) ).

tff(fact_79_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat: nat] : ( Y != suc(Nat) ) ) ).

tff(fact_80_zero__induct,axiom,
    ! [K: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K))
     => ( ! [N1: nat] :
            ( pp(aa(nat,bool,P1,suc(N1)))
           => pp(aa(nat,bool,P1,N1)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_81_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ? [M2: nat] : ( N = suc(M2) ) ) ).

tff(fact_82_nat__induct,axiom,
    ! [Na: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N1: nat] :
            ( pp(aa(nat,bool,P1,N1))
           => pp(aa(nat,bool,P1,suc(N1))) )
       => pp(aa(nat,bool,P1,Na)) ) ) ).

tff(fact_83_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = plus_plus(nat,dB_size(DB),suc(zero_zero(nat))) ) ).

tff(fact_84_dB_Osize_I2_J,axiom,
    ! [DB2: dB,DB1: dB] : ( dB_size(aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = plus_plus(nat,plus_plus(nat,dB_size(DB1),dB_size(DB2)),suc(zero_zero(nat))) ) ).

tff(fact_85_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,Ba: A] :
          ( ( plus_plus(A,Ba,Aa) = plus_plus(A,C1,Aa) )
        <=> ( Ba = C1 ) ) ) ).

tff(fact_86_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Ba: A,Aa: A] :
          ( ( plus_plus(A,Aa,Ba) = plus_plus(A,Aa,C1) )
        <=> ( Ba = C1 ) ) ) ).

tff(fact_87_nat__add__right__cancel,axiom,
    ! [Na: nat,K: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K) = plus_plus(nat,Na,K) )
    <=> ( M1 = Na ) ) ).

tff(fact_88_nat__add__left__cancel,axiom,
    ! [Na: nat,M1: nat,K: nat] :
      ( ( plus_plus(nat,K,M1) = plus_plus(nat,K,Na) )
    <=> ( M1 = Na ) ) ).

tff(fact_89_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_90_add__is__0,axiom,
    ! [Na: nat,M1: nat] :
      ( ( plus_plus(nat,M1,Na) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( Na = zero_zero(nat) ) ) ) ).

tff(fact_91_add__Suc__right,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,suc(N)) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_92_add__Suc,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_93_listsum__simps_I2_J,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(A),X: A] : ( monoid_add_listsum(A,cons(A,X,Xs)) = plus_plus(A,X,monoid_add_listsum(A,Xs)) ) ) ).

tff(fact_94_dB_Osize_I5_J,axiom,
    ! [DB2: dB,DB1: dB] : ( size_size(dB,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = plus_plus(nat,plus_plus(nat,size_size(dB,DB1),size_size(dB,DB2)),suc(zero_zero(nat))) ) ).

tff(fact_95_dB_Osize_I6_J,axiom,
    ! [DB: dB] : ( size_size(dB,abs(DB)) = plus_plus(nat,size_size(dB,DB),suc(zero_zero(nat))) ) ).

tff(fact_96_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_97_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( plus_plus(nat,M,zero_zero(nat)) = M ) ).

%----Arities (3)
tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (10)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    listsp(dB,it,cons(dB,aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,b),u),i)),zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),bs)))) ).

%------------------------------------------------------------------------------
