%------------------------------------------------------------------------------
% File     : LCL809_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 167
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_167 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  170 (  80 unt;  54 typ;   0 def)
%            Number of atoms       :  174 ( 115 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :   86 (  28   ~;   8   |;  10   &)
%                                         (  17 <=>;  23  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   45 (  26   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-3 aty)
%            Number of functors    :   42 (  42 usr;  15 con; 0-5 aty)
%            Number of variables   :  280 ( 243   !;   7   ?; 280   :)
%                                         (  30  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:22:09
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char1: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_String_Onibble,type,
    nibble: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (46)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omonoid__add__class_Olistsum,type,
    monoid_add_listsum: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_String_Ochar_OChar,type,
    char: ( nibble * nibble ) > char1 ).

tff(sy_c_String_Ochar_Ochar__case,type,
    char_case: 
      !>[T1: $tType] : ( ( fun(nibble,fun(nibble,T1)) * char1 ) > T1 ) ).

tff(sy_c_String_Ochar_Ochar__rec,type,
    char_rec: 
      !>[T1: $tType] : ( ( fun(nibble,fun(nibble,T1)) * char1 ) > T1 ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char1 > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_b____,type,
    b: dB ).

tff(sy_v_bs____,type,
    bs: list(dB) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_t____,type,
    t: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (98)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t)) ).

tff(fact_1_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3__096IT_A_Ib_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,b),u),i))) ).

tff(fact_4_True,axiom,
    n = i ).

tff(fact_5_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_6_subst__lift,axiom,
    ! [S2: dB,K1: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)),S2),K1) = T ) ).

tff(fact_7__096IT_A_Iu_A_092_060degree_062_Aa_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,u),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)))) ).

tff(fact_8__096IT_A_I_Ilift_Au_A0_A_092_060degree_062_AVar_A0_J_091a_091u_Pi_093_P0_093_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat)))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),u),i)),zero_zero(nat)))) ).

tff(fact_9_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X3: A] :
          ( ( zero_zero(A) = X3 )
        <=> ( X3 = zero_zero(A) ) ) ) ).

tff(fact_10_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),var(I)),J))) ) ).

tff(fact_11_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_12_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_13_char__size,axiom,
    ! [C2: char1] : ( char_size(C2) = zero_zero(nat) ) ).

tff(fact_14_substn__subst__0,axiom,
    ! [S2: dB,T: dB] : ( substn(T,S2,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S2),zero_zero(nat)) ) ).

tff(fact_15_Cons_I3_J,axiom,
    listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,u),i),bs))) ).

tff(fact_16_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_17_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB11 = DB13 )
        & ( DB21 = DB23 ) ) ) ).

tff(fact_18_dB_Osimps_I1_J,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( var(Nat4) = var(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_19_subst__App,axiom,
    ! [K1: nat,S2: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S2),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S2),K1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S2),K1)) ) ).

tff(fact_20_lift_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T)),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),K1)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K1)) ) ).

tff(fact_21_substn_Osimps_I2_J,axiom,
    ! [K1: nat,S2: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S2,K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S2,K1)),substn(U,S2,K1)) ) ).

tff(fact_22_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_23_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != var(Nat) ) ).

tff(fact_24_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T),var(I)))) ) ).

tff(fact_25_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_26_subst__eq,axiom,
    ! [U: dB,K1: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K1)),U),K1) = U ) ).

tff(fact_27_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_28_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X2)
    <=> ( listsp(A,A1,X2)
        & listsp(A,B1,X2) ) ) ).

tff(fact_29_map__ident,axiom,
    ! [A: $tType,X2: list(A)] : ( map(A,A,combi(A),X2) = X2 ) ).

tff(fact_30_substn__subst__n,axiom,
    ! [N: nat,S2: dB,T: dB] : ( substn(T,S2,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N,S2,zero_zero(nat))),N) ) ).

tff(fact_31_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_32_size__char,axiom,
    ! [C2: char1] : ( size_size(char1,C2) = zero_zero(nat) ) ).

tff(fact_33_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_34_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_35_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_36_liftn_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S2: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S2,K1)),liftn(N,T,K1)) ) ).

tff(fact_37_liftn__0,axiom,
    ! [K1: nat,T: dB] : ( liftn(zero_zero(nat),T,K1) = T ) ).

tff(fact_38_size__bool,axiom,
    ! [Ba: bool] : ( size_size(bool,Ba) = zero_zero(nat) ) ).

tff(fact_39_size__literal__def,axiom,
    ! [S2: literal] : ( size_size(literal,S2) = zero_zero(nat) ) ).

tff(fact_40_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_41_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat4: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat4)) = aa(nat,A,F1,Nat4) ) ).

tff(fact_42_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB11),DB21) ) ).

tff(fact_43_char_Osize_I2_J,axiom,
    ! [Nibble22: nibble,Nibble12: nibble] : ( size_size(char1,char(Nibble12,Nibble22)) = zero_zero(nat) ) ).

tff(fact_44_char_Oinject,axiom,
    ! [Nibble23: nibble,Nibble13: nibble,Nibble2: nibble,Nibble1: nibble] :
      ( ( char(Nibble1,Nibble2) = char(Nibble13,Nibble23) )
    <=> ( ( Nibble1 = Nibble13 )
        & ( Nibble2 = Nibble23 ) ) ) ).

tff(fact_45_char_Osize_I1_J,axiom,
    ! [Nibble22: nibble,Nibble12: nibble] : ( char_size(char(Nibble12,Nibble22)) = zero_zero(nat) ) ).

tff(fact_46_nat__size,axiom,
    ! [N: nat] : ( size_size(nat,N) = N ) ).

tff(fact_47_char_Oexhaust,axiom,
    ! [Y: char1] :
      ~ ! [Nibble11: nibble,Nibble21: nibble] : ( Y != char(Nibble11,Nibble21) ) ).

tff(fact_48_char_Osimps_I2_J,axiom,
    ! [A: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,A))] : ( char_case(A,F1,char(Nibble1,Nibble2)) = aa(nibble,A,aa(nibble,fun(nibble,A),F1,Nibble1),Nibble2) ) ).

tff(fact_49_char_Orecs,axiom,
    ! [A: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,A))] : ( char_rec(A,F1,char(Nibble1,Nibble2)) = aa(nibble,A,aa(nibble,fun(nibble,A),F1,Nibble1),Nibble2) ) ).

tff(fact_50_listsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(B)] : ( monoid_add_listsum(A,map(B,A,combk(A,B,zero_zero(A)),Xs)) = zero_zero(A) ) ) ).

tff(fact_51_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_52_liftn__lift,axiom,
    ! [K1: nat,T: dB,N: nat] : ( liftn(suc(N),T,K1) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N,T,K1)),K1) ) ).

tff(fact_53_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_54_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_55_apps__eq__tail__conv,axiom,
    ! [S1: dB,Ts: list(dB),R2: dB] :
      ( ( foldl(dB,dB,app,R2,Ts) = foldl(dB,dB,app,S1,Ts) )
    <=> ( R2 = S1 ) ) ).

tff(fact_56_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M1: nat] :
      ( ( foldl(dB,dB,app,var(M1),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M1 = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_57_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),Aa: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_58_nat_Oinject,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( suc(Nat4) = suc(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_59_Beta,axiom,
    ! [Ss1: list(dB),S1: dB,R2: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),S1),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S1))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S1),Ss1))) ) ) ).

tff(fact_60_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB5) )
    <=> ( DB3 = DB5 ) ) ).

tff(fact_61_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_62_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S1: dB,Rsa: list(dB),R2: dB] :
      ( ( foldl(dB,dB,app,abs(R2),Rsa) = foldl(dB,dB,app,abs(S1),Ss1) )
    <=> ( ( R2 = S1 )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_63_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_64_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB4) ) ).

tff(fact_65_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB4: dB] : ( abs(DB4) != var(Nat) ) ).

tff(fact_66_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat: nat] : ( var(Nat) != abs(DB4) ) ).

tff(fact_67_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB3)) = aa(dB,A,F3,DB3) ) ).

tff(fact_68_Suc__inject,axiom,
    ! [Y: nat,X1: nat] :
      ( ( suc(X1) = suc(Y) )
     => ( X1 = Y ) ) ).

tff(fact_69_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_70_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_71_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta: dB,S1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),Ta) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_72_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R2: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R2),Ss1) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_74_Suc__neq__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_75_Zero__neq__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_76_nat_Osimps_I3_J,axiom,
    ! [Nat3: nat] : ( suc(Nat3) != zero_zero(nat) ) ).

tff(fact_77_Suc__not__Zero,axiom,
    ! [M: nat] : ( suc(M) != zero_zero(nat) ) ).

tff(fact_78_nat_Osimps_I2_J,axiom,
    ! [Nat2: nat] : ( zero_zero(nat) != suc(Nat2) ) ).

tff(fact_79_Zero__not__Suc,axiom,
    ! [M: nat] : ( zero_zero(nat) != suc(M) ) ).

tff(fact_80_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs: list(dB),N2: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N2),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R1: dB] :
            ( ( Aa = abs(R1) )
            & pp(aa(dB,bool,it,R1)) )
        | ? [R1: dB,S: dB,Ss: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S)) ) ) ) ).

tff(fact_81_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat1: nat] : ( Y != suc(Nat1) ) ) ).

tff(fact_82_zero__induct,axiom,
    ! [K: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K))
     => ( ! [N1: nat] :
            ( pp(aa(nat,bool,P1,suc(N1)))
           => pp(aa(nat,bool,P1,N1)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_83_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ? [M2: nat] : ( N = suc(M2) ) ) ).

tff(fact_84_nat__induct,axiom,
    ! [Na: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N1: nat] :
            ( pp(aa(nat,bool,P1,N1))
           => pp(aa(nat,bool,P1,suc(N1))) )
       => pp(aa(nat,bool,P1,Na)) ) ) ).

tff(fact_85_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = plus_plus(nat,dB_size(DB),suc(zero_zero(nat))) ) ).

tff(fact_86_dB_Osize_I2_J,axiom,
    ! [DB2: dB,DB1: dB] : ( dB_size(aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = plus_plus(nat,plus_plus(nat,dB_size(DB1),dB_size(DB2)),suc(zero_zero(nat))) ) ).

tff(fact_87_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,Ba: A] :
          ( ( plus_plus(A,Ba,Aa) = plus_plus(A,C1,Aa) )
        <=> ( Ba = C1 ) ) ) ).

tff(fact_88_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Ba: A,Aa: A] :
          ( ( plus_plus(A,Aa,Ba) = plus_plus(A,Aa,C1) )
        <=> ( Ba = C1 ) ) ) ).

tff(fact_89_nat__add__right__cancel,axiom,
    ! [Na: nat,K: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K) = plus_plus(nat,Na,K) )
    <=> ( M1 = Na ) ) ).

tff(fact_90_nat__add__left__cancel,axiom,
    ! [Na: nat,M1: nat,K: nat] :
      ( ( plus_plus(nat,K,M1) = plus_plus(nat,K,Na) )
    <=> ( M1 = Na ) ) ).

tff(fact_91_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_92_add__is__0,axiom,
    ! [Na: nat,M1: nat] :
      ( ( plus_plus(nat,M1,Na) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( Na = zero_zero(nat) ) ) ) ).

tff(fact_93_add__Suc__right,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,suc(N)) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_94_add__Suc,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_95_nat_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(nat,suc(Nat)) = plus_plus(nat,size_size(nat,Nat),suc(zero_zero(nat))) ) ).

tff(fact_96_nat_Osize_I2_J,axiom,
    ! [Nat: nat] : ( nat_size(suc(Nat)) = plus_plus(nat,nat_size(Nat),suc(zero_zero(nat))) ) ).

tff(fact_97_dB_Osize_I5_J,axiom,
    ! [DB2: dB,DB1: dB] : ( size_size(dB,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = plus_plus(nat,plus_plus(nat,size_size(dB,DB1),size_size(dB,DB2)),suc(zero_zero(nat))) ) ).

%----Arities (3)
tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,b),u),i)),zero_zero(nat)))) ).

%------------------------------------------------------------------------------
