%------------------------------------------------------------------------------
% File     : LCL799_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 148
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_148 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  164 (  51 unt;  53 typ;   0 def)
%            Number of atoms       :  229 (  83 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  162 (  44   ~;   8   |;  15   &)
%                                         (  13 <=>;  82  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   45 (  22   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-4 aty)
%            Number of functors    :   45 (  45 usr;  24 con; 0-5 aty)
%            Number of variables   :  356 ( 320   !;   9   ?; 356   :)
%                                         (  27  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T6: $tType,A: $tType] : ( ( T6 * fun(A,fun(list(A),T6)) * list(A) ) > T6 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(type,fun(type,T6)) * type ) > T6 ) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB ) > fun(type,bool) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) ) > fun(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H_H____,type,
    t: type ).

tff(sy_v_T_H____,type,
    t2: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t1: type ).

tff(sy_v_Ts____,type,
    ts: list(type) ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t3: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0_uT,axiom,
    pp(aa(type,bool,typing(e,u),t1)) ).

tff(fact_1__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t3)) ).

tff(fact_2_True,axiom,
    n = i ).

tff(fact_3_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_4_argT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t1),a),t)) ).

tff(fact_5__096IT_A_Ia_091u_Pi_093_J_096,axiom,
    pp(aa(dB,bool,it,subst(a,u,i))) ).

tff(fact_6__096ALL_Ae_AT_H_Au_Ai_O_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_A_N_N_062_AIT_Au_A_N_N_062_Ae_A_092_060turnstile_062_Au_A_058_AT_A_N_N_062_AIT_A_Ia_091u_Pi_093_J_096,axiom,
    ! [E1: fun(nat,type),T5: type,U3: dB,I1: nat] :
      ( pp(aa(type,bool,typing(shift(type,E1,I1,t1),a),T5))
     => ( pp(aa(dB,bool,it,U3))
       => ( pp(aa(type,bool,typing(E1,U3),t1))
         => pp(aa(dB,bool,it,subst(a,U3,I1))) ) ) ) ).

tff(fact_7_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_8_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => ( pp(aa(type,bool,typing(E,Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,typing(E,subst(Ta,Ub,Ib)),Ta1)) ) ) ) ).

tff(fact_9_argsT,axiom,
    pp(aa(list(type),bool,typings(shift(type,e,i,t1),as),ts)) ).

tff(fact_10_uT_H,axiom,
    pp(aa(type,bool,typing(e,u),aa(type,type,aa(type,fun(type,type),fun1,t),foldr(type,type,fun1,ts,t2)))) ).

tff(fact_11_Cons,axiom,
    rs = cons(dB,a,as) ).

tff(fact_12_varT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t1),var(n)),aa(type,type,aa(type,fun(type,type),fun1,t),foldr(type,type,fun1,ts,t2)))) ).

tff(fact_13_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t1 = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T11),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T11))
             => pp(aa(dB,bool,it,subst(Ta,Ub,Ib))) ) ) ) ) ) ).

tff(fact_14_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t1 = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T21),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T21))
             => pp(aa(dB,bool,it,subst(Ta,Ub,Ib))) ) ) ) ) ) ).

tff(fact_15__096_B_Bthesis_O_A_I_B_BT_H_H_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_058_AT_H_H_A_092_060Rightarrow_062_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_H_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [T4: type] :
        ( pp(aa(type,bool,typing(shift(type,e,i,t1),var(n)),aa(type,type,aa(type,fun(type,type),fun1,T4),foldr(type,type,fun1,ts,t2))))
       => ~ pp(aa(type,bool,typing(shift(type,e,i,t1),a),T4)) ) ).

tff(fact_16__096e_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t1),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,var(n)),a),as)),t2)) ).

tff(fact_17_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_18_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_19_typing_OVar,axiom,
    ! [Ta1: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta1 )
     => pp(aa(type,bool,typing(Env,var(X)),Ta1)) ) ).

tff(fact_20_nT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t1),foldl(dB,dB,app,var(n),rs)),t2)) ).

tff(fact_21_headT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t1),aa(dB,dB,aa(dB,fun(dB,dB),app,var(n)),a)),foldr(type,type,fun1,ts,t2))) ).

tff(fact_22_T,axiom,
    t1 = aa(type,type,aa(type,fun(type,type),fun1,t),foldr(type,type,fun1,ts,t2)) ).

tff(fact_23_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Env,S),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,typing(Env,Ta),Ta1))
       => pp(aa(type,bool,typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta)),Ua)) ) ) ).

tff(fact_24__096_B_Bthesis_O_A_I_B_BTs_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_058_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_124_124_N_Aas_A_058_ATs_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ts1: list(type)] :
        ( pp(aa(type,bool,typing(shift(type,e,i,t1),aa(dB,dB,aa(dB,fun(dB,dB),app,var(n)),a)),foldr(type,type,fun1,Ts1,t2)))
       => ~ pp(aa(list(type),bool,typings(shift(type,e,i,t1),as),Ts1)) ) ).

tff(fact_25_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_26_app__Var__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),var(I)))) ) ).

tff(fact_27_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J1) = Ta1 ) ) ).

tff(fact_28_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Tsa: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Tsa,Ta1)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_29_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_30_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,subst(R3,var(I),J))) ) ).

tff(fact_31_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T3: type] :
            ( pp(aa(type,bool,typing(Eb,Ta),aa(type,type,aa(type,fun(type,type),fun1,T3),Ta1)))
           => ~ pp(aa(type,bool,typing(Eb,Ub),T3)) ) ) ).

tff(fact_32_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,var(Ib)),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_33_var__app__types,axiom,
    ! [Ua: type,Tsa: list(type),Ta1: type,Us1: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us1)),Ta1))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us2: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us2,Ta1) )
              & pp(aa(list(type),bool,typings(Eb,Us1),Us2)) ) ) ) ) ).

tff(fact_34_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_35_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts1,Ta1)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_36_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_37_subst__App,axiom,
    ! [K: nat,S2: dB,U1: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S2,K)),subst(U1,S2,K)) ) ).

tff(fact_38_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_39_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_40_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_41_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_42_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_43_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( subst(var(K),U1,K) = U1 ) ).

tff(fact_44__096e_0600_058T_H_H_062_A_092_060turnstile_062_Alift_Au_A0_A_092_060degree_062_AVar_A0_A_058_ATs_A_061_062_062_AT_H_096,axiom,
    pp(aa(type,bool,typing(shift(type,e,zero_zero(nat),t),aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat)))),foldr(type,type,fun1,ts,t2))) ).

tff(fact_45_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A2: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A2,List1) )
    <=> ( ( Aa = A2 )
        & ( List = List1 ) ) ) ).

tff(fact_46_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs: list(B),X: B,F: fun(B,fun(A,A))] : ( foldr(B,A,F,cons(B,X,Xs),Aa) = aa(A,A,aa(B,fun(A,A),F,X),foldr(B,A,F,Xs,Aa)) ) ).

tff(fact_47_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,cons(B,X,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,Aa),X),Xs) ) ).

tff(fact_48_Var_I2_J,axiom,
    pp(aa(type,bool,typing(shift(type,ea,ia,t1),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_49_Var_I4_J,axiom,
    pp(aa(type,bool,typing(ea,ua),t1)) ).

tff(fact_50__096IT_A_Ilift_Au_A0_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat)))) ).

tff(fact_51__096IT_A_Ilift_Au_A0_A_092_060degree_062_AVar_A0_J_096,axiom,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat))))) ).

tff(fact_52_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)) ) ).

tff(fact_53_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),I))) ) ).

tff(fact_54_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => pp(aa(type,bool,typing(shift(type,Eb,Ib,Ua),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib)),Ta1)) ) ).

tff(fact_55_subst__lift,axiom,
    ! [S2: dB,K: nat,T1: dB] : ( subst(aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K),S2,K) = T1 ) ).

tff(fact_56_not__Cons__self,axiom,
    ! [A: $tType,X3: A,Xs1: list(A)] : ( Xs1 != cons(A,X3,Xs1) ) ).

tff(fact_57_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X3: A] : ( cons(A,X3,Xs1) != Xs1 ) ).

tff(fact_58_typings_Osimps_I2_J,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,cons(dB,Ta,Ts)),Tsa))
    <=> pp(list_case(bool,type,fFalse,combc(type,fun(list(type),bool),fun(list(type),bool),aa(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool))),aa(fun(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool))),fun(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool)))),combb(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun(type,bool),fun(type,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(type,bool),fun(type,fun(bool,bool))),combb(bool,fun(bool,bool),type),fconj),typing(Eb,Ta))),typings(Eb,Ts)),Tsa)) ) ).

tff(fact_59_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_60_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Env,zero_zero(nat),Ta1),Ta),Ua))
     => pp(aa(type,bool,typing(Env,abs(Ta)),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua))) ) ).

tff(fact_61_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_62_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rsa: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rsa) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( R1 = S )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_63_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_64_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_65_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_66_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_67_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_68_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R1: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R1),Ss1) ) ).

tff(fact_69_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_70_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_71_Beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R1,S,zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss1))) ) ) ).

tff(fact_72_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta)),Ta1))
     => ~ ! [T3: type,U2: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T3),U2) )
           => ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),T3),Ta),U2)) ) ) ).

tff(fact_73_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta)),Ta1))
     => ~ ! [U2: type,V1: type] : ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),U2),Ta),V1)) ) ).

tff(fact_76_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_77_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X2: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X2)
    <=> ( listsp(A,A1,X2)
        & listsp(A,B1,X2) ) ) ).

tff(fact_78_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs1: list(dB),N: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N),Rs1) )
            & listsp(dB,it,Rs1) )
        | ? [R4: dB] :
            ( ( Aa = abs(R4) )
            & pp(aa(dB,bool,it,R4)) )
        | ? [R4: dB,S3: dB,Ss2: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R4)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R4,S3,zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_79_beta,axiom,
    ! [T1: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T1)),subst(S2,T1,zero_zero(nat)))) ).

tff(fact_80_appR,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S2)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T1))) ) ).

tff(fact_81_appL,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1))) ) ).

tff(fact_82_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T1)) ).

tff(fact_83_abs,axiom,
    ! [T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S2)),abs(T1))) ) ).

tff(fact_84_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R3,T1,I)),subst(S2,T1,I))) ) ).

tff(fact_85_subject__reduction,axiom,
    ! [T2: dB,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T2))
       => pp(aa(type,bool,typing(Eb,T2),Ta1)) ) ) ).

tff(fact_86_lift__preserves__beta,axiom,
    ! [I: nat,S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),lift,R3),I)),aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),I))) ) ).

tff(fact_87_beta__cases_I2_J,axiom,
    ! [S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S2))
     => ~ ! [T: dB] :
            ( ( S2 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T)) ) ) ).

tff(fact_88_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_89_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1)),U1))
     => ( ! [S1: dB] :
            ( ( U1 = subst(S1,T1,zero_zero(nat)) )
           => ( S2 != abs(S1) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_90_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_91_apps__betasE,axiom,
    ! [S: dB,Rsa: list(dB),R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),S))
     => ( ! [R2: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),R2))
           => ( S != foldl(dB,dB,app,R2,Rsa) ) )
       => ( ! [Rs: list(dB)] :
              ( step1(dB,beta,Rsa,Rs)
             => ( S != foldl(dB,dB,app,R1,Rs) ) )
         => ~ ! [T: dB] :
                ( ( R1 = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rsa = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,subst(T,U,zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_92_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_93_apps__preserves__betas,axiom,
    ! [R1: dB,Ss1: list(dB),Rsa: list(dB)] :
      ( step1(dB,beta,Rsa,Ss1)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),foldl(dB,dB,app,R1,Ss1))) ) ).

tff(fact_94_head__Var__reduction,axiom,
    ! [V: dB,Rsa: list(dB),Na: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(Na),Rsa)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rsa,Ss)
          & ( V = foldl(dB,dB,app,var(Na),Ss) ) ) ) ).

tff(fact_95_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Y1: A,R1: fun(A,fun(A,bool))] :
      ( step1(A,R1,cons(A,Y1,Ys),cons(A,X,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R1,Y1),X))
          & ( Xs = Ys ) )
        | ( ( X = Y1 )
          & step1(A,R1,Ys,Xs) ) ) ) ).

tff(fact_96_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),R1: fun(A,fun(A,bool))] :
      ( step1(A,R1,Ys,cons(A,X,Xs))
     => ( ! [Y: A] :
            ( ( Ys = cons(A,Y,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),R1,Y),X)) )
       => ~ ! [Zs: list(A)] :
              ( ( Ys = cons(A,X,Zs) )
             => ~ step1(A,R1,Zs,Xs) ) ) ) ).

tff(fact_97_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X1: A,Y: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X1)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y)),X1) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X),Xs) ) ) ).

tff(fact_98_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (10)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(type,bool,typing(e,subst(a,u,i)),t)) ).

%------------------------------------------------------------------------------
