%------------------------------------------------------------------------------
% File     : LCL797_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 145
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_145 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  172 (  52 unt;  56 typ;   0 def)
%            Number of atoms       :  239 (  85 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  174 (  51   ~;  16   |;  15   &)
%                                         (  13 <=>;  79  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   26 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   33 (  17   >;  16   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-4 aty)
%            Number of functors    :   48 (  48 usr;  27 con; 0-5 aty)
%            Number of variables   :  371 ( 333   !;   9   ?; 371   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:32
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (50)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(B,fun(A,C))) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T6: $tType,A: $tType] : ( ( T6 * fun(A,fun(list(A),T6)) * list(A) ) > T6 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : fun(fun(nat,A),fun(nat,fun(A,fun(nat,A)))) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(type,fun(type,T6)) * type ) > T6 ) ).

tff(sy_c_Type_Otyping,type,
    typing: fun(fun(nat,type),fun(dB,fun(type,bool))) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) ) > fun(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fimplies,type,
    fimplies: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H_H____,type,
    t2: type ).

tff(sy_v_T_H____,type,
    t1: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t: type ).

tff(sy_v_Ts____,type,
    ts: list(type) ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t3: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_1__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t3)) ).

tff(fact_2_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_3_True,axiom,
    n = i ).

tff(fact_4_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T11)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_5_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t = aa(type,type,aa(type,fun(type,type),fun1,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),T21)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T21))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_6_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E1: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E1),Ub),Ua))
       => ( ( Eb = aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),E1),Ib),Ua) )
         => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E1),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),Ub),Ib)),Ta1)) ) ) ) ).

tff(fact_7_subst__Var__IT,axiom,
    ! [J1: nat,I1: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),var(I1)),J1))) ) ).

tff(fact_8_uT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,e),u),t)) ).

tff(fact_9_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_10_argT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),a),t2)) ).

tff(fact_11_Cons,axiom,
    rs = cons(dB,a,as) ).

tff(fact_12_Var_I4_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,ea),ua),t)) ).

tff(fact_13_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J: nat,Ib: nat] :
      ( ( Ib = J )
     => ( aa(nat,A,aa(A,fun(nat,A),aa(nat,fun(A,fun(nat,A)),aa(fun(nat,A),fun(nat,fun(A,fun(nat,A))),shift(A),Eb),Ib),Ta1),J) = Ta1 ) ) ).

tff(fact_14_typing_OVar,axiom,
    ! [Ta1: type,X2: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X2) = Ta1 )
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),var(X2)),Ta1)) ) ).

tff(fact_15_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_16_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_17_Var_I2_J,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),ea),ia),t)),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_18_Var_Ohyps,axiom,
    listsp(dB,aa(fun(dB,bool),fun(dB,bool),aa(fun(dB,fun(bool,bool)),fun(fun(dB,bool),fun(dB,bool)),combs(dB,bool,bool),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it)),aa(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool),aa(fun(fun(fun(nat,type),bool),bool),fun(fun(dB,fun(fun(nat,type),bool)),fun(dB,bool)),combb(fun(fun(nat,type),bool),bool,dB),fAll(fun(nat,type))),aa(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool)),aa(fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),fun(fun(dB,fun(fun(nat,type),fun(type,bool))),fun(dB,fun(fun(nat,type),bool))),combb(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool),dB),aa(fun(fun(type,bool),bool),fun(fun(fun(nat,type),fun(type,bool)),fun(fun(nat,type),bool)),combb(fun(type,bool),bool,fun(nat,type)),fAll(type))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(dB,fun(fun(nat,type),fun(type,bool)))),combb(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool)),dB),aa(fun(fun(type,fun(dB,bool)),fun(type,bool)),fun(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(fun(nat,type),fun(type,bool))),combb(fun(type,fun(dB,bool)),fun(type,bool),fun(nat,type)),aa(fun(fun(dB,bool),bool),fun(fun(type,fun(dB,bool)),fun(type,bool)),combb(fun(dB,bool),bool,type),fAll(dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool)))),aa(fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,bool))))),combb(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool))),dB),aa(fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool)),fun(nat,type)),aa(fun(fun(dB,fun(nat,bool)),fun(dB,bool)),fun(fun(type,fun(dB,fun(nat,bool))),fun(type,fun(dB,bool))),combb(fun(dB,fun(nat,bool)),fun(dB,bool),type),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),combs(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(dB,fun(nat,bool))))),dB),combs(fun(nat,type),fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(dB,fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(type,fun(dB,fun(nat,bool)))),fun(nat,type)),combc(type,fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),aa(fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))))),combb(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),dB),aa(fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),fun(fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))))),combb(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(nat,type)),aa(fun(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(type,fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,bool),fun(nat,bool)),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),type),combb(fun(nat,bool),fun(nat,bool),dB)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(dB,fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool)))),dB),aa(fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),fun(fun(nat,type),fun(type,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool))),fun(fun(type,fun(nat,fun(bool,bool))),fun(type,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(nat,fun(bool,bool)),fun(fun(nat,bool),fun(nat,bool)),type),combs(nat,bool,bool)))),aa(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),aa(fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),fun(fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))))),combb(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool)))),dB),aa(fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),fun(fun(fun(nat,type),fun(type,fun(nat,bool))),fun(fun(nat,type),fun(type,fun(nat,fun(bool,bool))))),combb(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool))),fun(nat,type)),aa(fun(fun(nat,bool),fun(nat,fun(bool,bool))),fun(fun(type,fun(nat,bool)),fun(type,fun(nat,fun(bool,bool)))),combb(fun(nat,bool),fun(nat,fun(bool,bool)),type),aa(fun(bool,fun(bool,bool)),fun(fun(nat,bool),fun(nat,fun(bool,bool))),combb(bool,fun(bool,bool),nat),fimplies)))),aa(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(type,fun(nat,bool))))),combb(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool))),dB),aa(fun(fun(nat,fun(type,bool)),fun(type,fun(nat,bool))),fun(fun(fun(nat,type),fun(nat,fun(type,bool))),fun(fun(nat,type),fun(type,fun(nat,bool)))),combb(fun(nat,fun(type,bool)),fun(type,fun(nat,bool)),fun(nat,type)),combc(nat,type,bool))),aa(fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),fun(dB,fun(fun(nat,type),fun(nat,fun(type,bool)))),combc(fun(nat,type),dB,fun(nat,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool)))),aa(fun(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),fun(fun(nat,type),fun(dB,fun(nat,fun(type,bool))))),combb(fun(nat,fun(dB,fun(type,bool))),fun(dB,fun(nat,fun(type,bool))),fun(nat,type)),combc(nat,dB,fun(type,bool))),aa(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool)))),aa(fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),fun(fun(fun(nat,type),fun(nat,fun(nat,type))),fun(fun(nat,type),fun(nat,fun(dB,fun(type,bool))))),combb(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool))),fun(nat,type)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,fun(nat,type)),fun(nat,fun(dB,fun(type,bool)))),combb(fun(nat,type),fun(dB,fun(type,bool)),nat),typing)),aa(type,fun(fun(nat,type),fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),fun(type,fun(fun(nat,type),fun(nat,fun(nat,type)))),combc(fun(nat,type),type,fun(nat,fun(nat,type))),aa(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type)))),aa(fun(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type)))),fun(fun(fun(nat,type),fun(nat,fun(type,fun(nat,type)))),fun(fun(nat,type),fun(type,fun(nat,fun(nat,type))))),combb(fun(nat,fun(type,fun(nat,type))),fun(type,fun(nat,fun(nat,type))),fun(nat,type)),combc(nat,type,fun(nat,type))),shift(type))),t))))))))))),aa(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(fun(fun(nat,type),fun(dB,fun(nat,bool))),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)),fun(nat,type)),aa(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),combs(dB,fun(nat,bool),fun(nat,bool)),aa(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat)),aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies),it))))),aa(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(dB,fun(nat,bool))),fun(dB,fun(fun(nat,type),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool))),dB),aa(fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(dB,fun(nat,bool)),fun(fun(nat,type),fun(dB,fun(nat,bool)))),combc(fun(nat,type),fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),aa(fun(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(nat,type),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))))),combb(fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(nat,bool)),fun(dB,fun(nat,bool))),fun(nat,type)),combs(dB,fun(nat,bool),fun(nat,bool))),aa(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),aa(fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),fun(fun(fun(nat,type),fun(dB,fun(bool,bool))),fun(fun(nat,type),fun(dB,fun(fun(nat,bool),fun(nat,bool))))),combb(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool))),fun(nat,type)),aa(fun(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool))),fun(fun(dB,fun(bool,bool)),fun(dB,fun(fun(nat,bool),fun(nat,bool)))),combb(fun(bool,bool),fun(fun(nat,bool),fun(nat,bool)),dB),combb(bool,bool,nat))),aa(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool))),aa(fun(fun(dB,bool),fun(dB,fun(bool,bool))),fun(fun(fun(nat,type),fun(dB,bool)),fun(fun(nat,type),fun(dB,fun(bool,bool)))),combb(fun(dB,bool),fun(dB,fun(bool,bool)),fun(nat,type)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fimplies)),aa(type,fun(fun(nat,type),fun(dB,bool)),aa(fun(fun(nat,type),fun(type,fun(dB,bool))),fun(type,fun(fun(nat,type),fun(dB,bool))),combc(fun(nat,type),type,fun(dB,bool)),aa(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool))),aa(fun(fun(dB,fun(type,bool)),fun(type,fun(dB,bool))),fun(fun(fun(nat,type),fun(dB,fun(type,bool))),fun(fun(nat,type),fun(type,fun(dB,bool)))),combb(fun(dB,fun(type,bool)),fun(type,fun(dB,bool)),fun(nat,type)),combc(dB,type,bool)),typing)),t)))))),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool))),aa(fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(dB,fun(nat,bool)))),combb(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(dB,fun(nat,dB)),fun(dB,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),dB),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),subst))))))))),rs) ).

tff(fact_19_nT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),foldl(dB,dB,app,var(n),rs)),t1)) ).

tff(fact_20_argsT,axiom,
    pp(aa(list(type),bool,typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t),as),ts)) ).

tff(fact_21_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),S),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),Ta),Ta1))
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta)),Ua)) ) ) ).

tff(fact_22__096e_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,var(n)),a),as)),t1)) ).

tff(fact_23_varT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),var(n)),aa(type,type,aa(type,fun(type,type),fun1,t2),foldr(type,type,fun1,ts,t1)))) ).

tff(fact_24_headT,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),aa(dB,dB,aa(dB,fun(dB,dB),app,var(n)),a)),foldr(type,type,fun1,ts,t1))) ).

tff(fact_25_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_26_app__Var__IT,axiom,
    ! [I1: nat,T2: dB] :
      ( pp(aa(dB,bool,it,T2))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T2),var(I1)))) ) ).

tff(fact_27_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_28_subst__App,axiom,
    ! [K: nat,S2: dB,U1: dB,T2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1)),S2),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T2),S2),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U1),S2),K)) ) ).

tff(fact_29_T,axiom,
    t = aa(type,type,aa(type,fun(type,type),fun1,t2),foldr(type,type,fun1,ts,t1)) ).

tff(fact_30_uT_H,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,e),u),aa(type,type,aa(type,fun(type,type),fun1,t2),foldr(type,type,fun1,ts,t1)))) ).

tff(fact_31__096_B_Bthesis_O_A_I_B_BT_H_H_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_058_AT_H_H_A_092_060Rightarrow_062_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_H_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [T5: type] :
        ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),var(n)),aa(type,type,aa(type,fun(type,type),fun1,T5),foldr(type,type,fun1,ts,t1))))
       => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),a),T5)) ) ).

tff(fact_32__096_B_Bthesis_O_A_I_B_BTs_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_058_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_124_124_N_Aas_A_058_ATs_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ts1: list(type)] :
        ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t)),aa(dB,dB,aa(dB,fun(dB,dB),app,var(n)),a)),foldr(type,type,fun1,Ts1,t1)))
       => ~ pp(aa(list(type),bool,typings(aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),i),t),as),Ts1)) ) ).

tff(fact_33_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Tsa: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Tsa,Ta1)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_34_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_35_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_36_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_37_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U1),K) = U1 ) ).

tff(fact_38_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_39_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T4: type] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),aa(type,type,aa(type,fun(type,type),fun1,T4),Ta1)))
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ub),T4)) ) ) ).

tff(fact_40_var__app__types,axiom,
    ! [Ua: type,Tsa: list(type),Ta1: type,Us1: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us1)),Ta1))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us2: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us2,Ta1) )
              & pp(aa(list(type),bool,typings(Eb,Us1),Us2)) ) ) ) ) ).

tff(fact_41_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),var(Ib)),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_42_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_43_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_44_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_45_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),foldr(type,type,fun1,Ts1,Ta1)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_46_typings_Osimps_I2_J,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,cons(dB,Ta,Ts)),Tsa))
    <=> pp(list_case(bool,type,fFalse,aa(fun(list(type),bool),fun(type,fun(list(type),bool)),aa(fun(type,fun(fun(list(type),bool),fun(list(type),bool))),fun(fun(list(type),bool),fun(type,fun(list(type),bool))),combc(type,fun(list(type),bool),fun(list(type),bool)),aa(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool))),aa(fun(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool))),fun(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool)))),combb(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun(type,bool),fun(type,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(type,bool),fun(type,fun(bool,bool))),combb(bool,fun(bool,bool),type),fconj),aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta)))),typings(Eb,Ts)),Tsa)) ) ).

tff(fact_47__096e_0600_058T_H_H_062_A_092_060turnstile_062_Alift_Au_A0_A_092_060degree_062_AVar_A0_A_058_ATs_A_061_062_062_AT_H_096,axiom,
    pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),e),zero_zero(nat)),t2)),aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat)))),foldr(type,type,fun1,ts,t1))) ).

tff(fact_48_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A2: fun(A,bool),X1: list(A)] :
      ( listsp(A,aa(fun(A,bool),fun(A,bool),aa(fun(A,fun(bool,bool)),fun(fun(A,bool),fun(A,bool)),combs(A,bool,bool),aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A2)),B1),X1)
    <=> ( listsp(A,A2,X1)
        & listsp(A,B1,X1) ) ) ).

tff(fact_49_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A1: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A1,List1) )
    <=> ( ( Aa = A1 )
        & ( List = List1 ) ) ) ).

tff(fact_50__096IT_A_Ilift_Au_A0_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat)))) ).

tff(fact_51__096IT_A_Ilift_Au_A0_A_092_060degree_062_AVar_A0_J_096,axiom,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat))))) ).

tff(fact_52_lift_Osimps_I2_J,axiom,
    ! [K: nat,T2: dB,S2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T2),K)) ) ).

tff(fact_53_lift__IT,axiom,
    ! [I1: nat,T2: dB] :
      ( pp(aa(dB,bool,it,T2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T2),I1))) ) ).

tff(fact_54_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),Ib),Ua)),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ib)),Ta1)) ) ).

tff(fact_55_subst__lift,axiom,
    ! [S2: dB,K: nat,T2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T2),K)),S2),K) = T2 ) ).

tff(fact_56_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_57_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_58_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_59_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X2: B,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,cons(B,X2,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,Aa),X2),Xs) ) ).

tff(fact_60_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs: list(B),X2: B,F: fun(B,fun(A,A))] : ( foldr(B,A,F,cons(B,X2,Xs),Aa) = aa(A,A,aa(B,fun(A,A),F,X2),foldr(B,A,F,Xs,Aa)) ) ).

tff(fact_61_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_62_Beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss1))) ) ) ).

tff(fact_63_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Env),zero_zero(nat)),Ta1)),Ta),Ua))
     => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Env),abs(Ta)),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua))) ) ).

tff(fact_64_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_65_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_66_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rsa: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rsa) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( R1 = S )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_67_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_68_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_69_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_70_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_71_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_72_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R1: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R1),Ss1) ) ).

tff(fact_73_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),abs(Ta)),Ta1))
     => ~ ! [T4: type,U2: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun(type,type),fun1,T4),U2) )
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),zero_zero(nat)),T4)),Ta),U2)) ) ) ).

tff(fact_76_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),abs(Ta)),Ta1))
     => ~ ! [U2: type,V1: type] : ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),Eb),zero_zero(nat)),U2)),Ta),V1)) ) ).

tff(fact_77_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs1: list(dB),N: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N),Rs1) )
            & listsp(dB,it,Rs1) )
        | ? [R4: dB] :
            ( ( Aa = abs(R4) )
            & pp(aa(dB,bool,it,R4)) )
        | ? [R4: dB,S3: dB,Ss2: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R4)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R4),S3),zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_78_beta,axiom,
    ! [T2: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T2)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T2),zero_zero(nat)))) ).

tff(fact_79_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_80_appR,axiom,
    ! [U1: dB,T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S2)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T2))) ) ).

tff(fact_81_appL,axiom,
    ! [U1: dB,T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1))) ) ).

tff(fact_82_beta__cases_I1_J,axiom,
    ! [T2: dB,I1: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I1)),T2)) ).

tff(fact_83_abs,axiom,
    ! [T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S2)),abs(T2))) ) ).

tff(fact_84_lift__preserves__beta,axiom,
    ! [I1: nat,S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),lift,R3),I1)),aa(nat,dB,aa(dB,fun(nat,dB),lift,S2),I1))) ) ).

tff(fact_85_subject__reduction,axiom,
    ! [T3: dB,Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),Ta),Ta1))
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ta),T3))
       => pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,Eb),T3),Ta1)) ) ) ).

tff(fact_86_subst__preserves__beta,axiom,
    ! [I1: nat,T2: dB,S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),T2),I1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T2),I1))) ) ).

tff(fact_87_beta__cases_I2_J,axiom,
    ! [S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S2))
     => ~ ! [T1: dB] :
            ( ( S2 = abs(T1) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T1)) ) ) ).

tff(fact_88_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_89_beta__cases_I3_J,axiom,
    ! [U1: dB,T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2)),U1))
     => ( ! [S1: dB] :
            ( ( U1 = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T2),zero_zero(nat)) )
           => ( S2 != abs(S1) ) )
       => ( ! [T1: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T2) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1)) )
         => ~ ! [T1: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T2),T1)) ) ) ) ) ).

tff(fact_90_apps__betasE,axiom,
    ! [S: dB,Rsa: list(dB),R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),S))
     => ( ! [R2: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),R2))
           => ( S != foldl(dB,dB,app,R2,Rsa) ) )
       => ( ! [Rs: list(dB)] :
              ( step1(dB,beta,Rsa,Rs)
             => ( S != foldl(dB,dB,app,R1,Rs) ) )
         => ~ ! [T1: dB] :
                ( ( R1 = abs(T1) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rsa = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),U),zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_91_apps__preserves__betas,axiom,
    ! [R1: dB,Ss1: list(dB),Rsa: list(dB)] :
      ( step1(dB,beta,Rsa,Ss1)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),foldl(dB,dB,app,R1,Ss1))) ) ).

tff(fact_92_head__Var__reduction,axiom,
    ! [V: dB,Rsa: list(dB),Na: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(Na),Rsa)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rsa,Ss)
          & ( V = foldl(dB,dB,app,var(Na),Ss) ) ) ) ).

tff(fact_93_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X2: A,Ys: list(A),Y1: A,R1: fun(A,fun(A,bool))] :
      ( step1(A,R1,cons(A,Y1,Ys),cons(A,X2,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R1,Y1),X2))
          & ( Xs = Ys ) )
        | ( ( X2 = Y1 )
          & step1(A,R1,Ys,Xs) ) ) ) ).

tff(fact_94_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X2: A,Ys: list(A),R1: fun(A,fun(A,bool))] :
      ( step1(A,R1,Ys,cons(A,X2,Xs))
     => ( ! [Y: A] :
            ( ( Ys = cons(A,Y,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),R1,Y),X2)) )
       => ~ ! [Zs: list(A)] :
              ( ( Ys = cons(A,X2,Zs) )
             => ~ step1(A,R1,Zs,Xs) ) ) ) ).

tff(fact_95_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_96_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X2: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X3: A,Y: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X3)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y)),X3) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X2) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X2),Xs) ) ) ).

tff(fact_97_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,aa(nat,fun(dB,dB),aa(fun(dB,fun(nat,dB)),fun(nat,fun(dB,dB)),combc(dB,nat,dB),lift),zero_zero(nat)),Ts)) ) ).

tff(fact_98_map__ident,axiom,
    ! [A: $tType,X1: list(A)] : ( map(A,A,combi(A),X1) = X1 ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),aa(fun(A,fun(B,C)),fun(B,fun(A,C)),combc(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(A,fun(B,C)),fun(fun(A,B),fun(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fimplies_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q)) ) ).

tff(help_fimplies_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fimplies,P),Q))
      | ~ pp(P)
      | pp(Q) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    ! [E: fun(nat,type),T: type,U: dB,I: nat] :
      ( ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,aa(type,fun(nat,type),aa(nat,fun(type,fun(nat,type)),aa(fun(nat,type),fun(nat,fun(type,fun(nat,type))),shift(type),E),I),t)),a),T))
      | ~ pp(aa(dB,bool,it,U))
      | ~ pp(aa(type,bool,aa(dB,fun(type,bool),aa(fun(nat,type),fun(dB,fun(type,bool)),typing,E),U),t))
      | pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,a),U),I))) ) ).

%------------------------------------------------------------------------------
