%------------------------------------------------------------------------------
% File     : LCL794_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 139
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_139 [Bla13]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v8.2.0, 0.67 v7.5.0, 0.33 v7.4.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  166 (  52 unt;  54 typ;   0 def)
%            Number of atoms       :  229 (  86 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  161 (  44   ~;   8   |;  15   &)
%                                         (  13 <=>;  81  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   42 (  21   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-4 aty)
%            Number of functors    :   46 (  46 usr;  25 con; 0-5 aty)
%            Number of variables   :  368 ( 331   !;   9   ?; 368   :)
%                                         (  28  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:20:01
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun1: ( $tType * $tType ) > $tType ).

%----Explicit typings (48)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun1(fun1(B,C),fun1(fun1(A,B),fun1(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun1(A,fun1(B,C)) * B ) > fun1(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun1(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun1(A,fun1(B,C)) * fun1(A,B) ) > fun1(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun1(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun1(dB,fun1(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun1(dB,fun1(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun1(dB,fun1(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun1(dB,fun1(dB,fun1(nat,dB))) ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun1(A,fun1(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun1(B,fun1(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,fun1(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T5: $tType,A: $tType] : ( ( T5 * fun1(A,fun1(list(A),T5)) * list(A) ) > T5 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun1(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun1(nat,A) * nat * A ) > fun1(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun: fun1(type,fun1(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T5: $tType] : ( ( fun1(nat,T5) * fun1(type,fun1(type,T5)) * type ) > T5 ) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun1(nat,type) * dB ) > fun1(type,bool) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun1(nat,type) * list(dB) ) > fun1(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun1(bool,fun1(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H_H____,type,
    t1: type ).

tff(sy_v_T_H____,type,
    t: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t2: type ).

tff(sy_v_Ts____,type,
    ts: list(type) ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun1(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun1(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t3: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t3)) ).

tff(fact_1_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_2_uT_H,axiom,
    pp(aa(type,bool,typing(e,u),aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)))) ).

tff(fact_3_uT,axiom,
    pp(aa(type,bool,typing(e,u),t2)) ).

tff(fact_4_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta: type,Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta1),Ta))
     => pp(aa(type,bool,typing(shift(type,Eb,Ib,Ua),aa(nat,dB,aa(dB,fun1(nat,dB),lift,Ta1),Ib)),Ta)) ) ).

tff(fact_5__096IT_A_Ilift_Au_A0_A_092_060degree_062_AVar_A0_J_096,axiom,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat))))) ).

tff(fact_6_App,axiom,
    ! [Ta1: dB,Ua: type,Ta: type,S: dB,Env: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Env,S),aa(type,type,aa(type,fun1(type,type),fun,Ta),Ua)))
     => ( pp(aa(type,bool,typing(Env,Ta1),Ta))
       => pp(aa(type,bool,typing(Env,aa(dB,dB,aa(dB,fun1(dB,dB),app,S),Ta1)),Ua)) ) ) ).

tff(fact_7_T,axiom,
    t2 = aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)) ).

tff(fact_8__096IT_A_Ilift_Au_A0_J_096,axiom,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),lift,u),zero_zero(nat)))) ).

tff(fact_9_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S2: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),lift,aa(dB,dB,aa(dB,fun1(dB,dB),app,S2),T1)),K) = aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),lift,S2),K)),aa(nat,dB,aa(dB,fun1(nat,dB),lift,T1),K)) ) ).

tff(fact_10_typing_OVar,axiom,
    ! [Ta: type,X: nat,Env: fun1(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta )
     => pp(aa(type,bool,typing(Env,var(X)),Ta)) ) ).

tff(fact_11_typing__elims_I1_J,axiom,
    ! [Ta: type,Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,var(Ib)),Ta))
     => ( aa(nat,type,Eb,Ib) = Ta ) ) ).

tff(fact_12_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun1(type,type),fun,Type1),Type2) = aa(type,type,aa(type,fun1(type,type),fun,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_13_varT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t2),var(n)),aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)))) ).

tff(fact_14_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_15_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun1(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_16_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_17_True,axiom,
    n = i ).

tff(fact_18_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),lift,T1),I))) ) ).

tff(fact_19_argT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t2),a),t1)) ).

tff(fact_20_headT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t2),aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a)),foldr(type,type,fun,ts,t))) ).

tff(fact_21_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_22_app__Var__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun1(dB,dB),app,T1),var(I)))) ) ).

tff(fact_23_shift__eq,axiom,
    ! [A: $tType,Ta: A,Eb: fun1(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta),J1) = Ta ) ) ).

tff(fact_24_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_25_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun1(dB,dB),app,DB11),DB21) ) ).

tff(fact_26__096_B_Bthesis_O_A_I_B_BT_H_H_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_058_AT_H_H_A_092_060Rightarrow_062_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_H_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [T4: type] :
        ( pp(aa(type,bool,typing(shift(type,e,i,t2),var(n)),aa(type,type,aa(type,fun1(type,type),fun,T4),foldr(type,type,fun,ts,t))))
       => ~ pp(aa(type,bool,typing(shift(type,e,i,t2),a),T4)) ) ).

tff(fact_27_argsT,axiom,
    pp(aa(list(type),bool,typings(shift(type,e,i,t2),as),ts)) ).

tff(fact_28_typing__elims_I2_J,axiom,
    ! [Ta: type,Ub: dB,Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,aa(dB,dB,aa(dB,fun1(dB,dB),app,Ta1),Ub)),Ta))
     => ~ ! [T3: type] :
            ( pp(aa(type,bool,typing(Eb,Ta1),aa(type,type,aa(type,fun1(type,type),fun,T3),Ta)))
           => ~ pp(aa(type,bool,typing(Eb,Ub),T3)) ) ) ).

tff(fact_29_nT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t2),foldl(dB,dB,app,var(n),rs)),t)) ).

tff(fact_30_MI2,axiom,
    ! [Ub: dB,Ta: type,Ib: nat,Eb: fun1(nat,type),Ta1: dB,T21: type,T11: type] :
      ( ( t2 = aa(type,type,aa(type,fun1(type,type),fun,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T21),Ta1),Ta))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T21))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta1),Ub),Ib))) ) ) ) ) ) ).

tff(fact_31_MI1,axiom,
    ! [Ub: dB,Ta: type,Ib: nat,Eb: fun1(nat,type),Ta1: dB,T21: type,T11: type] :
      ( ( t2 = aa(type,type,aa(type,fun1(type,type),fun,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T11),Ta1),Ta))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta1),Ub),Ib))) ) ) ) ) ) ).

tff(fact_32__096_B_Bthesis_O_A_I_B_BTs_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_058_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_124_124_N_Aas_A_058_ATs_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ts1: list(type)] :
        ( pp(aa(type,bool,typing(shift(type,e,i,t2),aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a)),foldr(type,type,fun,Ts1,t)))
       => ~ pp(aa(list(type),bool,typings(shift(type,e,i,t2),as),Ts1)) ) ).

tff(fact_33_subst__App,axiom,
    ! [K: nat,S2: dB,U1: dB,T1: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,aa(dB,dB,aa(dB,fun1(dB,dB),app,T1),U1)),S2),K) = aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,T1),S2),K)),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,U1),S2),K)) ) ).

tff(fact_34__096e_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t2),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a),as)),t)) ).

tff(fact_35_Cons,axiom,
    rs = cons(dB,a,as) ).

tff(fact_36_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,var(K)),U1),K) = U1 ) ).

tff(fact_37_subst__lift,axiom,
    ! [S2: dB,K: nat,T1: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,aa(nat,dB,aa(dB,fun1(nat,dB),lift,T1),K)),S2),K) = T1 ) ).

tff(fact_38_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta: type,Tsa: list(type),Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta1),foldr(type,type,fun,Tsa,Ta)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta1,Ts)),Ta)) ) ) ).

tff(fact_39_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R3),var(I)),J))) ) ).

tff(fact_40_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun1(nat,type),Ta: type,Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta1),Ta))
     => ( pp(aa(type,bool,typing(E,Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,typing(E,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta1),Ub),Ib)),Ta)) ) ) ) ).

tff(fact_41_var__app__type__eq,axiom,
    ! [Ua: type,Ta: type,Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta))
     => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta = Ua ) ) ) ).

tff(fact_42_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_43_var__app__typesE,axiom,
    ! [Ta: type,Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,var(Ib)),foldr(type,type,fun,Ts1,Ta)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_44_var__app__types,axiom,
    ! [Ua: type,Tsa: list(type),Ta: type,Us1: list(dB),Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us1)),Ta))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us2: list(type)] :
              ( ( Ua = foldr(type,type,fun,Us2,Ta) )
              & pp(aa(list(type),bool,typings(Eb,Us1),Us2)) ) ) ) ) ).

tff(fact_45_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_46_list__app__typeD,axiom,
    ! [Ta: type,Ts: list(dB),Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta1,Ts)),Ta))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,typing(Eb,Ta1),foldr(type,type,fun,Ts1,Ta)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_47_list__app__typeE,axiom,
    ! [Ta: type,Ts: list(dB),Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta1,Ts)),Ta))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,Ta1),foldr(type,type,fun,Ts1,Ta)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_48_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_49_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A2: A,List: list(A),Aa: A] :
      ( ( cons(A,Aa,List) = cons(A,A2,List1) )
    <=> ( ( Aa = A2 )
        & ( List = List1 ) ) ) ).

tff(fact_50_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_51_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs: list(B),X: B,F: fun1(B,fun1(A,A))] : ( foldr(B,A,F,cons(B,X,Xs),Aa) = aa(A,A,aa(B,fun1(A,A),F,X),foldr(B,A,F,Xs,Aa)) ) ).

tff(fact_52_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,Aa: A,F: fun1(A,fun1(B,A))] : ( foldl(A,B,F,Aa,cons(B,X,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun1(B,A),F,Aa),X),Xs) ) ).

tff(fact_53_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X3: A] : ( cons(A,X3,Xs1) != Xs1 ) ).

tff(fact_54_not__Cons__self,axiom,
    ! [A: $tType,X3: A,Xs1: list(A)] : ( Xs1 != cons(A,X3,Xs1) ) ).

tff(fact_55_Var_I2_J,axiom,
    pp(aa(type,bool,typing(shift(type,ea,ia,t2),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_56_Abs,axiom,
    ! [Ua: type,Ta1: dB,Ta: type,Env: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(shift(type,Env,zero_zero(nat),Ta),Ta1),Ua))
     => pp(aa(type,bool,typing(Env,abs(Ta1)),aa(type,type,aa(type,fun1(type,type),fun,Ta),Ua))) ) ).

tff(fact_57_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_58_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun1(type,fun1(type,A)),F1: fun1(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun1(type,type),fun,Type1),Type2)) = aa(type,A,aa(type,fun1(type,A),F2,Type1),Type2) ) ).

tff(fact_59_Var_I4_J,axiom,
    pp(aa(type,bool,typing(ea,ua),t2)) ).

tff(fact_60_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_61_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rsa: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rsa) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( R1 = S )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_62_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_63_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_64_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun1(dB,dB),app,DB1),DB2) ) ).

tff(fact_65_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_66_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R1: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R1),Ss1) ) ).

tff(fact_67_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta1: dB,S: dB] : ( aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(S)),Ta1) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_68_Beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R1),S),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(R1)),S),Ss1))) ) ) ).

tff(fact_69_typing__elims_I3_J,axiom,
    ! [Ta: type,Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta1)),Ta))
     => ~ ! [T3: type,U2: type] :
            ( ( Ta = aa(type,type,aa(type,fun1(type,type),fun,T3),U2) )
           => ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),T3),Ta1),U2)) ) ) ).

tff(fact_70_typings_Osimps_I2_J,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,cons(dB,Ta1,Ts)),Tsa))
    <=> pp(list_case(bool,type,fFalse,combc(type,fun1(list(type),bool),fun1(list(type),bool),aa(fun1(type,fun1(bool,bool)),fun1(type,fun1(fun1(list(type),bool),fun1(list(type),bool))),aa(fun1(fun1(bool,bool),fun1(fun1(list(type),bool),fun1(list(type),bool))),fun1(fun1(type,fun1(bool,bool)),fun1(type,fun1(fun1(list(type),bool),fun1(list(type),bool)))),combb(fun1(bool,bool),fun1(fun1(list(type),bool),fun1(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun1(type,bool),fun1(type,fun1(bool,bool)),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(type,bool),fun1(type,fun1(bool,bool))),combb(bool,fun1(bool,bool),type),fconj),typing(Eb,Ta1))),typings(Eb,Ts)),Tsa)) ) ).

tff(fact_71_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_72_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun1(B,fun1(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List)) = aa(list(B),A,aa(B,fun1(list(B),A),F2,Aa),List) ) ).

tff(fact_73_abs__typeE,axiom,
    ! [Ta: type,Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,abs(Ta1)),Ta))
     => ~ ! [U2: type,V1: type] : ~ pp(aa(type,bool,typing(shift(type,Eb,zero_zero(nat),U2),Ta1),V1)) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun1(A,B),F: fun1(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_76_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun1(A,bool),A1: fun1(A,bool),X1: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun1(A,bool),fun1(A,fun1(bool,bool)),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(A,bool),fun1(A,fun1(bool,bool))),combb(bool,fun1(bool,bool),A),fconj),A1),B1),X1)
    <=> ( listsp(A,A1,X1)
        & listsp(A,B1,X1) ) ) ).

tff(fact_77_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs1: list(dB),N: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N),Rs1) )
            & listsp(dB,it,Rs1) )
        | ? [R4: dB] :
            ( ( Aa = abs(R4) )
            & pp(aa(dB,bool,it,R4)) )
        | ? [R4: dB,S3: dB,Ss2: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(R4)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R4),S3),zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_78_beta,axiom,
    ! [T1: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(S2)),T1)),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,S2),T1),zero_zero(nat)))) ).

tff(fact_79_appR,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,aa(dB,dB,aa(dB,fun1(dB,dB),app,U1),S2)),aa(dB,dB,aa(dB,fun1(dB,dB),app,U1),T1))) ) ).

tff(fact_80_appL,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,aa(dB,dB,aa(dB,fun1(dB,dB),app,S2),U1)),aa(dB,dB,aa(dB,fun1(dB,dB),app,T1),U1))) ) ).

tff(fact_81_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,var(I)),T1)) ).

tff(fact_82_abs,axiom,
    ! [T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,abs(S2)),abs(T1))) ) ).

tff(fact_83_subject__reduction,axiom,
    ! [T2: dB,Ta: type,Ta1: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta1),Ta))
     => ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,Ta1),T2))
       => pp(aa(type,bool,typing(Eb,T2),Ta)) ) ) ).

tff(fact_84_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,R3),S2))
     => pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R3),T1),I)),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,S2),T1),I))) ) ).

tff(fact_85_lift__preserves__beta,axiom,
    ! [I: nat,S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,R3),S2))
     => pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,aa(nat,dB,aa(dB,fun1(nat,dB),lift,R3),I)),aa(nat,dB,aa(dB,fun1(nat,dB),lift,S2),I))) ) ).

tff(fact_86_beta__cases_I2_J,axiom,
    ! [S2: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,abs(R3)),S2))
     => ~ ! [T: dB] :
            ( ( S2 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,R3),T)) ) ) ).

tff(fact_87_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,foldl(dB,dB,app,R1,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_88_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,aa(dB,dB,aa(dB,fun1(dB,dB),app,S2),T1)),U1))
     => ( ! [S1: dB] :
            ( ( U1 = aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,S1),T1),zero_zero(nat)) )
           => ( S2 != abs(S1) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun1(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,S2),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun1(dB,dB),app,S2),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_89_apps__betasE,axiom,
    ! [S: dB,Rsa: list(dB),R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),S))
     => ( ! [R2: dB] :
            ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,R1),R2))
           => ( S != foldl(dB,dB,app,R2,Rsa) ) )
       => ( ! [Rs: list(dB)] :
              ( step1(dB,beta,Rsa,Rs)
             => ( S != foldl(dB,dB,app,R1,Rs) ) )
         => ~ ! [T: dB] :
                ( ( R1 = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rsa = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,T),U),zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_90_apps__preserves__betas,axiom,
    ! [R1: dB,Ss1: list(dB),Rsa: list(dB)] :
      ( step1(dB,beta,Rsa,Ss1)
     => pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,foldl(dB,dB,app,R1,Rsa)),foldl(dB,dB,app,R1,Ss1))) ) ).

tff(fact_91_head__Var__reduction,axiom,
    ! [V: dB,Rsa: list(dB),Na: nat] :
      ( pp(aa(dB,bool,aa(dB,fun1(dB,bool),beta,foldl(dB,dB,app,var(Na),Rsa)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rsa,Ss)
          & ( V = foldl(dB,dB,app,var(Na),Ss) ) ) ) ).

tff(fact_92_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Y1: A,R1: fun1(A,fun1(A,bool))] :
      ( step1(A,R1,cons(A,Y1,Ys),cons(A,X,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun1(A,bool),R1,Y1),X))
          & ( Xs = Ys ) )
        | ( ( X = Y1 )
          & step1(A,R1,Ys,Xs) ) ) ) ).

tff(fact_93_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),R1: fun1(A,fun1(A,bool))] :
      ( step1(A,R1,Ys,cons(A,X,Xs))
     => ( ! [Y: A] :
            ( ( Ys = cons(A,Y,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun1(A,bool),R1,Y),X)) )
       => ~ ! [Zs: list(A)] :
              ( ( Ys = cons(A,X,Zs) )
             => ~ step1(A,R1,Zs,Xs) ) ) ) ).

tff(fact_94_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S: B,F: fun1(B,fun1(A,B))] :
      ( ! [X2: A,Y: A,S1: B] : ( aa(A,B,aa(B,fun1(A,B),F,aa(A,B,aa(B,fun1(A,B),F,S1),X2)),Y) = aa(A,B,aa(B,fun1(A,B),F,aa(A,B,aa(B,fun1(A,B),F,S1),Y)),X2) )
     => ( aa(A,B,aa(B,fun1(A,B),F,foldl(B,A,F,S,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun1(A,B),F,S),X),Xs) ) ) ).

tff(fact_95_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_96_substs__lemma,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ib: nat,Ta: type,Ub: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ub),Ta))
     => ( pp(aa(list(type),bool,typings(shift(type,Eb,Ib,Ta),Ts),Tsa))
       => pp(aa(list(type),bool,typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun1(nat,dB),subst,Ub),Ib),Ts)),Tsa)) ) ) ).

tff(fact_97_map__ident,axiom,
    ! [A: $tType,X1: list(A)] : ( map(A,A,combi(A),X1) = X1 ) ).

tff(fact_98_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,F: fun1(B,A)] : ( map(B,A,F,cons(B,X,Xs)) = cons(A,aa(B,A,F,X),map(B,A,F,Xs)) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun1(A,B),P: fun1(B,C)] : ( aa(A,C,aa(fun1(A,B),fun1(A,C),aa(fun1(B,C),fun1(fun1(A,B),fun1(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun1(A,fun1(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun1(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun1(A,B),P: fun1(A,fun1(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun1(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(type,bool,typing(shift(type,e,zero_zero(nat),t1),aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),lift,u),zero_zero(nat))),var(zero_zero(nat)))),foldr(type,type,fun,ts,t))) ).

%------------------------------------------------------------------------------
