%------------------------------------------------------------------------------
% File     : LCL793_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 137
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_137 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  160 (  61 unt;  43 typ;   0 def)
%            Number of atoms       :  211 (  86 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  116 (  22   ~;   4   |;   4   &)
%                                         (  20 <=>;  66  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   38 (  20   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-3 aty)
%            Number of functors    :   23 (  23 usr;   5 con; 0-5 aty)
%            Number of variables   :  259 ( 237   !;   1   ?; 259   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:59
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (37)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: ( dB * dB ) > dB ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,fun(T1,fun(T1,T1)))) * fun(dB,fun(T1,T1)) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t____,type,
    t: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    it(t) ).

tff(fact_1_Var_I3_J,axiom,
    it(ua) ).

tff(fact_2_uIT,axiom,
    it(u) ).

tff(fact_3__096IT_A_Ilift_Au_A0_J_096,axiom,
    it(lift(u,zero_zero(nat))) ).

tff(fact_4_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( it(T)
     => it(lift(T,I)) ) ).

tff(fact_5_Var__IT,axiom,
    ! [N: nat] : it(var(N)) ).

tff(fact_6_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( it(T)
     => it(app(T,var(I))) ) ).

tff(fact_7_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( lift(app(S,T),K) = app(lift(S,K),lift(T,K)) ) ).

tff(fact_8_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat2) )
    <=> ( Nat = Nat2 ) ) ).

tff(fact_9_dB_Osimps_I2_J,axiom,
    ! [DB22: dB,DB12: dB,DB2: dB,DB1: dB] :
      ( ( app(DB1,DB2) = app(DB12,DB22) )
    <=> ( ( DB1 = DB12 )
        & ( DB2 = DB22 ) ) ) ).

tff(fact_10_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat1: nat] : ( var(Nat1) != app(DB11,DB21) ) ).

tff(fact_11_dB_Osimps_I5_J,axiom,
    ! [Nat1: nat,DB21: dB,DB11: dB] : ( app(DB11,DB21) != var(Nat1) ) ).

tff(fact_12_dB_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( dB_size(var(Nat1)) = zero_zero(nat) ) ).

tff(fact_13_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_14_dB_Osize_I4_J,axiom,
    ! [Nat1: nat] : ( size_size(dB,var(Nat1)) = zero_zero(nat) ) ).

tff(fact_15_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R: dB] :
      ( it(R)
     => it(subst(R,var(I),J)) ) ).

tff(fact_16_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_17_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_18_subst__App,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( subst(app(T,U),S,K) = app(subst(T,S,K),subst(U,S,K)) ) ).

tff(fact_19_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_20_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( subst(lift(T,K),S,K) = T ) ).

tff(fact_21_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_22_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_23_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_24_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_25_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = subst(T,S,zero_zero(nat)) ) ).

tff(fact_26_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_27_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,app(DB1,DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_28_substn_Osimps_I2_J,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( substn(app(T,U),S,K) = app(substn(T,S,K),substn(U,S,K)) ) ).

tff(fact_29_nat__size,axiom,
    ! [N: nat] : ( size_size(nat,N) = N ) ).

tff(fact_30_size__bool,axiom,
    ! [B1: bool] : ( size_size(bool,B1) = zero_zero(nat) ) ).

tff(fact_31_substn__subst__n,axiom,
    ! [N: nat,S: dB,T: dB] : ( substn(T,S,N) = subst(T,liftn(N,S,zero_zero(nat)),N) ) ).

tff(fact_32_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB,N: nat] : ( liftn(N,app(S,T),K) = app(liftn(N,S,K),liftn(N,T,K)) ) ).

tff(fact_33_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_34_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,app(DB1,DB2)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB1),DB2),dB_rec(A,F1,F2,F3,DB1)),dB_rec(A,F1,F2,F3,DB2)) ) ).

tff(fact_35_subst__lt,axiom,
    ! [U: dB,I: nat,J: nat] :
      ( ord_less(nat,J,I)
     => ( subst(var(J),U,I) = var(J) ) ) ).

tff(fact_36_char__size,axiom,
    ! [C: char] : ( char_size(C) = zero_zero(nat) ) ).

tff(fact_37_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_38_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_39_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_40_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_41_size__char,axiom,
    ! [C: char] : ( size_size(char,C) = zero_zero(nat) ) ).

tff(fact_42_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_43_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),Na: nat,M1: nat] :
      ( ( ord_less(nat,M1,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
     => ( ( ( M1 = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
       => ( ( ord_less(nat,Na,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,Na),M1)) ) ) ) ).

tff(fact_44_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_45_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_46_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_47_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_48_nat__neq__iff,axiom,
    ! [Na: nat,M1: nat] :
      ( ( M1 != Na )
    <=> ( ord_less(nat,M1,Na)
        | ord_less(nat,Na,M1) ) ) ).

tff(fact_49_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_50_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_51_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_52_size__literal__def,axiom,
    ! [S: literal] : ( size_size(literal,S) = zero_zero(nat) ) ).

tff(fact_53_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_54_liftn_Osimps_I1_J,axiom,
    ! [N: nat,K: nat,I: nat] :
      ( ( ord_less(nat,I,K)
       => ( liftn(N,var(I),K) = var(I) ) )
      & ( ~ ord_less(nat,I,K)
       => ( liftn(N,var(I),K) = var(plus_plus(nat,I,N)) ) ) ) ).

tff(fact_55_infinite__descent0,axiom,
    ! [Na: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N1: nat] :
            ( ord_less(nat,zero_zero(nat),N1)
           => ( ~ pp(aa(nat,bool,P1,N1))
             => ? [M2: nat] :
                  ( ord_less(nat,M2,N1)
                  & ~ pp(aa(nat,bool,P1,M2)) ) ) )
       => pp(aa(nat,bool,P1,Na)) ) ) ).

tff(fact_56_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,Aa: A,B1: A] :
          ( ( plus_plus(A,B1,Aa) = plus_plus(A,C1,Aa) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_57_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,Aa: A] :
          ( ( plus_plus(A,Aa,B1) = plus_plus(A,Aa,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_58_nat__add__right__cancel,axiom,
    ! [Na: nat,K1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K1) = plus_plus(nat,Na,K1) )
    <=> ( M1 = Na ) ) ).

tff(fact_59_nat__add__left__cancel,axiom,
    ! [Na: nat,M1: nat,K1: nat] :
      ( ( plus_plus(nat,K1,M1) = plus_plus(nat,K1,Na) )
    <=> ( M1 = Na ) ) ).

tff(fact_60_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [Na: nat,M1: nat] :
          ( ( semiring_1_of_nat(A,M1) = semiring_1_of_nat(A,Na) )
        <=> ( M1 = Na ) ) ) ).

tff(fact_61_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ( zero_zero(A) = plus_plus(A,Aa,Aa) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_62_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,Aa: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,Aa),plus_plus(A,C1,B1))
        <=> ord_less(A,Aa,B1) ) ) ).

tff(fact_63_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,Aa: A] :
          ( ord_less(A,plus_plus(A,Aa,C1),plus_plus(A,B1,C1))
        <=> ord_less(A,Aa,B1) ) ) ).

tff(fact_64_add__is__0,axiom,
    ! [Na: nat,M1: nat] :
      ( ( plus_plus(nat,M1,Na) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( Na = zero_zero(nat) ) ) ) ).

tff(fact_65_nat__add__left__cancel__less,axiom,
    ! [Na: nat,M1: nat,K1: nat] :
      ( ord_less(nat,plus_plus(nat,K1,M1),plus_plus(nat,K1,Na))
    <=> ord_less(nat,M1,Na) ) ).

tff(fact_66_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ord_less(A,plus_plus(A,Aa,Aa),zero_zero(A))
        <=> ord_less(A,Aa,zero_zero(A)) ) ) ).

tff(fact_67_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [Aa: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,Aa,Aa))
        <=> ord_less(A,zero_zero(A),Aa) ) ) ).

tff(fact_68_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_69_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,M1,Na) ) ) ).

tff(fact_70_add__gr__0,axiom,
    ! [Na: nat,M1: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,M1,Na))
    <=> ( ord_less(nat,zero_zero(nat),M1)
        | ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_71_of__nat__add,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N: nat,M: nat] : ( semiring_1_of_nat(A,plus_plus(nat,M,N)) = plus_plus(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N)) ) ) ).

tff(fact_72_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ ord_less(nat,plus_plus(nat,I,J),I) ).

tff(fact_73_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ ord_less(nat,plus_plus(nat,J,I),I) ).

tff(fact_74_trans__less__add1,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,J,M)) ) ).

tff(fact_75_trans__less__add2,axiom,
    ! [M: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,M,J)) ) ).

tff(fact_76_add__less__mono1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,plus_plus(nat,I,K),plus_plus(nat,J,K)) ) ).

tff(fact_77_add__less__mono,axiom,
    ! [L: nat,K: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,K,L)
       => ord_less(nat,plus_plus(nat,I,K),plus_plus(nat,J,L)) ) ) ).

tff(fact_78_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K: nat] :
      ( ord_less(nat,K,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K,N) )
       => ord_less(nat,M,N) ) ) ).

tff(fact_79_add__lessD1,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less(nat,plus_plus(nat,I,J),K)
     => ord_less(nat,I,K) ) ).

tff(fact_80_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_81_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( plus_plus(nat,M,zero_zero(nat)) = M ) ).

tff(fact_82_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( plus_plus(nat,zero_zero(nat),N) = N ) ).

tff(fact_83_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K) = plus_plus(nat,M,plus_plus(nat,N,K)) ) ).

tff(fact_84_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_85_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_86_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_87_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_88_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_89_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_90_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_91_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_92_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_93_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_94_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C)) ) ) ).

tff(fact_95_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B)) ) ) ).

tff(fact_96_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C,D)
           => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ) ).

tff(fact_97_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
         => ord_less(A,A1,B) ) ) ).

tff(fact_98_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
         => ord_less(A,A1,B) ) ) ).

%----Arities (11)
tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (6)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    it(app(lift(u,zero_zero(nat)),var(zero_zero(nat)))) ).

%------------------------------------------------------------------------------
