%------------------------------------------------------------------------------
% File     : LCL792_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 136
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_136 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  182 (  63 unt;  46 typ;   0 def)
%            Number of atoms       :  287 (  85 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  163 (  12   ~;   5   |;  13   &)
%                                         (  32 <=>; 101  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   4 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    8 (   7 usr)
%            Number of type conns  :   35 (  21   >;  14   *;   0   +;   0  <<)
%            Number of predicates  :   16 (  15 usr;   0 prp; 1-3 aty)
%            Number of functors    :   24 (  24 usr;   5 con; 0-4 aty)
%            Number of variables   :  260 ( 230   !;   5   ?; 260   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:58
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char1: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_String_Onibble,type,
    nibble: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Int_Onat,type,
    nat1: int > nat ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Nat_Onat_Onat__case,type,
    nat_case: 
      !>[T1: $tType] : ( ( T1 * fun(nat,T1) * nat ) > T1 ) ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Nat__Transfer_Otsub,type,
    nat_tsub: ( int * int ) > int ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_String_Ochar_OChar,type,
    char: ( nibble * nibble ) > char1 ).

tff(sy_c_String_Ochar_Ochar__case,type,
    char_case: 
      !>[T1: $tType] : ( ( fun(nibble,fun(nibble,T1)) * char1 ) > T1 ) ).

tff(sy_c_String_Ochar_Ochar__rec,type,
    char_rec: 
      !>[T1: $tType] : ( ( fun(nibble,fun(nibble,T1)) * char1 ) > T1 ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char1 > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_t____,type,
    t: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    it(t) ).

tff(fact_1_Var_I3_J,axiom,
    it(ua) ).

tff(fact_2_uIT,axiom,
    it(u) ).

tff(fact_3_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( it(T)
     => it(lift(T,I)) ) ).

tff(fact_4_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_5_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_6_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_7_char__size,axiom,
    ! [C1: char1] : ( char_size(C1) = zero_zero(nat) ) ).

tff(fact_8_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_9_size__char,axiom,
    ! [C1: char1] : ( size_size(char1,C1) = zero_zero(nat) ) ).

tff(fact_10_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_11_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_12_size__literal__def,axiom,
    ! [S: literal] : ( size_size(literal,S) = zero_zero(nat) ) ).

tff(fact_13_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_14_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_15_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [Na: nat,M: nat] :
          ( ( semiring_1_of_nat(A,M) = semiring_1_of_nat(A,Na) )
        <=> ( M = Na ) ) ) ).

tff(fact_16_nat__size,axiom,
    ! [N: nat] : ( size_size(nat,N) = N ) ).

tff(fact_17_size__bool,axiom,
    ! [B1: bool] : ( size_size(bool,B1) = zero_zero(nat) ) ).

tff(fact_18_char_Osize_I2_J,axiom,
    ! [Nibble23: nibble,Nibble13: nibble] : ( size_size(char1,char(Nibble13,Nibble23)) = zero_zero(nat) ) ).

tff(fact_19_char_Osize_I1_J,axiom,
    ! [Nibble23: nibble,Nibble13: nibble] : ( char_size(char(Nibble13,Nibble23)) = zero_zero(nat) ) ).

tff(fact_20_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_21_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_22_int__eq__0__conv,axiom,
    ! [Na: nat] :
      ( ( semiring_1_of_nat(int,Na) = zero_zero(int) )
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_23_of__nat__aux_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Ib: A,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,zero_zero(nat),Ib) = Ib ) ) ).

tff(fact_24_nat__case__0,axiom,
    ! [A: $tType,F2: fun(nat,A),F1: A] : ( nat_case(A,F1,F2,zero_zero(nat)) = F1 ) ).

tff(fact_25_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_26_char_Oinject,axiom,
    ! [Nibble22: nibble,Nibble12: nibble,Nibble2: nibble,Nibble1: nibble] :
      ( ( char(Nibble1,Nibble2) = char(Nibble12,Nibble22) )
    <=> ( ( Nibble1 = Nibble12 )
        & ( Nibble2 = Nibble22 ) ) ) ).

tff(fact_27_int__int__eq,axiom,
    ! [Na: nat,M: nat] :
      ( ( semiring_1_of_nat(int,M) = semiring_1_of_nat(int,Na) )
    <=> ( M = Na ) ) ).

tff(fact_28_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_29_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) ) ) ).

tff(fact_30_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] : ( sgn_sgn(A,sgn_sgn(A,A1)) = sgn_sgn(A,A1) ) ) ).

tff(fact_31_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Aa: A] :
          ( ( sgn_sgn(A,Aa) = zero_zero(A) )
        <=> ( Aa = zero_zero(A) ) ) ) ).

tff(fact_32_char_Oexhaust,axiom,
    ! [Y: char1] :
      ~ ! [Nibble11: nibble,Nibble21: nibble] : ( Y != char(Nibble11,Nibble21) ) ).

tff(fact_33_char_Orecs,axiom,
    ! [A: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,A))] : ( char_rec(A,F1,char(Nibble1,Nibble2)) = aa(nibble,A,aa(nibble,fun(nibble,A),F1,Nibble1),Nibble2) ) ).

tff(fact_34_char_Osimps_I2_J,axiom,
    ! [A: $tType,Nibble2: nibble,Nibble1: nibble,F1: fun(nibble,fun(nibble,A))] : ( char_case(A,F1,char(Nibble1,Nibble2)) = aa(nibble,A,aa(nibble,fun(nibble,A),F1,Nibble1),Nibble2) ) ).

tff(fact_35_int__le__0__conv,axiom,
    ! [Na: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,Na),zero_zero(int))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_36_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M: nat] :
          ( ord_less_eq(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,Na))
        <=> ord_less_eq(nat,M,Na) ) ) ).

tff(fact_37_Nat__Transfer_Otransfer__nat__int__function__closures_I5_J,axiom,
    ord_less_eq(int,zero_zero(int),zero_zero(int)) ).

tff(fact_38_zero__le__imp__of__nat,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M1: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,M1)) ) ).

tff(fact_39_of__nat__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat] : ord_less_eq(A,zero_zero(A),semiring_1_of_nat(A,N)) ) ).

tff(fact_40_transfer__int__nat__quantifiers_I1_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ! [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
         => pp(aa(int,bool,P1,X2)) )
    <=> ! [X2: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X2))) ) ).

tff(fact_41_transfer__int__nat__quantifiers_I2_J,axiom,
    ! [P1: fun(int,bool)] :
      ( ? [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
          & pp(aa(int,bool,P1,X2)) )
    <=> ? [X2: nat] : pp(aa(int,bool,P1,semiring_1_of_nat(int,X2))) ) ).

tff(fact_42_Nat__Transfer_Otransfer__nat__int__function__closures_I9_J,axiom,
    ! [Z2: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,Z2)) ).

tff(fact_43_zero__zle__int,axiom,
    ! [N: nat] : ord_less_eq(int,zero_zero(int),semiring_1_of_nat(int,N)) ).

tff(fact_44_nonneg__eq__int,axiom,
    ! [Z2: int] :
      ( ord_less_eq(int,zero_zero(int),Z2)
     => ~ ! [M2: nat] : ( Z2 != semiring_1_of_nat(int,M2) ) ) ).

tff(fact_45_zero__le__imp__eq__int,axiom,
    ! [K: int] :
      ( ord_less_eq(int,zero_zero(int),K)
     => ? [N1: nat] : ( K = semiring_1_of_nat(int,N1) ) ) ).

tff(fact_46_order__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ord_less_eq(A,X,X) ) ).

tff(fact_47_conj__le__cong,axiom,
    ! [P2: bool,P1: bool,X1: int] :
      ( ( ord_less_eq(int,zero_zero(int),X1)
       => ( pp(P1)
        <=> pp(P2) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X1)
          & pp(P1) )
      <=> ( ord_less_eq(int,zero_zero(int),X1)
          & pp(P2) ) ) ) ).

tff(fact_48_imp__le__cong,axiom,
    ! [P2: bool,P1: bool,X1: int] :
      ( ( ord_less_eq(int,zero_zero(int),X1)
       => ( pp(P1)
        <=> pp(P2) ) )
     => ( ( ord_less_eq(int,zero_zero(int),X1)
         => pp(P1) )
      <=> ( ord_less_eq(int,zero_zero(int),X1)
         => pp(P2) ) ) ) ).

tff(fact_49_le0,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_50_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ord_less_eq(nat,zero_zero(nat),N) ).

tff(fact_51_le__0__eq,axiom,
    ! [Na: nat] :
      ( ord_less_eq(nat,Na,zero_zero(nat))
    <=> ( Na = zero_zero(nat) ) ) ).

tff(fact_52_le__antisym,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N)
     => ( ord_less_eq(nat,N,M1)
       => ( M1 = N ) ) ) ).

tff(fact_53_le__trans,axiom,
    ! [K: nat,J: nat,I: nat] :
      ( ord_less_eq(nat,I,J)
     => ( ord_less_eq(nat,J,K)
       => ord_less_eq(nat,I,K) ) ) ).

tff(fact_54_eq__imp__le,axiom,
    ! [N: nat,M1: nat] :
      ( ( M1 = N )
     => ord_less_eq(nat,M1,N) ) ).

tff(fact_55_nat__le__linear,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less_eq(nat,M1,N)
      | ord_less_eq(nat,N,M1) ) ).

tff(fact_56_le__refl,axiom,
    ! [N: nat] : ord_less_eq(nat,N,N) ).

tff(fact_57_transfer__int__nat__relations_I3_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less_eq(nat,X1,Y1) ) ).

tff(fact_58_zle__int,axiom,
    ! [Na: nat,M: nat] :
      ( ord_less_eq(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,Na))
    <=> ord_less_eq(nat,M,Na) ) ).

tff(fact_59_linorder__le__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less_eq(A,X,Y)
         => ord_less_eq(A,Y,X) ) ) ).

tff(fact_60_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_61_order__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,Z2)
           => ord_less_eq(A,X,Z2) ) ) ) ).

tff(fact_62_order__antisym,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
         => ( ord_less_eq(A,Y,X)
           => ( X = Y ) ) ) ) ).

tff(fact_63_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ord_less_eq(A,A1,B2)
         => ( ( B2 = C1 )
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_64_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( A1 = B2 )
         => ( ord_less_eq(A,B2,C1)
           => ord_less_eq(A,A1,C1) ) ) ) ).

tff(fact_65_order__antisym__conv,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [X1: A,Y1: A] :
          ( ord_less_eq(A,Y1,X1)
         => ( ord_less_eq(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_66_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [X1: A,G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
         => ord_less_eq(B,aa(A,B,F,X1),aa(A,B,G,X1)) ) ) ).

tff(fact_67_order__eq__refl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ( X = Y )
         => ord_less_eq(A,X,Y) ) ) ).

tff(fact_68_order__eq__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 = Y1 )
        <=> ( ord_less_eq(A,X1,Y1)
            & ord_less_eq(A,Y1,X1) ) ) ) ).

tff(fact_69_linorder__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less_eq(A,X,Y)
          | ord_less_eq(A,Y,X) ) ) ).

tff(fact_70_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ord_less_eq(fun(A,B),F,G)
        <=> ! [X2: A] : ord_less_eq(B,aa(A,B,F,X2),aa(A,B,G,X2)) ) ) ).

tff(fact_71_of__int__le__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less_eq(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less_eq(int,Z,zero_zero(int)) ) ) ).

tff(fact_72_of__int__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less_eq(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less_eq(int,zero_zero(int),Z) ) ) ).

tff(fact_73_nonneg__int__cases,axiom,
    ! [K: int] :
      ( ord_less_eq(int,zero_zero(int),K)
     => ~ ! [N1: nat] : ( K != semiring_1_of_nat(int,N1) ) ) ).

tff(fact_74_Nat__Transfer_Otransfer__nat__int__function__closures_I3_J,axiom,
    ! [Y: int,X: int] :
      ( ord_less_eq(int,zero_zero(int),X)
     => ( ord_less_eq(int,zero_zero(int),Y)
       => ord_less_eq(int,zero_zero(int),nat_tsub(X,Y)) ) ) ).

tff(fact_75_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z) )
        <=> ( W = Z ) ) ) ).

tff(fact_76_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( ring_1_of_int(A,Z) = zero_zero(A) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_77_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_78_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_79_of__int__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int,W: int] :
          ( ord_less_eq(A,ring_1_of_int(A,W),ring_1_of_int(A,Z))
        <=> ord_less_eq(int,W,Z) ) ) ).

tff(fact_80_of__int__of__nat__eq,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [N: nat] : ( ring_1_of_int(A,semiring_1_of_nat(int,N)) = semiring_1_of_nat(A,N) ) ) ).

tff(fact_81_of__int__int__eq,axiom,
    ! [N: nat] : ( ring_1_of_int(int,semiring_1_of_nat(int,N)) = semiring_1_of_nat(int,N) ) ).

tff(fact_82_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ord(B)
     => ! [G: fun(A,B),F: fun(A,B)] :
          ( ! [X3: A] : ord_less_eq(B,aa(A,B,F,X3),aa(A,B,G,X3))
         => ord_less_eq(fun(A,B),F,G) ) ) ).

tff(fact_83_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,F: fun(A,B),B1: A,Aa: A] :
          ( ord_less_eq(A,Aa,B1)
         => ( ( aa(A,B,F,B1) = C )
           => ( ! [X3: A,Y2: A] :
                  ( ord_less_eq(A,X3,Y2)
                 => ord_less_eq(B,aa(A,B,F,X3),aa(A,B,F,Y2)) )
             => ord_less_eq(B,aa(A,B,F,Aa),C) ) ) ) ) ).

tff(fact_84_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),Aa: A] :
          ( ord_less_eq(A,Aa,aa(B,A,F,B1))
         => ( ord_less_eq(B,B1,C)
           => ( ! [X3: B,Y2: B] :
                  ( ord_less_eq(B,X3,Y2)
                 => ord_less_eq(A,aa(B,A,F,X3),aa(B,A,F,Y2)) )
             => ord_less_eq(A,Aa,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_85_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,B1: B,F: fun(B,A),Aa: A] :
          ( ( Aa = aa(B,A,F,B1) )
         => ( ord_less_eq(B,B1,C)
           => ( ! [X3: B,Y2: B] :
                  ( ord_less_eq(B,X3,Y2)
                 => ord_less_eq(A,aa(B,A,F,X3),aa(B,A,F,Y2)) )
             => ord_less_eq(A,Aa,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_86_order__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,Aa: A] :
          ( ord_less_eq(A,Aa,B1)
         => ( ord_less_eq(B,aa(A,B,F,B1),C)
           => ( ! [X3: A,Y2: A] :
                  ( ord_less_eq(A,X3,Y2)
                 => ord_less_eq(B,aa(A,B,F,X3),aa(A,B,F,Y2)) )
             => ord_less_eq(B,aa(A,B,F,Aa),C) ) ) ) ) ).

tff(fact_87_of__nat__nat,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Z2: int] :
          ( ord_less_eq(int,zero_zero(int),Z2)
         => ( semiring_1_of_nat(A,nat1(Z2)) = ring_1_of_int(A,Z2) ) ) ) ).

tff(fact_88_nat__0,axiom,
    nat1(zero_zero(int)) = zero_zero(nat) ).

tff(fact_89_nat__0__iff,axiom,
    ! [Ib: int] :
      ( ( nat1(Ib) = zero_zero(nat) )
    <=> ord_less_eq(int,Ib,zero_zero(int)) ) ).

tff(fact_90_int__nat__eq,axiom,
    ! [Z2: int] :
      ( ( ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = Z2 ) )
      & ( ~ ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = zero_zero(int) ) ) ) ).

tff(fact_91_transfer__nat__int__numerals_I1_J,axiom,
    zero_zero(nat) = nat1(zero_zero(int)) ).

tff(fact_92_ex__nat,axiom,
    ! [P1: fun(nat,bool)] :
      ( ? [X11: nat] : pp(aa(nat,bool,P1,X11))
    <=> ? [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
          & pp(aa(nat,bool,P1,nat1(X2))) ) ) ).

tff(fact_93_all__nat,axiom,
    ! [P1: fun(nat,bool)] :
      ( ! [X11: nat] : pp(aa(nat,bool,P1,X11))
    <=> ! [X2: int] :
          ( ord_less_eq(int,zero_zero(int),X2)
         => pp(aa(nat,bool,P1,nat1(X2))) ) ) ).

tff(fact_94_transfer__nat__int__relations_I1_J,axiom,
    ! [Y1: int,X1: int] :
      ( ord_less_eq(int,zero_zero(int),X1)
     => ( ord_less_eq(int,zero_zero(int),Y1)
       => ( ( nat1(X1) = nat1(Y1) )
        <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_95_eq__nat__nat__iff,axiom,
    ! [Z1: int,Z: int] :
      ( ord_less_eq(int,zero_zero(int),Z)
     => ( ord_less_eq(int,zero_zero(int),Z1)
       => ( ( nat1(Z) = nat1(Z1) )
        <=> ( Z = Z1 ) ) ) ) ).

tff(fact_96_nat__mono,axiom,
    ! [Y: int,X: int] :
      ( ord_less_eq(int,X,Y)
     => ord_less_eq(nat,nat1(X),nat1(Y)) ) ).

tff(fact_97_nat__if__cong,axiom,
    ! [Y1: int,X1: int,P1: bool] :
      ( ( pp(P1)
       => ( nat1(X1) = nat1(if(int,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( nat1(Y1) = nat1(if(int,P1,X1,Y1)) ) ) ) ).

tff(fact_98_nat__int,axiom,
    ! [N: nat] : ( nat1(semiring_1_of_nat(int,N)) = N ) ).

%----Arities (27)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (9)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    it(lift(u,zero_zero(nat))) ).

%------------------------------------------------------------------------------
