%------------------------------------------------------------------------------
% File     : LCL789_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 130
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_130 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  170 (  61 unt;  57 typ;   0 def)
%            Number of atoms       :  201 ( 101 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  120 (  32   ~;   7   |;  14   &)
%                                         (  18 <=>;  49  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   10 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   44 (  23   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :    4 (   3 usr;   0 prp; 1-3 aty)
%            Number of functors    :   50 (  50 usr;  24 con; 0-5 aty)
%            Number of variables   :  387 ( 346   !;  10   ?; 387   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:47
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun1: ( $tType * $tType ) > $tType ).

%----Explicit typings (51)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun1(fun1(B,C),fun1(fun1(A,B),fun1(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun1(A,fun1(B,C)) * B ) > fun1(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun1(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun1(A,fun1(B,C)) * fun1(A,B) ) > fun1(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun1(dB,bool) ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun1(dB,fun1(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun1(dB,fun1(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun1(dB,fun1(dB,fun1(nat,dB))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun1(B,fun1(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,fun1(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T5: $tType,A: $tType] : ( ( T5 * fun1(A,fun1(list(A),T5)) * list(A) ) > T5 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun1(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun1(nat,A) * nat * A ) > fun1(nat,A) ) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun: fun1(type,fun1(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T5: $tType] : ( ( fun1(nat,T5) * fun1(type,fun1(type,T5)) * type ) > T5 ) ).

tff(sy_c_Type_Otype_Otype__rec,type,
    type_rec: 
      !>[T5: $tType] : ( ( fun1(nat,T5) * fun1(type,fun1(type,fun1(T5,fun1(T5,T5)))) * type ) > T5 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: fun1(nat,type) > fun1(dB,fun1(type,bool)) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun1(nat,type) * list(dB) ) > fun1(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun1(fun1(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun1(bool,fun1(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H_H____,type,
    t1: type ).

tff(sy_v_T_H____,type,
    t: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t2: type ).

tff(sy_v_Ts____,type,
    ts: list(type) ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun1(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun1(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t3: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t3)) ).

tff(fact_1_uT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(e),u),t2)) ).

tff(fact_2_T,axiom,
    t2 = aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)) ).

tff(fact_3_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_4_type_Osimps_I2_J,axiom,
    ! [Type23: type,Type13: type,Type22: type,Type12: type] :
      ( ( aa(type,type,aa(type,fun1(type,type),fun,Type12),Type22) = aa(type,type,aa(type,fun1(type,type),fun,Type13),Type23) )
    <=> ( ( Type12 = Type13 )
        & ( Type22 = Type23 ) ) ) ).

tff(fact_5_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_6_varT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),var(n)),aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)))) ).

tff(fact_7_argT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),a),t1)) ).

tff(fact_8__096_B_Bthesis_O_A_I_B_BT_H_H_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_058_AT_H_H_A_092_060Rightarrow_062_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_H_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [T4: type] :
        ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),var(n)),aa(type,type,aa(type,fun1(type,type),fun,T4),foldr(type,type,fun,ts,t))))
       => ~ pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),a),T4)) ) ).

tff(fact_9_headT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a)),foldr(type,type,fun,ts,t))) ).

tff(fact_10_argsT,axiom,
    pp(aa(list(type),bool,typings(shift(type,e,i,t2),as),ts)) ).

tff(fact_11_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun1(type,fun1(type,A)),F1: fun1(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun1(type,type),fun,Type12),Type22)) = aa(type,A,aa(type,fun1(type,A),F2,Type12),Type22) ) ).

tff(fact_12_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S: dB,Env: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),S),aa(type,type,aa(type,fun1(type,type),fun,Ta1),Ua)))
     => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),Ta),Ta1))
       => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),aa(dB,dB,aa(dB,fun1(dB,dB),app,S),Ta)),Ua)) ) ) ).

tff(fact_13_type_Orecs_I2_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun1(type,fun1(type,fun1(A,fun1(A,A)))),F1: fun1(nat,A)] : ( type_rec(A,F1,F2,aa(type,type,aa(type,fun1(type,type),fun,Type12),Type22)) = aa(A,A,aa(A,fun1(A,A),aa(type,fun1(A,fun1(A,A)),aa(type,fun1(type,fun1(A,fun1(A,A))),F2,Type12),Type22),type_rec(A,F1,F2,Type12)),type_rec(A,F1,F2,Type22)) ) ).

tff(fact_14_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),aa(dB,dB,aa(dB,fun1(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T3: type] :
            ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),aa(type,type,aa(type,fun1(type,type),fun,T3),Ta1)))
           => ~ pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),T3)) ) ) ).

tff(fact_15_type_Osimps_I3_J,axiom,
    ! [Type21: type,Type11: type,Nat: nat] : ( atom(Nat) != aa(type,type,aa(type,fun1(type,type),fun,Type11),Type21) ) ).

tff(fact_16_True,axiom,
    n = i ).

tff(fact_17_type_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( atom(Nat2) = atom(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_18_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_19_typing_OVar,axiom,
    ! [Ta1: type,X1: nat,Env: fun1(nat,type)] :
      ( ( aa(nat,type,Env,X1) = Ta1 )
     => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),var(X1)),Ta1)) ) ).

tff(fact_20__096_B_Bthesis_O_A_I_B_BTs_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_058_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_124_124_N_Aas_A_058_ATs_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ts1: list(type)] :
        ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a)),foldr(type,type,fun,Ts1,t)))
       => ~ pp(aa(list(type),bool,typings(shift(type,e,i,t2),as),Ts1)) ) ).

tff(fact_21_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_22_type_Orecs_I1_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun1(type,fun1(type,fun1(A,fun1(A,A)))),F1: fun1(nat,A)] : ( type_rec(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_23_type_Osimps_I5_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun1(type,fun1(type,A)),F1: fun1(nat,A)] : ( type_case(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_24_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun1(dB,dB),app,T),var(I)))) ) ).

tff(fact_25_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun1(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J1) = Ta1 ) ) ).

tff(fact_26_type_Osimps_I4_J,axiom,
    ! [Nat: nat,Type21: type,Type11: type] : ( aa(type,type,aa(type,fun1(type,type),fun,Type11),Type21) != atom(Nat) ) ).

tff(fact_27__096e_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a),as)),t)) ).

tff(fact_28_nT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),foldl(dB,dB,app,var(n),rs)),t)) ).

tff(fact_29_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun1(nat,type),Ta: dB,T2: type,T1: type] :
      ( ( t2 = aa(type,type,aa(type,fun1(type,type),fun,T1),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,Ib,T2)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),T2))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_30_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun1(nat,type),Ta: dB,T2: type,T1: type] :
      ( ( t2 = aa(type,type,aa(type,fun1(type,type),fun,T1),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,Ib,T1)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),T1))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_31_Cons,axiom,
    rs = cons(dB,a,as) ).

tff(fact_32_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_33_dB_Osimps_I2_J,axiom,
    ! [DB22: dB,DB12: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun1(dB,dB),app,DB12),DB22) )
    <=> ( ( DB11 = DB12 )
        & ( DB21 = DB22 ) ) ) ).

tff(fact_34_dB_Osimps_I4_J,axiom,
    ! [DB2: dB,DB1: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun1(dB,dB),app,DB1),DB2) ) ).

tff(fact_35_subst__App,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,aa(dB,dB,aa(dB,fun1(dB,dB),app,T),U)),S1),K) = aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,T),S1),K)),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,U),S1),K)) ) ).

tff(fact_36_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_37_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R2),var(I)),J))) ) ).

tff(fact_38_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun1(nat,type),Ta1: type,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(E),Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(E),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib)),Ta1)) ) ) ) ).

tff(fact_39_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_40_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Tsa: list(type),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),foldr(type,type,fun,Tsa,Ta1)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_41_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB1),DB2) != var(Nat) ) ).

tff(fact_42_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),var(Ib)),foldr(type,type,fun,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_43_var__app__types,axiom,
    ! [Ua: type,Tsa: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us)),Ta1))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun,Us1,Ta1) )
              & pp(aa(list(type),bool,typings(Eb,Us),Us1)) ) ) ) ) ).

tff(fact_44_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss) )
    <=> ( ( M = Na )
        & ( Rsa = Ss ) ) ) ).

tff(fact_45_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),foldr(type,type,fun,Ts1,Ta1)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_46_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),foldr(type,type,fun,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_47_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_48_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List2: list(A),Aa: A] :
      ( ( cons(A,Aa,List2) = cons(A,A5,List3) )
    <=> ( ( Aa = A5 )
        & ( List2 = List3 ) ) ) ).

tff(fact_49_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs: list(B),X1: B,F: fun1(B,fun1(A,A))] : ( foldr(B,A,F,cons(B,X1,Xs),Aa) = aa(A,A,aa(B,fun1(A,A),F,X1),foldr(B,A,F,Xs,Aa)) ) ).

tff(fact_50_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,Aa: A,F: fun1(A,fun1(B,A))] : ( foldl(A,B,F,Aa,cons(B,X1,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun1(B,A),F,Aa),X1),Xs) ) ).

tff(fact_51_Var_I2_J,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,ea,ia,t2)),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_52_Var_I4_J,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(ea),ua),t2)) ).

tff(fact_53_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_54_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_55_typings_Osimps_I2_J,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,cons(dB,Ta,Ts)),Tsa))
    <=> pp(list_case(bool,type,fFalse,combc(type,fun1(list(type),bool),fun1(list(type),bool),aa(fun1(type,fun1(bool,bool)),fun1(type,fun1(fun1(list(type),bool),fun1(list(type),bool))),aa(fun1(fun1(bool,bool),fun1(fun1(list(type),bool),fun1(list(type),bool))),fun1(fun1(type,fun1(bool,bool)),fun1(type,fun1(fun1(list(type),bool),fun1(list(type),bool)))),combb(fun1(bool,bool),fun1(fun1(list(type),bool),fun1(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun1(type,bool),fun1(type,fun1(bool,bool)),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(type,bool),fun1(type,fun1(bool,bool))),combb(bool,fun1(bool,bool),type),fconj),aa(dB,fun1(type,bool),typing(Eb),Ta))),typings(Eb,Ts)),Tsa)) ) ).

tff(fact_56_type_Oexhaust,axiom,
    ! [Y1: type] :
      ( ! [Nat1: nat] : ( Y1 != atom(Nat1) )
     => ~ ! [Type1: type,Type2: type] : ( Y1 != aa(type,type,aa(type,fun1(type,type),fun,Type1),Type2) ) ) ).

tff(fact_57_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X1: A,Xs: list(A),S: B,F: fun1(B,fun1(A,B))] :
      ( ! [X2: A,Y3: A,S2: B] : ( aa(A,B,aa(B,fun1(A,B),F,aa(A,B,aa(B,fun1(A,B),F,S2),X2)),Y3) = aa(A,B,aa(B,fun1(A,B),F,aa(A,B,aa(B,fun1(A,B),F,S2),Y3)),X2) )
     => ( aa(A,B,aa(B,fun1(A,B),F,foldl(B,A,F,S,Xs)),X1) = foldl(B,A,F,aa(A,B,aa(B,fun1(A,B),F,S),X1),Xs) ) ) ).

tff(fact_58_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),Aa: B,F2: fun1(B,fun1(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,Aa,List2)) = aa(list(B),A,aa(B,fun1(list(B),A),F2,Aa),List2) ) ).

tff(fact_59_substs__lemma,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),Ta1))
     => ( pp(aa(list(type),bool,typings(shift(type,Eb,Ib,Ta1),Ts),Tsa))
       => pp(aa(list(type),bool,typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun1(nat,dB),subst,Ub),Ib),Ts)),Tsa)) ) ) ).

tff(fact_60_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_61_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y1: A,Xs1: list(A),X: A] : ( splice(A,cons(A,X,Xs1),cons(A,Y1,Ys1)) = cons(A,X,cons(A,Y1,splice(A,Xs1,Ys1))) ) ).

tff(fact_62_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_63_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun1(A,bool),A2: fun1(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun1(A,bool),fun1(A,fun1(bool,bool)),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(A,bool),fun1(A,fun1(bool,bool))),combb(bool,fun1(bool,bool),A),fconj),A2),B1),X3)
    <=> ( listsp(A,A2,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_64_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,F: fun1(B,A)] : ( map(B,A,F,cons(B,X1,Xs)) = cons(A,aa(B,A,F,X1),map(B,A,F,Xs)) ) ).

tff(fact_65_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun1(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_66_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun1(C,B),Aa: A,G: fun1(A,fun1(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun1(C,B),fun1(C,A),aa(fun1(A,fun1(B,A)),fun1(A,fun1(fun1(C,B),fun1(C,A))),aa(fun1(fun1(B,A),fun1(fun1(C,B),fun1(C,A))),fun1(fun1(A,fun1(B,A)),fun1(A,fun1(fun1(C,B),fun1(C,A)))),combb(fun1(B,A),fun1(fun1(C,B),fun1(C,A)),A),combb(B,A,C)),G),F),Aa,Xs) ) ).

tff(fact_67_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys2: list(A),Y2: A,Xs: list(B),F: fun1(B,A)] :
      ( ( map(B,A,F,Xs) = cons(A,Y2,Ys2) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xs = cons(B,Z,Zs) )
          & ( aa(B,A,F,Z) = Y2 )
          & ( map(B,A,F,Zs) = Ys2 ) ) ) ).

tff(fact_68_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys2: list(B),F: fun1(B,A),Xs: list(A),X1: A] :
      ( ( cons(A,X1,Xs) = map(B,A,F,Ys2) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys2 = cons(B,Z,Zs) )
          & ( X1 = aa(B,A,F,Z) )
          & ( Xs = map(B,A,F,Zs) ) ) ) ).

tff(fact_69_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_70_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),lift,aa(dB,dB,aa(dB,fun1(dB,dB),app,S1),T)),K) = aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun1(nat,dB),lift,T),K)) ) ).

tff(fact_71_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),lift,T),I))) ) ).

tff(fact_72_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),Ta1))
     => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,Ib,Ua)),aa(nat,dB,aa(dB,fun1(nat,dB),lift,Ta),Ib)),Ta1)) ) ).

tff(fact_73_subst__lift,axiom,
    ! [S1: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,aa(nat,dB,aa(dB,fun1(nat,dB),lift,T),K)),S1),K) = T ) ).

tff(fact_74_lift__types,axiom,
    ! [Ua: type,Ib: nat,Tsa: list(type),Ts: list(dB),Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
     => pp(aa(list(type),bool,typings(shift(type,Eb,Ib,Ua),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)),Tsa)) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun1(A,B),F: fun1(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_77_lists__typings,axiom,
    ! [Tsa: list(type),Ts: list(dB),Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
     => listsp(dB,aa(fun1(dB,fun1(type,bool)),fun1(dB,bool),aa(fun1(fun1(type,bool),bool),fun1(fun1(dB,fun1(type,bool)),fun1(dB,bool)),combb(fun1(type,bool),bool,dB),fEx(type)),typing(Eb)),Ts) ) ).

tff(fact_78_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( var(M) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_79_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun1(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_80_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun1(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_81_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun1(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_82_listsp_ONil,axiom,
    ! [A: $tType,A2: fun1(A,bool)] : listsp(A,A2,nil(A)) ).

tff(fact_83_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun1(B,fun1(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_84_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,Aa: A,F: fun1(A,fun1(B,A))] : ( foldl(A,B,F,Aa,nil(B)) = Aa ) ).

tff(fact_85_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( cons(A,A4,List1) != nil(A) ) ).

tff(fact_86_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A4: A] : ( nil(A) != cons(A,A4,List1) ) ).

tff(fact_87_foldr_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,F: fun1(B,fun1(A,A))] : ( foldr(B,A,F,nil(B),Aa) = Aa ) ).

tff(fact_88_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_89_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_90_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_91_listsp_Osimps,axiom,
    ! [A: $tType,Aa: list(A),A2: fun1(A,bool)] :
      ( listsp(A,A2,Aa)
    <=> ( ( Aa = nil(A) )
        | ? [A3: A,L: list(A)] :
            ( ( Aa = cons(A,A3,L) )
            & pp(aa(A,bool,A2,A3))
            & listsp(A,A2,L) ) ) ) ).

tff(fact_92_type_Osize_I1_J,axiom,
    ! [Nat: nat] : ( type_size(atom(Nat)) = zero_zero(nat) ) ).

tff(fact_93_typings_Osimps_I1_J,axiom,
    ! [Tsa: list(type),Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,nil(dB)),Tsa))
    <=> ( Tsa = nil(type) ) ) ).

tff(fact_94_type_Osize_I3_J,axiom,
    ! [Nat: nat] : ( size_size(type,atom(Nat)) = zero_zero(nat) ) ).

tff(fact_95_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_96_list_Oexhaust,axiom,
    ! [A: $tType,Y1: list(A)] :
      ( ( Y1 != nil(A) )
     => ~ ! [A1: A,List: list(A)] : ( Y1 != cons(A,A1,List) ) ) ).

tff(fact_97_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y: A,Ys: list(A)] : ( Xs = cons(A,Y,Ys) ) ) ).

tff(fact_98_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (12)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun1(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun1(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun1(A,B),P: fun1(B,C)] : ( aa(A,C,aa(fun1(A,B),fun1(A,C),aa(fun1(B,C),fun1(fun1(A,B),fun1(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun1(A,fun1(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun1(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun1(A,B),P: fun1(A,fun1(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun1(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(e),u),aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)))) ).

%------------------------------------------------------------------------------
