%------------------------------------------------------------------------------
% File     : LCL788_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 129
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_129 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v9.1.0, 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  175 (  55 unt;  60 typ;   0 def)
%            Number of atoms       :  217 (  88 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  136 (  34   ~;  10   |;  16   &)
%                                         (  15 <=>;  61  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   5 avg)
%            Maximal term depth    :   17 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   44 (  23   >;  21   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-3 aty)
%            Number of functors    :   52 (  52 usr;  24 con; 0-5 aty)
%            Number of variables   :  401 ( 355   !;  12   ?; 401   :)
%                                         (  34  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:46
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun1: ( $tType * $tType ) > $tType ).

%----Explicit typings (54)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun1(fun1(B,C),fun1(fun1(A,B),fun1(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun1(A,fun1(B,C)) * B ) > fun1(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun1(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : fun1(fun1(A,fun1(B,C)),fun1(fun1(A,B),fun1(A,C))) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun1(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun1(dB,fun1(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun1(dB,fun1(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun1(dB,fun1(dB,fun1(nat,dB))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun1(B,fun1(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,fun1(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun1(A,fun1(list(A),list(A))) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun1(A,fun1(list(A),T4)) * list(A) ) > T4 ) ).

tff(sy_c_List_Olistset,type,
    listset: 
      !>[A: $tType] : ( list(fun1(A,bool)) > fun1(list(A),bool) ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun1(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Oset__Cons,type,
    set_Cons: 
      !>[A: $tType] : ( ( fun1(A,bool) * fun1(list(A),bool) ) > fun1(list(A),bool) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( fun1(A,bool) > fun1(A,bool) ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun1(nat,A) * nat * A ) > fun1(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun: fun1(type,fun1(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T4: $tType] : ( ( fun1(nat,T4) * fun1(type,fun1(type,T4)) * type ) > T4 ) ).

tff(sy_c_Type_Otype_Otype__rec,type,
    type_rec: 
      !>[T4: $tType] : ( ( fun1(nat,T4) * fun1(type,fun1(type,fun1(T4,fun1(T4,T4)))) * type ) > T4 ) ).

tff(sy_c_Type_Otyping,type,
    typing: fun1(nat,type) > fun1(dB,fun1(type,bool)) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun1(nat,type) * list(dB) ) > fun1(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun1(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun1(fun1(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun1(bool,fun1(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun1(A,fun1(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : fun1(A,fun1(fun1(A,bool),bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H_H____,type,
    t1: type ).

tff(sy_v_T_H____,type,
    t: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t2: type ).

tff(sy_v_Ts____,type,
    ts: list(type) ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun1(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun1(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t3: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (99)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t3)) ).

tff(fact_1_uT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(e),u),t2)) ).

tff(fact_2_varT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),var(n)),aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)))) ).

tff(fact_3_argT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),a),t1)) ).

tff(fact_4_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun1(type,type),fun,Type1),Type2) = aa(type,type,aa(type,fun1(type,type),fun,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_5_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_6_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_7_argsT,axiom,
    pp(aa(list(type),bool,typings(shift(type,e,i,t2),as),ts)) ).

tff(fact_8__096_B_Bthesis_O_A_I_B_BT_H_H_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_058_AT_H_H_A_092_060Rightarrow_062_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_092_060turnstile_062_Aa_A_058_AT_H_H_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [T3: type] :
        ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),var(n)),aa(type,type,aa(type,fun1(type,type),fun,T3),foldr(type,type,fun,ts,t))))
       => ~ pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),a),T3)) ) ).

tff(fact_9_headT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a)),foldr(type,type,fun,ts,t))) ).

tff(fact_10_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun1(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t2 = aa(type,type,aa(type,fun1(type,type),fun,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,Ib,T11)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_11_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun1(nat,type),Ta: dB,T21: type,T11: type] :
      ( ( t2 = aa(type,type,aa(type,fun1(type,type),fun,T11),T21) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,Ib,T21)),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),T21))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib))) ) ) ) ) ) ).

tff(fact_12_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun1(type,fun1(type,A)),F1: fun1(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun1(type,type),fun,Type1),Type2)) = aa(type,A,aa(type,fun1(type,A),F2,Type1),Type2) ) ).

tff(fact_13_type_Orecs_I2_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun1(type,fun1(type,fun1(A,fun1(A,A)))),F1: fun1(nat,A)] : ( type_rec(A,F1,F2,aa(type,type,aa(type,fun1(type,type),fun,Type1),Type2)) = aa(A,A,aa(A,fun1(A,A),aa(type,fun1(A,fun1(A,A)),aa(type,fun1(type,fun1(A,fun1(A,A))),F2,Type1),Type2),type_rec(A,F1,F2,Type1)),type_rec(A,F1,F2,Type2)) ) ).

tff(fact_14__096_B_Bthesis_O_A_I_B_BTs_O_A_091_124_Ae_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_058_ATs_A_061_062_062_AT_H_059_Ae_060i_058T_062_A_124_124_N_Aas_A_058_ATs_A_124_093_A_061_061_062_Athesis_J_A_061_061_062_Athesis_096,axiom,
    ~ ! [Ts1: list(type)] :
        ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a)),foldr(type,type,fun,Ts1,t)))
       => ~ pp(aa(list(type),bool,typings(shift(type,e,i,t2),as),Ts1)) ) ).

tff(fact_15_True,axiom,
    n = i ).

tff(fact_16_typing_OVar,axiom,
    ! [Ta1: type,X1: nat,Env: fun1(nat,type)] :
      ( ( aa(nat,type,Env,X1) = Ta1 )
     => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),var(X1)),Ta1)) ) ).

tff(fact_17_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_18_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S2: dB,Env: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),S2),aa(type,type,aa(type,fun1(type,type),fun,Ta1),Ua)))
     => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),Ta),Ta1))
       => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),aa(dB,dB,aa(dB,fun1(dB,dB),app,S2),Ta)),Ua)) ) ) ).

tff(fact_19_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_20_app__Var__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun1(dB,dB),app,T),var(I)))) ) ).

tff(fact_21_subst__Var__IT,axiom,
    ! [J1: nat,I: nat,R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R1),var(I)),J1))) ) ).

tff(fact_22_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun1(nat,A),J: nat,Ib: nat] :
      ( ( Ib = J )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J) = Ta1 ) ) ).

tff(fact_23_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun1(nat,type),Ta1: type,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(E),Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(E),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib)),Ta1)) ) ) ) ).

tff(fact_24__096e_060i_058T_062_A_092_060turnstile_062_AVar_An_A_092_060degree_062_Aa_A_092_060degree_062_092_060degree_062_Aas_A_058_AT_H_096,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun1(dB,dB),app,var(n)),a),as)),t)) ).

tff(fact_25_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),aa(dB,dB,aa(dB,fun1(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T2: type] :
            ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),aa(type,type,aa(type,fun1(type,type),fun,T2),Ta1)))
           => ~ pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),T2)) ) ) ).

tff(fact_26_nT,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,e,i,t2)),foldl(dB,dB,app,var(n),rs)),t)) ).

tff(fact_27_subst__App,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,aa(dB,dB,aa(dB,fun1(dB,dB),app,T),U)),S),K) = aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,T),S),K)),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,U),S),K)) ) ).

tff(fact_28_Cons,axiom,
    rs = aa(list(dB),list(dB),aa(dB,fun1(list(dB),list(dB)),cons(dB),a),as) ).

tff(fact_29_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_30_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun1(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_31_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_32_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_33_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Tsa: list(type),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),foldr(type,type,fun,Tsa,Ta1)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_34_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_35_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun1(dB,dB),app,DB11),DB21) ) ).

tff(fact_36_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),var(Ib)),foldr(type,type,fun,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_37_var__app__types,axiom,
    ! [Ua: type,Tsa: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us)),Ta1))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
       => ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun,Us1,Ta1) )
              & pp(aa(list(type),bool,typings(Eb,Us),Us1)) ) ) ) ) ).

tff(fact_38_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_39_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),foldr(type,type,fun,Ts1,Ta1)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_40_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),foldr(type,type,fun,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_41_apps__eq__tail__conv,axiom,
    ! [S2: dB,Ts: list(dB),R3: dB] :
      ( ( foldl(dB,dB,app,R3,Ts) = foldl(dB,dB,app,S2,Ts) )
    <=> ( R3 = S2 ) ) ).

tff(fact_42_list_Oinject,axiom,
    ! [A: $tType,List1: list(A),A2: A,List: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),Aa),List) = aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),A2),List1) )
    <=> ( ( Aa = A2 )
        & ( List = List1 ) ) ) ).

tff(fact_43_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs1: list(B),X1: B,F: fun1(B,fun1(A,A))] : ( foldr(B,A,F,aa(list(B),list(B),aa(B,fun1(list(B),list(B)),cons(B),X1),Xs1),Aa) = aa(A,A,aa(B,fun1(A,A),F,X1),foldr(B,A,F,Xs1,Aa)) ) ).

tff(fact_44_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X1: B,Aa: A,F: fun1(A,fun1(B,A))] : ( foldl(A,B,F,Aa,aa(list(B),list(B),aa(B,fun1(list(B),list(B)),cons(B),X1),Xs1)) = foldl(A,B,F,aa(B,A,aa(A,fun1(B,A),F,Aa),X1),Xs1) ) ).

tff(fact_45_Var_I2_J,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,ea,ia,t2)),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_46_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_47_Var_I4_J,axiom,
    pp(aa(type,bool,aa(dB,fun1(type,bool),typing(ea),ua),t2)) ).

tff(fact_48_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun1(A,bool),A1: fun1(A,bool),X3: list(A)] :
      ( listsp(A,aa(fun1(A,bool),fun1(A,bool),aa(fun1(A,fun1(bool,bool)),fun1(fun1(A,bool),fun1(A,bool)),combs(A,bool,bool),aa(fun1(A,bool),fun1(A,fun1(bool,bool)),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(A,bool),fun1(A,fun1(bool,bool))),combb(bool,fun1(bool,bool),A),fconj),A1)),B1),X3)
    <=> ( listsp(A,A1,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_49_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),X),Xs) != Xs ) ).

tff(fact_50_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),X),Xs) ) ).

tff(fact_51_typings_Osimps_I2_J,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,aa(list(dB),list(dB),aa(dB,fun1(list(dB),list(dB)),cons(dB),Ta),Ts)),Tsa))
    <=> pp(list_case(bool,type,fFalse,combc(type,fun1(list(type),bool),fun1(list(type),bool),aa(fun1(type,fun1(bool,bool)),fun1(type,fun1(fun1(list(type),bool),fun1(list(type),bool))),aa(fun1(fun1(bool,bool),fun1(fun1(list(type),bool),fun1(list(type),bool))),fun1(fun1(type,fun1(bool,bool)),fun1(type,fun1(fun1(list(type),bool),fun1(list(type),bool)))),combb(fun1(bool,bool),fun1(fun1(list(type),bool),fun1(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun1(type,bool),fun1(type,fun1(bool,bool)),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(type,bool),fun1(type,fun1(bool,bool))),combb(bool,fun1(bool,bool),type),fconj),aa(dB,fun1(type,bool),typing(Eb),Ta))),typings(Eb,Ts)),Tsa)) ) ).

tff(fact_52_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X1: A,Xs1: list(A),S2: B,F: fun1(B,fun1(A,B))] :
      ( ! [X2: A,Y2: A,S3: B] : ( aa(A,B,aa(B,fun1(A,B),F,aa(A,B,aa(B,fun1(A,B),F,S3),X2)),Y2) = aa(A,B,aa(B,fun1(A,B),F,aa(A,B,aa(B,fun1(A,B),F,S3),Y2)),X2) )
     => ( aa(A,B,aa(B,fun1(A,B),F,foldl(B,A,F,S2,Xs1)),X1) = foldl(B,A,F,aa(A,B,aa(B,fun1(A,B),F,S2),X1),Xs1) ) ) ).

tff(fact_53_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun1(B,fun1(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun1(list(B),list(B)),cons(B),Aa),List)) = aa(list(B),A,aa(B,fun1(list(B),A),F2,Aa),List) ) ).

tff(fact_54_substs__lemma,axiom,
    ! [Tsa: list(type),Ts: list(dB),Ib: nat,Ta1: type,Ub: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ub),Ta1))
     => ( pp(aa(list(type),bool,typings(shift(type,Eb,Ib,Ta1),Ts),Tsa))
       => pp(aa(list(type),bool,typings(Eb,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun1(nat,dB),subst,Ub),Ib),Ts)),Tsa)) ) ) ).

tff(fact_55_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_56_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X1: B,F: fun1(B,A)] : ( map(B,A,F,aa(list(B),list(B),aa(B,fun1(list(B),list(B)),cons(B),X1),Xs1)) = aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),aa(B,A,F,X1)),map(B,A,F,Xs1)) ) ).

tff(fact_57_subst__map,axiom,
    ! [Ib: nat,Ub: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),Ub),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,Ta),Ub),Ib),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun1(nat,dB),subst,Ub),Ib),Ts)) ) ).

tff(fact_58_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs1: list(C),F: fun1(C,B),Aa: A,G: fun1(A,fun1(B,A))] : ( foldl(A,B,G,Aa,map(C,B,F,Xs1)) = foldl(A,C,combc(A,fun1(C,B),fun1(C,A),aa(fun1(A,fun1(B,A)),fun1(A,fun1(fun1(C,B),fun1(C,A))),aa(fun1(fun1(B,A),fun1(fun1(C,B),fun1(C,A))),fun1(fun1(A,fun1(B,A)),fun1(A,fun1(fun1(C,B),fun1(C,A)))),combb(fun1(B,A),fun1(fun1(C,B),fun1(C,A)),A),combb(B,A,C)),G),F),Aa,Xs1) ) ).

tff(fact_59_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),F: fun1(B,A),Xs1: list(A),X1: A] :
      ( ( aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),X1),Xs1) = map(B,A,F,Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Ys1 = aa(list(B),list(B),aa(B,fun1(list(B),list(B)),cons(B),Z),Zs) )
          & ( X1 = aa(B,A,F,Z) )
          & ( Xs1 = map(B,A,F,Zs) ) ) ) ).

tff(fact_60_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys1: list(A),Y1: A,Xs1: list(B),F: fun1(B,A)] :
      ( ( map(B,A,F,Xs1) = aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),Y1),Ys1) )
    <=> ? [Z: B,Zs: list(B)] :
          ( ( Xs1 = aa(list(B),list(B),aa(B,fun1(list(B),list(B)),cons(B),Z),Zs) )
          & ( aa(B,A,F,Z) = Y1 )
          & ( map(B,A,F,Zs) = Ys1 ) ) ) ).

tff(fact_61_lift__map,axiom,
    ! [Ib: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ib) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),lift,Ta),Ib),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)) ) ).

tff(fact_62_lift__types,axiom,
    ! [Ua: type,Ib: nat,Tsa: list(type),Ts: list(dB),Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
     => pp(aa(list(type),bool,typings(shift(type,Eb,Ib,Ua),map(dB,dB,combc(dB,nat,dB,lift,Ib),Ts)),Tsa)) ) ).

tff(fact_63_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),lift,aa(dB,dB,aa(dB,fun1(dB,dB),app,S),T)),K) = aa(dB,dB,aa(dB,fun1(dB,dB),app,aa(nat,dB,aa(dB,fun1(nat,dB),lift,S),K)),aa(nat,dB,aa(dB,fun1(nat,dB),lift,T),K)) ) ).

tff(fact_64_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun1(nat,dB),lift,T),I))) ) ).

tff(fact_65_lift__type,axiom,
    ! [Ua: type,Ib: nat,Ta1: type,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),Ta1))
     => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,Ib,Ua)),aa(nat,dB,aa(dB,fun1(nat,dB),lift,Ta),Ib)),Ta1)) ) ).

tff(fact_66_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,aa(nat,dB,aa(dB,fun1(nat,dB),lift,T),K)),S),K) = T ) ).

tff(fact_67_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_68_lists__typings,axiom,
    ! [Tsa: list(type),Ts: list(dB),Eb: fun1(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,Ts),Tsa))
     => listsp(dB,aa(fun1(dB,fun1(type,bool)),fun1(dB,bool),aa(fun1(fun1(type,bool),bool),fun1(fun1(dB,fun1(type,bool)),fun1(dB,bool)),combb(fun1(type,bool),bool,dB),fEx(type)),typing(Eb)),Ts) ) ).

tff(fact_69_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),X),Xs),aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),Y),Ys)) = aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),X),aa(list(A),list(A),aa(A,fun1(list(A),list(A)),cons(A),Y),splice(A,Xs,Ys))) ) ).

tff(fact_70_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_71_Beta,axiom,
    ! [Ss1: list(dB),S2: dB,R3: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R3),S2),zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S2))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(R3)),S2),Ss1))) ) ) ).

tff(fact_72_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_73_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun1(A,B),F: fun1(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun1(A,bool),X1: A] :
      ( pp(aa(fun1(A,bool),bool,aa(A,fun1(fun1(A,bool),bool),member(A),X1),A1))
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_76_Collect__def,axiom,
    ! [A: $tType,P1: fun1(A,bool)] : ( collect(A,P1) = P1 ) ).

tff(fact_77_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S2: dB,Rsa: list(dB),R3: dB] :
      ( ( foldl(dB,dB,app,abs(R3),Rsa) = foldl(dB,dB,app,abs(S2),Ss1) )
    <=> ( ( R3 = S2 )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_78_Abs,axiom,
    ! [Ua: type,Ta: dB,Ta1: type,Env: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Env,zero_zero(nat),Ta1)),Ta),Ua))
     => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Env),abs(Ta)),aa(type,type,aa(type,fun1(type,type),fun,Ta1),Ua))) ) ).

tff(fact_79_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_80_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_81_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun1(dB,dB),app,DB1),DB2) ) ).

tff(fact_82_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun1(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_83_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_84_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R3: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R3),Ss1) ) ).

tff(fact_85_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,Ta: dB,S2: dB] : ( aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(S2)),Ta) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_86_typing__elims_I3_J,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),abs(Ta)),Ta1))
     => ~ ! [T2: type,U1: type] :
            ( ( Ta1 = aa(type,type,aa(type,fun1(type,type),fun,T2),U1) )
           => ~ pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,zero_zero(nat),T2)),Ta),U1)) ) ) ).

tff(fact_87_abs__typeE,axiom,
    ! [Ta1: type,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),abs(Ta)),Ta1))
     => ~ ! [U1: type,V: type] : ~ pp(aa(type,bool,aa(dB,fun1(type,bool),typing(shift(type,Eb,zero_zero(nat),U1)),Ta),V)) ) ).

tff(fact_88_IT_Osimps,axiom,
    ! [Aa: dB] :
      ( pp(aa(dB,bool,it,Aa))
    <=> ( ? [Rs: list(dB),N: nat] :
            ( ( Aa = foldl(dB,dB,app,var(N),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R2: dB] :
            ( ( Aa = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S1: dB,Ss: list(dB)] :
            ( ( Aa = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(R2)),S1),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R2),S1),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S1)) ) ) ) ).

tff(fact_89_set__Cons__def,axiom,
    ! [A: $tType,XS: fun1(list(A),bool),A1: fun1(A,bool)] : ( set_Cons(A,A1,XS) = collect(list(A),aa(fun1(list(A),fun1(A,bool)),fun1(list(A),bool),aa(fun1(fun1(A,bool),bool),fun1(fun1(list(A),fun1(A,bool)),fun1(list(A),bool)),combb(fun1(A,bool),bool,list(A)),fEx(A)),aa(fun1(list(A),fun1(A,fun1(list(A),bool))),fun1(list(A),fun1(A,bool)),aa(fun1(fun1(A,fun1(list(A),bool)),fun1(A,bool)),fun1(fun1(list(A),fun1(A,fun1(list(A),bool))),fun1(list(A),fun1(A,bool))),combb(fun1(A,fun1(list(A),bool)),fun1(A,bool),list(A)),aa(fun1(fun1(list(A),bool),bool),fun1(fun1(A,fun1(list(A),bool)),fun1(A,bool)),combb(fun1(list(A),bool),bool,A),fEx(list(A)))),combc(list(A),fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),bool)),aa(fun1(list(A),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool)))),fun1(list(A),fun1(fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),bool)))),aa(fun1(fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool))),fun1(fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),bool)))),fun1(fun1(list(A),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool)))),fun1(list(A),fun1(fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),bool))))),combb(fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool))),fun1(fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),bool))),list(A)),combs(A,fun1(list(A),bool),fun1(list(A),bool))),aa(fun1(list(A),fun1(A,fun1(list(A),fun1(bool,bool)))),fun1(list(A),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool)))),aa(fun1(fun1(A,fun1(list(A),fun1(bool,bool))),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool)))),fun1(fun1(list(A),fun1(A,fun1(list(A),fun1(bool,bool)))),fun1(list(A),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool))))),combb(fun1(A,fun1(list(A),fun1(bool,bool))),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool))),list(A)),aa(fun1(fun1(list(A),fun1(bool,bool)),fun1(fun1(list(A),bool),fun1(list(A),bool))),fun1(fun1(A,fun1(list(A),fun1(bool,bool))),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool)))),combb(fun1(list(A),fun1(bool,bool)),fun1(fun1(list(A),bool),fun1(list(A),bool)),A),combs(list(A),bool,bool))),aa(fun1(list(A),fun1(A,fun1(list(A),bool))),fun1(list(A),fun1(A,fun1(list(A),fun1(bool,bool)))),aa(fun1(fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),fun1(bool,bool)))),fun1(fun1(list(A),fun1(A,fun1(list(A),bool))),fun1(list(A),fun1(A,fun1(list(A),fun1(bool,bool))))),combb(fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),fun1(bool,bool))),list(A)),aa(fun1(fun1(list(A),bool),fun1(list(A),fun1(bool,bool))),fun1(fun1(A,fun1(list(A),bool)),fun1(A,fun1(list(A),fun1(bool,bool)))),combb(fun1(list(A),bool),fun1(list(A),fun1(bool,bool)),A),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(list(A),bool),fun1(list(A),fun1(bool,bool))),combb(bool,fun1(bool,bool),list(A)),fconj))),combc(list(A),fun1(A,fun1(list(A),list(A))),fun1(A,fun1(list(A),bool)),aa(fun1(list(A),fun1(fun1(list(A),list(A)),fun1(list(A),bool))),fun1(list(A),fun1(fun1(A,fun1(list(A),list(A))),fun1(A,fun1(list(A),bool)))),aa(fun1(fun1(fun1(list(A),list(A)),fun1(list(A),bool)),fun1(fun1(A,fun1(list(A),list(A))),fun1(A,fun1(list(A),bool)))),fun1(fun1(list(A),fun1(fun1(list(A),list(A)),fun1(list(A),bool))),fun1(list(A),fun1(fun1(A,fun1(list(A),list(A))),fun1(A,fun1(list(A),bool))))),combb(fun1(fun1(list(A),list(A)),fun1(list(A),bool)),fun1(fun1(A,fun1(list(A),list(A))),fun1(A,fun1(list(A),bool))),list(A)),combb(fun1(list(A),list(A)),fun1(list(A),bool),A)),aa(fun1(list(A),fun1(list(A),bool)),fun1(list(A),fun1(fun1(list(A),list(A)),fun1(list(A),bool))),aa(fun1(fun1(list(A),bool),fun1(fun1(list(A),list(A)),fun1(list(A),bool))),fun1(fun1(list(A),fun1(list(A),bool)),fun1(list(A),fun1(fun1(list(A),list(A)),fun1(list(A),bool)))),combb(fun1(list(A),bool),fun1(fun1(list(A),list(A)),fun1(list(A),bool)),list(A)),combb(list(A),bool,list(A))),fequal(list(A)))),cons(A))))),combc(A,fun1(list(A),bool),fun1(list(A),bool),aa(fun1(A,fun1(bool,bool)),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool))),aa(fun1(fun1(bool,bool),fun1(fun1(list(A),bool),fun1(list(A),bool))),fun1(fun1(A,fun1(bool,bool)),fun1(A,fun1(fun1(list(A),bool),fun1(list(A),bool)))),combb(fun1(bool,bool),fun1(fun1(list(A),bool),fun1(list(A),bool)),A),combb(bool,bool,list(A))),aa(fun1(A,bool),fun1(A,fun1(bool,bool)),aa(fun1(bool,fun1(bool,bool)),fun1(fun1(A,bool),fun1(A,fun1(bool,bool))),combb(bool,fun1(bool,bool),A),fconj),combc(A,fun1(A,bool),bool,member(A),A1))),combc(list(A),fun1(list(A),bool),bool,member(list(A)),XS)))))) ) ).

tff(fact_90_listset_Osimps_I2_J,axiom,
    ! [A: $tType,As: list(fun1(A,bool)),A1: fun1(A,bool)] : ( listset(A,aa(list(fun1(A,bool)),list(fun1(A,bool)),aa(fun1(A,bool),fun1(list(fun1(A,bool)),list(fun1(A,bool))),cons(fun1(A,bool)),A1),As)) = set_Cons(A,A1,listset(A,As)) ) ).

tff(fact_91_beta,axiom,
    ! [T: dB,S: dB] : beta(aa(dB,dB,aa(dB,fun1(dB,dB),app,abs(S)),T),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,S),T),zero_zero(nat))) ).

tff(fact_92_appR,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun1(dB,dB),app,U),S),aa(dB,dB,aa(dB,fun1(dB,dB),app,U),T)) ) ).

tff(fact_93_appL,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun1(dB,dB),app,S),U),aa(dB,dB,aa(dB,fun1(dB,dB),app,T),U)) ) ).

tff(fact_94_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ beta(var(I),T) ).

tff(fact_95_abs,axiom,
    ! [T: dB,S: dB] :
      ( beta(S,T)
     => beta(abs(S),abs(T)) ) ).

tff(fact_96_lift__preserves__beta,axiom,
    ! [I: nat,S: dB,R1: dB] :
      ( beta(R1,S)
     => beta(aa(nat,dB,aa(dB,fun1(nat,dB),lift,R1),I),aa(nat,dB,aa(dB,fun1(nat,dB),lift,S),I)) ) ).

tff(fact_97_subject__reduction,axiom,
    ! [T1: dB,Ta1: type,Ta: dB,Eb: fun1(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),Ta),Ta1))
     => ( beta(Ta,T1)
       => pp(aa(type,bool,aa(dB,fun1(type,bool),typing(Eb),T1),Ta1)) ) ) ).

tff(fact_98_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S: dB,R1: dB] :
      ( beta(R1,S)
     => beta(aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,R1),T),I),aa(nat,dB,aa(dB,fun1(nat,dB),aa(dB,fun1(dB,fun1(nat,dB)),subst,S),T),I)) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun1(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun1(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun1(A,B),P: fun1(B,C)] : ( aa(A,C,aa(fun1(A,B),fun1(A,C),aa(fun1(B,C),fun1(fun1(A,B),fun1(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun1(A,fun1(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun1(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun1(A,B),P: fun1(A,fun1(B,C))] : ( aa(A,C,aa(fun1(A,B),fun1(A,C),aa(fun1(A,fun1(B,C)),fun1(fun1(A,B),fun1(A,C)),combs(A,B,C),P),Q),R) = aa(B,C,aa(A,fun1(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun1(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun1(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun1(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    t2 = aa(type,type,aa(type,fun1(type,type),fun,t1),foldr(type,type,fun,ts,t)) ).

%------------------------------------------------------------------------------
