%------------------------------------------------------------------------------
% File     : LCL785_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 119
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_119 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  160 (  50 unt;  49 typ;   0 def)
%            Number of atoms       :  227 ( 137 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  147 (  31   ~;   9   |;  24   &)
%                                         (  28 <=>;  55  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   6 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   45 (  21   >;  24   *;   0   +;   0  <<)
%            Number of predicates  :    3 (   2 usr;   0 prp; 1-3 aty)
%            Number of functors    :   43 (  43 usr;  20 con; 0-5 aty)
%            Number of variables   :  430 ( 391   !;  10   ?; 430   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:40
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(dB,fun(dB,T3)) * fun(dB,T3) * dB ) > T3 ) ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : fun(list(A),fun(list(A),list(A))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Ofoldr,type,
    foldr: 
      !>[A: $tType,B: $tType] : ( ( fun(A,fun(B,B)) * list(A) * B ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T3: $tType,A: $tType] : ( ( T3 * fun(A,fun(list(A),T3)) * list(A) ) > T3 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: fun(type,fun(type,type)) ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(type,fun(type,T3)) * type ) > T3 ) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB ) > fun(type,bool) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) ) > fun(list(type),bool) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H____,type,
    t: type ).

tff(sy_v_T_Ha______,type,
    t_a: type ).

tff(sy_v_T____,type,
    t1: type ).

tff(sy_v_a____,type,
    a: dB ).

tff(sy_v_as____,type,
    as: list(dB) ).

tff(sy_v_e____,type,
    e: fun(nat,type) ).

tff(sy_v_ea______,type,
    ea: fun(nat,type) ).

tff(sy_v_i____,type,
    i: nat ).

tff(sy_v_ia______,type,
    ia: nat ).

tff(sy_v_n____,type,
    n: nat ).

tff(sy_v_rs____,type,
    rs: list(dB) ).

tff(sy_v_t____,type,
    t2: dB ).

tff(sy_v_u____,type,
    u: dB ).

tff(sy_v_ua______,type,
    ua: dB ).

%----Relevant facts (100)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t2)) ).

tff(fact_1_True,axiom,
    n = i ).

tff(fact_2_Cons,axiom,
    rs = aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),a),as) ).

tff(fact_3_uT,axiom,
    pp(aa(type,bool,typing(e,u),t1)) ).

tff(fact_4_nT,axiom,
    pp(aa(type,bool,typing(shift(type,e,i,t1),foldl(dB,dB,app,var(n),rs)),t)) ).

tff(fact_5_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rsa: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rsa) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rsa = Ss1 ) ) ) ).

tff(fact_6_typing_OVar,axiom,
    ! [Ta1: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = Ta1 )
     => pp(aa(type,bool,typing(Env,var(X)),Ta1)) ) ).

tff(fact_7_typing__elims_I1_J,axiom,
    ! [Ta1: type,Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,var(Ib)),Ta1))
     => ( aa(nat,type,Eb,Ib) = Ta1 ) ) ).

tff(fact_8_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_9_var__app__type__eq,axiom,
    ! [Ua: type,Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
       => ( Ta1 = Ua ) ) ) ).

tff(fact_10_uIT,axiom,
    pp(aa(dB,bool,it,u)) ).

tff(fact_11_Var_I3_J,axiom,
    pp(aa(dB,bool,it,ua)) ).

tff(fact_12_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat2) )
    <=> ( Nat = Nat2 ) ) ).

tff(fact_13_dB_Osimps_I2_J,axiom,
    ! [DB22: dB,DB12: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) )
    <=> ( ( DB1 = DB12 )
        & ( DB2 = DB22 ) ) ) ).

tff(fact_14_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat1: nat] : ( var(Nat1) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_15_dB_Osimps_I5_J,axiom,
    ! [Nat1: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat1) ) ).

tff(fact_16_Var_I2_J,axiom,
    pp(aa(type,bool,typing(shift(type,ea,ia,t1),foldl(dB,dB,app,var(n),rs)),t_a)) ).

tff(fact_17_Var_I4_J,axiom,
    pp(aa(type,bool,typing(ea,ua),t1)) ).

tff(fact_18_Var__IT,axiom,
    ! [N: nat] : pp(aa(dB,bool,it,var(N))) ).

tff(fact_19_app__Var__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),var(I)))) ) ).

tff(fact_20_shift__eq,axiom,
    ! [A: $tType,Ta1: A,Eb: fun(nat,A),J1: nat,Ib: nat] :
      ( ( Ib = J1 )
     => ( aa(nat,A,shift(A,Eb,Ib,Ta1),J1) = Ta1 ) ) ).

tff(fact_21_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List: list(A),Aa: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Aa),List) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List3) )
    <=> ( ( Aa = A5 )
        & ( List = List3 ) ) ) ).

tff(fact_22_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X),Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,Aa),X),Xs) ) ).

tff(fact_23_MI2,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t1 = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T2),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T2))
             => pp(aa(dB,bool,it,subst(Ta,Ub,Ib))) ) ) ) ) ) ).

tff(fact_24_MI1,axiom,
    ! [Ub: dB,Ta1: type,Ib: nat,Eb: fun(nat,type),Ta: dB,T2: type,T11: type] :
      ( ( t1 = aa(type,type,aa(type,fun(type,type),fun1,T11),T2) )
     => ( pp(aa(dB,bool,it,Ta))
       => ( pp(aa(type,bool,typing(shift(type,Eb,Ib,T11),Ta),Ta1))
         => ( pp(aa(dB,bool,it,Ub))
           => ( pp(aa(type,bool,typing(Eb,Ub),T11))
             => pp(aa(dB,bool,it,subst(Ta,Ub,Ib))) ) ) ) ) ) ).

tff(fact_25_IT_OVar,axiom,
    ! [Na: nat,Rsa: list(dB)] :
      ( listsp(dB,it,Rsa)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rsa))) ) ).

tff(fact_26_Var__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( var(M) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_27_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_28_App,axiom,
    ! [Ta: dB,Ua: type,Ta1: type,S: dB,Env: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Env,S),aa(type,type,aa(type,fun(type,type),fun1,Ta1),Ua)))
     => ( pp(aa(type,bool,typing(Env,Ta),Ta1))
       => pp(aa(type,bool,typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S),Ta)),Ua)) ) ) ).

tff(fact_29_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2) = aa(type,type,aa(type,fun(type,type),fun1,Type11),Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_30_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X3)
    <=> ( listsp(A,A1,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_31_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_32_subst__App,axiom,
    ! [K: nat,S2: dB,U1: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S2,K)),subst(U1,S2,K)) ) ).

tff(fact_33_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List2) ) ).

tff(fact_34_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A4: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),List2) != nil(A) ) ).

tff(fact_35_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,nil(B)) = Aa ) ).

tff(fact_36_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( subst(var(K),U1,K) = U1 ) ).

tff(fact_37_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,subst(R2,var(I),J))) ) ).

tff(fact_38_subst__lemma,axiom,
    ! [Ib: nat,Ua: type,Ub: dB,E: fun(nat,type),Ta1: type,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
     => ( pp(aa(type,bool,typing(E,Ub),Ua))
       => ( ( Eb = shift(type,E,Ib,Ua) )
         => pp(aa(type,bool,typing(E,subst(Ta,Ub,Ib)),Ta1)) ) ) ) ).

tff(fact_39_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1) != Xs1 ) ).

tff(fact_40_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1) ) ).

tff(fact_41_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_42_typing__elims_I2_J,axiom,
    ! [Ta1: type,Ub: dB,Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,aa(dB,dB,aa(dB,fun(dB,dB),app,Ta),Ub)),Ta1))
     => ~ ! [T: type] :
            ( pp(aa(type,bool,typing(Eb,Ta),aa(type,type,aa(type,fun(type,type),fun1,T),Ta1)))
           => ~ pp(aa(type,bool,typing(Eb,Ub),T)) ) ) ).

tff(fact_43_listsp_Osimps,axiom,
    ! [A: $tType,Aa: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,Aa)
    <=> ( ( Aa = nil(A) )
        | ? [A3: A,L: list(A)] :
            ( ( Aa = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),L) )
            & pp(aa(A,bool,A1,A3))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_44_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y3: A,Ys4: list(A)] : ( Xs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y3),Ys4) ) ) ).

tff(fact_45_list_Oexhaust,axiom,
    ! [A: $tType,Y2: list(A)] :
      ( ( Y2 != nil(A) )
     => ~ ! [A2: A,List1: list(A)] : ( Y2 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List1) ) ) ).

tff(fact_46_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)) ) ).

tff(fact_47_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,aa(type,type,aa(type,fun(type,type),fun1,Type1),Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_48_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X2)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X),Xs) ) ) ).

tff(fact_49_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

tff(fact_50_app__last,axiom,
    ! [Ub: dB,Ts: list(dB),Ta: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,Ta,Ts)),Ub) = foldl(dB,dB,app,Ta,aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),Ts),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),Ub),nil(dB)))) ) ).

tff(fact_51_App__eq__foldl__conv,axiom,
    ! [Ts: list(dB),Ta: dB,S: dB,R1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,R1),S) = foldl(dB,dB,app,Ta,Ts) )
    <=> ( ( ( Ts = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,R1),S) = Ta ) )
        & ( ( Ts != nil(dB) )
         => ? [Ss: list(dB)] :
              ( ( Ts = aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),Ss),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),S),nil(dB))) )
              & ( R1 = foldl(dB,dB,app,Ta,Ss) ) ) ) ) ) ).

tff(fact_52_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys2: list(A),Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys2)),Zs1) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys2),Zs1)) ) ).

tff(fact_53_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Zs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_54_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs: list(A),Ys: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),Xs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs),Xs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_55_append__Cons,axiom,
    ! [A: $tType,Ys2: list(A),Xs1: list(A),X1: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1)),Ys2) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys2)) ) ).

tff(fact_56_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( nil(A) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_57_self__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_58_self__append__conv2,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( Ys = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_59_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = nil(A) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_60_append__self__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = Xs )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_61_append__self__conv2,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = Ys )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_62_foldl__append,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Xs: list(B),Aa: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,Aa,aa(list(B),list(B),aa(list(B),fun(list(B),list(B)),append(B),Xs),Ys)) = foldl(A,B,F,foldl(A,B,F,Aa,Xs),Ys) ) ).

tff(fact_63_append__in__listsp__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys))
    <=> ( listsp(A,A1,Xs)
        & listsp(A,A1,Ys) ) ) ).

tff(fact_64_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys2: list(A),Y2: A,Xs1: list(A),X1: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys2)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),splice(A,Xs1,Ys2))) ) ).

tff(fact_65_append1__eq__conv,axiom,
    ! [A: $tType,Y1: A,Ys: list(A),X: A,Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A))) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),nil(A))) )
    <=> ( ( Xs = Ys )
        & ( X = Y1 ) ) ) ).

tff(fact_66_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs1: list(A),Ys2: list(A),Xs11: list(A),X1: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs11) = Ys2 )
     => ( ( Xs1 = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs11),Zs1) )
       => ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs1) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys2),Zs1) ) ) ) ).

tff(fact_67_append__Nil,axiom,
    ! [A: $tType,Ys2: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),nil(A)),Ys2) = Ys2 ) ).

tff(fact_68_append__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),nil(A)) = Xs1 ) ).

tff(fact_69_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys2: list(A),Xs1: list(A)] :
      ( ( Xs1 = Ys2 )
     => ( Xs1 = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),nil(A)),Ys2) ) ) ).

tff(fact_70_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs: list(A),Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs),Ts) )
    <=> ? [Us3: list(A)] :
          ( ( ( Xs = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs),Us3) )
            & ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Us3),Ys) = Ts ) )
          | ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Us3) = Zs )
            & ( Ys = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Us3),Ts) ) ) ) ) ).

tff(fact_71_append__eq__appendI,axiom,
    ! [A: $tType,Us2: list(A),Ys2: list(A),Zs1: list(A),Xs11: list(A),Xs1: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Xs11) = Zs1 )
     => ( ( Ys2 = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs11),Us2) )
       => ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys2) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs1),Us2) ) ) ) ).

tff(fact_72_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs: list(A),X: A,Zs: list(A),Ys: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),Zs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) )
    <=> ( ( ( Ys = nil(A) )
          & ( Zs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) ) )
        | ? [Ys3: list(A)] :
            ( ( Ys = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Ys3) )
            & ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys3),Zs) = Xs ) ) ) ) ).

tff(fact_73_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A),X: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),Zs) )
    <=> ( ( ( Ys = nil(A) )
          & ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs) = Zs ) )
        | ? [Ys3: list(A)] :
            ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Ys3) = Ys )
            & ( Xs = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys3),Zs) ) ) ) ) ).

tff(fact_74_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys2: list(A)] : ( splice(A,nil(A),Ys2) = Ys2 ) ).

tff(fact_77_rev__induct,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P1,nil(A)))
     => ( ! [X2: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P1,Xs2))
           => pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs2),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A))))) )
       => pp(aa(list(A),bool,P1,Xs)) ) ) ).

tff(fact_78_rev__cases,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ~ ! [Ys1: list(A),Y: A] : ( Xs1 != aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),nil(A))) ) ) ).

tff(fact_79_rev__exhaust2,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ~ ! [Ys1: list(A),Y: A] : ( Xs1 != aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),nil(A))) ) ) ).

tff(fact_80_rotate__simps,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X1: B] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xs1)) = aa(list(B),list(B),aa(list(B),fun(list(B),list(B)),append(B),Xs1),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),nil(B))) ) ) ).

tff(fact_81_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( rotate1(A,Xs) = nil(A) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_82_rotate1__def,axiom,
    ! [A: $tType,Xs: list(A)] : ( rotate1(A,Xs) = list_case(list(A),A,nil(A),aa(fun(A,list(A)),fun(A,fun(list(A),list(A))),aa(fun(list(A),fun(list(A),list(A))),fun(fun(A,list(A)),fun(A,fun(list(A),list(A)))),combb(list(A),fun(list(A),list(A)),A),combc(list(A),list(A),list(A),append(A))),aa(list(A),fun(A,list(A)),combc(A,list(A),list(A),cons(A)),nil(A))),Xs) ) ).

tff(fact_83_types__snoc,axiom,
    ! [Ta1: type,Ta: dB,Ts2: list(type),Ts: list(dB),Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,Ts),Ts2))
     => ( pp(aa(type,bool,typing(Eb,Ta),Ta1))
       => pp(aa(list(type),bool,typings(Eb,aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),Ts),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),Ta),nil(dB)))),aa(list(type),list(type),aa(list(type),fun(list(type),list(type)),append(type),Ts2),aa(list(type),list(type),aa(type,fun(list(type),list(type)),cons(type),Ta1),nil(type))))) ) ) ).

tff(fact_84_typings_Osimps_I1_J,axiom,
    ! [Ts2: list(type),Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,nil(dB)),Ts2))
    <=> ( Ts2 = nil(type) ) ) ).

tff(fact_85_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),Aa: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Aa),List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,Aa),List) ) ).

tff(fact_86_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_87_types__snoc__eq,axiom,
    ! [Ta1: type,Ts2: list(type),Ta: dB,Ts: list(dB),Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),Ts),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),Ta),nil(dB)))),aa(list(type),list(type),aa(list(type),fun(list(type),list(type)),append(type),Ts2),aa(list(type),list(type),aa(type,fun(list(type),list(type)),cons(type),Ta1),nil(type)))))
    <=> ( pp(aa(list(type),bool,typings(Eb,Ts),Ts2))
        & pp(aa(type,bool,typing(Eb,Ta),Ta1)) ) ) ).

tff(fact_88_types__snocE,axiom,
    ! [Ts2: list(type),Ta: dB,Ts: list(dB),Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),Ts),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),Ta),nil(dB)))),Ts2))
     => ~ ! [Us1: list(type),U: type] :
            ( ( Ts2 = aa(list(type),list(type),aa(list(type),fun(list(type),list(type)),append(type),Us1),aa(list(type),list(type),aa(type,fun(list(type),list(type)),cons(type),U),nil(type))) )
           => ( pp(aa(list(type),bool,typings(Eb,Ts),Us1))
             => ~ pp(aa(type,bool,typing(Eb,Ta),U)) ) ) ) ).

tff(fact_89_typings_Osimps_I2_J,axiom,
    ! [Ts2: list(type),Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(list(type),bool,typings(Eb,aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),Ta),Ts)),Ts2))
    <=> pp(list_case(bool,type,fFalse,aa(fun(list(type),bool),fun(type,fun(list(type),bool)),combc(type,fun(list(type),bool),fun(list(type),bool),aa(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool))),aa(fun(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool))),fun(fun(type,fun(bool,bool)),fun(type,fun(fun(list(type),bool),fun(list(type),bool)))),combb(fun(bool,bool),fun(fun(list(type),bool),fun(list(type),bool)),type),combb(bool,bool,list(type))),aa(fun(type,bool),fun(type,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(type,bool),fun(type,fun(bool,bool))),combb(bool,fun(bool,bool),type),fconj),typing(Eb,Ta)))),typings(Eb,Ts)),Ts2)) ) ).

tff(fact_90_list__app__typeI,axiom,
    ! [Ts: list(dB),Ta1: type,Ts2: list(type),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts2,Ta1)))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Ts2))
       => pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1)) ) ) ).

tff(fact_91_var__app__types,axiom,
    ! [Ua: type,Ts2: list(type),Ta1: type,Us: list(dB),Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,foldl(dB,dB,app,var(Ib),Ts),Us)),Ta1))
     => ( pp(aa(list(type),bool,typings(Eb,Ts),Ts2))
       => ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ua))
         => ? [Us1: list(type)] :
              ( ( Ua = foldr(type,type,fun1,Us1,Ta1) )
              & pp(aa(list(type),bool,typings(Eb,Us),Us1)) ) ) ) ) ).

tff(fact_92_foldr__append,axiom,
    ! [B: $tType,A: $tType,Aa: A,Ys: list(B),Xs: list(B),F: fun(B,fun(A,A))] : ( foldr(B,A,F,aa(list(B),list(B),aa(list(B),fun(list(B),list(B)),append(B),Xs),Ys),Aa) = foldr(B,A,F,Xs,foldr(B,A,F,Ys,Aa)) ) ).

tff(fact_93_foldr_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,F: fun(B,fun(A,A))] : ( foldr(B,A,F,nil(B),Aa) = Aa ) ).

tff(fact_94_foldr_Osimps_I2_J,axiom,
    ! [B: $tType,A: $tType,Aa: A,Xs: list(B),X: B,F: fun(B,fun(A,A))] : ( foldr(B,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X),Xs),Aa) = aa(A,A,aa(B,fun(A,A),F,X),foldr(B,A,F,Xs,Aa)) ) ).

tff(fact_95_var__app__typesE,axiom,
    ! [Ta1: type,Ts: list(dB),Ib: nat,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,var(Ib),Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,var(Ib)),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_96_list__app__typeE,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ~ ! [Ts1: list(type)] :
            ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts1,Ta1)))
           => ~ pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_97_list__app__typeD,axiom,
    ! [Ta1: type,Ts: list(dB),Ta: dB,Eb: fun(nat,type)] :
      ( pp(aa(type,bool,typing(Eb,foldl(dB,dB,app,Ta,Ts)),Ta1))
     => ? [Ts1: list(type)] :
          ( pp(aa(type,bool,typing(Eb,Ta),foldr(type,type,fun1,Ts1,Ta1)))
          & pp(aa(list(type),bool,typings(Eb,Ts),Ts1)) ) ) ).

tff(fact_98_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,F: fun(B,list(A))] : ( maps(B,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X),Xs)) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),aa(B,list(A),F,X)),maps(B,A,F,Xs)) ) ).

tff(fact_99_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

%----Helper facts (10)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    pp(aa(type,bool,typing(shift(type,e,i,t1),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,var(n)),a),as)),t)) ).

%------------------------------------------------------------------------------
