%------------------------------------------------------------------------------
% File     : LCL781_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 100
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_100 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  177 (  64 unt;  57 typ;   0 def)
%            Number of atoms       :  211 ( 121 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  120 (  29   ~;   7   |;   7   &)
%                                         (  17 <=>;  60  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   13 (   4 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   50 (  27   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   41 (  41 usr;  12 con; 0-5 aty)
%            Number of variables   :  339 ( 302   !;   1   ?; 339   :)
%                                         (  36  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:33
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (51)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(dB,fun(dB,T3)) * fun(dB,T3) * dB ) > T3 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omonoid__add__class_Olistsum,type,
    monoid_add_listsum: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: ( type * type ) > type ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(type,fun(type,T3)) * type ) > T3 ) ).

tff(sy_c_Type_Otype_Otype__rec,type,
    type_rec: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(type,fun(type,fun(T3,fun(T3,T3)))) * type ) > T3 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: fun(nat,type) > fun(dB,fun(type,bool)) ).

tff(sy_c_Type_Otypings,type,
    typings: ( fun(nat,type) * list(dB) * list(type) ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fEx,type,
    fEx: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T_H,type,
    t2: type ).

tff(sy_v_T____,type,
    t1: type ).

tff(sy_v_e,type,
    e: fun(nat,type) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_t____,type,
    t: dB ).

tff(sy_v_u,type,
    u: dB ).

%----Relevant facts (97)
tff(fact_0__096IT_At_096,axiom,
    pp(aa(dB,bool,it,t)) ).

tff(fact_1_MI1,axiom,
    ! [U2: dB,Ta: type,I: nat,E: fun(nat,type),Ta1: dB,T2: type,T11: type] :
      ( ( t1 = fun1(T11,T2) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,E,I,T11)),Ta1),Ta))
         => ( pp(aa(dB,bool,it,U2))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),U2),T11))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),U2),I))) ) ) ) ) ) ).

tff(fact_2_MI2,axiom,
    ! [U2: dB,Ta: type,I: nat,E: fun(nat,type),Ta1: dB,T2: type,T11: type] :
      ( ( t1 = fun1(T11,T2) )
     => ( pp(aa(dB,bool,it,Ta1))
       => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,E,I,T2)),Ta1),Ta))
         => ( pp(aa(dB,bool,it,U2))
           => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),U2),T2))
             => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),U2),I))) ) ) ) ) ) ).

tff(fact_3_subst__lemma,axiom,
    ! [I: nat,Ua: type,U2: dB,E1: fun(nat,type),Ta: type,Ta1: dB,E: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),Ta1),Ta))
     => ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E1),U2),Ua))
       => ( ( E = shift(type,E1,I,Ua) )
         => pp(aa(type,bool,aa(dB,fun(type,bool),typing(E1),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta1),U2),I)),Ta)) ) ) ) ).

tff(fact_4_shift__eq,axiom,
    ! [A: $tType,Ta: A,E: fun(nat,A),J1: nat,I: nat] :
      ( ( I = J1 )
     => ( aa(nat,A,shift(A,E,I,Ta),J1) = Ta ) ) ).

tff(fact_5_subst__Var__IT,axiom,
    ! [J: nat,I1: nat,R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),var(I1)),J))) ) ).

tff(fact_6_lift__type,axiom,
    ! [Ua: type,I: nat,Ta: type,Ta1: dB,E: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),Ta1),Ta))
     => pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,E,I,Ua)),aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta1),I)),Ta)) ) ).

tff(fact_7_lift__IT,axiom,
    ! [I1: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I1))) ) ).

tff(fact_8_substs__lemma,axiom,
    ! [Ts1: list(type),Ts: list(dB),I: nat,Ta: type,U2: dB,E: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),U2),Ta))
     => ( typings(shift(type,E,I,Ta),Ts,Ts1)
       => typings(E,map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,U2),I),Ts),Ts1) ) ) ).

tff(fact_9_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_10_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_11_typing_OVar,axiom,
    ! [Ta: type,X2: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X2) = Ta )
     => pp(aa(type,bool,aa(dB,fun(type,bool),typing(Env),var(X2)),Ta)) ) ).

tff(fact_12_typing__elims_I1_J,axiom,
    ! [Ta: type,I: nat,E: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),var(I)),Ta))
     => ( aa(nat,type,E,I) = Ta ) ) ).

tff(fact_13_type_Osimps_I2_J,axiom,
    ! [Type24: type,Type14: type,Type23: type,Type13: type] :
      ( ( fun1(Type13,Type23) = fun1(Type14,Type24) )
    <=> ( ( Type13 = Type14 )
        & ( Type23 = Type24 ) ) ) ).

tff(fact_14_lift__types,axiom,
    ! [Ua: type,I: nat,Ts1: list(type),Ts: list(dB),E: fun(nat,type)] :
      ( typings(E,Ts,Ts1)
     => typings(shift(type,E,I,Ua),map(dB,dB,combc(dB,nat,dB,lift,I),Ts),Ts1) ) ).

tff(fact_15_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_16_dB_Osimps_I3_J,axiom,
    ! [DB3: dB,DB1: dB] :
      ( ( abs(DB1) = abs(DB3) )
    <=> ( DB1 = DB3 ) ) ).

tff(fact_17_dB_Osimps_I1_J,axiom,
    ! [Nat4: nat,Nat3: nat] :
      ( ( var(Nat3) = var(Nat4) )
    <=> ( Nat3 = Nat4 ) ) ).

tff(fact_18_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S),K) = T ) ).

tff(fact_19_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U1),K) = U1 ) ).

tff(fact_20_dB_Osimps_I7_J,axiom,
    ! [Nat5: nat,DB2: dB] : ( abs(DB2) != var(Nat5) ) ).

tff(fact_21_dB_Osimps_I6_J,axiom,
    ! [DB2: dB,Nat5: nat] : ( var(Nat5) != abs(DB2) ) ).

tff(fact_22_Abs,axiom,
    ! [Ua: type,Ta1: dB,Ta: type,Env: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,Env,zero_zero(nat),Ta)),Ta1),Ua))
     => pp(aa(type,bool,aa(dB,fun(type,bool),typing(Env),abs(Ta1)),fun1(Ta,Ua))) ) ).

tff(fact_23_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type23: type,Type13: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,fun1(Type13,Type23)) = aa(type,A,aa(type,fun(type,A),F2,Type13),Type23) ) ).

tff(fact_24_typing__elims_I3_J,axiom,
    ! [Ta: type,Ta1: dB,E: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),abs(Ta1)),Ta))
     => ~ ! [T1: type,U: type] :
            ( ( Ta = fun1(T1,U) )
           => ~ pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,E,zero_zero(nat),T1)),Ta1),U)) ) ) ).

tff(fact_25_abs__typeE,axiom,
    ! [Ta: type,Ta1: dB,E: fun(nat,type)] :
      ( pp(aa(type,bool,aa(dB,fun(type,bool),typing(E),abs(Ta1)),Ta))
     => ~ ! [U: type,V: type] : ~ pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,E,zero_zero(nat),U)),Ta1),V)) ) ).

tff(fact_26_dB_Osize_I1_J,axiom,
    ! [Nat5: nat] : ( dB_size(var(Nat5)) = zero_zero(nat) ) ).

tff(fact_27_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_28_dB_Osize_I4_J,axiom,
    ! [Nat5: nat] : ( size_size(dB,var(Nat5)) = zero_zero(nat) ) ).

tff(fact_29_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_30_listsp__conj__eq,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,A3),B3),X3)
    <=> ( listsp(A,A3,X3)
        & listsp(A,B3,X3) ) ) ).

tff(fact_31_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_32_substn__subst__n,axiom,
    ! [N1: nat,S: dB,T: dB] : ( substn(T,S,N1) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N1,S,zero_zero(nat))),N1) ) ).

tff(fact_33_lists__typings,axiom,
    ! [Ts1: list(type),Ts: list(dB),E: fun(nat,type)] :
      ( typings(E,Ts,Ts1)
     => listsp(dB,combb(fun(type,bool),bool,dB,fEx(type),typing(E)),Ts) ) ).

tff(fact_34_type_Osimps_I5_J,axiom,
    ! [A: $tType,Nat3: nat,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,atom(Nat3)) = aa(nat,A,F1,Nat3) ) ).

tff(fact_35_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB1)) = aa(dB,A,F3,DB1) ) ).

tff(fact_36_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat3: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat3)) = aa(nat,A,F1,Nat3) ) ).

tff(fact_37_type_Orecs_I2_J,axiom,
    ! [A: $tType,Type23: type,Type13: type,F2: fun(type,fun(type,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( type_rec(A,F1,F2,fun1(Type13,Type23)) = aa(A,A,aa(A,fun(A,A),aa(type,fun(A,fun(A,A)),aa(type,fun(type,fun(A,fun(A,A))),F2,Type13),Type23),type_rec(A,F1,F2,Type13)),type_rec(A,F1,F2,Type23)) ) ).

tff(fact_38_type_Osimps_I1_J,axiom,
    ! [Nat4: nat,Nat3: nat] :
      ( ( atom(Nat3) = atom(Nat4) )
    <=> ( Nat3 = Nat4 ) ) ).

tff(fact_39_type_Orecs_I1_J,axiom,
    ! [A: $tType,Nat3: nat,F2: fun(type,fun(type,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( type_rec(A,F1,F2,atom(Nat3)) = aa(nat,A,F1,Nat3) ) ).

tff(fact_40_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_41_type_Osimps_I4_J,axiom,
    ! [Nat5: nat,Type22: type,Type12: type] : ( fun1(Type12,Type22) != atom(Nat5) ) ).

tff(fact_42_type_Osimps_I3_J,axiom,
    ! [Type22: type,Type12: type,Nat5: nat] : ( atom(Nat5) != fun1(Type12,Type22) ) ).

tff(fact_43_type_Osize_I1_J,axiom,
    ! [Nat5: nat] : ( type_size(atom(Nat5)) = zero_zero(nat) ) ).

tff(fact_44_type_Osize_I3_J,axiom,
    ! [Nat5: nat] : ( size_size(type,atom(Nat5)) = zero_zero(nat) ) ).

tff(fact_45_type_Oexhaust,axiom,
    ! [Y: type] :
      ( ! [Nat: nat] : ( Y != atom(Nat) )
     => ~ ! [Type11: type,Type21: type] : ( Y != fun1(Type11,Type21) ) ) ).

tff(fact_46_listsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(B)] : ( monoid_add_listsum(A,map(B,A,combk(A,B,zero_zero(A)),Xs)) = zero_zero(A) ) ) ).

tff(fact_47_liftn__lift,axiom,
    ! [K: nat,T: dB,N1: nat] : ( liftn(suc(N1),T,K) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N1,T,K)),K) ) ).

tff(fact_48_shift__commute,axiom,
    ! [A: $tType,Ta: A,Ua: A,I: nat,E: fun(nat,A)] : ( shift(A,shift(A,E,I,Ua),zero_zero(nat),Ta) = shift(A,shift(A,E,zero_zero(nat),Ta),suc(I),Ua) ) ).

tff(fact_49_nat_Oinject,axiom,
    ! [Nat4: nat,Nat3: nat] :
      ( ( suc(Nat3) = suc(Nat4) )
    <=> ( Nat3 = Nat4 ) ) ).

tff(fact_50_Zero__not__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_51_nat_Osimps_I2_J,axiom,
    ! [Nat2: nat] : ( zero_zero(nat) != suc(Nat2) ) ).

tff(fact_52_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_53_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_54_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_55_Suc__neq__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_56_Zero__neq__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_57_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( suc(Nat1) != zero_zero(nat) ) ).

tff(fact_58_Suc__not__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_59_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat: nat] : ( Y != suc(Nat) ) ) ).

tff(fact_60_zero__induct,axiom,
    ! [K1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K1))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,suc(N2)))
           => pp(aa(nat,bool,P1,N2)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_61_nat__induct,axiom,
    ! [N: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,N2))
           => pp(aa(nat,bool,P1,suc(N2))) )
       => pp(aa(nat,bool,P1,N)) ) ) ).

tff(fact_62_not0__implies__Suc,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ? [M2: nat] : ( N1 = suc(M2) ) ) ).

tff(fact_63_type_Osize_I2_J,axiom,
    ! [Type2: type,Type1: type] : ( type_size(fun1(Type1,Type2)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),type_size(Type1)),type_size(Type2))),suc(zero_zero(nat))) ) ).

tff(fact_64_type_Osize_I4_J,axiom,
    ! [Type2: type,Type1: type] : ( size_size(type,fun1(Type1,Type2)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),size_size(type,Type1)),size_size(type,Type2))),suc(zero_zero(nat))) ) ).

tff(fact_65_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),dB_size(DB)),suc(zero_zero(nat))) ) ).

tff(fact_66_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B1: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C2) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_67_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A1: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C2),A1) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_68_nat__add__left__cancel,axiom,
    ! [N: nat,M: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),M) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),N) )
    <=> ( M = N ) ) ).

tff(fact_69_nat__add__right__cancel,axiom,
    ! [N: nat,K1: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K1) )
    <=> ( M = N ) ) ).

tff(fact_70_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_71_add__is__0,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_72_add__Suc,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M1)),N1) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1)) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_74_add__Suc__right,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),suc(N1)) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1)) ) ).

tff(fact_75_dB_Osize_I6_J,axiom,
    ! [DB: dB] : ( size_size(dB,abs(DB)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),size_size(dB,DB)),suc(zero_zero(nat))) ) ).

tff(fact_76_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_77_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_78_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_79_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A2) )
         => ( B2 = C1 ) ) ) ).

tff(fact_80_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_81_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_82_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_83_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_84_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),M1) ) ).

tff(fact_85_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X),Z)) ) ).

tff(fact_86_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K)) ) ).

tff(fact_87_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N1) = N1 ) ).

tff(fact_88_Nat_Oadd__0__right,axiom,
    ! [M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),zero_zero(nat)) = M1 ) ).

tff(fact_89_add__eq__self__zero,axiom,
    ! [N1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1) = M1 )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_90_add__Suc__shift,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M1)),N1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),suc(N1)) ) ).

tff(fact_91_one__is__add,axiom,
    ! [N: nat,M: nat] :
      ( ( suc(zero_zero(nat)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_92_add__is__1,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = suc(zero_zero(nat)) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_93_listsum__addf,axiom,
    ! [A: $tType,B: $tType] :
      ( comm_monoid_add(A)
     => ! [Xs: list(B),G: fun(B,A),F: fun(B,A)] : ( monoid_add_listsum(A,map(B,A,combs(B,A,A,combb(A,fun(A,A),B,plus_plus(A),F),G),Xs)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),monoid_add_listsum(A,map(B,A,F,Xs))),monoid_add_listsum(A,map(B,A,G,Xs))) ) ) ).

tff(fact_94_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_95_subst__Abs,axiom,
    ! [K: nat,S: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,abs(T)),S),K) = abs(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),aa(nat,dB,aa(dB,fun(nat,dB),lift,S),zero_zero(nat))),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),one_one(nat)))) ) ).

tff(fact_96_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [A1: A,B1: A] :
          ( ( B1 = aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

%----Arities (8)
tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (11)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fEx_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(A,bool,P,X))
      | pp(aa(fun(A,bool),bool,fEx(A),P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (4)
tff(conj_0,hypothesis,
    pp(aa(type,bool,aa(dB,fun(type,bool),typing(shift(type,e,i,t1)),t),t2)) ).

tff(conj_1,hypothesis,
    pp(aa(dB,bool,it,u)) ).

tff(conj_2,hypothesis,
    pp(aa(type,bool,aa(dB,fun(type,bool),typing(e),u),t1)) ).

tff(conj_3,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,t),u),i))) ).

%------------------------------------------------------------------------------
