%------------------------------------------------------------------------------
% File     : LCL780_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 94
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_94 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  167 (  52 unt;  47 typ;   0 def)
%            Number of atoms       :  235 (  89 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  147 (  32   ~;   2   |;   8   &)
%                                         (  34 <=>;  71  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    6 (   5 usr)
%            Number of type conns  :   51 (  26   >;  25   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   30 (  30 usr;   8 con; 0-5 aty)
%            Number of variables   :  261 ( 239   !;   2   ?; 261   :)
%                                         (  20  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:31
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (41)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Int_Onat,type,
    nat1: int > nat ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(dB,fun(dB,T4)) * fun(dB,T4) * dB ) > T4 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OAtom,type,
    atom: nat > type ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: ( type * type ) > type ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,T4)) * type ) > T4 ) ).

tff(sy_c_Type_Otype_Otype__rec,type,
    type_rec: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(type,fun(type,fun(T4,fun(T4,T4)))) * type ) > T4 ) ).

tff(sy_c_Type_Otype_Otype__size,type,
    type_size: type > nat ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_T,type,
    t1: type ).

tff(sy_v_U,type,
    u1: type ).

tff(sy_v_e,type,
    e: fun(nat,type) ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_t,type,
    t: dB ).

tff(sy_v_u,type,
    u: dB ).

%----Relevant facts (99)
tff(fact_0_subst__lemma,axiom,
    ! [I: nat,Ua: type,U2: dB,E1: fun(nat,type),T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,T1,T2)
     => ( typing(E1,U2,Ua)
       => ( ( E = shift(type,E1,I,Ua) )
         => typing(E1,subst(T1,U2,I),T2) ) ) ) ).

tff(fact_1_shift__eq,axiom,
    ! [A: $tType,T2: A,E: fun(nat,A),J1: nat,I: nat] :
      ( ( I = J1 )
     => ( aa(nat,A,shift(A,E,I,T2),J1) = T2 ) ) ).

tff(fact_2_subst__Var__IT,axiom,
    ! [J: nat,I1: nat,R: dB] :
      ( it(R)
     => it(subst(R,var(I1),J)) ) ).

tff(fact_3_lift__type,axiom,
    ! [Ua: type,I: nat,T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,T1,T2)
     => typing(shift(type,E,I,Ua),lift(T1,I),T2) ) ).

tff(fact_4_lift__IT,axiom,
    ! [I1: nat,T: dB] :
      ( it(T)
     => it(lift(T,I1)) ) ).

tff(fact_5_Var__IT,axiom,
    ! [N2: nat] : it(var(N2)) ).

tff(fact_6_Lambda,axiom,
    ! [R: dB] :
      ( it(R)
     => it(abs(R)) ) ).

tff(fact_7_typing_OVar,axiom,
    ! [T2: type,X1: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X1) = T2 )
     => typing(Env,var(X1),T2) ) ).

tff(fact_8_typing__elims_I1_J,axiom,
    ! [T2: type,I: nat,E: fun(nat,type)] :
      ( typing(E,var(I),T2)
     => ( aa(nat,type,E,I) = T2 ) ) ).

tff(fact_9_abs__typeE,axiom,
    ! [T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,abs(T1),T2)
     => ~ ! [U: type,V: type] : ~ typing(shift(type,E,zero_zero(nat),U),T1,V) ) ).

tff(fact_10_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( subst(lift(T,K),S,K) = T ) ).

tff(fact_11_shift__gt,axiom,
    ! [A: $tType,T2: A,E: fun(nat,A),I: nat,J1: nat] :
      ( ord_less(nat,J1,I)
     => ( aa(nat,A,shift(A,E,I,T2),J1) = aa(nat,A,E,J1) ) ) ).

tff(fact_12_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_13_dB_Osimps_I3_J,axiom,
    ! [DB2: dB,DB: dB] :
      ( ( abs(DB) = abs(DB2) )
    <=> ( DB = DB2 ) ) ).

tff(fact_14_dB_Osimps_I7_J,axiom,
    ! [Nat1: nat,DB1: dB] : ( abs(DB1) != var(Nat1) ) ).

tff(fact_15_dB_Osimps_I6_J,axiom,
    ! [DB1: dB,Nat1: nat] : ( var(Nat1) != abs(DB1) ) ).

tff(fact_16_subst__lt,axiom,
    ! [U1: dB,I1: nat,J: nat] :
      ( ord_less(nat,J,I1)
     => ( subst(var(J),U1,I1) = var(J) ) ) ).

tff(fact_17_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( subst(var(K),U1,K) = U1 ) ).

tff(fact_18_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_19_less__nat__zero__code,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_20_less__zeroE,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_21_Abs,axiom,
    ! [Ua: type,T1: dB,T2: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),T2),T1,Ua)
     => typing(Env,abs(T1),fun1(T2,Ua)) ) ).

tff(fact_22_dB_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( dB_size(var(Nat1)) = zero_zero(nat) ) ).

tff(fact_23_not__less0,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_24_gr__implies__not0,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,M2,N2)
     => ( N2 != zero_zero(nat) ) ) ).

tff(fact_25_gr0I,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N2) ) ).

tff(fact_26_type_Osimps_I2_J,axiom,
    ! [Type23: type,Type13: type,Type22: type,Type12: type] :
      ( ( fun1(Type12,Type22) = fun1(Type13,Type23) )
    <=> ( ( Type12 = Type13 )
        & ( Type22 = Type23 ) ) ) ).

tff(fact_27_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_28_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N: nat,M: nat] :
      ( ( ord_less(nat,M,N)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
     => ( ( ( M = N )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
       => ( ( ord_less(nat,N,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N),M)) ) ) ) ).

tff(fact_29_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_30_less__not__refl2,axiom,
    ! [M2: nat,N2: nat] :
      ( ord_less(nat,N2,M2)
     => ( M2 != N2 ) ) ).

tff(fact_31_less__irrefl__nat,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_32_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_33_nat__neq__iff,axiom,
    ! [N: nat,M: nat] :
      ( ( M != N )
    <=> ( ord_less(nat,M,N)
        | ord_less(nat,N,M) ) ) ).

tff(fact_34_less__not__refl,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_35_typing__elims_I3_J,axiom,
    ! [T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,abs(T1),T2)
     => ~ ! [T3: type,U: type] :
            ( ( T2 = fun1(T3,U) )
           => ~ typing(shift(type,E,zero_zero(nat),T3),T1,U) ) ) ).

tff(fact_36_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,fun1(Type12,Type22)) = aa(type,A,aa(type,fun(type,A),F2,Type12),Type22) ) ).

tff(fact_37_dB_Osize_I4_J,axiom,
    ! [Nat1: nat] : ( size_size(dB,var(Nat1)) = zero_zero(nat) ) ).

tff(fact_38_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,N))
        <=> ord_less(nat,zero_zero(nat),N) ) ) ).

tff(fact_39_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = subst(T,S,zero_zero(nat)) ) ).

tff(fact_40_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_41_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N: nat,M: nat] :
          ( ( semiring_1_of_nat(A,M) = semiring_1_of_nat(A,N) )
        <=> ( M = N ) ) ) ).

tff(fact_42_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_43_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N))
        <=> ord_less(nat,M,N) ) ) ).

tff(fact_44_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M2: nat] : ~ ord_less(A,semiring_1_of_nat(A,M2),zero_zero(A)) ) ).

tff(fact_45_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N2: nat,M2: nat] :
          ( ord_less(nat,M2,N2)
         => ord_less(A,semiring_1_of_nat(A,M2),semiring_1_of_nat(A,N2)) ) ) ).

tff(fact_46_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N2: nat,M2: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M2),semiring_1_of_nat(A,N2))
         => ord_less(nat,M2,N2) ) ) ).

tff(fact_47_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_48_substn__subst__n,axiom,
    ! [N2: nat,S: dB,T: dB] : ( substn(T,S,N2) = subst(T,liftn(N2,S,zero_zero(nat)),N2) ) ).

tff(fact_49_zero__less__int__conv,axiom,
    ! [N: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,N))
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_50_type_Osimps_I5_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_51_infinite__descent0,axiom,
    ! [N: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N3: nat] :
            ( ord_less(nat,zero_zero(nat),N3)
           => ( ~ pp(aa(nat,bool,P1,N3))
             => ? [M1: nat] :
                  ( ord_less(nat,M1,N3)
                  & ~ pp(aa(nat,bool,P1,M1)) ) ) )
       => pp(aa(nat,bool,P1,N)) ) ) ).

tff(fact_52_type_Orecs_I2_J,axiom,
    ! [A: $tType,Type22: type,Type12: type,F2: fun(type,fun(type,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( type_rec(A,F1,F2,fun1(Type12,Type22)) = aa(A,A,aa(A,fun(A,A),aa(type,fun(A,fun(A,A)),aa(type,fun(type,fun(A,fun(A,A))),F2,Type12),Type22),type_rec(A,F1,F2,Type12)),type_rec(A,F1,F2,Type22)) ) ).

tff(fact_53_type_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( atom(Nat2) = atom(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_54_int__less__0__conv,axiom,
    ! [K: nat] : ~ ord_less(int,semiring_1_of_nat(int,K),zero_zero(int)) ).

tff(fact_55_int__int__eq,axiom,
    ! [N: nat,M: nat] :
      ( ( semiring_1_of_nat(int,M) = semiring_1_of_nat(int,N) )
    <=> ( M = N ) ) ).

tff(fact_56_type_Orecs_I1_J,axiom,
    ! [A: $tType,Nat2: nat,F2: fun(type,fun(type,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( type_rec(A,F1,F2,atom(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_57_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_58_type_Osimps_I3_J,axiom,
    ! [Type21: type,Type11: type,Nat1: nat] : ( atom(Nat1) != fun1(Type11,Type21) ) ).

tff(fact_59_type_Osimps_I4_J,axiom,
    ! [Nat1: nat,Type21: type,Type11: type] : ( fun1(Type11,Type21) != atom(Nat1) ) ).

tff(fact_60_int__eq__0__conv,axiom,
    ! [N: nat] :
      ( ( semiring_1_of_nat(int,N) = zero_zero(int) )
    <=> ( N = zero_zero(nat) ) ) ).

tff(fact_61_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_62_zless__int,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N))
    <=> ord_less(nat,M,N) ) ).

tff(fact_63_zero__less__imp__eq__int,axiom,
    ! [K: int] :
      ( ord_less(int,zero_zero(int),K)
     => ? [N3: nat] :
          ( ord_less(nat,zero_zero(nat),N3)
          & ( K = semiring_1_of_nat(int,N3) ) ) ) ).

tff(fact_64_type_Osize_I1_J,axiom,
    ! [Nat1: nat] : ( type_size(atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_65_transfer__int__nat__relations_I2_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less(nat,X1,Y1) ) ).

tff(fact_66_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

tff(fact_67_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) ) ) ).

tff(fact_68_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_69_type_Osize_I3_J,axiom,
    ! [Nat1: nat] : ( size_size(type,atom(Nat1)) = zero_zero(nat) ) ).

tff(fact_70_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less(int,zero_zero(int),Z) ) ) ).

tff(fact_71_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less(int,Z,zero_zero(int)) ) ) ).

tff(fact_72_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W: int] :
          ( ( ring_1_of_int(A,W) = ring_1_of_int(A,Z) )
        <=> ( W = Z ) ) ) ).

tff(fact_73_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_76_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( ring_1_of_int(A,Z) = zero_zero(A) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_77_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int,W: int] :
          ( ord_less(A,ring_1_of_int(A,W),ring_1_of_int(A,Z))
        <=> ord_less(int,W,Z) ) ) ).

tff(fact_78_of__int__of__nat__eq,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [N2: nat] : ( ring_1_of_int(A,semiring_1_of_nat(int,N2)) = semiring_1_of_nat(A,N2) ) ) ).

tff(fact_79_of__int__int__eq,axiom,
    ! [N2: nat] : ( ring_1_of_int(int,semiring_1_of_nat(int,N2)) = semiring_1_of_nat(int,N2) ) ).

tff(fact_80_type_Oexhaust,axiom,
    ! [Y: type] :
      ( ! [Nat: nat] : ( Y != atom(Nat) )
     => ~ ! [Type1: type,Type2: type] : ( Y != fun1(Type1,Type2) ) ) ).

tff(fact_81_zero__less__nat__eq,axiom,
    ! [Z: int] :
      ( ord_less(nat,zero_zero(nat),nat1(Z))
    <=> ord_less(int,zero_zero(int),Z) ) ).

tff(fact_82_nat__0,axiom,
    nat1(zero_zero(int)) = zero_zero(nat) ).

tff(fact_83_zless__nat__conj,axiom,
    ! [Z: int,W: int] :
      ( ord_less(nat,nat1(W),nat1(Z))
    <=> ( ord_less(int,zero_zero(int),Z)
        & ord_less(int,W,Z) ) ) ).

tff(fact_84_nat__int,axiom,
    ! [N2: nat] : ( nat1(semiring_1_of_nat(int,N2)) = N2 ) ).

tff(fact_85_nat__if__cong,axiom,
    ! [Y1: int,X1: int,P1: bool] :
      ( ( pp(P1)
       => ( nat1(X1) = nat1(if(int,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( nat1(Y1) = nat1(if(int,P1,X1,Y1)) ) ) ) ).

tff(fact_86_transfer__nat__int__numerals_I1_J,axiom,
    zero_zero(nat) = nat1(zero_zero(int)) ).

tff(fact_87_nat__mono__iff,axiom,
    ! [W: int,Z: int] :
      ( ord_less(int,zero_zero(int),Z)
     => ( ord_less(nat,nat1(W),nat1(Z))
      <=> ord_less(int,W,Z) ) ) ).

tff(fact_88_zless__nat__eq__int__zless,axiom,
    ! [Z: int,M: nat] :
      ( ord_less(nat,M,nat1(Z))
    <=> ord_less(int,semiring_1_of_nat(int,M),Z) ) ).

tff(fact_89_split__nat,axiom,
    ! [I: int,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,nat1(I)))
    <=> ( ! [N1: nat] :
            ( ( I = semiring_1_of_nat(int,N1) )
           => pp(aa(nat,bool,P1,N1)) )
        & ( ord_less(int,I,zero_zero(int))
         => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ) ).

tff(fact_90_nat__less__iff,axiom,
    ! [M: nat,W: int] :
      ( ord_less_eq(int,zero_zero(int),W)
     => ( ord_less(nat,nat1(W),M)
      <=> ord_less(int,W,semiring_1_of_nat(int,M)) ) ) ).

tff(fact_91_of__nat__nat,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [Z2: int] :
          ( ord_less_eq(int,zero_zero(int),Z2)
         => ( semiring_1_of_nat(A,nat1(Z2)) = ring_1_of_int(A,Z2) ) ) ) ).

tff(fact_92_of__nat__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less_eq(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N))
        <=> ord_less_eq(nat,M,N) ) ) ).

tff(fact_93_of__int__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int,W: int] :
          ( ord_less_eq(A,ring_1_of_int(A,W),ring_1_of_int(A,Z))
        <=> ord_less_eq(int,W,Z) ) ) ).

tff(fact_94_nat__0__iff,axiom,
    ! [I: int] :
      ( ( nat1(I) = zero_zero(nat) )
    <=> ord_less_eq(int,I,zero_zero(int)) ) ).

tff(fact_95_int__nat__eq,axiom,
    ! [Z2: int] :
      ( ( ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = Z2 ) )
      & ( ~ ord_less_eq(int,zero_zero(int),Z2)
       => ( semiring_1_of_nat(int,nat1(Z2)) = zero_zero(int) ) ) ) ).

tff(fact_96_of__int__0__le__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less_eq(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less_eq(int,zero_zero(int),Z) ) ) ).

tff(fact_97_of__int__le__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less_eq(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less_eq(int,Z,zero_zero(int)) ) ) ).

tff(fact_98_eq__nat__nat__iff,axiom,
    ! [Z1: int,Z: int] :
      ( ord_less_eq(int,zero_zero(int),Z)
     => ( ord_less_eq(int,zero_zero(int),Z1)
       => ( ( nat1(Z) = nat1(Z1) )
        <=> ( Z = Z1 ) ) ) ) ).

%----Arities (11)
tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    it(t) ).

tff(conj_1,hypothesis,
    typing(shift(type,e,i,u1),t,t1) ).

tff(conj_2,hypothesis,
    it(u) ).

tff(conj_3,hypothesis,
    typing(e,u,u1) ).

tff(conj_4,conjecture,
    it(subst(t,u,i)) ).

%------------------------------------------------------------------------------
