%------------------------------------------------------------------------------
% File     : LCL779_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 84
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_84 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  146 (  53 unt;  39 typ;   0 def)
%            Number of atoms       :  223 ( 152 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  156 (  40   ~;   9   |;  32   &)
%                                         (  30 <=>;  45  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   51 (  24   >;  27   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-4 aty)
%            Number of functors    :   30 (  30 usr;   9 con; 0-5 aty)
%            Number of variables   :  385 ( 344   !;  19   ?; 385   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:29
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,T2)) * fun(dB,T2) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),T2)) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),fun(T2,T2))) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_r,type,
    r: dB ).

tff(sy_v_s,type,
    s: dB ).

tff(sy_v_ss,type,
    ss: list(dB) ).

%----Relevant facts (99)
tff(fact_0_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_1_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,subst(R2,var(I),J))) ) ).

tff(fact_2_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss2: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss2) )
    <=> ( ( M = N )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_3_subst__App,axiom,
    ! [K: nat,S2: dB,U1: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S2,K)),subst(U1,S2,K)) ) ).

tff(fact_4_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_5_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat3) )
    <=> ( Nat = Nat3 ) ) ).

tff(fact_6_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB1 = DB14 )
        & ( DB2 = DB24 ) ) ) ).

tff(fact_7_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( subst(var(K),U1,K) = U1 ) ).

tff(fact_8_dB_Osimps_I4_J,axiom,
    ! [DB23: dB,DB13: dB,Nat2: nat] : ( var(Nat2) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_9_dB_Osimps_I5_J,axiom,
    ! [Nat2: nat,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != var(Nat2) ) ).

tff(fact_10_Beta,axiom,
    ! [Ss2: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss2)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss2))) ) ) ).

tff(fact_11_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_12_dB_Osize_I1_J,axiom,
    ! [Nat2: nat] : ( dB_size(var(Nat2)) = zero_zero(nat) ) ).

tff(fact_13_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB: dB] :
      ( ( abs(DB) = abs(DB5) )
    <=> ( DB = DB5 ) ) ).

tff(fact_14_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_15_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss2) )
    <=> ( ( R = S )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_16_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != abs(DB4) ) ).

tff(fact_17_dB_Osimps_I9_J,axiom,
    ! [DB22: dB,DB12: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_18_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat2: nat] : ( var(Nat2) != abs(DB4) ) ).

tff(fact_19_dB_Osimps_I7_J,axiom,
    ! [Nat2: nat,DB4: dB] : ( abs(DB4) != var(Nat2) ) ).

tff(fact_20_Var__apps__neq__Abs__apps,axiom,
    ! [Ss2: list(dB),R: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R),Ss2) ) ).

tff(fact_21_Abs__App__neq__Var__apps,axiom,
    ! [Ss2: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss2) ) ).

tff(fact_22_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_23_IT_Osimps,axiom,
    ! [A2: dB] :
      ( pp(aa(dB,bool,it,A2))
    <=> ( ? [Rs2: list(dB),N3: nat] :
            ( ( A2 = foldl(dB,dB,app,var(N3),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R3: dB] :
            ( ( A2 = abs(R3) )
            & pp(aa(dB,bool,it,R3)) )
        | ? [R3: dB,S3: dB,Ss: list(dB)] :
            ( ( A2 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R3)),S3),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R3,S3,zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_24_beta,axiom,
    ! [T1: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T1)),subst(S2,T1,zero_zero(nat)))) ).

tff(fact_25_dB_Osize_I4_J,axiom,
    ! [Nat2: nat] : ( size_size(dB,var(Nat2)) = zero_zero(nat) ) ).

tff(fact_26_substn__subst__0,axiom,
    ! [S2: dB,T1: dB] : ( substn(T1,S2,zero_zero(nat)) = subst(T1,S2,zero_zero(nat)) ) ).

tff(fact_27_apps__eq__Abs__conv,axiom,
    ! [R: dB,Ss2: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss2) = abs(R) )
    <=> ( ( S = abs(R) )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_28_Abs__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,R: dB] :
      ( ( abs(R) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( abs(R) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_29_Var__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( var(M) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_30_dB_Oexhaust,axiom,
    ! [Y3: dB] :
      ( ! [Nat1: nat] : ( Y3 != var(Nat1) )
     => ( ! [DB11: dB,DB21: dB] : ( Y3 != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) )
       => ~ ! [DB3: dB] : ( Y3 != abs(DB3) ) ) ) ).

tff(fact_31_ex__head__tail,axiom,
    ! [Ta: dB] :
    ? [Ts1: list(dB),H: dB] :
      ( ( Ta = foldl(dB,dB,app,H,Ts1) )
      & ( ? [N2: nat] : ( H = var(N2) )
        | ? [U: dB] : ( H = abs(U) ) ) ) ).

tff(fact_32_appL,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1))) ) ).

tff(fact_33_appR,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S2)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T1))) ) ).

tff(fact_34_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T1)) ).

tff(fact_35_abs,axiom,
    ! [T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S2)),abs(T1))) ) ).

tff(fact_36_substn_Osimps_I2_J,axiom,
    ! [K: nat,S2: dB,U1: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S2,K)),substn(U1,S2,K)) ) ).

tff(fact_37_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S2: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R2,T1,I)),subst(S2,T1,I))) ) ).

tff(fact_38_beta__cases_I2_J,axiom,
    ! [S2: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R2)),S2))
     => ~ ! [T: dB] :
            ( ( S2 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),T)) ) ) ).

tff(fact_39_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_40_apps__preserves__beta,axiom,
    ! [Ss2: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Ss2)),foldl(dB,dB,app,S,Ss2))) ) ).

tff(fact_41_substn__subst__n,axiom,
    ! [N1: nat,S2: dB,T1: dB] : ( substn(T1,S2,N1) = subst(T1,liftn(N1,S2,zero_zero(nat)),N1) ) ).

tff(fact_42_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1)),U1))
     => ( ! [S1: dB] :
            ( ( U1 = subst(S1,T1,zero_zero(nat)) )
           => ( S2 != abs(S1) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_43_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,nil(B)) = A2 ) ).

tff(fact_44_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S2: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S2,K)),liftn(N1,T1,K)) ) ).

tff(fact_45_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_46_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y1: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X2)),Y1) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y1)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X),Xs) ) ) ).

tff(fact_47_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_48_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_49_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_50_apps__preserves__betas,axiom,
    ! [R: dB,Ss2: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss2)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),foldl(dB,dB,app,R,Ss2))) ) ).

tff(fact_51_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V))
     => ? [Ss1: list(dB)] :
          ( step1(dB,beta,Rs,Ss1)
          & ( V = foldl(dB,dB,app,var(N),Ss1) ) ) ) ).

tff(fact_52_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_53_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_54_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_55_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),R: fun(A,fun(A,bool))] : ~ step1(A,R,nil(A),Xs) ).

tff(fact_56_not__step1__Nil,axiom,
    ! [A: $tType,Xs: list(A),R: fun(A,fun(A,bool))] : ~ step1(A,R,Xs,nil(A)) ).

tff(fact_57_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,R,Rs1) ) )
         => ~ ! [T: dB] :
                ( ( R = abs(T) )
               => ! [U: dB,Us3: list(dB)] :
                    ( ( Rs = cons(dB,U,Us3) )
                   => ( S != foldl(dB,dB,app,subst(T,U,zero_zero(nat)),Us3) ) ) ) ) ) ) ).

tff(fact_58_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_59_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List1: list(A),A2: A] :
      ( ( cons(A,A2,List1) = cons(A,A6,List3) )
    <=> ( ( A2 = A6 )
        & ( List1 = List3 ) ) ) ).

tff(fact_60_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),Y: A,R: fun(A,fun(A,bool))] :
      ( step1(A,R,cons(A,Y,Ys),cons(A,X,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R,Y),X))
          & ( Xs = Ys ) )
        | ( ( X = Y )
          & step1(A,R,Ys,Xs) ) ) ) ).

tff(fact_61_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( cons(A,A5,List2) != nil(A) ) ).

tff(fact_62_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != cons(A,A5,List2) ) ).

tff(fact_63_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,cons(B,X,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A2),X),Xs) ) ).

tff(fact_64_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != cons(A,X1,Xs1) ) ).

tff(fact_65_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( cons(A,X1,Xs1) != Xs1 ) ).

tff(fact_66_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A2: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,A2,List1)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A2),List1),list_rec(A,B,F1,F2,List1)) ) ).

tff(fact_67_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A2,List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List1) ) ).

tff(fact_68_listsp_Osimps,axiom,
    ! [A: $tType,A2: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,A2)
    <=> ( ( A2 = nil(A) )
        | ? [A4: A,L: list(A)] :
            ( ( A2 = cons(A,A4,L) )
            & pp(aa(A,bool,A1,A4))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_69_list_Oexhaust,axiom,
    ! [A: $tType,Y3: list(A)] :
      ( ( Y3 != nil(A) )
     => ~ ! [A3: A,List: list(A)] : ( Y3 != cons(A,A3,List) ) ) ).

tff(fact_70_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y2: A,Ys3: list(A)] : ( Xs = cons(A,Y2,Ys3) ) ) ).

tff(fact_71_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys: list(A),R: fun(A,fun(A,bool))] :
      ( step1(A,R,Ys,cons(A,X,Xs))
     => ( ! [Y1: A] :
            ( ( Ys = cons(A,Y1,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),R,Y1),X)) )
       => ~ ! [Zs2: list(A)] :
              ( ( Ys = cons(A,X,Zs2) )
             => ~ step1(A,R,Zs2,Xs) ) ) ) ).

tff(fact_72_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_73_sublist__singleton,axiom,
    ! [A: $tType,X: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X,nil(A)),A1) = cons(A,X,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( member(A,X,A1)
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_76_App__eq__foldl__conv,axiom,
    ! [Ts: list(dB),Ta: dB,S: dB,R: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = foldl(dB,dB,app,Ta,Ts) )
    <=> ( ( ( Ts = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = Ta ) )
        & ( ( Ts != nil(dB) )
         => ? [Ss: list(dB)] :
              ( ( Ts = append(dB,Ss,cons(dB,S,nil(dB))) )
              & ( R = foldl(dB,dB,app,Ta,Ss) ) ) ) ) ) ).

tff(fact_77_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Xs) = append(A,Zs,Xs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_78_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = append(A,Xs,Zs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_79_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys2: list(A),Xs1: list(A)] : ( append(A,append(A,Xs1,Ys2),Zs1) = append(A,Xs1,append(A,Ys2,Zs1)) ) ).

tff(fact_80_append__Cons,axiom,
    ! [A: $tType,Ys2: list(A),Xs1: list(A),X1: A] : ( append(A,cons(A,X1,Xs1),Ys2) = cons(A,X1,append(A,Xs1,Ys2)) ) ).

tff(fact_81_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( nil(A) = append(A,Xs,Ys) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_82_self__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = append(A,Xs,Ys) )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_83_self__append__conv2,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( Ys = append(A,Xs,Ys) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_84_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = nil(A) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_85_append__self__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = Xs )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_86_append__self__conv2,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = Ys )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_87_foldl__append,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Xs: list(B),A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,append(B,Xs,Ys)) = foldl(A,B,F,foldl(A,B,F,A2,Xs),Ys) ) ).

tff(fact_88_append__in__listsp__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,append(A,Xs,Ys))
    <=> ( listsp(A,A1,Xs)
        & listsp(A,A1,Ys) ) ) ).

tff(fact_89_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_90_append1__eq__conv,axiom,
    ! [A: $tType,Y: A,Ys: list(A),X: A,Xs: list(A)] :
      ( ( append(A,Xs,cons(A,X,nil(A))) = append(A,Ys,cons(A,Y,nil(A))) )
    <=> ( ( Xs = Ys )
        & ( X = Y ) ) ) ).

tff(fact_91_append__step1I,axiom,
    ! [A: $tType,Us2: list(A),Vs: list(A),Xs: list(A),Ys: list(A),R: fun(A,fun(A,bool))] :
      ( ( ( step1(A,R,Ys,Xs)
          & ( Vs = Us2 ) )
        | ( ( Ys = Xs )
          & step1(A,R,Vs,Us2) ) )
     => step1(A,R,append(A,Ys,Vs),append(A,Xs,Us2)) ) ).

tff(fact_92_append__eq__appendI,axiom,
    ! [A: $tType,Us1: list(A),Ys2: list(A),Zs1: list(A),Xs11: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Xs11) = Zs1 )
     => ( ( Ys2 = append(A,Xs11,Us1) )
       => ( append(A,Xs1,Ys2) = append(A,Zs1,Us1) ) ) ) ).

tff(fact_93_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs: list(A),Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = append(A,Zs,Ts) )
    <=> ? [Us: list(A)] :
          ( ( ( Xs = append(A,Zs,Us) )
            & ( append(A,Us,Ys) = Ts ) )
          | ( ( append(A,Xs,Us) = Zs )
            & ( Ys = append(A,Us,Ts) ) ) ) ) ).

tff(fact_94_append__Nil,axiom,
    ! [A: $tType,Ys2: list(A)] : ( append(A,nil(A),Ys2) = Ys2 ) ).

tff(fact_95_append__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( append(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_96_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys2: list(A),Xs1: list(A)] :
      ( ( Xs1 = Ys2 )
     => ( Xs1 = append(A,nil(A),Ys2) ) ) ).

tff(fact_97_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A),X: A] :
      ( ( cons(A,X,Xs) = append(A,Ys,Zs) )
    <=> ( ( ( Ys = nil(A) )
          & ( cons(A,X,Xs) = Zs ) )
        | ? [Ys1: list(A)] :
            ( ( cons(A,X,Ys1) = Ys )
            & ( Xs = append(A,Ys1,Zs) ) ) ) ) ).

tff(fact_98_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs: list(A),X: A,Zs: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Zs) = cons(A,X,Xs) )
    <=> ( ( ( Ys = nil(A) )
          & ( Zs = cons(A,X,Xs) ) )
        | ? [Ys1: list(A)] :
            ( ( Ys = cons(A,X,Ys1) )
            & ( append(A,Ys1,Zs) = Xs ) ) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,foldl(dB,dB,app,subst(r,s,zero_zero(nat)),ss))) ).

tff(conj_1,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,subst(r,s,zero_zero(nat)),ss)),var(i)))) ).

tff(conj_2,hypothesis,
    pp(aa(dB,bool,it,s)) ).

tff(conj_3,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,s),var(i)))) ).

tff(conj_4,conjecture,
    pp(aa(dB,bool,it,s)) ).

%------------------------------------------------------------------------------
