%------------------------------------------------------------------------------
% File     : LCL777_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 82
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_82 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  143 (  48 unt;  36 typ;   0 def)
%            Number of atoms       :  232 ( 155 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  166 (  41   ~;   9   |;  34   &)
%                                         (  31 <=>;  51  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   39 (  21   >;  18   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-4 aty)
%            Number of functors    :   28 (  28 usr;   9 con; 0-5 aty)
%            Number of variables   :  383 ( 347   !;  15   ?; 383   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:26
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (31)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A1: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A1: $tType] : A1 ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A1: $tType] : ( ( fun(A1,fun(A1,bool)) * list(A1) * list(A1) ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A1: $tType] : ( ( fun(B,fun(A1,B)) * B * list(A1) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A1: $tType] : ( ( A1 * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A1: $tType] : list(A1) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A1: $tType] : ( ( T2 * fun(A1,fun(list(A1),T2)) * list(A1) ) > T2 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A1: $tType] : ( ( fun(A1,bool) * list(A1) ) > $o ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,list(B)) * list(A1) ) > list(B) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A1: $tType] : ( list(A1) > list(A1) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A1: $tType] : ( ( list(A1) * list(A1) ) > list(A1) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A1: $tType] : ( ( list(A1) * fun(nat,bool) ) > list(A1) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A1: $tType] : ( A1 > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A1: $tType,B: $tType] : ( ( fun(A1,B) * A1 ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A1: $tType] : ( ( A1 * fun(A1,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_r,type,
    r: dB ).

tff(sy_v_s,type,
    s: dB ).

tff(sy_v_ss,type,
    ss: list(dB) ).

%----Relevant facts (99)
tff(fact_0_Var__IT,axiom,
    ! [N2: nat] : pp(aa(dB,bool,it,var(N2))) ).

tff(fact_1_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,subst(R3,var(I),J))) ) ).

tff(fact_2_Var__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( var(M) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_3_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss1) )
    <=> ( ( M = N )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_4_append1__eq__conv,axiom,
    ! [A1: $tType,Y1: A1,Ys: list(A1),X: A1,Xs: list(A1)] :
      ( ( append(A1,Xs,cons(A1,X,nil(A1))) = append(A1,Ys,cons(A1,Y1,nil(A1))) )
    <=> ( ( Xs = Ys )
        & ( X = Y1 ) ) ) ).

tff(fact_5_App__eq__foldl__conv,axiom,
    ! [Ts: list(dB),Ta: dB,S: dB,R: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = foldl(dB,dB,app,Ta,Ts) )
    <=> ( ( ( Ts = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = Ta ) )
        & ( ( Ts != nil(dB) )
         => ? [Ss2: list(dB)] :
              ( ( Ts = append(dB,Ss2,cons(dB,S,nil(dB))) )
              & ( R = foldl(dB,dB,app,Ta,Ss2) ) ) ) ) ) ).

tff(fact_6_app__last,axiom,
    ! [U2: dB,Ts: list(dB),Ta: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,Ta,Ts)),U2) = foldl(dB,dB,app,Ta,append(dB,Ts,cons(dB,U2,nil(dB)))) ) ).

tff(fact_7_subst__App,axiom,
    ! [K: nat,S1: dB,U1: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S1,K)),subst(U1,S1,K)) ) ).

tff(fact_8_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_9_foldl__append,axiom,
    ! [A1: $tType,B: $tType,Ys: list(B),Xs: list(B),A: A1,F: fun(A1,fun(B,A1))] : ( foldl(A1,B,F,A,append(B,Xs,Ys)) = foldl(A1,B,F,foldl(A1,B,F,A,Xs),Ys) ) ).

tff(fact_10_Nil__is__append__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1)] :
      ( ( nil(A1) = append(A1,Xs,Ys) )
    <=> ( ( Xs = nil(A1) )
        & ( Ys = nil(A1) ) ) ) ).

tff(fact_11_self__append__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1)] :
      ( ( Xs = append(A1,Xs,Ys) )
    <=> ( Ys = nil(A1) ) ) ).

tff(fact_12_self__append__conv2,axiom,
    ! [A1: $tType,Xs: list(A1),Ys: list(A1)] :
      ( ( Ys = append(A1,Xs,Ys) )
    <=> ( Xs = nil(A1) ) ) ).

tff(fact_13_append__is__Nil__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1)] :
      ( ( append(A1,Xs,Ys) = nil(A1) )
    <=> ( ( Xs = nil(A1) )
        & ( Ys = nil(A1) ) ) ) ).

tff(fact_14_list_Oinject,axiom,
    ! [A1: $tType,List3: list(A1),A6: A1,List: list(A1),A: A1] :
      ( ( cons(A1,A,List) = cons(A1,A6,List3) )
    <=> ( ( A = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_15_append__same__eq,axiom,
    ! [A1: $tType,Zs1: list(A1),Xs: list(A1),Ys: list(A1)] :
      ( ( append(A1,Ys,Xs) = append(A1,Zs1,Xs) )
    <=> ( Ys = Zs1 ) ) ).

tff(fact_16_same__append__eq,axiom,
    ! [A1: $tType,Zs1: list(A1),Ys: list(A1),Xs: list(A1)] :
      ( ( append(A1,Xs,Ys) = append(A1,Xs,Zs1) )
    <=> ( Ys = Zs1 ) ) ).

tff(fact_17_append__assoc,axiom,
    ! [A1: $tType,Zs2: list(A1),Ys1: list(A1),Xs1: list(A1)] : ( append(A1,append(A1,Xs1,Ys1),Zs2) = append(A1,Xs1,append(A1,Ys1,Zs2)) ) ).

tff(fact_18_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_19_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_20_append__Cons,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs1: list(A1),X1: A1] : ( append(A1,cons(A1,X1,Xs1),Ys1) = cons(A1,X1,append(A1,Xs1,Ys1)) ) ).

tff(fact_21_append__self__conv2,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1)] :
      ( ( append(A1,Xs,Ys) = Ys )
    <=> ( Xs = nil(A1) ) ) ).

tff(fact_22_append__self__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1)] :
      ( ( append(A1,Xs,Ys) = Xs )
    <=> ( Ys = nil(A1) ) ) ).

tff(fact_23_not__Cons__self2,axiom,
    ! [A1: $tType,Xs1: list(A1),X1: A1] : ( cons(A1,X1,Xs1) != Xs1 ) ).

tff(fact_24_not__Cons__self,axiom,
    ! [A1: $tType,X1: A1,Xs1: list(A1)] : ( Xs1 != cons(A1,X1,Xs1) ) ).

tff(fact_25_append__eq__appendI,axiom,
    ! [A1: $tType,Us3: list(A1),Ys1: list(A1),Zs2: list(A1),Xs11: list(A1),Xs1: list(A1)] :
      ( ( append(A1,Xs1,Xs11) = Zs2 )
     => ( ( Ys1 = append(A1,Xs11,Us3) )
       => ( append(A1,Xs1,Ys1) = append(A1,Zs2,Us3) ) ) ) ).

tff(fact_26_append__eq__append__conv2,axiom,
    ! [A1: $tType,Ts: list(A1),Zs1: list(A1),Ys: list(A1),Xs: list(A1)] :
      ( ( append(A1,Xs,Ys) = append(A1,Zs1,Ts) )
    <=> ? [Us2: list(A1)] :
          ( ( ( Xs = append(A1,Zs1,Us2) )
            & ( append(A1,Us2,Ys) = Ts ) )
          | ( ( append(A1,Xs,Us2) = Zs1 )
            & ( Ys = append(A1,Us2,Ts) ) ) ) ) ).

tff(fact_27_list_Osimps_I3_J,axiom,
    ! [A1: $tType,List2: list(A1),A5: A1] : ( cons(A1,A5,List2) != nil(A1) ) ).

tff(fact_28_list_Osimps_I2_J,axiom,
    ! [A1: $tType,List2: list(A1),A5: A1] : ( nil(A1) != cons(A1,A5,List2) ) ).

tff(fact_29_Cons__eq__appendI,axiom,
    ! [A1: $tType,Zs2: list(A1),Xs1: list(A1),Ys1: list(A1),Xs11: list(A1),X1: A1] :
      ( ( cons(A1,X1,Xs11) = Ys1 )
     => ( ( Xs1 = append(A1,Xs11,Zs2) )
       => ( cons(A1,X1,Xs1) = append(A1,Ys1,Zs2) ) ) ) ).

tff(fact_30_eq__Nil__appendI,axiom,
    ! [A1: $tType,Ys1: list(A1),Xs1: list(A1)] :
      ( ( Xs1 = Ys1 )
     => ( Xs1 = append(A1,nil(A1),Ys1) ) ) ).

tff(fact_31_append__Nil2,axiom,
    ! [A1: $tType,Xs1: list(A1)] : ( append(A1,Xs1,nil(A1)) = Xs1 ) ).

tff(fact_32_append__Nil,axiom,
    ! [A1: $tType,Ys1: list(A1)] : ( append(A1,nil(A1),Ys1) = Ys1 ) ).

tff(fact_33_foldl__Cons,axiom,
    ! [A1: $tType,B: $tType,Xs: list(B),X: B,A: A1,F: fun(A1,fun(B,A1))] : ( foldl(A1,B,F,A,cons(B,X,Xs)) = foldl(A1,B,F,aa(B,A1,aa(A1,fun(B,A1),F,A),X),Xs) ) ).

tff(fact_34_foldl__Nil,axiom,
    ! [B: $tType,A1: $tType,A: A1,F: fun(A1,fun(B,A1))] : ( foldl(A1,B,F,A,nil(B)) = A ) ).

tff(fact_35_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_36_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_37_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( subst(var(K),U1,K) = U1 ) ).

tff(fact_38_Cons__eq__append__conv,axiom,
    ! [A1: $tType,Zs1: list(A1),Ys: list(A1),Xs: list(A1),X: A1] :
      ( ( cons(A1,X,Xs) = append(A1,Ys,Zs1) )
    <=> ( ( ( Ys = nil(A1) )
          & ( cons(A1,X,Xs) = Zs1 ) )
        | ? [Ys4: list(A1)] :
            ( ( cons(A1,X,Ys4) = Ys )
            & ( Xs = append(A1,Ys4,Zs1) ) ) ) ) ).

tff(fact_39_append__eq__Cons__conv,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1,Zs1: list(A1),Ys: list(A1)] :
      ( ( append(A1,Ys,Zs1) = cons(A1,X,Xs) )
    <=> ( ( ( Ys = nil(A1) )
          & ( Zs1 = cons(A1,X,Xs) ) )
        | ? [Ys4: list(A1)] :
            ( ( Ys = cons(A1,X,Ys4) )
            & ( append(A1,Ys4,Zs1) = Xs ) ) ) ) ).

tff(fact_40_rev__cases,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( ( Xs1 != nil(A1) )
     => ~ ! [Ys2: list(A1),Y: A1] : ( Xs1 != append(A1,Ys2,cons(A1,Y,nil(A1))) ) ) ).

tff(fact_41_rev__induct,axiom,
    ! [A1: $tType,Xs: list(A1),P: fun(list(A1),bool)] :
      ( pp(aa(list(A1),bool,P,nil(A1)))
     => ( ! [X2: A1,Xs2: list(A1)] :
            ( pp(aa(list(A1),bool,P,Xs2))
           => pp(aa(list(A1),bool,P,append(A1,Xs2,cons(A1,X2,nil(A1))))) )
       => pp(aa(list(A1),bool,P,Xs)) ) ) ).

tff(fact_42_list_Oexhaust,axiom,
    ! [A1: $tType,Y2: list(A1)] :
      ( ( Y2 != nil(A1) )
     => ~ ! [A4: A1,List1: list(A1)] : ( Y2 != cons(A1,A4,List1) ) ) ).

tff(fact_43_neq__Nil__conv,axiom,
    ! [A1: $tType,Xs: list(A1)] :
      ( ( Xs != nil(A1) )
    <=> ? [Y3: A1,Ys3: list(A1)] : ( Xs = cons(A1,Y3,Ys3) ) ) ).

tff(fact_44_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_45_insert__Nil,axiom,
    ! [A1: $tType,X1: A1] : ( insert(A1,X1,nil(A1)) = cons(A1,X1,nil(A1)) ) ).

tff(fact_46_sublist__singleton,axiom,
    ! [A1: $tType,X: A1,A2: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A2)
       => ( sublist(A1,cons(A1,X,nil(A1)),A2) = cons(A1,X,nil(A1)) ) )
      & ( ~ member(nat,zero_zero(nat),A2)
       => ( sublist(A1,cons(A1,X,nil(A1)),A2) = nil(A1) ) ) ) ).

tff(fact_47_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_48_sublist__nil,axiom,
    ! [A1: $tType,A2: fun(nat,bool)] : ( sublist(A1,nil(A1),A2) = nil(A1) ) ).

tff(fact_49_zero__reorient,axiom,
    ! [A1: $tType] :
      ( zero(A1)
     => ! [X: A1] :
          ( ( zero_zero(A1) = X )
        <=> ( X = zero_zero(A1) ) ) ) ).

tff(fact_50_rev__exhaust2,axiom,
    ! [A1: $tType,Xs1: list(A1)] :
      ( ( Xs1 != nil(A1) )
     => ~ ! [Ys2: list(A1),Y: A1] : ( Xs1 != append(A1,Ys2,cons(A1,Y,nil(A1))) ) ) ).

tff(fact_51_rotate__simps,axiom,
    ! [A1: $tType,B: $tType,Xs1: list(B),X1: B] :
      ( ( rotate1(A1,nil(A1)) = nil(A1) )
      & ( rotate1(B,cons(B,X1,Xs1)) = append(B,Xs1,cons(B,X1,nil(B))) ) ) ).

tff(fact_52_maps__simps_I1_J,axiom,
    ! [A1: $tType,B: $tType,Xs: list(B),X: B,F: fun(B,list(A1))] : ( maps(B,A1,F,cons(B,X,Xs)) = append(A1,aa(B,list(A1),F,X),maps(B,A1,F,Xs)) ) ).

tff(fact_53_Beta,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss1))) ) ) ).

tff(fact_54_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_55_rotate1__is__Nil__conv,axiom,
    ! [A1: $tType,Xs: list(A1)] :
      ( ( rotate1(A1,Xs) = nil(A1) )
    <=> ( Xs = nil(A1) ) ) ).

tff(fact_56_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_57_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( R = S )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_58_apps__eq__Abs__conv,axiom,
    ! [R: dB,Ss1: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss1) = abs(R) )
    <=> ( ( S = abs(R) )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_59_Abs__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( ( abs(R) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( abs(R) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_60_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_61_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_62_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_63_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_64_maps__simps_I2_J,axiom,
    ! [B: $tType,A1: $tType,F: fun(B,list(A1))] : ( maps(B,A1,F,nil(B)) = nil(A1) ) ).

tff(fact_65_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R),Ss1) ) ).

tff(fact_66_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss1) ) ).

tff(fact_67_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_68_beta,axiom,
    ! [T1: dB,S1: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T1)),subst(S1,T1,zero_zero(nat)))) ).

tff(fact_69_foldl__fun__comm,axiom,
    ! [B: $tType,A1: $tType,X: A1,Xs: list(A1),S: B,F: fun(B,fun(A1,B))] :
      ( ! [X2: A1,Y: A1,S2: B] : ( aa(A1,B,aa(B,fun(A1,B),F,aa(A1,B,aa(B,fun(A1,B),F,S2),X2)),Y) = aa(A1,B,aa(B,fun(A1,B),F,aa(A1,B,aa(B,fun(A1,B),F,S2),Y)),X2) )
     => ( aa(A1,B,aa(B,fun(A1,B),F,foldl(B,A1,F,S,Xs)),X) = foldl(B,A1,F,aa(A1,B,aa(B,fun(A1,B),F,S),X),Xs) ) ) ).

tff(fact_70_splice_Osimps_I2_J,axiom,
    ! [A1: $tType,Va: list(A1),V1: A1] : ( splice(A1,cons(A1,V1,Va),nil(A1)) = cons(A1,V1,Va) ) ).

tff(fact_71_appR,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S1)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T1))) ) ).

tff(fact_72_appL,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U1))) ) ).

tff(fact_73_listsp_ONil,axiom,
    ! [A1: $tType,A2: fun(A1,bool)] : listsp(A1,A2,nil(A1)) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A1: $tType,G: fun(A1,B),F: fun(A1,B)] :
      ( ! [X2: A1] : ( aa(A1,B,F,X2) = aa(A1,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A1: $tType,A2: fun(A1,bool),X: A1] :
      ( member(A1,X,A2)
    <=> pp(aa(A1,bool,A2,X)) ) ).

tff(fact_76_append__in__listsp__conv,axiom,
    ! [A1: $tType,Ys: list(A1),Xs: list(A1),A2: fun(A1,bool)] :
      ( listsp(A1,A2,append(A1,Xs,Ys))
    <=> ( listsp(A1,A2,Xs)
        & listsp(A1,A2,Ys) ) ) ).

tff(fact_77_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T1)) ).

tff(fact_78_abs,axiom,
    ! [T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S1)),abs(T1))) ) ).

tff(fact_79_splice_Osimps_I3_J,axiom,
    ! [A1: $tType,Ys1: list(A1),Y2: A1,Xs1: list(A1),X1: A1] : ( splice(A1,cons(A1,X1,Xs1),cons(A1,Y2,Ys1)) = cons(A1,X1,cons(A1,Y2,splice(A1,Xs1,Ys1))) ) ).

tff(fact_80_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R3,T1,I)),subst(S1,T1,I))) ) ).

tff(fact_81_splice_Osimps_I1_J,axiom,
    ! [A1: $tType,Ys1: list(A1)] : ( splice(A1,nil(A1),Ys1) = Ys1 ) ).

tff(fact_82_splice__Nil2,axiom,
    ! [A1: $tType,Xs1: list(A1)] : ( splice(A1,Xs1,nil(A1)) = Xs1 ) ).

tff(fact_83_beta__cases_I2_J,axiom,
    ! [S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S1))
     => ~ ! [T: dB] :
            ( ( S1 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T)) ) ) ).

tff(fact_84_listsp_Osimps,axiom,
    ! [A1: $tType,A: list(A1),A2: fun(A1,bool)] :
      ( listsp(A1,A2,A)
    <=> ( ( A = nil(A1) )
        | ? [A3: A1,L: list(A1)] :
            ( ( A = cons(A1,A3,L) )
            & pp(aa(A1,bool,A2,A3))
            & listsp(A1,A2,L) ) ) ) ).

tff(fact_85_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_86_IT_Osimps,axiom,
    ! [A: dB] :
      ( pp(aa(dB,bool,it,A))
    <=> ( ? [Rs2: list(dB),N1: nat] :
            ( ( A = foldl(dB,dB,app,var(N1),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R2: dB] :
            ( ( A = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S3: dB,Ss2: list(dB)] :
            ( ( A = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R2,S3,zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_87_beta__cases_I3_J,axiom,
    ! [U1: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),U1))
     => ( ! [S2: dB] :
            ( ( U1 = subst(S2,T1,zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T)) )
         => ~ ! [T: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_88_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,R,Rs1) ) )
         => ~ ! [T: dB] :
                ( ( R = abs(T) )
               => ! [U: dB,Us1: list(dB)] :
                    ( ( Rs = cons(dB,U,Us1) )
                   => ( S != foldl(dB,dB,app,subst(T,U,zero_zero(nat)),Us1) ) ) ) ) ) ) ).

tff(fact_89_apps__preserves__betas,axiom,
    ! [R: dB,Ss1: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss1)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),foldl(dB,dB,app,R,Ss1))) ) ).

tff(fact_90_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V))
     => ? [Ss: list(dB)] :
          ( step1(dB,beta,Rs,Ss)
          & ( V = foldl(dB,dB,app,var(N),Ss) ) ) ) ).

tff(fact_91_Cons__step1__Cons,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1,Ys: list(A1),Y1: A1,R: fun(A1,fun(A1,bool))] :
      ( step1(A1,R,cons(A1,Y1,Ys),cons(A1,X,Xs))
    <=> ( ( pp(aa(A1,bool,aa(A1,fun(A1,bool),R,Y1),X))
          & ( Xs = Ys ) )
        | ( ( X = Y1 )
          & step1(A1,R,Ys,Xs) ) ) ) ).

tff(fact_92_not__step1__Nil,axiom,
    ! [A1: $tType,Xs: list(A1),R: fun(A1,fun(A1,bool))] : ~ step1(A1,R,Xs,nil(A1)) ).

tff(fact_93_not__Nil__step1,axiom,
    ! [A1: $tType,Xs: list(A1),R: fun(A1,fun(A1,bool))] : ~ step1(A1,R,nil(A1),Xs) ).

tff(fact_94_append__step1I,axiom,
    ! [A1: $tType,Us: list(A1),Vs: list(A1),Xs: list(A1),Ys: list(A1),R: fun(A1,fun(A1,bool))] :
      ( ( ( step1(A1,R,Ys,Xs)
          & ( Vs = Us ) )
        | ( ( Ys = Xs )
          & step1(A1,R,Vs,Us) ) )
     => step1(A1,R,append(A1,Ys,Vs),append(A1,Xs,Us)) ) ).

tff(fact_95_Snoc__step1__SnocD,axiom,
    ! [A1: $tType,X: A1,Xs: list(A1),Y1: A1,Ys: list(A1),R: fun(A1,fun(A1,bool))] :
      ( step1(A1,R,append(A1,Ys,cons(A1,Y1,nil(A1))),append(A1,Xs,cons(A1,X,nil(A1))))
     => ( ( step1(A1,R,Ys,Xs)
          & ( Y1 = X ) )
        | ( ( Ys = Xs )
          & pp(aa(A1,bool,aa(A1,fun(A1,bool),R,Y1),X)) ) ) ) ).

tff(fact_96_Cons__step1E,axiom,
    ! [A1: $tType,Xs: list(A1),X: A1,Ys: list(A1),R: fun(A1,fun(A1,bool))] :
      ( step1(A1,R,Ys,cons(A1,X,Xs))
     => ( ! [Y: A1] :
            ( ( Ys = cons(A1,Y,Xs) )
           => ~ pp(aa(A1,bool,aa(A1,fun(A1,bool),R,Y),X)) )
       => ~ ! [Zs: list(A1)] :
              ( ( Ys = cons(A1,X,Zs) )
             => ~ step1(A1,R,Zs,Xs) ) ) ) ).

tff(fact_97_list_Osimps_I4_J,axiom,
    ! [B: $tType,A1: $tType,F2: fun(B,fun(list(B),A1)),F1: A1] : ( list_case(A1,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_98_list_Osimps_I5_J,axiom,
    ! [A1: $tType,B: $tType,List: list(B),A: B,F2: fun(B,fun(list(B),A1)),F1: A1] : ( list_case(A1,B,F1,F2,cons(B,A,List)) = aa(list(B),A1,aa(B,fun(list(B),A1),F2,A),List) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,foldl(dB,dB,app,subst(r,s,zero_zero(nat)),ss))) ).

tff(conj_1,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,subst(r,s,zero_zero(nat)),ss)),var(i)))) ).

tff(conj_2,hypothesis,
    pp(aa(dB,bool,it,s)) ).

tff(conj_3,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,s),var(i)))) ).

tff(conj_4,conjecture,
    pp(aa(dB,bool,it,foldl(dB,dB,app,subst(r,s,zero_zero(nat)),append(dB,ss,cons(dB,var(i),nil(dB)))))) ).

%------------------------------------------------------------------------------
