%------------------------------------------------------------------------------
% File     : LCL775_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 80
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_80 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.67 v6.4.0
% Syntax   : Number of formulae    :  145 (  49 unt;  38 typ;   0 def)
%            Number of atoms       :  231 ( 153 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  166 (  42   ~;   9   |;  34   &)
%                                         (  30 <=>;  51  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   45 (  23   >;  22   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-4 aty)
%            Number of functors    :   29 (  29 usr;   9 con; 0-5 aty)
%            Number of variables   :  379 ( 344   !;  15   ?; 379   :)
%                                         (  20  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:22
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),T2)) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_r,type,
    r: dB ).

tff(sy_v_s,type,
    s: dB ).

tff(sy_v_ss,type,
    ss: list(dB) ).

%----Relevant facts (99)
tff(fact_0_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_1_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,subst(R2,var(I),J))) ) ).

tff(fact_2_Beta,axiom,
    ! [Ss2: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss2)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss2))) ) ) ).

tff(fact_3_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss2) )
    <=> ( ( R = S )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_4_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss2: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss2) )
    <=> ( ( M = N )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_5_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_6_subst__App,axiom,
    ! [K: nat,S2: dB,U2: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S2,K)),subst(U2,S2,K)) ) ).

tff(fact_7_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_8_Abs__App__neq__Var__apps,axiom,
    ! [Ss2: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss2) ) ).

tff(fact_9_Var__apps__neq__Abs__apps,axiom,
    ! [Ss2: list(dB),R: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R),Ss2) ) ).

tff(fact_10_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_11_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_12_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_13_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_14_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_15_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_16_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_17_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_18_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_19_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_20_subst__eq,axiom,
    ! [U2: dB,K: nat] : ( subst(var(K),U2,K) = U2 ) ).

tff(fact_21_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_22_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_23_beta,axiom,
    ! [T1: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T1)),subst(S2,T1,zero_zero(nat)))) ).

tff(fact_24_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_25_IT_Osimps,axiom,
    ! [A2: dB] :
      ( pp(aa(dB,bool,it,A2))
    <=> ( ? [Rs2: list(dB),N2: nat] :
            ( ( A2 = foldl(dB,dB,app,var(N2),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R3: dB] :
            ( ( A2 = abs(R3) )
            & pp(aa(dB,bool,it,R3)) )
        | ? [R3: dB,S3: dB,Ss: list(dB)] :
            ( ( A2 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R3)),S3),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R3,S3,zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_26_substn__subst__0,axiom,
    ! [S2: dB,T1: dB] : ( substn(T1,S2,zero_zero(nat)) = subst(T1,S2,zero_zero(nat)) ) ).

tff(fact_27_apps__eq__Abs__conv,axiom,
    ! [R: dB,Ss2: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss2) = abs(R) )
    <=> ( ( S = abs(R) )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_28_Abs__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,R: dB] :
      ( ( abs(R) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( abs(R) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_29_Var__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( var(M) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_30_appL,axiom,
    ! [U2: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U2)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2))) ) ).

tff(fact_31_appR,axiom,
    ! [U2: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U2),S2)),aa(dB,dB,aa(dB,fun(dB,dB),app,U2),T1))) ) ).

tff(fact_32_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T1)) ).

tff(fact_33_abs,axiom,
    ! [T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S2)),abs(T1))) ) ).

tff(fact_34_substn_Osimps_I2_J,axiom,
    ! [K: nat,S2: dB,U2: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S2,K)),substn(U2,S2,K)) ) ).

tff(fact_35_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S2: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R2,T1,I)),subst(S2,T1,I))) ) ).

tff(fact_36_beta__cases_I2_J,axiom,
    ! [S2: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R2)),S2))
     => ~ ! [T: dB] :
            ( ( S2 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),T)) ) ) ).

tff(fact_37_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_38_apps__preserves__beta,axiom,
    ! [Ss2: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Ss2)),foldl(dB,dB,app,S,Ss2))) ) ).

tff(fact_39_substn__subst__n,axiom,
    ! [N1: nat,S2: dB,T1: dB] : ( substn(T1,S2,N1) = subst(T1,liftn(N1,S2,zero_zero(nat)),N1) ) ).

tff(fact_40_beta__cases_I3_J,axiom,
    ! [U2: dB,T1: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1)),U2))
     => ( ! [S1: dB] :
            ( ( U2 = subst(S1,T1,zero_zero(nat)) )
           => ( S2 != abs(S1) ) )
       => ( ! [T: dB] :
              ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T)) )
         => ~ ! [T: dB] :
                ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_41_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,nil(B)) = A2 ) ).

tff(fact_42_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S2: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S2,K)),liftn(N1,T1,K)) ) ).

tff(fact_43_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_44_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X2: A,Xs1: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X1: A,Y: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X1)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y)),X1) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs1)),X2) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X2),Xs1) ) ) ).

tff(fact_45_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_46_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_47_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_48_apps__preserves__betas,axiom,
    ! [R: dB,Ss2: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss2)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),foldl(dB,dB,app,R,Ss2))) ) ).

tff(fact_49_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V))
     => ? [Ss1: list(dB)] :
          ( step1(dB,beta,Rs,Ss1)
          & ( V = foldl(dB,dB,app,var(N),Ss1) ) ) ) ).

tff(fact_50_not__step1__Nil,axiom,
    ! [A: $tType,Xs1: list(A),R: fun(A,fun(A,bool))] : ~ step1(A,R,Xs1,nil(A)) ).

tff(fact_51_not__Nil__step1,axiom,
    ! [A: $tType,Xs1: list(A),R: fun(A,fun(A,bool))] : ~ step1(A,R,nil(A),Xs1) ).

tff(fact_52_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,R,Rs1) ) )
         => ~ ! [T: dB] :
                ( ( R = abs(T) )
               => ! [U1: dB,Us3: list(dB)] :
                    ( ( Rs = cons(dB,U1,Us3) )
                   => ( S != foldl(dB,dB,app,subst(T,U1,zero_zero(nat)),Us3) ) ) ) ) ) ) ).

tff(fact_53_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List2: list(A),A2: A] :
      ( ( cons(A,A2,List2) = cons(A,A6,List3) )
    <=> ( ( A2 = A6 )
        & ( List2 = List3 ) ) ) ).

tff(fact_54_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs1: list(A),X2: A,Ys1: list(A),Y1: A,R: fun(A,fun(A,bool))] :
      ( step1(A,R,cons(A,Y1,Ys1),cons(A,X2,Xs1))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R,Y1),X2))
          & ( Xs1 = Ys1 ) )
        | ( ( X2 = Y1 )
          & step1(A,R,Ys1,Xs1) ) ) ) ).

tff(fact_55_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A2,List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List2) ) ).

tff(fact_56_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_57_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_58_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X2: B,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,cons(B,X2,Xs1)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A2),X2),Xs1) ) ).

tff(fact_59_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( nil(A) != cons(A,A5,List1) ) ).

tff(fact_60_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A5: A] : ( cons(A,A5,List1) != nil(A) ) ).

tff(fact_61_listsp_Osimps,axiom,
    ! [A: $tType,A2: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,A2)
    <=> ( ( A2 = nil(A) )
        | ? [A4: A,L: list(A)] :
            ( ( A2 = cons(A,A4,L) )
            & pp(aa(A,bool,A1,A4))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_62_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y3: A,Ys4: list(A)] : ( Xs1 = cons(A,Y3,Ys4) ) ) ).

tff(fact_63_list_Oexhaust,axiom,
    ! [A: $tType,Y2: list(A)] :
      ( ( Y2 != nil(A) )
     => ~ ! [A3: A,List: list(A)] : ( Y2 != cons(A,A3,List) ) ) ).

tff(fact_64_Cons__step1E,axiom,
    ! [A: $tType,Xs1: list(A),X2: A,Ys1: list(A),R: fun(A,fun(A,bool))] :
      ( step1(A,R,Ys1,cons(A,X2,Xs1))
     => ( ! [Y: A] :
            ( ( Ys1 = cons(A,Y,Xs1) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),R,Y),X2)) )
       => ~ ! [Zs2: list(A)] :
              ( ( Ys1 = cons(A,X2,Zs2) )
             => ~ step1(A,R,Zs2,Xs1) ) ) ) ).

tff(fact_65_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_66_sublist__singleton,axiom,
    ! [A: $tType,X2: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X2,nil(A)),A1) = cons(A,X2,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X2,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_67_App__eq__foldl__conv,axiom,
    ! [Ts: list(dB),Ta: dB,S: dB,R: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = foldl(dB,dB,app,Ta,Ts) )
    <=> ( ( ( Ts = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = Ta ) )
        & ( ( Ts != nil(dB) )
         => ? [Ss: list(dB)] :
              ( ( Ts = append(dB,Ss,cons(dB,S,nil(dB))) )
              & ( R = foldl(dB,dB,app,Ta,Ss) ) ) ) ) ) ).

tff(fact_68_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs1: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Xs1) = append(A,Zs,Xs1) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_69_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = append(A,Xs1,Zs) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_70_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys3: list(A),Xs: list(A)] : ( append(A,append(A,Xs,Ys3),Zs1) = append(A,Xs,append(A,Ys3,Zs1)) ) ).

tff(fact_71_append__Cons,axiom,
    ! [A: $tType,Ys3: list(A),Xs: list(A),X: A] : ( append(A,cons(A,X,Xs),Ys3) = cons(A,X,append(A,Xs,Ys3)) ) ).

tff(fact_72_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( nil(A) = append(A,Xs1,Ys1) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_73_self__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( Xs1 = append(A,Xs1,Ys1) )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X2: A] :
      ( member(A,X2,A1)
    <=> pp(aa(A,bool,A1,X2)) ) ).

tff(fact_76_self__append__conv2,axiom,
    ! [A: $tType,Xs1: list(A),Ys1: list(A)] :
      ( ( Ys1 = append(A,Xs1,Ys1) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_77_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = nil(A) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_78_append__self__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = Xs1 )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_79_append__self__conv2,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = Ys1 )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_80_foldl__append,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),Xs1: list(B),A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,append(B,Xs1,Ys1)) = foldl(A,B,F,foldl(A,B,F,A2,Xs1),Ys1) ) ).

tff(fact_81_append__in__listsp__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,append(A,Xs1,Ys1))
    <=> ( listsp(A,A1,Xs1)
        & listsp(A,A1,Ys1) ) ) ).

tff(fact_82_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_83_append1__eq__conv,axiom,
    ! [A: $tType,Y1: A,Ys1: list(A),X2: A,Xs1: list(A)] :
      ( ( append(A,Xs1,cons(A,X2,nil(A))) = append(A,Ys1,cons(A,Y1,nil(A))) )
    <=> ( ( Xs1 = Ys1 )
        & ( X2 = Y1 ) ) ) ).

tff(fact_84_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs: list(A),Ys3: list(A),Xs11: list(A),X: A] :
      ( ( cons(A,X,Xs11) = Ys3 )
     => ( ( Xs = append(A,Xs11,Zs1) )
       => ( cons(A,X,Xs) = append(A,Ys3,Zs1) ) ) ) ).

tff(fact_85_append__eq__appendI,axiom,
    ! [A: $tType,Us2: list(A),Ys3: list(A),Zs1: list(A),Xs11: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Xs11) = Zs1 )
     => ( ( Ys3 = append(A,Xs11,Us2) )
       => ( append(A,Xs,Ys3) = append(A,Zs1,Us2) ) ) ) ).

tff(fact_86_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs: list(A),Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = append(A,Zs,Ts) )
    <=> ? [Us1: list(A)] :
          ( ( ( Xs1 = append(A,Zs,Us1) )
            & ( append(A,Us1,Ys1) = Ts ) )
          | ( ( append(A,Xs1,Us1) = Zs )
            & ( Ys1 = append(A,Us1,Ts) ) ) ) ) ).

tff(fact_87_append__Nil,axiom,
    ! [A: $tType,Ys3: list(A)] : ( append(A,nil(A),Ys3) = Ys3 ) ).

tff(fact_88_append__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( append(A,Xs,nil(A)) = Xs ) ).

tff(fact_89_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys3: list(A),Xs: list(A)] :
      ( ( Xs = Ys3 )
     => ( Xs = append(A,nil(A),Ys3) ) ) ).

tff(fact_90_append__step1I,axiom,
    ! [A: $tType,Us: list(A),Vs: list(A),Xs1: list(A),Ys1: list(A),R: fun(A,fun(A,bool))] :
      ( ( ( step1(A,R,Ys1,Xs1)
          & ( Vs = Us ) )
        | ( ( Ys1 = Xs1 )
          & step1(A,R,Vs,Us) ) )
     => step1(A,R,append(A,Ys1,Vs),append(A,Xs1,Us)) ) ).

tff(fact_91_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs1: list(A),X2: A,Zs: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Zs) = cons(A,X2,Xs1) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( Zs = cons(A,X2,Xs1) ) )
        | ? [Ys2: list(A)] :
            ( ( Ys1 = cons(A,X2,Ys2) )
            & ( append(A,Ys2,Zs) = Xs1 ) ) ) ) ).

tff(fact_92_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A),X2: A] :
      ( ( cons(A,X2,Xs1) = append(A,Ys1,Zs) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( cons(A,X2,Xs1) = Zs ) )
        | ? [Ys2: list(A)] :
            ( ( cons(A,X2,Ys2) = Ys1 )
            & ( Xs1 = append(A,Ys2,Zs) ) ) ) ) ).

tff(fact_93_Snoc__step1__SnocD,axiom,
    ! [A: $tType,X2: A,Xs1: list(A),Y1: A,Ys1: list(A),R: fun(A,fun(A,bool))] :
      ( step1(A,R,append(A,Ys1,cons(A,Y1,nil(A))),append(A,Xs1,cons(A,X2,nil(A))))
     => ( ( step1(A,R,Ys1,Xs1)
          & ( Y1 = X2 ) )
        | ( ( Ys1 = Xs1 )
          & pp(aa(A,bool,aa(A,fun(A,bool),R,Y1),X2)) ) ) ) ).

tff(fact_94_app__last,axiom,
    ! [U: dB,Ts: list(dB),Ta: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,Ta,Ts)),U) = foldl(dB,dB,app,Ta,append(dB,Ts,cons(dB,U,nil(dB)))) ) ).

tff(fact_95_rev__induct,axiom,
    ! [A: $tType,Xs1: list(A),P: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P,nil(A)))
     => ( ! [X1: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P,Xs2))
           => pp(aa(list(A),bool,P,append(A,Xs2,cons(A,X1,nil(A))))) )
       => pp(aa(list(A),bool,P,Xs1)) ) ) ).

tff(fact_96_rev__cases,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys: list(A),Y: A] : ( Xs != append(A,Ys,cons(A,Y,nil(A))) ) ) ).

tff(fact_97_rev__exhaust2,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys: list(A),Y: A] : ( Xs != append(A,Ys,cons(A,Y,nil(A))) ) ) ).

tff(fact_98_rotate__simps,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B,cons(B,X,Xs)) = append(B,Xs,cons(B,X,nil(B))) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,foldl(dB,dB,app,subst(r,s,zero_zero(nat)),ss))) ).

tff(conj_1,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,subst(r,s,zero_zero(nat)),ss)),var(i)))) ).

tff(conj_2,hypothesis,
    pp(aa(dB,bool,it,s)) ).

tff(conj_3,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,s),var(i)))) ).

tff(conj_4,conjecture,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(r)),s),ss)),var(i)))) ).

%------------------------------------------------------------------------------
