%------------------------------------------------------------------------------
% File     : LCL774_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 79
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_79 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  147 (  60 unt;  37 typ;   0 def)
%            Number of atoms       :  193 ( 124 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  107 (  24   ~;   4   |;  15   &)
%                                         (  21 <=>;  43  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   4 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   36 (  17   >;  19   *;   0   +;   0  <<)
%            Number of predicates  :   12 (  11 usr;   0 prp; 1-3 aty)
%            Number of functors    :   23 (  23 usr;   6 con; 0-5 aty)
%            Number of variables   :  288 ( 263   !;   7   ?; 288   :)
%                                         (  18  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:21
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,T2)) * fun(dB,T2) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,fun(T2,fun(T2,T2)))) * fun(dB,fun(T2,T2)) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B1: $tType,A: $tType] : ( ( fun(B1,fun(A,B1)) * B1 * list(A) ) > B1 ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B1: $tType] : ( ( fun(A,B1) * A ) > B1 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_r,type,
    r: dB ).

%----Relevant facts (98)
tff(fact_0_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_1_dB_Osimps_I1_J,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( var(Nat4) = var(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_2_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB11 = DB13 )
        & ( DB21 = DB23 ) ) ) ).

tff(fact_3_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat3: nat] : ( var(Nat3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_4_dB_Osimps_I5_J,axiom,
    ! [Nat3: nat,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != var(Nat3) ) ).

tff(fact_5_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,subst(R1,var(I),J))) ) ).

tff(fact_6_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,lift(T1,I))) ) ).

tff(fact_7_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat4: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat4)) = aa(nat,A,F1,Nat4) ) ).

tff(fact_8_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N: nat,Rs1: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs1) = foldl(dB,dB,app,var(N),Ss) )
    <=> ( ( M = N )
        & ( Rs1 = Ss ) ) ) ).

tff(fact_9_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB11),DB21) ) ).

tff(fact_10_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S1,K)),substn(U,S1,K)) ) ).

tff(fact_11_IT_OVar,axiom,
    ! [N: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs1))) ) ).

tff(fact_12_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S1,K)),liftn(N1,T1,K)) ) ).

tff(fact_13_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_14_subst__App,axiom,
    ! [K: nat,S1: dB,U: dB,T1: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T1,S1,K)),subst(U,S1,K)) ) ).

tff(fact_15_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S1,K)),lift(T1,K)) ) ).

tff(fact_16_subst__lift,axiom,
    ! [S1: dB,K: nat,T1: dB] : ( subst(lift(T1,K),S1,K) = T1 ) ).

tff(fact_17_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_18_substn__subst__n,axiom,
    ! [N1: nat,S1: dB,T1: dB] : ( substn(T1,S1,N1) = subst(T1,liftn(N1,S1,zero_zero(nat)),N1) ) ).

tff(fact_19_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( var(M) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_20_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),R: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R),Ss) ) ).

tff(fact_21_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss) ) ).

tff(fact_22_liftn__lift,axiom,
    ! [K: nat,T1: dB,N1: nat] : ( liftn(suc(N1),T1,K) = lift(liftn(N1,T1,K),K) ) ).

tff(fact_23_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs1: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs1) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( R = S )
        & ( Rs1 = Ss ) ) ) ).

tff(fact_24_substn__subst__0,axiom,
    ! [S1: dB,T1: dB] : ( substn(T1,S1,zero_zero(nat)) = subst(T1,S1,zero_zero(nat)) ) ).

tff(fact_25_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat4: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat4)) = aa(nat,A,F1,Nat4) ) ).

tff(fact_26_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB11),DB21),dB_rec(A,F1,F2,F3,DB11)),dB_rec(A,F1,F2,F3,DB21)) ) ).

tff(fact_27_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB5) )
    <=> ( DB3 = DB5 ) ) ).

tff(fact_28_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_29_apps__eq__Abs__conv,axiom,
    ! [R: dB,Ss: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss) = abs(R) )
    <=> ( ( S = abs(R) )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_30_Abs__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( ( abs(R) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( abs(R) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_31_Beta,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss))) ) ) ).

tff(fact_32_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB3)) = aa(A,A,aa(dB,fun(A,A),F3,DB3),dB_rec(A,F1,F2,F3,DB3)) ) ).

tff(fact_33_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_34_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB4) ) ).

tff(fact_35_dB_Osimps_I7_J,axiom,
    ! [Nat3: nat,DB4: dB] : ( abs(DB4) != var(Nat3) ) ).

tff(fact_36_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat3: nat] : ( var(Nat3) != abs(DB4) ) ).

tff(fact_37_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_38_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB3)) = aa(dB,A,F3,DB3) ) ).

tff(fact_39_listsp_ONil,axiom,
    ! [A: $tType,A3: fun(A,bool)] : listsp(A,A3,nil(A)) ).

tff(fact_40_IT_Osimps,axiom,
    ! [A1: dB] :
      ( pp(aa(dB,bool,it,A1))
    <=> ( ? [Rs: list(dB),N3: nat] :
            ( ( A1 = foldl(dB,dB,app,var(N3),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R2: dB] :
            ( ( A1 = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S2: dB,Ss1: list(dB)] :
            ( ( A1 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S2),Ss1) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R2,S2,zero_zero(nat)),Ss1)))
            & pp(aa(dB,bool,it,S2)) ) ) ) ).

tff(fact_41_nat_Oinject,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( suc(Nat4) = suc(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_42_dB_Osize_I1_J,axiom,
    ! [Nat3: nat] : ( dB_size(var(Nat3)) = zero_zero(nat) ) ).

tff(fact_43_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_44_n__not__Suc__n,axiom,
    ! [N1: nat] : ( N1 != suc(N1) ) ).

tff(fact_45_Suc__n__not__n,axiom,
    ! [N1: nat] : ( suc(N1) != N1 ) ).

tff(fact_46_Suc__inject,axiom,
    ! [Y: nat,X1: nat] :
      ( ( suc(X1) = suc(Y) )
     => ( X1 = Y ) ) ).

tff(fact_47_Zero__not__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_48_nat_Osimps_I2_J,axiom,
    ! [Nat2: nat] : ( zero_zero(nat) != suc(Nat2) ) ).

tff(fact_49_Suc__not__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_50_nat_Osimps_I3_J,axiom,
    ! [Nat1: nat] : ( suc(Nat1) != zero_zero(nat) ) ).

tff(fact_51_Zero__neq__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_52_Suc__neq__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_53_foldl__Nil,axiom,
    ! [B1: $tType,A: $tType,A1: A,F: fun(A,fun(B1,A))] : ( foldl(A,B1,F,A1,nil(B1)) = A1 ) ).

tff(fact_54_not0__implies__Suc,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ? [M2: nat] : ( N1 = suc(M2) ) ) ).

tff(fact_55_nat__induct,axiom,
    ! [N: nat,P: fun(nat,bool)] :
      ( pp(aa(nat,bool,P,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P,N2))
           => pp(aa(nat,bool,P,suc(N2))) )
       => pp(aa(nat,bool,P,N)) ) ) ).

tff(fact_56_zero__induct,axiom,
    ! [K1: nat,P: fun(nat,bool)] :
      ( pp(aa(nat,bool,P,K1))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P,suc(N2)))
           => pp(aa(nat,bool,P,N2)) )
       => pp(aa(nat,bool,P,zero_zero(nat))) ) ) ).

tff(fact_57_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat: nat] : ( Y != suc(Nat) ) ) ).

tff(fact_58_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),dB_size(DB)),suc(zero_zero(nat))) ) ).

tff(fact_59_dB_Osize_I2_J,axiom,
    ! [DB2: dB,DB1: dB] : ( dB_size(aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),dB_size(DB1)),dB_size(DB2))),suc(zero_zero(nat))) ) ).

tff(fact_60_beta,axiom,
    ! [T1: dB,S1: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T1),subst(S1,T1,zero_zero(nat))) ).

tff(fact_61_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_62_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
        <=> ( B2 = C1 ) ) ) ).

tff(fact_63_nat__add__right__cancel,axiom,
    ! [N: nat,K1: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K1) )
    <=> ( M = N ) ) ).

tff(fact_64_nat__add__left__cancel,axiom,
    ! [N: nat,M: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),M) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),N) )
    <=> ( M = N ) ) ).

tff(fact_65_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_66_add__is__0,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_67_add__Suc__right,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),suc(N1)) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1)) ) ).

tff(fact_68_add__Suc,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M1)),N1) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1)) ) ).

tff(fact_69_appL,axiom,
    ! [U: dB,T1: dB,S1: dB] :
      ( beta(S1,T1)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U)) ) ).

tff(fact_70_appR,axiom,
    ! [U: dB,T1: dB,S1: dB] :
      ( beta(S1,T1)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S1),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T1)) ) ).

tff(fact_71_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ beta(var(I),T1) ).

tff(fact_72_abs,axiom,
    ! [T1: dB,S1: dB] :
      ( beta(S1,T1)
     => beta(abs(S1),abs(T1)) ) ).

tff(fact_73_ext,axiom,
    ! [B1: $tType,A: $tType,G: fun(A,B1),F: fun(A,B1)] :
      ( ! [X2: A] : ( aa(A,B1,F,X2) = aa(A,B1,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_foldl__assoc,axiom,
    ! [A: $tType] :
      ( semigroup_add(A)
     => ! [Zs: list(A),Y1: A,X: A] : ( foldl(A,A,plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),X),Y1),Zs) = aa(A,A,aa(A,fun(A,A),plus_plus(A),X),foldl(A,A,plus_plus(A),Y1,Zs)) ) ) ).

tff(fact_75_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S1: dB,R1: dB] :
      ( beta(R1,S1)
     => beta(subst(R1,T1,I),subst(S1,T1,I)) ) ).

tff(fact_76_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R1: dB] :
      ( beta(R1,S1)
     => beta(lift(R1,I),lift(S1,I)) ) ).

tff(fact_77_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A2: A,B: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B),A2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C),A2) )
         => ( B = C ) ) ) ).

tff(fact_78_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C) )
         => ( B = C ) ) ) ).

tff(fact_79_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C) )
         => ( B = C ) ) ) ).

tff(fact_80_nat__add__assoc,axiom,
    ! [K: nat,N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K)) ) ).

tff(fact_81_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B)),C) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),B),C)) ) ) ).

tff(fact_82_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),Z)) ) ).

tff(fact_83_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),M1) ) ).

tff(fact_84_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_85_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_86_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N1) = N1 ) ).

tff(fact_87_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_88_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_89_Nat_Oadd__0__right,axiom,
    ! [M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),zero_zero(nat)) = M1 ) ).

tff(fact_90_add__Suc__shift,axiom,
    ! [N1: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M1)),N1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),suc(N1)) ) ).

tff(fact_91_add__eq__self__zero,axiom,
    ! [N1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1) = M1 )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_92_foldl__absorb0,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),X: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),X),foldl(A,A,plus_plus(A),zero_zero(A),Zs)) = foldl(A,A,plus_plus(A),X,Zs) ) ) ).

tff(fact_93_one__is__add,axiom,
    ! [N: nat,M: nat] :
      ( ( suc(zero_zero(nat)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_94_add__is__1,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = suc(zero_zero(nat)) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_95_beta__cases_I2_J,axiom,
    ! [S1: dB,R1: dB] :
      ( beta(abs(R1),S1)
     => ~ ! [T: dB] :
            ( ( S1 = abs(T) )
           => ~ beta(R1,T) ) ) ).

tff(fact_96_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_97_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S: dB,R: dB] :
      ( beta(R,S)
     => beta(foldl(dB,dB,app,R,Ss),foldl(dB,dB,app,S,Ss)) ) ).

%----Arities (7)
tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,r)) ).

tff(conj_1,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,r),var(i)))) ).

tff(conj_2,conjecture,
    pp(aa(dB,bool,it,var(i))) ).

%------------------------------------------------------------------------------
