%------------------------------------------------------------------------------
% File     : LCL773_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 78
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_78 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  164 (  66 unt;  43 typ;   0 def)
%            Number of atoms       :  213 (  99 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  127 (  35   ~;   6   |;   9   &)
%                                         (  22 <=>;  55  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   46 (  24   >;  22   *;   0   +;   0  <<)
%            Number of predicates  :   11 (  10 usr;   0 prp; 1-3 aty)
%            Number of functors    :   27 (  27 usr;   6 con; 0-5 aty)
%            Number of variables   :  262 ( 236   !;   7   ?; 262   :)
%                                         (  19  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:19
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osgn__if,type,
    sgn_if: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Osgn__class_Osgn,type,
    sgn_sgn: 
      !>[A: $tType] : ( A > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,T2)) * fun(dB,T2) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,fun(T2,fun(T2,T2)))) * fun(dB,fun(T2,T2)) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_r,type,
    r: dB ).

%----Relevant facts (99)
tff(fact_0_Var__IT,axiom,
    ! [N3: nat] : pp(aa(dB,bool,it,var(N3))) ).

tff(fact_1_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,subst(R2,var(I),J))) ) ).

tff(fact_2_subst__App,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T,S1,K)),subst(U,S1,K)) ) ).

tff(fact_3_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_4_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB21: dB,DB11: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB11 = DB13 )
        & ( DB21 = DB23 ) ) ) ).

tff(fact_5_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_6_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_7_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != var(Nat) ) ).

tff(fact_8_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_9_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_10_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_11_substn__subst__0,axiom,
    ! [S1: dB,T: dB] : ( substn(T,S1,zero_zero(nat)) = subst(T,S1,zero_zero(nat)) ) ).

tff(fact_12_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_13_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S1,K)),substn(U,S1,K)) ) ).

tff(fact_14_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_15_substn__subst__n,axiom,
    ! [N3: nat,S1: dB,T: dB] : ( substn(T,S1,N3) = subst(T,liftn(N3,S1,zero_zero(nat)),N3) ) ).

tff(fact_16_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_17_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_18_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_19_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_20_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_21_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB11),DB21) ) ).

tff(fact_22_size__bool,axiom,
    ! [B1: bool] : ( size_size(bool,B1) = zero_zero(nat) ) ).

tff(fact_23_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB,N3: nat] : ( liftn(N3,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N3,S1,K)),liftn(N3,T,K)) ) ).

tff(fact_24_nat__size,axiom,
    ! [N3: nat] : ( size_size(nat,N3) = N3 ) ).

tff(fact_25_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_26_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_27_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB21: dB,DB11: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB11),DB21),dB_rec(A,F1,F2,F3,DB11)),dB_rec(A,F1,F2,F3,DB21)) ) ).

tff(fact_28_subst__lt,axiom,
    ! [U: dB,I: nat,J: nat] :
      ( ord_less(nat,J,I)
     => ( subst(var(J),U,I) = var(J) ) ) ).

tff(fact_29_char__size,axiom,
    ! [C: char] : ( char_size(C) = zero_zero(nat) ) ).

tff(fact_30_sgn0,axiom,
    ! [A: $tType] :
      ( sgn_if(A)
     => ( sgn_sgn(A,zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_31_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,lift(T,I))) ) ).

tff(fact_32_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB3)) = aa(dB,A,F3,DB3) ) ).

tff(fact_33_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_34_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S1: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S1,K)),lift(T,K)) ) ).

tff(fact_35_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB3: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB3)) = aa(A,A,aa(dB,fun(A,A),F3,DB3),dB_rec(A,F1,F2,F3,DB3)) ) ).

tff(fact_36_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_37_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_38_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_39_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_40_subst__lift,axiom,
    ! [S1: dB,K: nat,T: dB] : ( subst(lift(T,K),S1,K) = T ) ).

tff(fact_41_sgn__less,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,sgn_sgn(A,A1),zero_zero(A))
        <=> ord_less(A,A1,zero_zero(A)) ) ) ).

tff(fact_42_sgn__greater,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ord_less(A,zero_zero(A),sgn_sgn(A,A1))
        <=> ord_less(A,zero_zero(A),A1) ) ) ).

tff(fact_43_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_44_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_45_less__nat__zero__code,axiom,
    ! [N3: nat] : ~ ord_less(nat,N3,zero_zero(nat)) ).

tff(fact_46_less__zeroE,axiom,
    ! [N3: nat] : ~ ord_less(nat,N3,zero_zero(nat)) ).

tff(fact_47_sgn__sgn,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] : ( sgn_sgn(A,sgn_sgn(A,A2)) = sgn_sgn(A,A2) ) ) ).

tff(fact_48_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_49_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M: nat] :
      ( ( ord_less(nat,M,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
     => ( ( ( M = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
       => ( ( ord_less(nat,N1,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M)) ) ) ) ).

tff(fact_50_less__not__refl3,axiom,
    ! [T: nat,S1: nat] :
      ( ord_less(nat,S1,T)
     => ( S1 != T ) ) ).

tff(fact_51_less__not__refl2,axiom,
    ! [M1: nat,N3: nat] :
      ( ord_less(nat,N3,M1)
     => ( M1 != N3 ) ) ).

tff(fact_52_less__irrefl__nat,axiom,
    ! [N3: nat] : ~ ord_less(nat,N3,N3) ).

tff(fact_53_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_54_nat__neq__iff,axiom,
    ! [N1: nat,M: nat] :
      ( ( M != N1 )
    <=> ( ord_less(nat,M,N1)
        | ord_less(nat,N1,M) ) ) ).

tff(fact_55_less__not__refl,axiom,
    ! [N3: nat] : ~ ord_less(nat,N3,N3) ).

tff(fact_56_gr0I,axiom,
    ! [N3: nat] :
      ( ( N3 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N3) ) ).

tff(fact_57_gr__implies__not0,axiom,
    ! [N3: nat,M1: nat] :
      ( ord_less(nat,M1,N3)
     => ( N3 != zero_zero(nat) ) ) ).

tff(fact_58_not__less0,axiom,
    ! [N3: nat] : ~ ord_less(nat,N3,zero_zero(nat)) ).

tff(fact_59_sgn__0__0,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A1: A] :
          ( ( sgn_sgn(A,A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_60_size__char,axiom,
    ! [C: char] : ( size_size(char,C) = zero_zero(nat) ) ).

tff(fact_61_Beta,axiom,
    ! [Ss1: list(dB),S3: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R1,S3,zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S3))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S3),Ss1))) ) ) ).

tff(fact_62_beta,axiom,
    ! [T: dB,S1: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T),subst(S1,T,zero_zero(nat))) ).

tff(fact_63_size__literal__def,axiom,
    ! [S1: literal] : ( size_size(literal,S1) = zero_zero(nat) ) ).

tff(fact_64_appR,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S1),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_65_appL,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_66_beta__cases_I1_J,axiom,
    ! [T: dB,I: nat] : ~ beta(var(I),T) ).

tff(fact_67_abs,axiom,
    ! [T: dB,S1: dB] :
      ( beta(S1,T)
     => beta(abs(S1),abs(T)) ) ).

tff(fact_68_subst__preserves__beta,axiom,
    ! [I: nat,T: dB,S1: dB,R2: dB] :
      ( beta(R2,S1)
     => beta(subst(R2,T,I),subst(S1,T,I)) ) ).

tff(fact_69_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R2: dB] :
      ( beta(R2,S1)
     => beta(lift(R2,I),lift(S1,I)) ) ).

tff(fact_70_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S3: dB,Rs1: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rs1) = foldl(dB,dB,app,abs(S3),Ss1) )
    <=> ( ( R1 = S3 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_71_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N1: nat,Rs1: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs1) = foldl(dB,dB,app,var(N1),Ss1) )
    <=> ( ( M = N1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_72_beta__cases_I2_J,axiom,
    ! [S1: dB,R2: dB] :
      ( beta(abs(R2),S1)
     => ~ ! [T1: dB] :
            ( ( S1 = abs(T1) )
           => ~ beta(R2,T1) ) ) ).

tff(fact_73_apps__eq__tail__conv,axiom,
    ! [S3: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S3,Ts) )
    <=> ( R1 = S3 ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R1: dB,Ts: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts) != foldl(dB,dB,app,abs(R1),Ss1) ) ).

tff(fact_76_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N1: nat,Ta: dB,S3: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S3)),Ta) != foldl(dB,dB,app,var(N1),Ss1) ) ).

tff(fact_77_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S3: dB,R1: dB] :
      ( beta(R1,S3)
     => beta(foldl(dB,dB,app,R1,Ss1),foldl(dB,dB,app,S3,Ss1)) ) ).

tff(fact_78_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S1: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),U)
     => ( ! [S2: dB] :
            ( ( U = subst(S2,T,zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ beta(S1,T1) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1) )
               => ~ beta(T,T1) ) ) ) ) ).

tff(fact_79_IT_OVar,axiom,
    ! [N1: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs1))) ) ).

tff(fact_80_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,zero_zero(nat),N1) ) ) ).

tff(fact_81_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N1: nat,M: nat] :
          ( ( semiring_1_of_nat(A,M) = semiring_1_of_nat(A,N1) )
        <=> ( M = N1 ) ) ) ).

tff(fact_82_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_83_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,M,N1) ) ) ).

tff(fact_84_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N3: nat,M1: nat] :
          ( ord_less(nat,M1,N3)
         => ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N3)) ) ) ).

tff(fact_85_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N3: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N3))
         => ord_less(nat,M1,N3) ) ) ).

tff(fact_86_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M1: nat] : ~ ord_less(A,semiring_1_of_nat(A,M1),zero_zero(A)) ) ).

tff(fact_87_IT_Osimps,axiom,
    ! [A1: dB] :
      ( pp(aa(dB,bool,it,A1))
    <=> ( ? [Rs: list(dB),N2: nat] :
            ( ( A1 = foldl(dB,dB,app,var(N2),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R: dB] :
            ( ( A1 = abs(R) )
            & pp(aa(dB,bool,it,R)) )
        | ? [R: dB,S: dB,Ss: list(dB)] :
            ( ( A1 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S)) ) ) ) ).

tff(fact_88_zero__less__int__conv,axiom,
    ! [N1: nat] :
      ( ord_less(int,zero_zero(int),semiring_1_of_nat(int,N1))
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_89_int__int__eq,axiom,
    ! [N1: nat,M: nat] :
      ( ( semiring_1_of_nat(int,M) = semiring_1_of_nat(int,N1) )
    <=> ( M = N1 ) ) ).

tff(fact_90_int__less__0__conv,axiom,
    ! [K: nat] : ~ ord_less(int,semiring_1_of_nat(int,K),zero_zero(int)) ).

tff(fact_91_int__eq__0__conv,axiom,
    ! [N1: nat] :
      ( ( semiring_1_of_nat(int,N1) = zero_zero(int) )
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_92_int__0,axiom,
    semiring_1_of_nat(int,zero_zero(nat)) = zero_zero(int) ).

tff(fact_93_zless__int,axiom,
    ! [N1: nat,M: nat] :
      ( ord_less(int,semiring_1_of_nat(int,M),semiring_1_of_nat(int,N1))
    <=> ord_less(nat,M,N1) ) ).

tff(fact_94_zero__less__imp__eq__int,axiom,
    ! [K: int] :
      ( ord_less(int,zero_zero(int),K)
     => ? [N: nat] :
          ( ord_less(nat,zero_zero(nat),N)
          & ( K = semiring_1_of_nat(int,N) ) ) ) ).

tff(fact_95_transfer__int__nat__relations_I2_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less(nat,X1,Y1) ) ).

tff(fact_96_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_97_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) ) ) ).

tff(fact_98_transfer__int__nat__numerals_I1_J,axiom,
    zero_zero(int) = semiring_1_of_nat(int,zero_zero(nat)) ).

%----Arities (10)
tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Groups_Osgn__if,axiom,
    sgn_if(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (9)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,r)) ).

tff(conj_1,hypothesis,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,r),var(i)))) ).

tff(conj_2,conjecture,
    pp(aa(dB,bool,it,subst(r,var(i),zero_zero(nat)))) ).

%------------------------------------------------------------------------------
