%------------------------------------------------------------------------------
% File     : LCL772_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 77
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_77 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  153 (  50 unt;  37 typ;   0 def)
%            Number of atoms       :  226 (  88 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  139 (  29   ~;   2   |;   4   &)
%                                         (  21 <=>;  83  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   5 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   32 (  15   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :   18 (  17 usr;   0 prp; 1-3 aty)
%            Number of functors    :   17 (  17 usr;   4 con; 0-5 aty)
%            Number of variables   :  308 ( 286   !;   1   ?; 308   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:19:17
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (33)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: ( dB * dB ) > dB ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,fun(T1,fun(T1,T1)))) * fun(dB,fun(T1,T1)) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_r,type,
    r: dB ).

%----Relevant facts (99)
tff(fact_0_Var__IT,axiom,
    ! [N1: nat] : it(var(N1)) ).

tff(fact_1_Lambda,axiom,
    ! [R: dB] :
      ( it(R)
     => it(abs(R)) ) ).

tff(fact_2_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB: dB] :
      ( ( abs(DB) = abs(DB5) )
    <=> ( DB = DB5 ) ) ).

tff(fact_3_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat3) )
    <=> ( Nat1 = Nat3 ) ) ).

tff(fact_4_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB2: dB,DB1: dB] :
      ( ( app(DB1,DB2) = app(DB14,DB24) )
    <=> ( ( DB1 = DB14 )
        & ( DB2 = DB24 ) ) ) ).

tff(fact_5_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB4: dB] : ( abs(DB4) != var(Nat) ) ).

tff(fact_6_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat: nat] : ( var(Nat) != abs(DB4) ) ).

tff(fact_7_dB_Osimps_I9_J,axiom,
    ! [DB23: dB,DB13: dB,DB4: dB] : ( abs(DB4) != app(DB13,DB23) ) ).

tff(fact_8_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB23: dB,DB13: dB] : ( app(DB13,DB23) != abs(DB4) ) ).

tff(fact_9_dB_Osimps_I4_J,axiom,
    ! [DB22: dB,DB12: dB,Nat: nat] : ( var(Nat) != app(DB12,DB22) ) ).

tff(fact_10_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB22: dB,DB12: dB] : ( app(DB12,DB22) != var(Nat) ) ).

tff(fact_11_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R: dB] :
      ( it(R)
     => it(subst(R,var(I),J)) ) ).

tff(fact_12_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat2: nat] : ( Y != var(Nat2) )
     => ( ! [DB11: dB,DB21: dB] : ( Y != app(DB11,DB21) )
       => ~ ! [DB3: dB] : ( Y != abs(DB3) ) ) ) ).

tff(fact_13_subst__App,axiom,
    ! [K1: nat,S: dB,U: dB,T: dB] : ( subst(app(T,U),S,K1) = app(subst(T,S,K1),subst(U,S,K1)) ) ).

tff(fact_14_subst__eq,axiom,
    ! [U: dB,K1: nat] : ( subst(var(K1),U,K1) = U ) ).

tff(fact_15_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_16_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_17_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,app(DB1,DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_18_substn_Osimps_I2_J,axiom,
    ! [K1: nat,S: dB,U: dB,T: dB] : ( substn(app(T,U),S,K1) = app(substn(T,S,K1),substn(U,S,K1)) ) ).

tff(fact_19_liftn_Osimps_I2_J,axiom,
    ! [K1: nat,T: dB,S: dB,N1: nat] : ( liftn(N1,app(S,T),K1) = app(liftn(N1,S,K1),liftn(N1,T,K1)) ) ).

tff(fact_20_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB)) = aa(A,A,aa(dB,fun(A,A),F3,DB),dB_rec(A,F1,F2,F3,DB)) ) ).

tff(fact_21_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_22_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,app(DB1,DB2)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB1),DB2),dB_rec(A,F1,F2,F3,DB1)),dB_rec(A,F1,F2,F3,DB2)) ) ).

tff(fact_23_subst__lt,axiom,
    ! [U: dB,I: nat,J: nat] :
      ( ord_less(nat,J,I)
     => ( subst(var(J),U,I) = var(J) ) ) ).

tff(fact_24_substn__subst__n,axiom,
    ! [N1: nat,S: dB,T: dB] : ( substn(T,S,N1) = subst(T,liftn(N1,S,zero_zero(nat)),N1) ) ).

tff(fact_25_liftn_Osimps_I1_J,axiom,
    ! [N1: nat,K1: nat,I: nat] :
      ( ( ord_less(nat,I,K1)
       => ( liftn(N1,var(I),K1) = var(I) ) )
      & ( ~ ord_less(nat,I,K1)
       => ( liftn(N1,var(I),K1) = var(plus_plus(nat,I,N1)) ) ) ) ).

tff(fact_26_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),N: nat,M: nat] :
      ( ( ord_less(nat,M,N)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M)) )
     => ( ( ( M = N )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M)) )
       => ( ( ord_less(nat,N,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N),M)) ) ) ) ).

tff(fact_27_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_28_less__not__refl2,axiom,
    ! [M1: nat,N1: nat] :
      ( ord_less(nat,N1,M1)
     => ( M1 != N1 ) ) ).

tff(fact_29_less__irrefl__nat,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_30_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_31_nat__add__left__cancel,axiom,
    ! [N: nat,M: nat,K2: nat] :
      ( ( plus_plus(nat,K2,M) = plus_plus(nat,K2,N) )
    <=> ( M = N ) ) ).

tff(fact_32_nat__add__right__cancel,axiom,
    ! [N: nat,K2: nat,M: nat] :
      ( ( plus_plus(nat,M,K2) = plus_plus(nat,N,K2) )
    <=> ( M = N ) ) ).

tff(fact_33_less__zeroE,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_34_less__nat__zero__code,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_35_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_36_add__is__0,axiom,
    ! [N: nat,M: nat] :
      ( ( plus_plus(nat,M,N) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N = zero_zero(nat) ) ) ) ).

tff(fact_37_nat__add__left__cancel__less,axiom,
    ! [N: nat,M: nat,K2: nat] :
      ( ord_less(nat,plus_plus(nat,K2,M),plus_plus(nat,K2,N))
    <=> ord_less(nat,M,N) ) ).

tff(fact_38_add__gr__0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,M,N))
    <=> ( ord_less(nat,zero_zero(nat),M)
        | ord_less(nat,zero_zero(nat),N) ) ) ).

tff(fact_39_gr0I,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_40_add__lessD1,axiom,
    ! [K1: nat,J: nat,I: nat] :
      ( ord_less(nat,plus_plus(nat,I,J),K1)
     => ord_less(nat,I,K1) ) ).

tff(fact_41_less__add__eq__less,axiom,
    ! [N1: nat,M1: nat,L: nat,K1: nat] :
      ( ord_less(nat,K1,L)
     => ( ( plus_plus(nat,M1,L) = plus_plus(nat,K1,N1) )
       => ord_less(nat,M1,N1) ) ) ).

tff(fact_42_add__less__mono,axiom,
    ! [L: nat,K1: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ( ord_less(nat,K1,L)
       => ord_less(nat,plus_plus(nat,I,K1),plus_plus(nat,J,L)) ) ) ).

tff(fact_43_add__less__mono1,axiom,
    ! [K1: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,plus_plus(nat,I,K1),plus_plus(nat,J,K1)) ) ).

tff(fact_44_trans__less__add2,axiom,
    ! [M1: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,M1,J)) ) ).

tff(fact_45_trans__less__add1,axiom,
    ! [M1: nat,J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ord_less(nat,I,plus_plus(nat,J,M1)) ) ).

tff(fact_46_gr__implies__not0,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
     => ( N1 != zero_zero(nat) ) ) ).

tff(fact_47_not__add__less2,axiom,
    ! [I: nat,J: nat] : ~ ord_less(nat,plus_plus(nat,J,I),I) ).

tff(fact_48_not__add__less1,axiom,
    ! [J: nat,I: nat] : ~ ord_less(nat,plus_plus(nat,I,J),I) ).

tff(fact_49_not__less0,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,zero_zero(nat)) ).

tff(fact_50_plus__nat_Oadd__0,axiom,
    ! [N1: nat] : ( plus_plus(nat,zero_zero(nat),N1) = N1 ) ).

tff(fact_51_Nat_Oadd__0__right,axiom,
    ! [M1: nat] : ( plus_plus(nat,M1,zero_zero(nat)) = M1 ) ).

tff(fact_52_nat__add__commute,axiom,
    ! [N1: nat,M1: nat] : ( plus_plus(nat,M1,N1) = plus_plus(nat,N1,M1) ) ).

tff(fact_53_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_54_nat__add__assoc,axiom,
    ! [K1: nat,N1: nat,M1: nat] : ( plus_plus(nat,plus_plus(nat,M1,N1),K1) = plus_plus(nat,M1,plus_plus(nat,N1,K1)) ) ).

tff(fact_55_add__eq__self__zero,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = M1 )
     => ( N1 = zero_zero(nat) ) ) ).

tff(fact_56_liftn__0,axiom,
    ! [K1: nat,T: dB] : ( liftn(zero_zero(nat),T,K1) = T ) ).

tff(fact_57_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = subst(T,S,zero_zero(nat)) ) ).

tff(fact_58_less__not__refl,axiom,
    ! [N1: nat] : ~ ord_less(nat,N1,N1) ).

tff(fact_59_nat__neq__iff,axiom,
    ! [N: nat,M: nat] :
      ( ( M != N )
    <=> ( ord_less(nat,M,N)
        | ord_less(nat,N,M) ) ) ).

tff(fact_60_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_61_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A2,A2))
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_62_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A2: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_63_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B1,C1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_64_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_65_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( plus_plus(A,A2,A2) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_66_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ( plus_plus(A,B1,A2) = plus_plus(A,C1,A2) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_67_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_68_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_69_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_70_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_71_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_72_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_73_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_74_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_75_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_76_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( plus_plus(A,zero_zero(A),A1) = A1 ) ) ).

tff(fact_77_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C)) ) ) ).

tff(fact_78_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B)) ) ) ).

tff(fact_79_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C,D)
           => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ) ).

tff(fact_80_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
         => ord_less(A,A1,B) ) ) ).

tff(fact_81_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
         => ord_less(A,A1,B) ) ) ).

tff(fact_82_even__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_83_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),plus_plus(A,A1,B)) ) ) ) ).

tff(fact_84_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,plus_plus(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_85_less__imp__add__positive,axiom,
    ! [J: nat,I: nat] :
      ( ord_less(nat,I,J)
     => ? [K: nat] :
          ( ord_less(nat,zero_zero(nat),K)
          & ( plus_plus(nat,I,K) = J ) ) ) ).

tff(fact_86_pos__add__strict,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,B,C)
           => ord_less(A,B,plus_plus(A,A1,C)) ) ) ) ).

tff(fact_87_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_88_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_89_termination__basic__simps_I2_J,axiom,
    ! [Y: nat,Z: nat,X: nat] :
      ( ord_less(nat,X,Z)
     => ord_less(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_90_termination__basic__simps_I1_J,axiom,
    ! [Z: nat,Y: nat,X: nat] :
      ( ord_less(nat,X,Y)
     => ord_less(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_91_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [A2: A,B1: A] :
          ( ( B1 = plus_plus(A,B1,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_92_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( plus_plus(A,A1,zero_zero(A)) = A1 ) ) ).

tff(fact_93_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,A1: A] : ( plus_plus(A,A1,C) = plus_plus(A,C,A1) ) ) ).

tff(fact_94_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,C,plus_plus(A,A1,D)) ) ) ).

tff(fact_95_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,A1: A] : ( plus_plus(A,A1,plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),D) ) ) ).

tff(fact_96_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_97_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,plus_plus(A,A1,C),B) ) ) ).

tff(fact_98_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),plus_plus(A,C,D)) = plus_plus(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ).

%----Arities (12)
tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    it(r) ).

tff(conj_1,hypothesis,
    it(app(r,var(i))) ).

tff(conj_2,conjecture,
    it(app(abs(r),var(i))) ).

%------------------------------------------------------------------------------
