%------------------------------------------------------------------------------
% File     : LCL767_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 72
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_72 [Bla13]

% Status   : Theorem
% Rating   : 0.33 v7.4.0, 0.75 v7.1.0, 1.00 v6.4.0
% Syntax   : Number of formulae    :  156 (  49 unt;  39 typ;   0 def)
%            Number of atoms       :  240 ( 180 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  174 (  51   ~;  17   |;  33   &)
%                                         (  34 <=>;  39  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   6 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   40 (  23   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :    5 (   4 usr;   0 prp; 1-3 aty)
%            Number of functors    :   32 (  32 usr;  10 con; 0-5 aty)
%            Number of variables   :  428 ( 385   !;  12   ?; 428   :)
%                                         (  31  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:49
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( fun(A,fun(B,C)) > fun(B,fun(A,C)) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T: $tType] : ( ( fun(nat,T) * fun(dB,fun(dB,T)) * fun(dB,T) * dB ) > T ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : fun(list(A),fun(list(A),list(A))) ).

tff(sy_c_List_Obutlast,type,
    butlast: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T: $tType,A: $tType] : ( ( T * fun(A,fun(list(A),T)) * list(A) ) > T ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_rs,type,
    rs: list(dB) ).

%----Relevant facts (100)
tff(fact_0_Var__IT,axiom,
    ! [N2: nat] : pp(aa(dB,bool,it,var(N2))) ).

tff(fact_1_IT_OVar,axiom,
    ! [N1: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs))) ) ).

tff(fact_2_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( var(M) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_3_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N1: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N1),Ss) )
    <=> ( ( M = N1 )
        & ( Rs = Ss ) ) ) ).

tff(fact_4_append1__eq__conv,axiom,
    ! [A: $tType,Y1: A,Ys: list(A),X1: A,Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A))) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),nil(A))) )
    <=> ( ( Xs = Ys )
        & ( X1 = Y1 ) ) ) ).

tff(fact_5_App__eq__foldl__conv,axiom,
    ! [Ts1: list(dB),Ta: dB,S: dB,R1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,R1),S) = foldl(dB,dB,app,Ta,Ts1) )
    <=> ( ( ( Ts1 = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,R1),S) = Ta ) )
        & ( ( Ts1 != nil(dB) )
         => ? [Ss1: list(dB)] :
              ( ( Ts1 = aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),Ss1),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),S),nil(dB))) )
              & ( R1 = foldl(dB,dB,app,Ta,Ss1) ) ) ) ) ) ).

tff(fact_6_app__last,axiom,
    ! [U1: dB,Ts1: list(dB),Ta: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,Ta,Ts1)),U1) = foldl(dB,dB,app,Ta,aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),Ts1),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),U1),nil(dB)))) ) ).

tff(fact_7_append__in__listsp__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),A3: fun(A,bool)] :
      ( listsp(A,A3,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys))
    <=> ( listsp(A,A3,Xs)
        & listsp(A,A3,Ys) ) ) ).

tff(fact_8_listsp_ONil,axiom,
    ! [A: $tType,A3: fun(A,bool)] : listsp(A,A3,nil(A)) ).

tff(fact_9_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts1: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts1) = foldl(dB,dB,app,S,Ts1) )
    <=> ( R1 = S ) ) ).

tff(fact_10_foldl__append,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),Xs: list(B),A1: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A1,aa(list(B),list(B),aa(list(B),fun(list(B),list(B)),append(B),Xs),Ys)) = foldl(A,B,F,foldl(A,B,F,A1,Xs),Ys) ) ).

tff(fact_11_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( nil(A) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_12_self__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_13_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List: list(A),A1: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A1),List) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A6),List3) )
    <=> ( ( A1 = A6 )
        & ( List = List3 ) ) ) ).

tff(fact_14_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs: list(A),Ys: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),Xs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs),Xs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_15_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Zs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_16_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys1: list(A),Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)),Zs1) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys1),Zs1)) ) ).

tff(fact_17_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A3: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,A3),B1),X3)
    <=> ( listsp(A,A3,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_18_append__Cons,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A),X: A] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)),Ys1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)) ) ).

tff(fact_19_append__self__conv2,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = Ys )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_20_append__self__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = Xs )
    <=> ( Ys = nil(A) ) ) ).

tff(fact_21_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = nil(A) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_22_self__append__conv2,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( Ys = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_23_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) != Xs1 ) ).

tff(fact_24_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) ) ).

tff(fact_25_append__eq__appendI,axiom,
    ! [A: $tType,Us1: list(A),Ys1: list(A),Zs1: list(A),Xs11: list(A),Xs1: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Xs11) = Zs1 )
     => ( ( Ys1 = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs11),Us1) )
       => ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs1),Us1) ) ) ) ).

tff(fact_26_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts1: list(A),Zs: list(A),Ys: list(A),Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs),Ts1) )
    <=> ? [Us: list(A)] :
          ( ( ( Xs = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Zs),Us) )
            & ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Us),Ys) = Ts1 ) )
          | ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Us) = Zs )
            & ( Ys = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Us),Ts1) ) ) ) ) ).

tff(fact_27_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) != nil(A) ) ).

tff(fact_28_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) ) ).

tff(fact_29_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs1: list(A),Ys1: list(A),Xs11: list(A),X: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs11) = Ys1 )
     => ( ( Xs1 = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs11),Zs1) )
       => ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys1),Zs1) ) ) ) ).

tff(fact_30_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( Xs1 = Ys1 )
     => ( Xs1 = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),nil(A)),Ys1) ) ) ).

tff(fact_31_append__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),nil(A)) = Xs1 ) ).

tff(fact_32_append__Nil,axiom,
    ! [A: $tType,Ys1: list(A)] : ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),nil(A)),Ys1) = Ys1 ) ).

tff(fact_33_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,A1: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A1,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A1),X1),Xs) ) ).

tff(fact_34_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A1: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A1,nil(B)) = A1 ) ).

tff(fact_35_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A),X1: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),Zs) )
    <=> ( ( ( Ys = nil(A) )
          & ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) = Zs ) )
        | ? [Ys4: list(A)] :
            ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Ys4) = Ys )
            & ( Xs = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys4),Zs) ) ) ) ) ).

tff(fact_36_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Zs: list(A),Ys: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys),Zs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) )
    <=> ( ( ( Ys = nil(A) )
          & ( Zs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) ) )
        | ? [Ys4: list(A)] :
            ( ( Ys = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Ys4) )
            & ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys4),Zs) = Xs ) ) ) ) ).

tff(fact_37_listsp_Osimps,axiom,
    ! [A: $tType,A1: list(A),A3: fun(A,bool)] :
      ( listsp(A,A3,A1)
    <=> ( ( A1 = nil(A) )
        | ? [A4: A,L: list(A)] :
            ( ( A1 = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),L) )
            & pp(aa(A,bool,A3,A4))
            & listsp(A,A3,L) ) ) ) ).

tff(fact_38_rev__cases,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ~ ! [Ys2: list(A),Y2: A] : ( Xs1 != aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys2),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),nil(A))) ) ) ).

tff(fact_39_rev__induct,axiom,
    ! [A: $tType,Xs: list(A),P1: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P1,nil(A)))
     => ( ! [X2: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P1,Xs2))
           => pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs2),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A))))) )
       => pp(aa(list(A),bool,P1,Xs)) ) ) ).

tff(fact_40_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat3) )
    <=> ( Nat = Nat3 ) ) ).

tff(fact_41_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB1 = DB14 )
        & ( DB2 = DB24 ) ) ) ).

tff(fact_42_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List1: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List1) ) ) ).

tff(fact_43_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y3: A,Ys3: list(A)] : ( Xs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y3),Ys3) ) ) ).

tff(fact_44_dB_Osimps_I5_J,axiom,
    ! [Nat2: nat,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != var(Nat2) ) ).

tff(fact_45_dB_Osimps_I4_J,axiom,
    ! [DB23: dB,DB13: dB,Nat2: nat] : ( var(Nat2) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_46_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) ).

tff(fact_47_rev__exhaust2,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ~ ! [Ys2: list(A),Y2: A] : ( Xs1 != aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Ys2),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),nil(A))) ) ) ).

tff(fact_48_rotate__simps,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X: B] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X),Xs1)) = aa(list(B),list(B),aa(list(B),fun(list(B),list(B)),append(B),Xs1),aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X),nil(B))) ) ) ).

tff(fact_49_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,F: fun(B,list(A))] : ( maps(B,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xs)) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),aa(B,list(A),F,X1)),maps(B,A,F,Xs)) ) ).

tff(fact_50_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( rotate1(A,Xs) = nil(A) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_51_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_52_rotate1__def,axiom,
    ! [A: $tType,Xs: list(A)] : ( rotate1(A,Xs) = list_case(list(A),A,nil(A),combb(list(A),fun(list(A),list(A)),A,combc(list(A),list(A),list(A),append(A)),aa(list(A),fun(A,list(A)),combc(A,list(A),list(A),cons(A)),nil(A))),Xs) ) ).

tff(fact_53_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X1: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y2: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X2)),Y2) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y2)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X1) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X1),Xs) ) ) ).

tff(fact_54_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va),nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),V),Va) ) ).

tff(fact_55_apps__eq__Abs__conv,axiom,
    ! [R1: dB,Ss: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss) = abs(R1) )
    <=> ( ( S = abs(R1) )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_56_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB: dB] :
      ( ( abs(DB) = abs(DB5) )
    <=> ( DB = DB5 ) ) ).

tff(fact_57_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_58_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys1: list(A),Y: A,Xs1: list(A),X: A] : ( splice(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),Ys1)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y),splice(A,Xs1,Ys1))) ) ).

tff(fact_59_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rs) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( R1 = S )
        & ( Rs = Ss ) ) ) ).

tff(fact_60_Abs__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( ( abs(R1) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( abs(R1) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_61_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat2: nat] : ( var(Nat2) != abs(DB4) ) ).

tff(fact_62_dB_Osimps_I7_J,axiom,
    ! [Nat2: nat,DB4: dB] : ( abs(DB4) != var(Nat2) ) ).

tff(fact_63_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != abs(DB4) ) ).

tff(fact_64_dB_Osimps_I9_J,axiom,
    ! [DB22: dB,DB12: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_65_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys1: list(A)] : ( splice(A,nil(A),Ys1) = Ys1 ) ).

tff(fact_66_splice__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( splice(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_67_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),N1: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N1),Ss) ) ).

tff(fact_68_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),R1: dB,Ts1: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts1) != foldl(dB,dB,app,abs(R1),Ss) ) ).

tff(fact_69_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List: list(B),A1: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A1),List)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A1),List) ) ).

tff(fact_70_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_71_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_72_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat1: nat] : ( Y != var(Nat1) )
     => ( ! [DB11: dB,DB21: dB] : ( Y != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) )
       => ~ ! [DB3: dB] : ( Y != abs(DB3) ) ) ) ).

tff(fact_73_ex__head__tail,axiom,
    ! [Ta: dB] :
    ? [Ts: list(dB),H: dB] :
      ( ( Ta = foldl(dB,dB,app,H,Ts) )
      & ( ? [N: nat] : ( H = var(N) )
        | ? [U: dB] : ( H = abs(U) ) ) ) ).

tff(fact_74_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,P1: fun(A,bool)] :
      ( list_ex1(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs))
    <=> ( ( pp(aa(A,bool,P1,X1))
         => list_all(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fdisj,combb(bool,bool,A,fNot,P1)),fequal(A,X1)),Xs) )
        & ( ~ pp(aa(A,bool,P1,X1))
         => list_ex1(A,P1,Xs) ) ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_77_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,P1: fun(A,bool)] :
      ( list_all(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs))
    <=> ( pp(aa(A,bool,P1,X1))
        & list_all(A,P1,Xs) ) ) ).

tff(fact_78_list__all__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : list_all(A,P1,nil(A)) ).

tff(fact_79_list__all__append,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),P1: fun(A,bool)] :
      ( list_all(A,P1,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),Ys))
    <=> ( list_all(A,P1,Xs)
        & list_all(A,P1,Ys) ) ) ).

tff(fact_80_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_81_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_82_list__nonempty__induct,axiom,
    ! [A: $tType,P1: fun(list(A),bool),Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),nil(A))))
       => ( ! [X2: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P1,Xs2))
               => pp(aa(list(A),bool,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X2),Xs2))) ) )
         => pp(aa(list(A),bool,P1,Xs)) ) ) ) ).

tff(fact_83_last__snoc,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( last(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)))) = X ) ).

tff(fact_84_last_Osimps,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] :
      ( ( ( Xs1 = nil(A) )
       => ( last(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = X ) )
      & ( ( Xs1 != nil(A) )
       => ( last(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = last(A,Xs1) ) ) ) ).

tff(fact_85_last__ConsL,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] :
      ( ( Xs1 = nil(A) )
     => ( last(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = X ) ) ).

tff(fact_86_last__ConsR,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ( last(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = last(A,Xs1) ) ) ).

tff(fact_87_last__appendL,axiom,
    ! [A: $tType,Xs1: list(A),Ys1: list(A)] :
      ( ( Ys1 = nil(A) )
     => ( last(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)) = last(A,Xs1) ) ) ).

tff(fact_88_last__appendR,axiom,
    ! [A: $tType,Xs1: list(A),Ys1: list(A)] :
      ( ( Ys1 != nil(A) )
     => ( last(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)) = last(A,Ys1) ) ) ).

tff(fact_89_last__append,axiom,
    ! [A: $tType,Xs1: list(A),Ys1: list(A)] :
      ( ( ( Ys1 = nil(A) )
       => ( last(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)) = last(A,Xs1) ) )
      & ( ( Ys1 != nil(A) )
       => ( last(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)) = last(A,Ys1) ) ) ) ).

tff(fact_90_snoc__eq__iff__butlast,axiom,
    ! [A: $tType,Ys: list(A),X1: A,Xs: list(A)] :
      ( ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A))) = Ys )
    <=> ( ( Ys != nil(A) )
        & ( butlast(A,Ys) = Xs )
        & ( last(A,Ys) = X1 ) ) ) ).

tff(fact_91_append__butlast__last__id,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ( aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),butlast(A,Xs1)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),last(A,Xs1)),nil(A))) = Xs1 ) ) ).

tff(fact_92_butlast_Osimps_I1_J,axiom,
    ! [A: $tType] : ( butlast(A,nil(A)) = nil(A) ) ).

tff(fact_93_butlast_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] :
      ( ( ( Xs1 = nil(A) )
       => ( butlast(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = nil(A) ) )
      & ( ( Xs1 != nil(A) )
       => ( butlast(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),butlast(A,Xs1)) ) ) ) ).

tff(fact_94_butlast__append,axiom,
    ! [A: $tType,Xs1: list(A),Ys1: list(A)] :
      ( ( ( Ys1 = nil(A) )
       => ( butlast(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)) = butlast(A,Xs1) ) )
      & ( ( Ys1 != nil(A) )
       => ( butlast(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),Ys1)) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),butlast(A,Ys1)) ) ) ) ).

tff(fact_95_butlast__snoc,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( butlast(A,aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),Xs1),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)))) = Xs1 ) ).

tff(fact_96_rev_Osimps_I2_J,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( rev(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1)) = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),rev(A,Xs1)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A))) ) ).

tff(fact_97_rev__eq__Cons__iff,axiom,
    ! [A: $tType,Ys: list(A),Y1: A,Xs: list(A)] :
      ( ( rev(A,Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Ys) )
    <=> ( Xs = aa(list(A),list(A),aa(list(A),fun(list(A),list(A)),append(A),rev(A,Ys)),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),nil(A))) ) ) ).

tff(fact_98_rev__is__rev__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( rev(A,Xs) = rev(A,Ys) )
    <=> ( Xs = Ys ) ) ).

tff(fact_99_rev_Osimps_I1_J,axiom,
    ! [A: $tType] : ( rev(A,nil(A)) = nil(A) ) ).

%----Helper facts (15)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,aa(B,fun(A,C),combc(A,B,C,P),Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,fequal(A,X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,fequal(A,X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    listsp(dB,combs(dB,bool,bool,combb(bool,fun(bool,bool),dB,fconj,it),combb(dB,bool,dB,it,aa(dB,fun(dB,dB),combc(dB,dB,dB,app),var(i)))),rs) ).

tff(conj_1,conjecture,
    pp(aa(dB,bool,it,foldl(dB,dB,app,var(n),aa(list(dB),list(dB),aa(list(dB),fun(list(dB),list(dB)),append(dB),rs),aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),var(i)),nil(dB)))))) ).

%------------------------------------------------------------------------------
