%------------------------------------------------------------------------------
% File     : LCL766_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 71
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_71 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  165 (  59 unt;  48 typ;   0 def)
%            Number of atoms       :  216 ( 113 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  139 (  40   ~;  13   |;  18   &)
%                                         (  20 <=>;  48  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    9 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   48 (  26   >;  22   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-3 aty)
%            Number of functors    :   40 (  40 usr;  12 con; 0-5 aty)
%            Number of variables   :  416 ( 365   !;  13   ?; 416   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:17:23
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (43)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T2: $tType] : ( ( fun(nat,T2) * fun(dB,fun(dB,T2)) * fun(dB,T2) * dB ) > T2 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( fun(A,fun(A,bool)) > fun(list(A),fun(list(A),bool)) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),T2)) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T2: $tType,A: $tType] : ( ( T2 * fun(A,fun(list(A),fun(T2,T2))) * list(A) ) > T2 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omonoid__add__class_Olistsum,type,
    monoid_add_listsum: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Predicate_Oconversep,type,
    conversep: 
      !>[A: $tType,B: $tType] : ( fun(A,fun(B,bool)) > fun(B,fun(A,bool)) ) ).

tff(sy_c_Wellfounded_Oaccp,type,
    accp: 
      !>[A: $tType] : ( fun(A,fun(A,bool)) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_rs,type,
    rs: list(dB) ).

%----Relevant facts (99)
tff(fact_0_Var__IT,axiom,
    ! [N1: nat] : pp(aa(dB,bool,it,var(N1))) ).

tff(fact_1_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_2_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss) )
    <=> ( ( M = N )
        & ( Rs = Ss ) ) ) ).

tff(fact_3_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,R1,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R1 = S ) ) ).

tff(fact_4_listsp__conj__eq,axiom,
    ! [A: $tType,B2: fun(A,bool),A2: fun(A,bool),X1: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A2),B2),X1)
    <=> ( listsp(A,A2,X1)
        & listsp(A,B2,X1) ) ) ).

tff(fact_5_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat3) )
    <=> ( Nat1 = Nat3 ) ) ).

tff(fact_6_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB1 = DB14 )
        & ( DB2 = DB24 ) ) ) ).

tff(fact_7_dB_Osimps_I4_J,axiom,
    ! [DB23: dB,DB13: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_8_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != var(Nat) ) ).

tff(fact_9_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),var(I)),J))) ) ).

tff(fact_10_Var__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( var(M) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_11_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),N: nat,Ta: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),Ta) != foldl(dB,dB,app,var(N),Ss) ) ).

tff(fact_12_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),R1: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(R1),Ss) ) ).

tff(fact_13_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB: dB] :
      ( ( abs(DB) = abs(DB5) )
    <=> ( DB = DB5 ) ) ).

tff(fact_14_listsp_ONil,axiom,
    ! [A: $tType,A2: fun(A,bool)] : listsp(A,A2,nil(A)) ).

tff(fact_15_subst__App,axiom,
    ! [K: nat,S1: dB,U2: dB,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2)),S1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U2),S1),K)) ) ).

tff(fact_16_Lambda,axiom,
    ! [R3: dB] :
      ( pp(aa(dB,bool,it,R3))
     => pp(aa(dB,bool,it,abs(R3))) ) ).

tff(fact_17_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs: list(dB),R1: dB] :
      ( ( foldl(dB,dB,app,abs(R1),Rs) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( R1 = S )
        & ( Rs = Ss ) ) ) ).

tff(fact_18_apps__eq__Abs__conv,axiom,
    ! [R1: dB,Ss: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss) = abs(R1) )
    <=> ( ( S = abs(R1) )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_19_Abs__eq__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( ( abs(R1) = foldl(dB,dB,app,S,Ss) )
    <=> ( ( abs(R1) = S )
        & ( Ss = nil(dB) ) ) ) ).

tff(fact_20_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A1: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A1,nil(B)) = A1 ) ).

tff(fact_21_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != abs(DB4) ) ).

tff(fact_22_dB_Osimps_I9_J,axiom,
    ! [DB22: dB,DB12: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_23_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat: nat] : ( var(Nat) != abs(DB4) ) ).

tff(fact_24_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB4: dB] : ( abs(DB4) != var(Nat) ) ).

tff(fact_25_subst__eq,axiom,
    ! [U2: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U2),K) = U2 ) ).

tff(fact_26_Beta,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss))) ) ) ).

tff(fact_27_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X2: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X3: A,Y2: A,S2: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),X3)),Y2) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),Y2)),X3) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X2) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X2),Xs) ) ) ).

tff(fact_28_IT_Osimps,axiom,
    ! [A1: dB] :
      ( pp(aa(dB,bool,it,A1))
    <=> ( ? [Rs2: list(dB),N3: nat] :
            ( ( A1 = foldl(dB,dB,app,var(N3),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R4: dB] :
            ( ( A1 = abs(R4) )
            & pp(aa(dB,bool,it,R4)) )
        | ? [R4: dB,S3: dB,Ss2: list(dB)] :
            ( ( A1 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R4)),S3),Ss2) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R4),S3),zero_zero(nat)),Ss2)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_29_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_30_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_31_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat2: nat] : ( Y != var(Nat2) )
     => ( ! [DB11: dB,DB21: dB] : ( Y != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) )
       => ~ ! [DB3: dB] : ( Y != abs(DB3) ) ) ) ).

tff(fact_32_ex__head__tail,axiom,
    ! [Ta: dB] :
    ? [Ts1: list(dB),H: dB] :
      ( ( Ta = foldl(dB,dB,app,H,Ts1) )
      & ( ? [N2: nat] : ( H = var(N2) )
        | ? [U: dB] : ( H = abs(U) ) ) ) ).

tff(fact_33_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_34_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_35_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_36_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_37_beta,axiom,
    ! [T1: dB,S1: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T1)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T1),zero_zero(nat)))) ).

tff(fact_38_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_39_substn__subst__0,axiom,
    ! [S1: dB,T1: dB] : ( substn(T1,S1,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S1),zero_zero(nat)) ) ).

tff(fact_40_appR,axiom,
    ! [U2: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U2),S1)),aa(dB,dB,aa(dB,fun(dB,dB),app,U2),T1))) ) ).

tff(fact_41_appL,axiom,
    ! [U2: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U2)),aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2))) ) ).

tff(fact_42_beta__cases_I1_J,axiom,
    ! [T1: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T1)) ).

tff(fact_43_abs,axiom,
    ! [T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S1)),abs(T1))) ) ).

tff(fact_44_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U2: dB,T1: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U2),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T1,S1,K)),substn(U2,S1,K)) ) ).

tff(fact_45_subst__preserves__beta,axiom,
    ! [I: nat,T1: dB,S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),T1),I)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T1),I))) ) ).

tff(fact_46_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X2: A] :
          ( ( zero_zero(A) = X2 )
        <=> ( X2 = zero_zero(A) ) ) ) ).

tff(fact_47_beta__cases_I2_J,axiom,
    ! [S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R3)),S1))
     => ~ ! [T: dB] :
            ( ( S1 = abs(T) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),T)) ) ) ).

tff(fact_48_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Ss)),foldl(dB,dB,app,S,Ss))) ) ).

tff(fact_49_substn__subst__n,axiom,
    ! [N1: nat,S1: dB,T1: dB] : ( substn(T1,S1,N1) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),liftn(N1,S1,zero_zero(nat))),N1) ) ).

tff(fact_50_beta__cases_I3_J,axiom,
    ! [U2: dB,T1: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),U2))
     => ( ! [S2: dB] :
            ( ( U2 = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T1),zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T: dB] :
              ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,T),T1) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T)) )
         => ~ ! [T: dB] :
                ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T)) ) ) ) ) ).

tff(fact_51_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_52_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S1,K)),liftn(N1,T1,K)) ) ).

tff(fact_53_liftn__0,axiom,
    ! [K: nat,T1: dB] : ( liftn(zero_zero(nat),T1,K) = T1 ) ).

tff(fact_54_apps__preserves__betas,axiom,
    ! [R1: dB,Ss: list(dB),Rs: list(dB)] :
      ( pp(aa(list(dB),bool,aa(list(dB),fun(list(dB),bool),step1(dB,beta),Rs),Ss))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rs)),foldl(dB,dB,app,R1,Ss))) ) ).

tff(fact_55_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V))
     => ? [Ss1: list(dB)] :
          ( pp(aa(list(dB),bool,aa(list(dB),fun(list(dB),bool),step1(dB,beta),Rs),Ss1))
          & ( V = foldl(dB,dB,app,var(N),Ss1) ) ) ) ).

tff(fact_56_subst__map,axiom,
    ! [Ia: nat,U1: dB,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,Ta,Ts)),U1),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ta),U1),Ia),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,U1),Ia),Ts)) ) ).

tff(fact_57_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_58_map__ident,axiom,
    ! [A: $tType,X1: list(A)] : ( map(A,A,combi(A),X1) = X1 ) ).

tff(fact_59_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_60_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_61_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_62_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A1: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A1,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),A1,Xs) ) ).

tff(fact_63_not__step1__Nil,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(A,fun(A,bool))] : ~ pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R1),Xs),nil(A))) ).

tff(fact_64_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(A,fun(A,bool))] : ~ pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R1),nil(A)),Xs)) ).

tff(fact_65_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_66_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)) ) ).

tff(fact_67_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),I))) ) ).

tff(fact_68_lift__map,axiom,
    ! [Ia: nat,Ts: list(dB),Ta: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,Ta,Ts)),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,Ta),Ia),map(dB,dB,combc(dB,nat,dB,lift,Ia),Ts)) ) ).

tff(fact_69_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R3: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R3),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),lift,R3),I)),aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),I))) ) ).

tff(fact_70_subst__lift,axiom,
    ! [S1: dB,K: nat,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)),S1),K) = T1 ) ).

tff(fact_71_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R1,Rs)),S))
     => ( ! [R2: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),R2))
           => ( S != foldl(dB,dB,app,R2,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( pp(aa(list(dB),bool,aa(list(dB),fun(list(dB),bool),step1(dB,beta),Rs),Rs1))
             => ( S != foldl(dB,dB,app,R1,Rs1) ) )
         => ~ ! [T: dB] :
                ( ( R1 = abs(T) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rs = cons(dB,U,Us) )
                   => ( S != foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),U),zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_72_double__induction__lemma,axiom,
    ! [Ss: list(dB),R1: dB,Ta: dB,S: dB] :
      ( pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),S))
     => ( pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),Ta))
       => ( ( Ta = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),S),zero_zero(nat)),Ss) )
         => pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R1)),S),Ss))) ) ) ) ).

tff(fact_73_listsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(B)] : ( monoid_add_listsum(A,map(B,A,combk(A,B,zero_zero(A)),Xs)) = zero_zero(A) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X3: A] : ( aa(A,B,F,X3) = aa(A,B,G,X3) )
     => ( F = G ) ) ).

tff(fact_75_list_Oinject,axiom,
    ! [A: $tType,List2: list(A),A5: A,List1: list(A),A1: A] :
      ( ( cons(A,A1,List1) = cons(A,A5,List2) )
    <=> ( ( A1 = A5 )
        & ( List1 = List2 ) ) ) ).

tff(fact_76_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X2: B,F: fun(B,A)] : ( map(B,A,F,cons(B,X2,Xs)) = cons(A,aa(B,A,F,X2),map(B,A,F,Xs)) ) ).

tff(fact_77_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X2: A,Ys: list(A),Y1: A,R1: fun(A,fun(A,bool))] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R1),cons(A,Y1,Ys)),cons(A,X2,Xs)))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R1,Y1),X2))
          & ( Xs = Ys ) )
        | ( ( X2 = Y1 )
          & pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R1),Ys),Xs)) ) ) ) ).

tff(fact_78_step1__converse,axiom,
    ! [A: $tType,R1: fun(A,fun(A,bool))] : ( step1(A,conversep(A,A,R1)) = conversep(list(A),list(A),step1(A,R1)) ) ).

tff(fact_79_in__step1__converse,axiom,
    ! [A: $tType,Y1: list(A),X2: list(A),R1: fun(A,fun(A,bool))] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,conversep(A,A,R1)),X2),Y1))
    <=> pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),conversep(list(A),list(A),step1(A,R1)),X2),Y1)) ) ).

tff(fact_80_listsum__simps_I1_J,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ( monoid_add_listsum(A,nil(A)) = zero_zero(A) ) ) ).

tff(fact_81_Cons__acc__step1I,axiom,
    ! [A: $tType,Xs: list(A),X2: A,R1: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,accp(A,R1),X2))
     => ( pp(aa(list(A),bool,accp(list(A),step1(A,R1)),Xs))
       => pp(aa(list(A),bool,accp(list(A),step1(A,R1)),cons(A,X2,Xs))) ) ) ).

tff(fact_82_ListOrder_Olists__accI,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(A,fun(A,bool))] :
      ( pp(aa(list(A),bool,accp(list(A),step1(A,R1)),Xs))
     => listsp(A,accp(A,R1),Xs) ) ).

tff(fact_83_ListOrder_Olists__accD,axiom,
    ! [A: $tType,Xs: list(A),R1: fun(A,fun(A,bool))] :
      ( listsp(A,accp(A,R1),Xs)
     => pp(aa(list(A),bool,accp(list(A),step1(A,R1)),Xs)) ) ).

tff(fact_84_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A1: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,A1,List1)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A1),List1),list_rec(A,B,F1,F2,List1)) ) ).

tff(fact_85_IT__implies__termi,axiom,
    ! [Ta: dB] :
      ( pp(aa(dB,bool,it,Ta))
     => pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),Ta)) ) ).

tff(fact_86_termi__implies__IT,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),R1))
     => pp(aa(dB,bool,it,R1)) ) ).

tff(fact_87_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A1: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A1,List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A1),List1) ) ).

tff(fact_88_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_89_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_90_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X2: B,A1: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A1,cons(B,X2,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A1),X2),Xs) ) ).

tff(fact_91_list_Osimps_I3_J,axiom,
    ! [A: $tType,List: list(A),A4: A] : ( cons(A,A4,List) != nil(A) ) ).

tff(fact_92_list_Osimps_I2_J,axiom,
    ! [A: $tType,List: list(A),A4: A] : ( nil(A) != cons(A,A4,List) ) ).

tff(fact_93_conversep__noteq,axiom,
    ! [A: $tType,X1: A,Xa: A] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),conversep(A,A,aa(fun(A,fun(A,bool)),fun(A,fun(A,bool)),aa(fun(fun(A,bool),fun(A,bool)),fun(fun(A,fun(A,bool)),fun(A,fun(A,bool))),combb(fun(A,bool),fun(A,bool),A),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot)),fequal(A))),X1),Xa))
    <=> ( X1 != Xa ) ) ).

tff(fact_94_listsp_Osimps,axiom,
    ! [A: $tType,A1: list(A),A2: fun(A,bool)] :
      ( listsp(A,A2,A1)
    <=> ( ( A1 = nil(A) )
        | ? [A3: A,L: list(A)] :
            ( ( A1 = cons(A,A3,L) )
            & pp(aa(A,bool,A2,A3))
            & listsp(A,A2,L) ) ) ) ).

tff(fact_95_conversep__iff,axiom,
    ! [A: $tType,B: $tType,B1: A,A1: B,R1: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R1),A1),B1))
    <=> pp(aa(B,bool,aa(A,fun(B,bool),R1,B1),A1)) ) ).

tff(fact_96_conversep__eq,axiom,
    ! [A: $tType] : ( conversep(A,A,fequal(A)) = fequal(A) ) ).

tff(fact_97_conversepD,axiom,
    ! [A: $tType,B: $tType,B1: A,A1: B,R1: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R1),A1),B1))
     => pp(aa(B,bool,aa(A,fun(B,bool),R1,B1),A1)) ) ).

tff(fact_98_conversep_Ointros,axiom,
    ! [B: $tType,A: $tType,B1: B,A1: A,R1: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),R1,A1),B1))
     => pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R1),B1),A1)) ) ).

%----Arities (2)
tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    listsp(dB,combs(dB,bool,bool,aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it),aa(fun(dB,dB),fun(dB,bool),aa(fun(dB,bool),fun(fun(dB,dB),fun(dB,bool)),combb(dB,bool,dB),it),combc(dB,dB,dB,app,var(i)))),rs) ).

tff(conj_1,conjecture,
    pp(aa(dB,bool,it,aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,var(n),rs)),var(i)))) ).

%------------------------------------------------------------------------------
