%------------------------------------------------------------------------------
% File     : LCL764_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 66
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_66 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  152 (  48 unt;  38 typ;   0 def)
%            Number of atoms       :  222 ( 167 equ)
%            Maximal formula atoms :    6 (   1 avg)
%            Number of connectives :  144 (  36   ~;   7   |;  24   &)
%                                         (  31 <=>;  46  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    6 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   46 (  26   >;  20   *;   0   +;   0  <<)
%            Number of predicates  :    9 (   8 usr;   0 prp; 1-3 aty)
%            Number of functors    :   27 (  27 usr;   3 con; 0-5 aty)
%            Number of variables   :  371 ( 331   !;   7   ?; 371   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:54
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

tff(ty_tc_prod,type,
    product_prod: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Enum_Oenum,type,
    enum: 
      !>[A: $tType] : $o ).

tff(sy_cl_HOL_Oequal,type,
    cl_HOL_Oequal: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_c_Enum_Oproduct,type,
    product: 
      !>[A: $tType,B: $tType] : ( ( list(A) * list(B) ) > list(product_prod(A,B)) ) ).

tff(sy_c_HOL_Oequal__class_Oequal,type,
    equal_equal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Obutlast,type,
    butlast: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Ohd,type,
    hd: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_List_Olinorder__class_Oinsort__key,type,
    linorder_insort_key: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * B * list(B) ) > list(B) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),T1)) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T1: $tType,A: $tType] : ( ( T1 * fun(A,fun(list(A),fun(T1,T1))) * list(A) ) > T1 ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omember,type,
    member: 
      !>[A: $tType] : ( ( list(A) * A ) > $o ) ).

tff(sy_c_List_Onull,type,
    null: 
      !>[A: $tType] : ( list(A) > $o ) ).

tff(sy_c_List_Oreplicate,type,
    replicate: 
      !>[A: $tType] : ( ( nat * A ) > list(A) ) ).

tff(sy_c_List_Orev,type,
    rev: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osplice,type,
    splice: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Otl,type,
    tl: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

%----Relevant facts (100)
tff(fact_0_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_1_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,lift(T,I))) ) ).

tff(fact_2_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_3_product_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,Uu: list(B)] : ( product(A,B,nil(A),Uu) = nil(product_prod(A,B)) ) ).

tff(fact_4_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_5_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_6_null__rec_I2_J,axiom,
    ! [B: $tType] : null(B,nil(B)) ).

tff(fact_7_List_Onull__def,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( null(A,Xs1)
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_8_eq__Nil__null,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 = nil(A) )
    <=> null(A,Xs1) ) ).

tff(fact_9_listsp_Osimps,axiom,
    ! [A: $tType,A4: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,A4)
    <=> ( ( A4 = nil(A) )
        | ? [A6: A,L: list(A)] :
            ( ( A4 = cons(A,A6,L) )
            & pp(aa(A,bool,A1,A6))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_10_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,list(A))] : ( maps(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_11_member__rec_I2_J,axiom,
    ! [A: $tType,Y: A] : ~ member(A,nil(A),Y) ).

tff(fact_12_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A5: A,List2: list(A),A4: A] :
      ( ( cons(A,A4,List2) = cons(A,A5,List3) )
    <=> ( ( A4 = A5 )
        & ( List2 = List3 ) ) ) ).

tff(fact_13_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( Xs != cons(A,X,Xs) ) ).

tff(fact_14_not__Cons__self2,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( cons(A,X,Xs) != Xs ) ).

tff(fact_15_null__rec_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ~ null(A,cons(A,X,Xs)) ).

tff(fact_16_member__rec_I1_J,axiom,
    ! [A: $tType,Y1: A,Xs1: list(A),X1: A] :
      ( member(A,cons(A,X1,Xs1),Y1)
    <=> ( ( X1 = Y1 )
        | member(A,Xs1,Y1) ) ) ).

tff(fact_17_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A4: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A4,List2)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A4),List2) ) ).

tff(fact_18_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List2: list(B),A4: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,A4,List2)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A4),List2),list_rec(A,B,F1,F2,List2)) ) ).

tff(fact_19_list_Osimps_I3_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( cons(A,A3,List1) != nil(A) ) ).

tff(fact_20_list_Osimps_I2_J,axiom,
    ! [A: $tType,List1: list(A),A3: A] : ( nil(A) != cons(A,A3,List1) ) ).

tff(fact_21_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != cons(A,A2,List) ) ) ).

tff(fact_22_neq__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
    <=> ? [Y3: A,Ys4: list(A)] : ( Xs1 = cons(A,Y3,Ys4) ) ) ).

tff(fact_23_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_24_equal__Nil__null,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),Xs1),nil(A)))
    <=> null(A,Xs1) ) ).

tff(fact_25_splice_Osimps_I2_J,axiom,
    ! [A: $tType,Va: list(A),V: A] : ( splice(A,cons(A,V,Va),nil(A)) = cons(A,V,Va) ) ).

tff(fact_26_splice_Osimps_I3_J,axiom,
    ! [A: $tType,Ys: list(A),Y: A,Xs: list(A),X: A] : ( splice(A,cons(A,X,Xs),cons(A,Y,Ys)) = cons(A,X,cons(A,Y,splice(A,Xs,Ys))) ) ).

tff(fact_27_list__nonempty__induct,axiom,
    ! [A: $tType,P: fun(list(A),bool),Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ( ! [X2: A] : pp(aa(list(A),bool,P,cons(A,X2,nil(A))))
       => ( ! [X2: A,Xs2: list(A)] :
              ( ( Xs2 != nil(A) )
             => ( pp(aa(list(A),bool,P,Xs2))
               => pp(aa(list(A),bool,P,cons(A,X2,Xs2))) ) )
         => pp(aa(list(A),bool,P,Xs1)) ) ) ) ).

tff(fact_28_last_Osimps,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( ( Xs = nil(A) )
       => ( last(A,cons(A,X,Xs)) = X ) )
      & ( ( Xs != nil(A) )
       => ( last(A,cons(A,X,Xs)) = last(A,Xs) ) ) ) ).

tff(fact_29_butlast_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( ( Xs = nil(A) )
       => ( butlast(A,cons(A,X,Xs)) = nil(A) ) )
      & ( ( Xs != nil(A) )
       => ( butlast(A,cons(A,X,Xs)) = cons(A,X,butlast(A,Xs)) ) ) ) ).

tff(fact_30_butlast_Osimps_I1_J,axiom,
    ! [A: $tType] : ( butlast(A,nil(A)) = nil(A) ) ).

tff(fact_31_equal__list__def,axiom,
    ! [A: $tType,Y1: list(A),X1: list(A)] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),equal_equal(list(A)),X1),Y1))
    <=> ( X1 = Y1 ) ) ).

tff(fact_32_splice_Osimps_I1_J,axiom,
    ! [A: $tType,Ys: list(A)] : ( splice(A,nil(A),Ys) = Ys ) ).

tff(fact_33_splice__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( splice(A,Xs,nil(A)) = Xs ) ).

tff(fact_34_last__ConsL,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( Xs = nil(A) )
     => ( last(A,cons(A,X,Xs)) = X ) ) ).

tff(fact_35_last__ConsR,axiom,
    ! [A: $tType,X: A,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( last(A,cons(A,X,Xs)) = last(A,Xs) ) ) ).

tff(fact_36_append__butlast__last__id,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( append(A,butlast(A,Xs),cons(A,last(A,Xs),nil(A))) = Xs ) ) ).

tff(fact_37_snoc__eq__iff__butlast,axiom,
    ! [A: $tType,Ys1: list(A),X1: A,Xs1: list(A)] :
      ( ( append(A,Xs1,cons(A,X1,nil(A))) = Ys1 )
    <=> ( ( Ys1 != nil(A) )
        & ( butlast(A,Ys1) = Xs1 )
        & ( last(A,Ys1) = X1 ) ) ) ).

tff(fact_38_eq__equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( fequal(A) = equal_equal(A) ) ) ).

tff(fact_39_equal__eq,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [Y1: A,X1: A] :
          ( pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X1),Y1))
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_40_equal__refl,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ! [X: A] : pp(aa(A,bool,aa(A,fun(A,bool),equal_equal(A),X),X)) ) ).

tff(fact_41_equal,axiom,
    ! [A: $tType] :
      ( cl_HOL_Oequal(A)
     => ( equal_equal(A) = fequal(A) ) ) ).

tff(fact_42_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs1: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Xs1) = append(A,Zs,Xs1) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_43_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = append(A,Xs1,Zs) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_44_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys: list(A),Xs: list(A)] : ( append(A,append(A,Xs,Ys),Zs1) = append(A,Xs,append(A,Ys,Zs1)) ) ).

tff(fact_45_append__Cons,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A),X: A] : ( append(A,cons(A,X,Xs),Ys) = cons(A,X,append(A,Xs,Ys)) ) ).

tff(fact_46_append__self__conv2,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = Ys1 )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_47_append__self__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = Xs1 )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_48_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = nil(A) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_49_self__append__conv2,axiom,
    ! [A: $tType,Xs1: list(A),Ys1: list(A)] :
      ( ( Ys1 = append(A,Xs1,Ys1) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_50_self__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( Xs1 = append(A,Xs1,Ys1) )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_51_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( nil(A) = append(A,Xs1,Ys1) )
    <=> ( ( Xs1 = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_52_append__in__listsp__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,append(A,Xs1,Ys1))
    <=> ( listsp(A,A1,Xs1)
        & listsp(A,A1,Ys1) ) ) ).

tff(fact_53_append1__eq__conv,axiom,
    ! [A: $tType,Y1: A,Ys1: list(A),X1: A,Xs1: list(A)] :
      ( ( append(A,Xs1,cons(A,X1,nil(A))) = append(A,Ys1,cons(A,Y1,nil(A))) )
    <=> ( ( Xs1 = Ys1 )
        & ( X1 = Y1 ) ) ) ).

tff(fact_54_append__eq__appendI,axiom,
    ! [A: $tType,Us1: list(A),Ys: list(A),Zs1: list(A),Xs11: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Xs11) = Zs1 )
     => ( ( Ys = append(A,Xs11,Us1) )
       => ( append(A,Xs,Ys) = append(A,Zs1,Us1) ) ) ) ).

tff(fact_55_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs: list(A),Ys1: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Ys1) = append(A,Zs,Ts) )
    <=> ? [Us: list(A)] :
          ( ( ( Xs1 = append(A,Zs,Us) )
            & ( append(A,Us,Ys1) = Ts ) )
          | ( ( append(A,Xs1,Us) = Zs )
            & ( Ys1 = append(A,Us,Ts) ) ) ) ) ).

tff(fact_56_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs: list(A),Ys: list(A),Xs11: list(A),X: A] :
      ( ( cons(A,X,Xs11) = Ys )
     => ( ( Xs = append(A,Xs11,Zs1) )
       => ( cons(A,X,Xs) = append(A,Ys,Zs1) ) ) ) ).

tff(fact_57_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = Ys )
     => ( Xs = append(A,nil(A),Ys) ) ) ).

tff(fact_58_append__Nil2,axiom,
    ! [A: $tType,Xs: list(A)] : ( append(A,Xs,nil(A)) = Xs ) ).

tff(fact_59_append__Nil,axiom,
    ! [A: $tType,Ys: list(A)] : ( append(A,nil(A),Ys) = Ys ) ).

tff(fact_60_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs1: list(A),X1: A,Zs: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Zs) = cons(A,X1,Xs1) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( Zs = cons(A,X1,Xs1) ) )
        | ? [Ys3: list(A)] :
            ( ( Ys1 = cons(A,X1,Ys3) )
            & ( append(A,Ys3,Zs) = Xs1 ) ) ) ) ).

tff(fact_61_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A),X1: A] :
      ( ( cons(A,X1,Xs1) = append(A,Ys1,Zs) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( cons(A,X1,Xs1) = Zs ) )
        | ? [Ys3: list(A)] :
            ( ( cons(A,X1,Ys3) = Ys1 )
            & ( Xs1 = append(A,Ys3,Zs) ) ) ) ) ).

tff(fact_62_butlast__append,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( ( Ys = nil(A) )
       => ( butlast(A,append(A,Xs,Ys)) = butlast(A,Xs) ) )
      & ( ( Ys != nil(A) )
       => ( butlast(A,append(A,Xs,Ys)) = append(A,Xs,butlast(A,Ys)) ) ) ) ).

tff(fact_63_last__appendL,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( Ys = nil(A) )
     => ( last(A,append(A,Xs,Ys)) = last(A,Xs) ) ) ).

tff(fact_64_last__appendR,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( Ys != nil(A) )
     => ( last(A,append(A,Xs,Ys)) = last(A,Ys) ) ) ).

tff(fact_65_last__append,axiom,
    ! [A: $tType,Xs: list(A),Ys: list(A)] :
      ( ( ( Ys = nil(A) )
       => ( last(A,append(A,Xs,Ys)) = last(A,Xs) ) )
      & ( ( Ys != nil(A) )
       => ( last(A,append(A,Xs,Ys)) = last(A,Ys) ) ) ) ).

tff(fact_66_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X1: B,F: fun(B,list(A))] : ( maps(B,A,F,cons(B,X1,Xs1)) = append(A,aa(B,list(A),F,X1),maps(B,A,F,Xs1)) ) ).

tff(fact_67_butlast__snoc,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( butlast(A,append(A,Xs,cons(A,X,nil(A)))) = Xs ) ).

tff(fact_68_last__snoc,axiom,
    ! [A: $tType,X: A,Xs: list(A)] : ( last(A,append(A,Xs,cons(A,X,nil(A)))) = X ) ).

tff(fact_69_rev__induct,axiom,
    ! [A: $tType,Xs1: list(A),P: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P,nil(A)))
     => ( ! [X2: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P,Xs2))
           => pp(aa(list(A),bool,P,append(A,Xs2,cons(A,X2,nil(A))))) )
       => pp(aa(list(A),bool,P,Xs1)) ) ) ).

tff(fact_70_rev__cases,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys2: list(A),Y2: A] : ( Xs != append(A,Ys2,cons(A,Y2,nil(A))) ) ) ).

tff(fact_71_rev__exhaust2,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ~ ! [Ys2: list(A),Y2: A] : ( Xs != append(A,Ys2,cons(A,Y2,nil(A))) ) ) ).

tff(fact_72_rotate__simps,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B,cons(B,X,Xs)) = append(B,Xs,cons(B,X,nil(B))) ) ) ).

tff(fact_73_rev_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( rev(A,cons(A,X,Xs)) = append(A,rev(A,Xs),cons(A,X,nil(A))) ) ).

tff(fact_74_rev__is__rev__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( rev(A,Xs1) = rev(A,Ys1) )
    <=> ( Xs1 = Ys1 ) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_76_rev_Osimps_I1_J,axiom,
    ! [A: $tType] : ( rev(A,nil(A)) = nil(A) ) ).

tff(fact_77_Nil__is__rev__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( nil(A) = rev(A,Xs1) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_78_rev__is__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( rev(A,Xs1) = nil(A) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_79_rev__append,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] : ( rev(A,append(A,Xs,Ys)) = append(A,rev(A,Ys),rev(A,Xs)) ) ).

tff(fact_80_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( rotate1(A,Xs1) = nil(A) )
    <=> ( Xs1 = nil(A) ) ) ).

tff(fact_81_singleton__rev__conv,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] :
      ( ( cons(A,X1,nil(A)) = rev(A,Xs1) )
    <=> ( Xs1 = cons(A,X1,nil(A)) ) ) ).

tff(fact_82_rev__singleton__conv,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] :
      ( ( rev(A,Xs1) = cons(A,X1,nil(A)) )
    <=> ( Xs1 = cons(A,X1,nil(A)) ) ) ).

tff(fact_83_rev__eq__Cons__iff,axiom,
    ! [A: $tType,Ys1: list(A),Y1: A,Xs1: list(A)] :
      ( ( rev(A,Xs1) = cons(A,Y1,Ys1) )
    <=> ( Xs1 = append(A,rev(A,Ys1),cons(A,Y1,nil(A))) ) ) ).

tff(fact_84_rev__rev__ident,axiom,
    ! [A: $tType,Xs: list(A)] : ( rev(A,rev(A,Xs)) = Xs ) ).

tff(fact_85_rev__swap,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A)] :
      ( ( rev(A,Xs1) = Ys1 )
    <=> ( Xs1 = rev(A,Ys1) ) ) ).

tff(fact_86_hd__rev,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( hd(A,rev(A,Xs)) = last(A,Xs) ) ) ).

tff(fact_87_last__rev,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( last(A,rev(A,Xs)) = hd(A,Xs) ) ) ).

tff(fact_88_hd_Osimps,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( hd(A,cons(A,X,Xs)) = X ) ).

tff(fact_89_hd__append2,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( hd(A,append(A,Xs,Ys)) = hd(A,Xs) ) ) ).

tff(fact_90_hd__append,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( ( Xs = nil(A) )
       => ( hd(A,append(A,Xs,Ys)) = hd(A,Ys) ) )
      & ( ( Xs != nil(A) )
       => ( hd(A,append(A,Xs,Ys)) = hd(A,Xs) ) ) ) ).

tff(fact_91_rotate1__hd__tl,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( rotate1(A,Xs) = append(A,tl(A,Xs),cons(A,hd(A,Xs),nil(A))) ) ) ).

tff(fact_92_replicate__append__same,axiom,
    ! [A: $tType,X: A,I: nat] : ( append(A,replicate(A,I,X),cons(A,X,nil(A))) = cons(A,X,replicate(A,I,X)) ) ).

tff(fact_93_tl_Osimps_I1_J,axiom,
    ! [A: $tType] : ( tl(A,nil(A)) = nil(A) ) ).

tff(fact_94_rev__replicate,axiom,
    ! [A: $tType,X: A,N: nat] : ( rev(A,replicate(A,N,X)) = replicate(A,N,X) ) ).

tff(fact_95_replicate__app__Cons__same,axiom,
    ! [A: $tType,Xs: list(A),X: A,N: nat] : ( append(A,replicate(A,N,X),cons(A,X,Xs)) = cons(A,X,append(A,replicate(A,N,X),Xs)) ) ).

tff(fact_96_tl__append2,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs != nil(A) )
     => ( tl(A,append(A,Xs,Ys)) = append(A,tl(A,Xs),Ys) ) ) ).

tff(fact_97_tl_Osimps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X: A] : ( tl(A,cons(A,X,Xs)) = Xs ) ).

tff(fact_98_append__replicate__commute,axiom,
    ! [A: $tType,K: nat,X: A,N: nat] : ( append(A,replicate(A,N,X),replicate(A,K,X)) = append(A,replicate(A,K,X),replicate(A,N,X)) ) ).

tff(fact_99_insort__key_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType] :
      ( linorder(B)
     => ! [X1: A,F: fun(A,B)] : ( linorder_insort_key(A,B,F,X1,nil(A)) = cons(A,X1,nil(A)) ) ) ).

%----Arities (9)
tff(arity_prod___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(product_prod(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Enum_Oenum,axiom,
    enum(bool) ).

tff(arity_fun___Enum_Oenum,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( enum(T_2)
        & enum(T_1) )
     => enum(fun(T_1,T_2)) ) ).

tff(arity_fun___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ( cl_HOL_Oequal(T_2)
        & enum(T_1) )
     => cl_HOL_Oequal(fun(T_1,T_2)) ) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___HOL_Oequal,axiom,
    cl_HOL_Oequal(bool) ).

tff(arity_Lambda_OdB___HOL_Oequal,axiom,
    cl_HOL_Oequal(dB) ).

tff(arity_List_Olist___HOL_Oequal,axiom,
    ! [T_1: $tType] : cl_HOL_Oequal(list(T_1)) ).

tff(arity_prod___HOL_Oequal,axiom,
    ! [T_1: $tType,T_2: $tType] : cl_HOL_Oequal(product_prod(T_1,T_2)) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    listsp(dB,it,nil(dB)) ).

%------------------------------------------------------------------------------
