%------------------------------------------------------------------------------
% File     : LCL762_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 64
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_64 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  145 (  50 unt;  39 typ;   0 def)
%            Number of atoms       :  223 ( 132 equ)
%            Maximal formula atoms :   12 (   1 avg)
%            Number of connectives :  159 (  42   ~;  10   |;  30   &)
%                                         (  25 <=>;  52  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    6 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   51 (  26   >;  25   *;   0   +;   0  <<)
%            Number of predicates  :    6 (   5 usr;   0 prp; 1-3 aty)
%            Number of functors    :   31 (  31 usr;   6 con; 0-5 aty)
%            Number of variables   :  393 ( 339   !;  28   ?; 393   :)
%                                         (  26  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:51
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T4: $tType] : ( ( fun(nat,T4) * fun(dB,fun(dB,T4)) * fun(dB,T4) * dB ) > T4 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( fun(A,fun(A,bool)) > fun(list(A),fun(list(A),bool)) ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun(A,fun(list(A),T4)) * list(A) ) > T4 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T4: $tType,A: $tType] : ( ( T4 * fun(A,fun(list(A),fun(T4,T4))) * list(A) ) > T4 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Predicate_Oconversep,type,
    conversep: 
      !>[A: $tType,B: $tType] : ( fun(A,fun(B,bool)) > fun(B,fun(A,bool)) ) ).

tff(sy_c_Wellfounded_Oaccp,type,
    accp: 
      !>[A: $tType] : ( fun(A,fun(A,bool)) > fun(A,bool) ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : fun(A,fun(A,bool)) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (99)
tff(fact_0_Var__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( var(M) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_1_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),Na: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(Na),Ss1) )
    <=> ( ( M = Na )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_2_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,R,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( R = S ) ) ).

tff(fact_3_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat3) )
    <=> ( Nat1 = Nat3 ) ) ).

tff(fact_4_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB2: dB,DB1: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB1 = DB14 )
        & ( DB2 = DB24 ) ) ) ).

tff(fact_5_dB_Osimps_I4_J,axiom,
    ! [DB23: dB,DB13: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_6_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != var(Nat) ) ).

tff(fact_7_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A5: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A5,nil(B)) = A5 ) ).

tff(fact_8_IT_OVar,axiom,
    ! [Na: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(Na),Rs))) ) ).

tff(fact_9_Abs__eq__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( ( abs(R) = foldl(dB,dB,app,S,Ss1) )
    <=> ( ( abs(R) = S )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_10_apps__eq__Abs__conv,axiom,
    ! [R: dB,Ss1: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss1) = abs(R) )
    <=> ( ( S = abs(R) )
        & ( Ss1 = nil(dB) ) ) ) ).

tff(fact_11_subst__Var__IT,axiom,
    ! [J: nat,I: nat,R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,subst(R2,var(I),J))) ) ).

tff(fact_12_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB: dB] :
      ( ( abs(DB) = abs(DB5) )
    <=> ( DB = DB5 ) ) ).

tff(fact_13_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_14_subst__App,axiom,
    ! [K: nat,S2: dB,U3: dB,T3: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T3),U3),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T3,S2,K)),subst(U3,S2,K)) ) ).

tff(fact_15_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_16_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S: dB,Rs: list(dB),R: dB] :
      ( ( foldl(dB,dB,app,abs(R),Rs) = foldl(dB,dB,app,abs(S),Ss1) )
    <=> ( ( R = S )
        & ( Rs = Ss1 ) ) ) ).

tff(fact_17_dB_Osimps_I8_J,axiom,
    ! [DB4: dB,DB22: dB,DB12: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) != abs(DB4) ) ).

tff(fact_18_dB_Osimps_I9_J,axiom,
    ! [DB22: dB,DB12: dB,DB4: dB] : ( abs(DB4) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) ) ).

tff(fact_19_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat: nat] : ( var(Nat) != abs(DB4) ) ).

tff(fact_20_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB4: dB] : ( abs(DB4) != var(Nat) ) ).

tff(fact_21_subst__eq,axiom,
    ! [U3: dB,K: nat] : ( subst(var(K),U3,K) = U3 ) ).

tff(fact_22_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),R: dB,Ts: list(dB),Na: nat] : ( foldl(dB,dB,app,var(Na),Ts) != foldl(dB,dB,app,abs(R),Ss1) ) ).

tff(fact_23_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),Na: nat,T: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T) != foldl(dB,dB,app,var(Na),Ss1) ) ).

tff(fact_24_Beta,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss1))) ) ) ).

tff(fact_25_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X1: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y1: A,S3: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S3),X2)),Y1) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S3),Y1)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X1) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X1),Xs) ) ) ).

tff(fact_26_IT_Osimps,axiom,
    ! [A5: dB] :
      ( pp(aa(dB,bool,it,A5))
    <=> ( ? [Rs2: list(dB),N2: nat] :
            ( ( A5 = foldl(dB,dB,app,var(N2),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R3: dB] :
            ( ( A5 = abs(R3) )
            & pp(aa(dB,bool,it,R3)) )
        | ? [R3: dB,S1: dB,Ss: list(dB)] :
            ( ( A5 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R3)),S1),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R3,S1,zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S1)) ) ) ) ).

tff(fact_27_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_28_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_29_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat2: nat] : ( Y != var(Nat2) )
     => ( ! [DB11: dB,DB21: dB] : ( Y != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) )
       => ~ ! [DB3: dB] : ( Y != abs(DB3) ) ) ) ).

tff(fact_30_ex__head__tail,axiom,
    ! [T: dB] :
    ? [Ts1: list(dB),H: dB] :
      ( ( T = foldl(dB,dB,app,H,Ts1) )
      & ( ? [N1: nat] : ( H = var(N1) )
        | ? [U1: dB] : ( H = abs(U1) ) ) ) ).

tff(fact_31_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_32_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_33_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB2: dB,DB1: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB1),DB2) ) ).

tff(fact_34_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_35_beta,axiom,
    ! [T3: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T3)),subst(S2,T3,zero_zero(nat)))) ).

tff(fact_36_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_37_substn__subst__0,axiom,
    ! [S2: dB,T3: dB] : ( substn(T3,S2,zero_zero(nat)) = subst(T3,S2,zero_zero(nat)) ) ).

tff(fact_38_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_39_appR,axiom,
    ! [U3: dB,T3: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T3))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U3),S2)),aa(dB,dB,aa(dB,fun(dB,dB),app,U3),T3))) ) ).

tff(fact_40_appL,axiom,
    ! [U3: dB,T3: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T3))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U3)),aa(dB,dB,aa(dB,fun(dB,dB),app,T3),U3))) ) ).

tff(fact_41_beta__cases_I1_J,axiom,
    ! [T3: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I)),T3)) ).

tff(fact_42_abs,axiom,
    ! [T3: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T3))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S2)),abs(T3))) ) ).

tff(fact_43_substn_Osimps_I2_J,axiom,
    ! [K: nat,S2: dB,U3: dB,T3: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T3),U3),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T3,S2,K)),substn(U3,S2,K)) ) ).

tff(fact_44_subst__preserves__beta,axiom,
    ! [I: nat,T3: dB,S2: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R2,T3,I)),subst(S2,T3,I))) ) ).

tff(fact_45_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_46_beta__cases_I2_J,axiom,
    ! [S2: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R2)),S2))
     => ~ ! [T1: dB] :
            ( ( S2 = abs(T1) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),T1)) ) ) ).

tff(fact_47_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Ss1)),foldl(dB,dB,app,S,Ss1))) ) ).

tff(fact_48_substn__subst__n,axiom,
    ! [N: nat,S2: dB,T3: dB] : ( substn(T3,S2,N) = subst(T3,liftn(N,S2,zero_zero(nat)),N) ) ).

tff(fact_49_beta__cases_I3_J,axiom,
    ! [U3: dB,T3: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T3)),U3))
     => ( ! [S3: dB] :
            ( ( U3 = subst(S3,T3,zero_zero(nat)) )
           => ( S2 != abs(S3) ) )
       => ( ! [T1: dB] :
              ( ( U3 = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T3) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1)) )
         => ~ ! [T1: dB] :
                ( ( U3 = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T3),T1)) ) ) ) ) ).

tff(fact_50_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_51_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T3: dB,S2: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T3),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S2,K)),liftn(N,T3,K)) ) ).

tff(fact_52_liftn__0,axiom,
    ! [K: nat,T3: dB] : ( liftn(zero_zero(nat),T3,K) = T3 ) ).

tff(fact_53_apps__preserves__betas,axiom,
    ! [R: dB,Ss1: list(dB),Rs: list(dB)] :
      ( pp(aa(list(dB),bool,aa(list(dB),fun(list(dB),bool),step1(dB,beta),Rs),Ss1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),foldl(dB,dB,app,R,Ss1))) ) ).

tff(fact_54_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),Na: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(Na),Rs)),V))
     => ? [Ss2: list(dB)] :
          ( pp(aa(list(dB),bool,aa(list(dB),fun(list(dB),bool),step1(dB,beta),Rs),Ss2))
          & ( V = foldl(dB,dB,app,var(Na),Ss2) ) ) ) ).

tff(fact_55_double__induction__lemma,axiom,
    ! [Ss1: list(dB),R: dB,T: dB,S: dB] :
      ( pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),S))
     => ( pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),T))
       => ( ( T = foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss1) )
         => pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss1))) ) ) ) ).

tff(fact_56_beta_Osimps,axiom,
    ! [A2: dB,A11: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,A11),A2))
    <=> ( ? [S1: dB,T2: dB] :
            ( ( A11 = aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T2) )
            & ( A2 = subst(S1,T2,zero_zero(nat)) ) )
        | ? [S1: dB,T2: dB,U2: dB] :
            ( ( A11 = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U2) )
            & ( A2 = aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U2) )
            & pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T2)) )
        | ? [S1: dB,T2: dB,U2: dB] :
            ( ( A11 = aa(dB,dB,aa(dB,fun(dB,dB),app,U2),S1) )
            & ( A2 = aa(dB,dB,aa(dB,fun(dB,dB),app,U2),T2) )
            & pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T2)) )
        | ? [S1: dB,T2: dB] :
            ( ( A11 = abs(S1) )
            & ( A2 = abs(T2) )
            & pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T2)) ) ) ) ).

tff(fact_57_IT__implies__termi,axiom,
    ! [T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),T)) ) ).

tff(fact_58_termi__implies__IT,axiom,
    ! [R: dB] :
      ( pp(aa(dB,bool,accp(dB,conversep(dB,dB,beta)),R))
     => pp(aa(dB,bool,it,R)) ) ).

tff(fact_59_step1__converse,axiom,
    ! [A: $tType,R: fun(A,fun(A,bool))] : ( step1(A,conversep(A,A,R)) = conversep(list(A),list(A),step1(A,R)) ) ).

tff(fact_60_in__step1__converse,axiom,
    ! [A: $tType,Y3: list(A),X1: list(A),R: fun(A,fun(A,bool))] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,conversep(A,A,R)),X1),Y3))
    <=> pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),conversep(list(A),list(A),step1(A,R)),X1),Y3)) ) ).

tff(fact_61_ListOrder_Olists__accD,axiom,
    ! [A: $tType,Xs: list(A),R: fun(A,fun(A,bool))] :
      ( listsp(A,accp(A,R),Xs)
     => pp(aa(list(A),bool,accp(list(A),step1(A,R)),Xs)) ) ).

tff(fact_62_not__step1__Nil,axiom,
    ! [A: $tType,Xs: list(A),R: fun(A,fun(A,bool))] : ~ pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R),Xs),nil(A))) ).

tff(fact_63_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),R: fun(A,fun(A,bool))] : ~ pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R),nil(A)),Xs)) ).

tff(fact_64_ListOrder_Olists__accI,axiom,
    ! [A: $tType,Xs: list(A),R: fun(A,fun(A,bool))] :
      ( pp(aa(list(A),bool,accp(list(A),step1(A,R)),Xs))
     => listsp(A,accp(A,R),Xs) ) ).

tff(fact_65_conversep__iff,axiom,
    ! [A: $tType,B: $tType,B2: A,A5: B,R: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R),A5),B2))
    <=> pp(aa(B,bool,aa(A,fun(B,bool),R,B2),A5)) ) ).

tff(fact_66_conversep__eq,axiom,
    ! [A: $tType] : ( conversep(A,A,fequal(A)) = fequal(A) ) ).

tff(fact_67_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,R,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( pp(aa(list(dB),bool,aa(list(dB),fun(list(dB),bool),step1(dB,beta),Rs),Rs1))
             => ( S != foldl(dB,dB,app,R,Rs1) ) )
         => ~ ! [T1: dB] :
                ( ( R = abs(T1) )
               => ! [U1: dB,Us: list(dB)] :
                    ( ( Rs = cons(dB,U1,Us) )
                   => ( S != foldl(dB,dB,app,subst(T1,U1,zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_68_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A7: A,List1: list(A),A5: A] :
      ( ( cons(A,A5,List1) = cons(A,A7,List3) )
    <=> ( ( A5 = A7 )
        & ( List1 = List3 ) ) ) ).

tff(fact_69_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Ys: list(A),Y3: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R),cons(A,Y3,Ys)),cons(A,X1,Xs)))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),R,Y3),X1))
          & ( Xs = Ys ) )
        | ( ( X1 = Y3 )
          & pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R),Ys),Xs)) ) ) ) ).

tff(fact_70_Cons__acc__step1I,axiom,
    ! [A: $tType,Xs: list(A),X1: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,accp(A,R),X1))
     => ( pp(aa(list(A),bool,accp(list(A),step1(A,R)),Xs))
       => pp(aa(list(A),bool,accp(list(A),step1(A,R)),cons(A,X1,Xs))) ) ) ).

tff(fact_71_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,A5: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A5,cons(B,X1,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A5),X1),Xs) ) ).

tff(fact_72_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A5: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A5,List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A5),List1) ) ).

tff(fact_73_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( cons(A,X,Xs1) != Xs1 ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_76_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != cons(A,X,Xs1) ) ).

tff(fact_77_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A6: A] : ( nil(A) != cons(A,A6,List2) ) ).

tff(fact_78_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A6: A] : ( cons(A,A6,List2) != nil(A) ) ).

tff(fact_79_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A5: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,cons(B,A5,List1)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A5),List1),list_rec(A,B,F1,F2,List1)) ) ).

tff(fact_80_conversep__conversep,axiom,
    ! [B: $tType,A: $tType,R: fun(A,fun(B,bool))] : ( conversep(B,A,conversep(A,B,R)) = R ) ).

tff(fact_81_conversep_Ointros,axiom,
    ! [B: $tType,A: $tType,B2: B,A5: A,R: fun(A,fun(B,bool))] :
      ( pp(aa(B,bool,aa(A,fun(B,bool),R,A5),B2))
     => pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R),B2),A5)) ) ).

tff(fact_82_conversepD,axiom,
    ! [A: $tType,B: $tType,B2: A,A5: B,R: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R),A5),B2))
     => pp(aa(B,bool,aa(A,fun(B,bool),R,B2),A5)) ) ).

tff(fact_83_listsp_Osimps,axiom,
    ! [A: $tType,A5: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,A5)
    <=> ( ( A5 = nil(A) )
        | ? [A3: A,L: list(A)] :
            ( ( A5 = cons(A,A3,L) )
            & pp(aa(A,bool,A1,A3))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_84_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y2: A,Ys2: list(A)] : ( Xs = cons(A,Y2,Ys2) ) ) ).

tff(fact_85_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A4: A,List: list(A)] : ( Y != cons(A,A4,List) ) ) ).

tff(fact_86_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Ys: list(A),R: fun(A,fun(A,bool))] :
      ( pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R),Ys),cons(A,X1,Xs)))
     => ( ! [Y1: A] :
            ( ( Ys = cons(A,Y1,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),R,Y1),X1)) )
       => ~ ! [Zs2: list(A)] :
              ( ( Ys = cons(A,X1,Zs2) )
             => ~ pp(aa(list(A),bool,aa(list(A),fun(list(A),bool),step1(A,R),Zs2),Xs)) ) ) ) ).

tff(fact_87_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = cons(A,X,nil(A)) ) ).

tff(fact_88_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = cons(A,X1,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X1,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_89_conversep_Osimps,axiom,
    ! [A: $tType,B: $tType,A2: A,A11: B,R: fun(A,fun(B,bool))] :
      ( pp(aa(A,bool,aa(B,fun(A,bool),conversep(A,B,R),A11),A2))
    <=> ? [A3: A,B1: B] :
          ( ( A11 = B1 )
          & ( A2 = A3 )
          & pp(aa(B,bool,aa(A,fun(B,bool),R,A3),B1)) ) ) ).

tff(fact_90_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_91_app__last,axiom,
    ! [U: dB,Ts: list(dB),T: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,T,Ts)),U) = foldl(dB,dB,app,T,append(dB,Ts,cons(dB,U,nil(dB)))) ) ).

tff(fact_92_App__eq__foldl__conv,axiom,
    ! [Ts: list(dB),T: dB,S: dB,R: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = foldl(dB,dB,app,T,Ts) )
    <=> ( ( ( Ts = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,R),S) = T ) )
        & ( ( Ts != nil(dB) )
         => ? [Ss: list(dB)] :
              ( ( Ts = append(dB,Ss,cons(dB,S,nil(dB))) )
              & ( R = foldl(dB,dB,app,T,Ss) ) ) ) ) ) ).

tff(fact_93_append__same__eq,axiom,
    ! [A: $tType,Zs1: list(A),Xs: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Xs) = append(A,Zs1,Xs) )
    <=> ( Ys = Zs1 ) ) ).

tff(fact_94_same__append__eq,axiom,
    ! [A: $tType,Zs1: list(A),Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = append(A,Xs,Zs1) )
    <=> ( Ys = Zs1 ) ) ).

tff(fact_95_append__assoc,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs1: list(A)] : ( append(A,append(A,Xs1,Ys1),Zs) = append(A,Xs1,append(A,Ys1,Zs)) ) ).

tff(fact_96_append__Cons,axiom,
    ! [A: $tType,Ys1: list(A),Xs1: list(A),X: A] : ( append(A,cons(A,X,Xs1),Ys1) = cons(A,X,append(A,Xs1,Ys1)) ) ).

tff(fact_97_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( nil(A) = append(A,Xs,Ys) )
    <=> ( ( Xs = nil(A) )
        & ( Ys = nil(A) ) ) ) ).

tff(fact_98_self__append__conv,axiom,
    ! [A: $tType,Ys: list(A),Xs: list(A)] :
      ( ( Xs = append(A,Xs,Ys) )
    <=> ( Ys = nil(A) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (4)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,aa(A,fun(A,bool),fequal(A),X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,foldl(dB,dB,app,var(n),nil(dB)))) ).

tff(conj_1,conjecture,
    pp(aa(dB,bool,it,var(n))) ).

%------------------------------------------------------------------------------
