%------------------------------------------------------------------------------
% File     : LCL761_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 63
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_63 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  156 (  37 unt;  39 typ;   0 def)
%            Number of atoms       :  282 (  63 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  209 (  44   ~;   5   |;   7   &)
%                                         (  13 <=>; 140  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   40 (  20   >;  20   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-3 aty)
%            Number of functors    :   21 (  21 usr;   4 con; 0-5 aty)
%            Number of variables   :  361 ( 337   !;   3   ?; 361   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:35
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: ( dB * dB ) > dB ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(dB,fun(dB,T6)) * fun(dB,T6) * dB ) > T6 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(dB,fun(dB,fun(T6,fun(T6,T6)))) * fun(dB,fun(T6,T6)) * dB ) > T6 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Transitive__Closure_Ortranclp,type,
    transitive_rtranclp: 
      !>[A: $tType] : ( fun(A,fun(A,bool)) > fun(A,fun(A,bool)) ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: ( type * type ) > type ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(type,fun(type,T6)) * type ) > T6 ) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_n,type,
    n: nat ).

%----Relevant facts (99)
tff(fact_0_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_1_subst__Var__IT,axiom,
    ! [J1: nat,I1: nat,R1: dB] :
      ( it(R1)
     => it(subst(R1,var(I1),J1)) ) ).

tff(fact_2_lift__IT,axiom,
    ! [I1: nat,T: dB] :
      ( it(T)
     => it(lift(T,I1)) ) ).

tff(fact_3_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_4_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat1: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat1)) = aa(nat,A,F1,Nat1) ) ).

tff(fact_5_Lambda,axiom,
    ! [R1: dB] :
      ( it(R1)
     => it(abs(R1)) ) ).

tff(fact_6_typing_OVar,axiom,
    ! [T2: type,X: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X) = T2 )
     => typing(Env,var(X),T2) ) ).

tff(fact_7_typing__elims_I1_J,axiom,
    ! [T2: type,I: nat,E: fun(nat,type)] :
      ( typing(E,var(I),T2)
     => ( aa(nat,type,E,I) = T2 ) ) ).

tff(fact_8_beta__cases_I1_J,axiom,
    ! [T: dB,I1: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I1)),T)) ).

tff(fact_9_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_10_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB4: dB] : ( abs(DB4) != var(Nat) ) ).

tff(fact_11_dB_Osimps_I6_J,axiom,
    ! [DB4: dB,Nat: nat] : ( var(Nat) != abs(DB4) ) ).

tff(fact_12_dB_Osimps_I3_J,axiom,
    ! [DB3: dB,DB: dB] :
      ( ( abs(DB) = abs(DB3) )
    <=> ( DB = DB3 ) ) ).

tff(fact_13_abs,axiom,
    ! [T: dB,S: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S)),abs(T))) ) ).

tff(fact_14_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( subst(lift(T,K),S,K) = T ) ).

tff(fact_15_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_16_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB)) = aa(A,A,aa(dB,fun(A,A),F3,DB),dB_rec(A,F1,F2,F3,DB)) ) ).

tff(fact_17_lift__preserves__beta,axiom,
    ! [I1: nat,S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,lift(R1,I1)),lift(S,I1))) ) ).

tff(fact_18_subst__preserves__beta,axiom,
    ! [I1: nat,T: dB,S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R1,T,I1)),subst(S,T,I1))) ) ).

tff(fact_19_subject__reduction,axiom,
    ! [T4: dB,T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,T1,T2)
     => ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T1),T4))
       => typing(E,T4,T2) ) ) ).

tff(fact_20_beta__cases_I2_J,axiom,
    ! [S: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R1)),S))
     => ~ ! [T5: dB] :
            ( ( S = abs(T5) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),T5)) ) ) ).

tff(fact_21_lift__type,axiom,
    ! [U2: type,I: nat,T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,T1,T2)
     => typing(shift(type,E,I,U2),lift(T1,I),T2) ) ).

tff(fact_22_subst__lemma,axiom,
    ! [I: nat,U2: type,U3: dB,E1: fun(nat,type),T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,T1,T2)
     => ( typing(E1,U3,U2)
       => ( ( E = shift(type,E1,I,U2) )
         => typing(E1,subst(T1,U3,I),T2) ) ) ) ).

tff(fact_23_rtrancl__beta__Abs,axiom,
    ! [S2: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),S1),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),abs(S1)),abs(S2))) ) ).

tff(fact_24_subst__lt,axiom,
    ! [U: dB,I1: nat,J1: nat] :
      ( ord_less(nat,J1,I1)
     => ( subst(var(J1),U,I1) = var(J1) ) ) ).

tff(fact_25_lift__preserves__beta_H,axiom,
    ! [I: nat,S1: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),R),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),lift(R,I)),lift(S1,I))) ) ).

tff(fact_26_subst__preserves__beta2,axiom,
    ! [I: nat,T1: dB,S1: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),subst(T1,R,I)),subst(T1,S1,I))) ) ).

tff(fact_27_subst__preserves__beta_H,axiom,
    ! [I: nat,T1: dB,S1: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),R),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),subst(R,T1,I)),subst(S1,T1,I))) ) ).

tff(fact_28_subst__preserves__beta2_H,axiom,
    ! [I: nat,T1: dB,S1: dB,R: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),R),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),subst(T1,R,I)),subst(T1,S1,I))) ) ).

tff(fact_29_shift__eq,axiom,
    ! [A: $tType,T2: A,E: fun(nat,A),J: nat,I: nat] :
      ( ( I = J )
     => ( aa(nat,A,shift(A,E,I,T2),J) = T2 ) ) ).

tff(fact_30_shift__gt,axiom,
    ! [A: $tType,T2: A,E: fun(nat,A),I: nat,J: nat] :
      ( ord_less(nat,J,I)
     => ( aa(nat,A,shift(A,E,I,T2),J) = aa(nat,A,E,J) ) ) ).

tff(fact_31_subject__reduction_H,axiom,
    ! [T2: type,E: fun(nat,type),T4: dB,T1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),transitive_rtranclp(dB,beta),T1),T4))
     => ( typing(E,T1,T2)
       => typing(E,T4,T2) ) ) ).

tff(fact_32_r__into__rtranclp,axiom,
    ! [A: $tType,Y2: A,X: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),R,X),Y2))
     => pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),X),Y2)) ) ).

tff(fact_33_rtranclp_Ortrancl__refl,axiom,
    ! [A: $tType,A1: A,R: fun(A,fun(A,bool))] : pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),A1),A1)) ).

tff(fact_34_rtranclp__idemp,axiom,
    ! [A: $tType,R: fun(A,fun(A,bool))] : ( transitive_rtranclp(A,transitive_rtranclp(A,R)) = transitive_rtranclp(A,R) ) ).

tff(fact_35_rtranclp__trans,axiom,
    ! [A: $tType,Z2: A,Y2: A,X: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),X),Y2))
     => ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),Y2),Z2))
       => pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),X),Z2)) ) ) ).

tff(fact_36_rtranclp_Ortrancl__into__rtrancl,axiom,
    ! [A: $tType,C: A,B1: A,A1: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),A1),B1))
     => ( pp(aa(A,bool,aa(A,fun(A,bool),R,B1),C))
       => pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),A1),C)) ) ) ).

tff(fact_37_converse__rtranclp__into__rtranclp,axiom,
    ! [A: $tType,C: A,B1: A,A1: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),R,A1),B1))
     => ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),B1),C))
       => pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),A1),C)) ) ) ).

tff(fact_38_converse__rtranclp__induct,axiom,
    ! [A: $tType,P: fun(A,bool),B1: A,A1: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),A1),B1))
     => ( pp(aa(A,bool,P,B1))
       => ( ! [Y1: A,Z: A] :
              ( pp(aa(A,bool,aa(A,fun(A,bool),R,Y1),Z))
             => ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),Z),B1))
               => ( pp(aa(A,bool,P,Z))
                 => pp(aa(A,bool,P,Y1)) ) ) )
         => pp(aa(A,bool,P,A1)) ) ) ) ).

tff(fact_39_rtranclp__induct,axiom,
    ! [A: $tType,P: fun(A,bool),B1: A,A1: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),A1),B1))
     => ( pp(aa(A,bool,P,A1))
       => ( ! [Y1: A,Z: A] :
              ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),A1),Y1))
             => ( pp(aa(A,bool,aa(A,fun(A,bool),R,Y1),Z))
               => ( pp(aa(A,bool,P,Y1))
                 => pp(aa(A,bool,P,Z)) ) ) )
         => pp(aa(A,bool,P,B1)) ) ) ) ).

tff(fact_40_converse__rtranclpE,axiom,
    ! [A: $tType,Z2: A,X: A,R: fun(A,fun(A,bool))] :
      ( pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),X),Z2))
     => ( ( X != Z2 )
       => ~ ! [Y1: A] :
              ( pp(aa(A,bool,aa(A,fun(A,bool),R,X),Y1))
             => ~ pp(aa(A,bool,aa(A,fun(A,bool),transitive_rtranclp(A,R),Y1),Z2)) ) ) ) ).

tff(fact_41_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_42_nat__neq__iff,axiom,
    ! [Na: nat,M: nat] :
      ( ( M != Na )
    <=> ( ord_less(nat,M,Na)
        | ord_less(nat,Na,M) ) ) ).

tff(fact_43_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),Na: nat,M: nat] :
      ( ( ord_less(nat,M,Na)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) )
     => ( ( ( M = Na )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) )
       => ( ( ord_less(nat,Na,M)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Na),M)) ) ) ) ).

tff(fact_44_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_45_less__not__refl2,axiom,
    ! [M1: nat,N: nat] :
      ( ord_less(nat,N,M1)
     => ( M1 != N ) ) ).

tff(fact_46_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_47_linorder__neqE__nat,axiom,
    ! [Y: nat,X2: nat] :
      ( ( X2 != Y )
     => ( ~ ord_less(nat,X2,Y)
       => ord_less(nat,Y,X2) ) ) ).

tff(fact_48_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X2: A] :
          ( ~ ord_less(A,X2,Y)
         => ( ( X2 != Y )
           => ord_less(A,Y,X2) ) ) ) ).

tff(fact_49_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ~ ord_less(A,Y,X2) ) ) ).

tff(fact_50_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z1: A,Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ( ord_less(A,Y,Z1)
           => ord_less(A,X2,Z1) ) ) ) ).

tff(fact_51_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ( ( B2 = C1 )
           => ord_less(A,A2,C1) ) ) ) ).

tff(fact_52_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A2: A] :
          ( ( A2 = B2 )
         => ( ord_less(A,B2,C1)
           => ord_less(A,A2,C1) ) ) ) ).

tff(fact_53_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X2: A] : ~ ord_less(A,X2,X2) ) ).

tff(fact_54_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X: A] :
          ( ( X != Y2 )
        <=> ( ord_less(A,X,Y2)
            | ord_less(A,Y2,X) ) ) ) ).

tff(fact_55_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X: A] :
          ( ~ ord_less(A,X,Y2)
        <=> ( ord_less(A,Y2,X)
            | ( X = Y2 ) ) ) ) ).

tff(fact_56_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
          | ( X2 = Y )
          | ord_less(A,Y,X2) ) ) ).

tff(fact_57_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X: A,Y2: A] :
          ( ~ ord_less(A,Y2,X)
         => ( ~ ord_less(A,X,Y2)
          <=> ( X = Y2 ) ) ) ) ).

tff(fact_58_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X2: A] :
          ( ( X2 != Y )
         => ( ~ ord_less(A,X2,Y)
           => ord_less(A,Y,X2) ) ) ) ).

tff(fact_59_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ( X2 != Y ) ) ) ).

tff(fact_60_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ~ ord_less(A,Y,X2) ) ) ).

tff(fact_61_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ~ ord_less(A,Y,X2) ) ) ).

tff(fact_62_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ( X2 != Y ) ) ) ).

tff(fact_63_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ( Y != X2 ) ) ) ).

tff(fact_64_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P: bool,Y2: A,X: A] :
          ( ord_less(A,X,Y2)
         => ( ord_less(A,Y2,X)
           => pp(P) ) ) ) ).

tff(fact_65_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A2: A] :
          ( ord_less(A,A2,B2)
         => ~ ord_less(A,B2,A2) ) ) ).

tff(fact_66_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [X11: A] : ord_less(A,X,X11) ) ).

tff(fact_67_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X2: A] :
        ? [Y1: A] : ord_less(A,Y1,X2) ) ).

tff(fact_68_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y: A,X2: A] :
          ( ord_less(A,X2,Y)
         => ? [Z: A] :
              ( ord_less(A,X2,Z)
              & ord_less(A,Z,Y) ) ) ) ).

tff(fact_69_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ( aa(A,B,F,B1) = C )
           => ( ! [X1: A,Y1: A] :
                  ( ord_less(A,X1,Y1)
                 => ord_less(B,aa(A,B,F,X1),aa(A,B,F,Y1)) )
             => ord_less(B,aa(A,B,F,A1),C) ) ) ) ) ).

tff(fact_70_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ord_less(A,A1,aa(B,A,F,B1))
         => ( ord_less(B,B1,C)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less(B,X1,Y1)
                 => ord_less(A,aa(B,A,F,X1),aa(B,A,F,Y1)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_71_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,B1: B,F: fun(B,A),A1: A] :
          ( ( A1 = aa(B,A,F,B1) )
         => ( ord_less(B,B1,C)
           => ( ! [X1: B,Y1: B] :
                  ( ord_less(B,X1,Y1)
                 => ord_less(A,aa(B,A,F,X1),aa(B,A,F,Y1)) )
             => ord_less(A,A1,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_72_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,A1: A] :
          ( ord_less(A,A1,B1)
         => ( ord_less(B,aa(A,B,F,B1),C)
           => ( ! [X1: A,Y1: A] :
                  ( ord_less(A,X1,Y1)
                 => ord_less(B,aa(A,B,F,X1),aa(A,B,F,Y1)) )
             => ord_less(B,aa(A,B,F,A1),C) ) ) ) ) ).

tff(fact_73_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X2: A] :
          ( ( X2 != Y )
         => ( ~ ord_less(A,X2,Y)
           => ord_less(A,Y,X2) ) ) ) ).

tff(fact_74_abs__typeE,axiom,
    ! [T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,abs(T1),T2)
     => ~ ! [U1: type,V: type] : ~ typing(shift(type,E,zero_zero(nat),U1),T1,V) ) ).

tff(fact_75_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X1: A] : ( aa(A,B,F,X1) = aa(A,B,G,X1) )
     => ( F = G ) ) ).

tff(fact_76_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_77_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_78_neq0__conv,axiom,
    ! [Na: nat] :
      ( ( Na != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),Na) ) ).

tff(fact_79_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_80_gr__implies__not0,axiom,
    ! [N: nat,M1: nat] :
      ( ord_less(nat,M1,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_81_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_82_Abs,axiom,
    ! [U2: type,T1: dB,T2: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),T2),T1,U2)
     => typing(Env,abs(T1),fun1(T2,U2)) ) ).

tff(fact_83_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( fun1(Type1,Type2) = fun1(Type11,Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_84_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_85_typing__elims_I3_J,axiom,
    ! [T2: type,T1: dB,E: fun(nat,type)] :
      ( typing(E,abs(T1),T2)
     => ~ ! [T3: type,U1: type] :
            ( ( T2 = fun1(T3,U1) )
           => ~ typing(shift(type,E,zero_zero(nat),T3),T1,U1) ) ) ).

tff(fact_86_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_87_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,fun1(Type1,Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_88_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_89_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,zero_zero(nat),Na) ) ) ).

tff(fact_90_beta,axiom,
    ! [T: dB,S: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,app(abs(S),T)),subst(S,T,zero_zero(nat)))) ).

tff(fact_91_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [Na: nat,M: nat] :
          ( ( semiring_1_of_nat(A,M) = semiring_1_of_nat(A,Na) )
        <=> ( M = Na ) ) ) ).

tff(fact_92_dB_Osimps_I2_J,axiom,
    ! [DB21: dB,DB11: dB,DB2: dB,DB1: dB] :
      ( ( app(DB1,DB2) = app(DB11,DB21) )
    <=> ( ( DB1 = DB11 )
        & ( DB2 = DB21 ) ) ) ).

tff(fact_93_appL,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,app(S,U)),app(T,U))) ) ).

tff(fact_94_appR,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S),T))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,app(U,S)),app(U,T))) ) ).

tff(fact_95_subst__App,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( subst(app(T,U),S,K) = app(subst(T,S,K),subst(U,S,K)) ) ).

tff(fact_96_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( lift(app(S,T),K) = app(lift(S,K),lift(T,K)) ) ).

tff(fact_97_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_98_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [Na: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,Na))
        <=> ord_less(nat,M,Na) ) ) ).

%----Arities (15)
tff(arity_fun___Orderings_Opreorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( preorder(T_2)
     => preorder(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_fun___Orderings_Oord,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( ord(T_2)
     => ord(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (1)
tff(conj_0,conjecture,
    it(var(n)) ).

%------------------------------------------------------------------------------
