%------------------------------------------------------------------------------
% File     : LCL759_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 58
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_58 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.25 v7.1.0, 0.33 v6.4.0
% Syntax   : Number of formulae    :  165 (  67 unt;  46 typ;   0 def)
%            Number of atoms       :  208 ( 125 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  121 (  32   ~;   8   |;  13   &)
%                                         (  19 <=>;  49  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   4 avg)
%            Maximal term depth    :   11 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   30 (  17   >;  13   *;   0   +;   0  <<)
%            Number of predicates  :   13 (  12 usr;   0 prp; 1-3 aty)
%            Number of functors    :   31 (  31 usr;  12 con; 0-5 aty)
%            Number of variables   :  313 ( 276   !;   7   ?; 313   :)
%                                         (  30  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:31
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (41)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Osemigroup__add,type,
    semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_ja,type,
    ja: nat ).

tff(sy_v_ra,type,
    ra: dB ).

tff(sy_v_s,type,
    s: dB ).

tff(sy_v_ss,type,
    ss: list(dB) ).

%----Relevant facts (97)
tff(fact_0_Beta,axiom,
    ! [Ss: list(dB),S2: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S2),zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S2))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S2),Ss))) ) ) ).

tff(fact_1_subst__map,axiom,
    ! [Ia: nat,U1: dB,Ts: list(dB),T2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,T2,Ts)),U1),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T2),U1),Ia),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,U1),Ia),Ts)) ) ).

tff(fact_2_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S2: dB,Rs1: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs1) = foldl(dB,dB,app,abs(S2),Ss) )
    <=> ( ( Ra = S2 )
        & ( Rs1 = Ss ) ) ) ).

tff(fact_3_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N1: nat,Rs1: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs1) = foldl(dB,dB,app,var(N1),Ss) )
    <=> ( ( M = N1 )
        & ( Rs1 = Ss ) ) ) ).

tff(fact_4_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_5_subst__App,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)),S),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S),K)) ) ).

tff(fact_6_apps__eq__tail__conv,axiom,
    ! [S2: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S2,Ts) )
    <=> ( Ra = S2 ) ) ).

tff(fact_7_Abs__App__neq__Var__apps,axiom,
    ! [Ss: list(dB),N1: nat,T2: dB,S2: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T2) != foldl(dB,dB,app,var(N1),Ss) ) ).

tff(fact_8_Var__apps__neq__Abs__apps,axiom,
    ! [Ss: list(dB),Ra: dB,Ts: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts) != foldl(dB,dB,app,abs(Ra),Ss) ) ).

tff(fact_9_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_10_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB4: dB] :
      ( ( abs(DB4) = abs(DB5) )
    <=> ( DB4 = DB5 ) ) ).

tff(fact_11_dB_Osimps_I1_J,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( var(Nat4) = var(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_12_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_13_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_14_dB_Osimps_I8_J,axiom,
    ! [DB3: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB3) ) ).

tff(fact_15_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_16_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB3: dB] : ( abs(DB3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_17_dB_Osimps_I6_J,axiom,
    ! [DB3: dB,Nat: nat] : ( var(Nat) != abs(DB3) ) ).

tff(fact_18_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB3: dB] : ( abs(DB3) != var(Nat) ) ).

tff(fact_19_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,var(K)),U),K) = U ) ).

tff(fact_20_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A1: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A1,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),A1,Xs) ) ).

tff(fact_21_nat_Oinject,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( suc(Nat4) = suc(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_22_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_23_IT_OVar,axiom,
    ! [N1: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs1))) ) ).

tff(fact_24_Suc__neq__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_25_Zero__neq__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_26_nat_Osimps_I3_J,axiom,
    ! [Nat3: nat] : ( suc(Nat3) != zero_zero(nat) ) ).

tff(fact_27_Suc__not__Zero,axiom,
    ! [M1: nat] : ( suc(M1) != zero_zero(nat) ) ).

tff(fact_28_listsp__conj__eq,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A3),B3),X3)
    <=> ( listsp(A,A3,X3)
        & listsp(A,B3,X3) ) ) ).

tff(fact_29_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_30_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_31_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_32_Suc__inject,axiom,
    ! [Y: nat,X1: nat] :
      ( ( suc(X1) = suc(Y) )
     => ( X1 = Y ) ) ).

tff(fact_33_Zero__not__Suc,axiom,
    ! [M1: nat] : ( zero_zero(nat) != suc(M1) ) ).

tff(fact_34_nat_Osimps_I2_J,axiom,
    ! [Nat2: nat] : ( zero_zero(nat) != suc(Nat2) ) ).

tff(fact_35_IT_Osimps,axiom,
    ! [A1: dB] :
      ( pp(aa(dB,bool,it,A1))
    <=> ( ? [Rs: list(dB),N3: nat] :
            ( ( A1 = foldl(dB,dB,app,var(N3),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R2: dB] :
            ( ( A1 = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S3: dB,Ss1: list(dB)] :
            ( ( A1 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S3),Ss1) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),S3),zero_zero(nat)),Ss1)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_36_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ? [M2: nat] : ( N = suc(M2) ) ) ).

tff(fact_37_nat__induct,axiom,
    ! [N1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,N2))
           => pp(aa(nat,bool,P1,suc(N2))) )
       => pp(aa(nat,bool,P1,N1)) ) ) ).

tff(fact_38_zero__induct,axiom,
    ! [K1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K1))
     => ( ! [N2: nat] :
            ( pp(aa(nat,bool,P1,suc(N2)))
           => pp(aa(nat,bool,P1,N2)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_39_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat1: nat] : ( Y != suc(Nat1) ) ) ).

tff(fact_40_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_41_lift_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)) ) ).

tff(fact_42_lift__IT,axiom,
    ! [I1: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I1))) ) ).

tff(fact_43_lift__map,axiom,
    ! [Ia: nat,Ts: list(dB),T2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,T2,Ts)),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,T2),Ia),map(dB,dB,combc(dB,nat,dB,lift,Ia),Ts)) ) ).

tff(fact_44_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),K)),S),K) = T ) ).

tff(fact_45_dB_Osize_I3_J,axiom,
    ! [DB: dB] : ( dB_size(abs(DB)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),dB_size(DB)),suc(zero_zero(nat))) ) ).

tff(fact_46_liftn__lift,axiom,
    ! [K: nat,T: dB,N: nat] : ( liftn(suc(N),T,K) = aa(nat,dB,aa(dB,fun(nat,dB),lift,liftn(N,T,K)),K) ) ).

tff(fact_47_dB_Osize_I2_J,axiom,
    ! [DB2: dB,DB1: dB] : ( dB_size(aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),dB_size(DB1)),dB_size(DB2))),suc(zero_zero(nat))) ) ).

tff(fact_48_beta,axiom,
    ! [T: dB,S: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),zero_zero(nat))) ).

tff(fact_49_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_50_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C2) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_51_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A1: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C2),A1) )
        <=> ( B2 = C2 ) ) ) ).

tff(fact_52_nat__add__left__cancel,axiom,
    ! [N1: nat,M: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),M) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K1),N1) )
    <=> ( M = N1 ) ) ).

tff(fact_53_nat__add__right__cancel,axiom,
    ! [N1: nat,K1: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),K1) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N1),K1) )
    <=> ( M = N1 ) ) ).

tff(fact_54_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( zero_zero(A) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_55_add__is__0,axiom,
    ! [N1: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1) = zero_zero(nat) )
    <=> ( ( M = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_56_add__Suc__right,axiom,
    ! [N: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),suc(N)) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N)) ) ).

tff(fact_57_add__Suc,axiom,
    ! [N: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M1)),N) = suc(aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N)) ) ).

tff(fact_58_appL,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S),U),aa(dB,dB,aa(dB,fun(dB,dB),app,T),U)) ) ).

tff(fact_59_appR,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(S,T)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U),S),aa(dB,dB,aa(dB,fun(dB,dB),app,U),T)) ) ).

tff(fact_60_abs,axiom,
    ! [T: dB,S: dB] :
      ( beta(S,T)
     => beta(abs(S),abs(T)) ) ).

tff(fact_61_beta__cases_I1_J,axiom,
    ! [T: dB,I1: nat] : ~ beta(var(I1),T) ).

tff(fact_62_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T: dB,S: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S,K)),liftn(N,T,K)) ) ).

tff(fact_63_dB_Osize_I5_J,axiom,
    ! [DB2: dB,DB1: dB] : ( size_size(dB,aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),size_size(dB,DB1)),size_size(dB,DB2))),suc(zero_zero(nat))) ) ).

tff(fact_64_dB_Osize_I6_J,axiom,
    ! [DB: dB] : ( size_size(dB,abs(DB)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),size_size(dB,DB)),suc(zero_zero(nat))) ) ).

tff(fact_65_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_66_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A2) = A2 ) ) ).

tff(fact_67_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_68_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),zero_zero(A)) = A2 ) ) ).

tff(fact_69_add__eq__self__zero,axiom,
    ! [N: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N) = M1 )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_70_Nat_Oadd__0__right,axiom,
    ! [M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),zero_zero(nat)) = M1 ) ).

tff(fact_71_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N) = N ) ).

tff(fact_72_add__Suc__shift,axiom,
    ! [N: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),suc(M1)),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),suc(N)) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_foldl__assoc,axiom,
    ! [A: $tType] :
      ( semigroup_add(A)
     => ! [Zs: list(A),Y1: A,X: A] : ( foldl(A,A,plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),X),Y1),Zs) = aa(A,A,aa(A,fun(A,A),plus_plus(A),X),foldl(A,A,plus_plus(A),Y1,Zs)) ) ) ).

tff(fact_75_nat__add__commute,axiom,
    ! [N: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M1) ) ).

tff(fact_76_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),Z)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),Y),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),X1),Z)) ) ).

tff(fact_77_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B1)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),C1)) ) ) ).

tff(fact_78_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M1: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),K)) ) ).

tff(fact_79_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_80_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C1) )
         => ( B1 = C1 ) ) ) ).

tff(fact_81_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A2) )
         => ( B1 = C1 ) ) ) ).

tff(fact_82_subst__preserves__beta,axiom,
    ! [I1: nat,T: dB,S: dB,R1: dB] :
      ( beta(R1,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R1),T),I1),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S),T),I1)) ) ).

tff(fact_83_lift__preserves__beta,axiom,
    ! [I1: nat,S: dB,R1: dB] :
      ( beta(R1,S)
     => beta(aa(nat,dB,aa(dB,fun(nat,dB),lift,R1),I1),aa(nat,dB,aa(dB,fun(nat,dB),lift,S),I1)) ) ).

tff(fact_84_liftn__0,axiom,
    ! [K: nat,T: dB] : ( liftn(zero_zero(nat),T,K) = T ) ).

tff(fact_85_foldl__absorb0,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [Zs: list(A),X: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),X),foldl(A,A,plus_plus(A),zero_zero(A),Zs)) = foldl(A,A,plus_plus(A),X,Zs) ) ) ).

tff(fact_86_one__is__add,axiom,
    ! [N1: nat,M: nat] :
      ( ( suc(zero_zero(nat)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N1 = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N1 = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_87_add__is__1,axiom,
    ! [N1: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N1) = suc(zero_zero(nat)) )
    <=> ( ( ( M = suc(zero_zero(nat)) )
          & ( N1 = zero_zero(nat) ) )
        | ( ( M = zero_zero(nat) )
          & ( N1 = suc(zero_zero(nat)) ) ) ) ) ).

tff(fact_88_beta__cases_I2_J,axiom,
    ! [S: dB,R1: dB] :
      ( beta(abs(R1),S)
     => ~ ! [T1: dB] :
            ( ( S = abs(T1) )
           => ~ beta(R1,T1) ) ) ).

tff(fact_89_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),A1) = zero_zero(A) )
        <=> ( A1 = zero_zero(A) ) ) ) ).

tff(fact_90_apps__preserves__beta,axiom,
    ! [Ss: list(dB),S2: dB,Ra: dB] :
      ( beta(Ra,S2)
     => beta(foldl(dB,dB,app,Ra,Ss),foldl(dB,dB,app,S2,Ss)) ) ).

tff(fact_91_substn__subst__n,axiom,
    ! [N: nat,S: dB,T: dB] : ( substn(T,S,N) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),liftn(N,S,zero_zero(nat))),N) ) ).

tff(fact_92_substn_Osimps_I2_J,axiom,
    ! [K: nat,S: dB,U: dB,T: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T),U),S,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T,S,K)),substn(U,S,K)) ) ).

tff(fact_93_substn__subst__0,axiom,
    ! [S: dB,T: dB] : ( substn(T,S,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),S),zero_zero(nat)) ) ).

tff(fact_94_beta__cases_I3_J,axiom,
    ! [U: dB,T: dB,S: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S),T),U)
     => ( ! [S1: dB] :
            ( ( U = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T),zero_zero(nat)) )
           => ( S != abs(S1) ) )
       => ( ! [T1: dB] :
              ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T) )
             => ~ beta(S,T1) )
         => ~ ! [T1: dB] :
                ( ( U = aa(dB,dB,aa(dB,fun(dB,dB),app,S),T1) )
               => ~ beta(T,T1) ) ) ) ) ).

tff(fact_95_subst__Abs,axiom,
    ! [K: nat,S: dB,T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,abs(T)),S),K) = abs(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),aa(nat,dB,aa(dB,fun(nat,dB),lift,S),zero_zero(nat))),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),K),one_one(nat)))) ) ).

tff(fact_96_One__nat__def,axiom,
    one_one(nat) = suc(zero_zero(nat)) ).

%----Arities (8)
tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Osemigroup__add,axiom,
    semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

%----Helper facts (9)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,ra),s),zero_zero(nat)),ss))) ).

tff(conj_1,hypothesis,
    ! [I: nat,J: nat] : pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,ra),var(suc(I))),suc(J))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,s),var(I)),J)),zero_zero(nat)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,var(I)),J),ss)))) ).

tff(conj_2,hypothesis,
    pp(aa(dB,bool,it,s)) ).

tff(conj_3,hypothesis,
    ! [I: nat,J: nat] : pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,s),var(I)),J))) ).

tff(conj_4,conjecture,
    pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,ra),var(suc(ia))),suc(ja)))),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,s),var(ia)),ja)),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,var(ia)),ja),ss)))) ).

%------------------------------------------------------------------------------
