%------------------------------------------------------------------------------
% File     : LCL757_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 56
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_56 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  147 (  49 unt;  40 typ;   0 def)
%            Number of atoms       :  231 ( 156 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  166 (  42   ~;   9   |;  34   &)
%                                         (  31 <=>;  50  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :    7 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   47 (  24   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :    7 (   6 usr;   0 prp; 1-4 aty)
%            Number of functors    :   31 (  31 usr;  10 con; 0-5 aty)
%            Number of variables   :  388 ( 351   !;  15   ?; 388   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:20
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (35)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T3: $tType,A: $tType] : ( ( T3 * fun(A,fun(list(A),T3)) * list(A) ) > T3 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( fun(A,list(B)) * list(A) ) > list(B) ) ).

tff(sy_c_List_Orotate1,type,
    rotate1: 
      !>[A: $tType] : ( list(A) > list(A) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_ja,type,
    ja: nat ).

tff(sy_v_ra,type,
    ra: dB ).

tff(sy_v_s,type,
    s: dB ).

tff(sy_v_ss,type,
    ss: list(dB) ).

%----Relevant facts (99)
tff(fact_0_Beta,axiom,
    ! [Ss2: list(dB),S: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(Ra,S,zero_zero(nat)),Ss2)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S),Ss2))) ) ) ).

tff(fact_1_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,Rs: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs) = foldl(dB,dB,app,abs(S),Ss2) )
    <=> ( ( Ra = S )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_2_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss2: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,var(M),Rs) = foldl(dB,dB,app,var(N),Ss2) )
    <=> ( ( M = N )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_3_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_4_subst__App,axiom,
    ! [K: nat,S2: dB,U2: dB,T2: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U2),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T2,S2,K)),subst(U2,S2,K)) ) ).

tff(fact_5_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( Ra = S ) ) ).

tff(fact_6_Abs__App__neq__Var__apps,axiom,
    ! [Ss2: list(dB),N: nat,T: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T) != foldl(dB,dB,app,var(N),Ss2) ) ).

tff(fact_7_Var__apps__neq__Abs__apps,axiom,
    ! [Ss2: list(dB),Ra: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,var(N),Ts) != foldl(dB,dB,app,abs(Ra),Ss2) ) ).

tff(fact_8_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_9_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat1: nat] :
      ( ( var(Nat1) = var(Nat2) )
    <=> ( Nat1 = Nat2 ) ) ).

tff(fact_10_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_11_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X: A] :
          ( ( zero_zero(A) = X )
        <=> ( X = zero_zero(A) ) ) ) ).

tff(fact_12_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_13_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

tff(fact_14_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_15_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_16_dB_Osimps_I6_J,axiom,
    ! [DB: dB,Nat: nat] : ( var(Nat) != abs(DB) ) ).

tff(fact_17_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB: dB] : ( abs(DB) != var(Nat) ) ).

tff(fact_18_subst__eq,axiom,
    ! [U2: dB,K: nat] : ( subst(var(K),U2,K) = U2 ) ).

tff(fact_19_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_20_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N),Rs))) ) ).

tff(fact_21_beta,axiom,
    ! [T2: dB,S2: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T2)),subst(S2,T2,zero_zero(nat)))) ).

tff(fact_22_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_23_IT_Osimps,axiom,
    ! [A2: dB] :
      ( pp(aa(dB,bool,it,A2))
    <=> ( ? [Rs2: list(dB),N2: nat] :
            ( ( A2 = foldl(dB,dB,app,var(N2),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R2: dB] :
            ( ( A2 = abs(R2) )
            & pp(aa(dB,bool,it,R2)) )
        | ? [R2: dB,S3: dB,Ss: list(dB)] :
            ( ( A2 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R2)),S3),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R2,S3,zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_24_substn__subst__0,axiom,
    ! [S2: dB,T2: dB] : ( substn(T2,S2,zero_zero(nat)) = subst(T2,S2,zero_zero(nat)) ) ).

tff(fact_25_apps__eq__Abs__conv,axiom,
    ! [Ra: dB,Ss2: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss2) = abs(Ra) )
    <=> ( ( S = abs(Ra) )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_26_Var__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,M: nat] :
      ( ( var(M) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( var(M) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_27_Abs__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,Ra: dB] :
      ( ( abs(Ra) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( abs(Ra) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_28_appL,axiom,
    ! [U2: dB,T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U2)),aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U2))) ) ).

tff(fact_29_appR,axiom,
    ! [U2: dB,T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U2),S2)),aa(dB,dB,aa(dB,fun(dB,dB),app,U2),T2))) ) ).

tff(fact_30_abs,axiom,
    ! [T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S2)),abs(T2))) ) ).

tff(fact_31_beta__cases_I1_J,axiom,
    ! [T2: dB,I1: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,var(I1)),T2)) ).

tff(fact_32_substn_Osimps_I2_J,axiom,
    ! [K: nat,S2: dB,U2: dB,T2: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U2),S2,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T2,S2,K)),substn(U2,S2,K)) ) ).

tff(fact_33_subst__preserves__beta,axiom,
    ! [I1: nat,T2: dB,S2: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),S2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,subst(R1,T2,I1)),subst(S2,T2,I1))) ) ).

tff(fact_34_beta__cases_I2_J,axiom,
    ! [S2: dB,R1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R1)),S2))
     => ~ ! [T1: dB] :
            ( ( S2 = abs(T1) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R1),T1)) ) ) ).

tff(fact_35_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_36_apps__preserves__beta,axiom,
    ! [Ss2: list(dB),S: dB,Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Ss2)),foldl(dB,dB,app,S,Ss2))) ) ).

tff(fact_37_substn__subst__n,axiom,
    ! [N1: nat,S2: dB,T2: dB] : ( substn(T2,S2,N1) = subst(T2,liftn(N1,S2,zero_zero(nat)),N1) ) ).

tff(fact_38_beta__cases_I3_J,axiom,
    ! [U2: dB,T2: dB,S2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2)),U2))
     => ( ! [S1: dB] :
            ( ( U2 = subst(S1,T2,zero_zero(nat)) )
           => ( S2 != abs(S1) ) )
       => ( ! [T1: dB] :
              ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T2) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S2),T1)) )
         => ~ ! [T1: dB] :
                ( ( U2 = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T1) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T2),T1)) ) ) ) ) ).

tff(fact_39_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,nil(B)) = A2 ) ).

tff(fact_40_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T2: dB,S2: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S2,K)),liftn(N1,T2,K)) ) ).

tff(fact_41_liftn__0,axiom,
    ! [K: nat,T2: dB] : ( liftn(zero_zero(nat),T2,K) = T2 ) ).

tff(fact_42_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y: A,S1: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),X2)),Y) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S1),Y)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X),Xs) ) ) ).

tff(fact_43_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_44_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_45_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P: fun(A,bool)] : ~ list_ex1(A,P,nil(A)) ).

tff(fact_46_apps__preserves__betas,axiom,
    ! [Ra: dB,Ss2: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss2)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),foldl(dB,dB,app,Ra,Ss2))) ) ).

tff(fact_47_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,var(N),Rs)),V))
     => ? [Ss1: list(dB)] :
          ( step1(dB,beta,Rs,Ss1)
          & ( V = foldl(dB,dB,app,var(N),Ss1) ) ) ) ).

tff(fact_48_not__step1__Nil,axiom,
    ! [A: $tType,Xs: list(A),Ra: fun(A,fun(A,bool))] : ~ step1(A,Ra,Xs,nil(A)) ).

tff(fact_49_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),Ra: fun(A,fun(A,bool))] : ~ step1(A,Ra,nil(A),Xs) ).

tff(fact_50_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),S))
     => ( ! [R: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),R))
           => ( S != foldl(dB,dB,app,R,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,Ra,Rs1) ) )
         => ~ ! [T1: dB] :
                ( ( Ra = abs(T1) )
               => ! [U1: dB,Us3: list(dB)] :
                    ( ( Rs = cons(dB,U1,Us3) )
                   => ( S != foldl(dB,dB,app,subst(T1,U1,zero_zero(nat)),Us3) ) ) ) ) ) ) ).

tff(fact_51_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List1: list(A),A2: A] :
      ( ( cons(A,A2,List1) = cons(A,A6,List3) )
    <=> ( ( A2 = A6 )
        & ( List1 = List3 ) ) ) ).

tff(fact_52_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys1: list(A),Y1: A,Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,cons(A,Y1,Ys1),cons(A,X,Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y1),X))
          & ( Xs = Ys1 ) )
        | ( ( X = Y1 )
          & step1(A,Ra,Ys1,Xs) ) ) ) ).

tff(fact_53_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X1: A] : ( cons(A,X1,Xs1) != Xs1 ) ).

tff(fact_54_not__Cons__self,axiom,
    ! [A: $tType,X1: A,Xs1: list(A)] : ( Xs1 != cons(A,X1,Xs1) ) ).

tff(fact_55_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,cons(B,X,Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A2),X),Xs) ) ).

tff(fact_56_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != cons(A,A5,List2) ) ).

tff(fact_57_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( cons(A,A5,List2) != nil(A) ) ).

tff(fact_58_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A2: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,cons(B,A2,List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A2),List1) ) ).

tff(fact_59_listsp_Osimps,axiom,
    ! [A: $tType,A2: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,A2)
    <=> ( ( A2 = nil(A) )
        | ? [A4: A,L: list(A)] :
            ( ( A2 = cons(A,A4,L) )
            & pp(aa(A,bool,A1,A4))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_60_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y3: A,Ys4: list(A)] : ( Xs = cons(A,Y3,Ys4) ) ) ).

tff(fact_61_list_Oexhaust,axiom,
    ! [A: $tType,Y2: list(A)] :
      ( ( Y2 != nil(A) )
     => ~ ! [A3: A,List: list(A)] : ( Y2 != cons(A,A3,List) ) ) ).

tff(fact_62_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X: A,Ys1: list(A),Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,Ys1,cons(A,X,Xs))
     => ( ! [Y: A] :
            ( ( Ys1 = cons(A,Y,Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y),X)) )
       => ~ ! [Zs2: list(A)] :
              ( ( Ys1 = cons(A,X,Zs2) )
             => ~ step1(A,Ra,Zs2,Xs) ) ) ) ).

tff(fact_63_insert__Nil,axiom,
    ! [A: $tType,X1: A] : ( insert(A,X1,nil(A)) = cons(A,X1,nil(A)) ) ).

tff(fact_64_sublist__singleton,axiom,
    ! [A: $tType,X: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X,nil(A)),A1) = cons(A,X,nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,cons(A,X,nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_65_App__eq__foldl__conv,axiom,
    ! [Ts: list(dB),T: dB,S: dB,Ra: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,Ra),S) = foldl(dB,dB,app,T,Ts) )
    <=> ( ( ( Ts = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,Ra),S) = T ) )
        & ( ( Ts != nil(dB) )
         => ? [Ss: list(dB)] :
              ( ( Ts = append(dB,Ss,cons(dB,S,nil(dB))) )
              & ( Ra = foldl(dB,dB,app,T,Ss) ) ) ) ) ) ).

tff(fact_66_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Xs) = append(A,Zs,Xs) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_67_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys1) = append(A,Xs,Zs) )
    <=> ( Ys1 = Zs ) ) ).

tff(fact_68_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys3: list(A),Xs1: list(A)] : ( append(A,append(A,Xs1,Ys3),Zs1) = append(A,Xs1,append(A,Ys3,Zs1)) ) ).

tff(fact_69_append__Cons,axiom,
    ! [A: $tType,Ys3: list(A),Xs1: list(A),X1: A] : ( append(A,cons(A,X1,Xs1),Ys3) = cons(A,X1,append(A,Xs1,Ys3)) ) ).

tff(fact_70_Nil__is__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] :
      ( ( nil(A) = append(A,Xs,Ys1) )
    <=> ( ( Xs = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_71_self__append__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] :
      ( ( Xs = append(A,Xs,Ys1) )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_72_self__append__conv2,axiom,
    ! [A: $tType,Xs: list(A),Ys1: list(A)] :
      ( ( Ys1 = append(A,Xs,Ys1) )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_73_append__is__Nil__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys1) = nil(A) )
    <=> ( ( Xs = nil(A) )
        & ( Ys1 = nil(A) ) ) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X: A] :
      ( member(A,X,A1)
    <=> pp(aa(A,bool,A1,X)) ) ).

tff(fact_76_append__self__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys1) = Xs )
    <=> ( Ys1 = nil(A) ) ) ).

tff(fact_77_append__self__conv2,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys1) = Ys1 )
    <=> ( Xs = nil(A) ) ) ).

tff(fact_78_foldl__append,axiom,
    ! [A: $tType,B: $tType,Ys1: list(B),Xs: list(B),A2: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A2,append(B,Xs,Ys1)) = foldl(A,B,F,foldl(A,B,F,A2,Xs),Ys1) ) ).

tff(fact_79_append__in__listsp__conv,axiom,
    ! [A: $tType,Ys1: list(A),Xs: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,append(A,Xs,Ys1))
    <=> ( listsp(A,A1,Xs)
        & listsp(A,A1,Ys1) ) ) ).

tff(fact_80_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_81_append1__eq__conv,axiom,
    ! [A: $tType,Y1: A,Ys1: list(A),X: A,Xs: list(A)] :
      ( ( append(A,Xs,cons(A,X,nil(A))) = append(A,Ys1,cons(A,Y1,nil(A))) )
    <=> ( ( Xs = Ys1 )
        & ( X = Y1 ) ) ) ).

tff(fact_82_Cons__eq__appendI,axiom,
    ! [A: $tType,Zs1: list(A),Xs1: list(A),Ys3: list(A),Xs11: list(A),X1: A] :
      ( ( cons(A,X1,Xs11) = Ys3 )
     => ( ( Xs1 = append(A,Xs11,Zs1) )
       => ( cons(A,X1,Xs1) = append(A,Ys3,Zs1) ) ) ) ).

tff(fact_83_append__eq__appendI,axiom,
    ! [A: $tType,Us2: list(A),Ys3: list(A),Zs1: list(A),Xs11: list(A),Xs1: list(A)] :
      ( ( append(A,Xs1,Xs11) = Zs1 )
     => ( ( Ys3 = append(A,Xs11,Us2) )
       => ( append(A,Xs1,Ys3) = append(A,Zs1,Us2) ) ) ) ).

tff(fact_84_append__eq__append__conv2,axiom,
    ! [A: $tType,Ts: list(A),Zs: list(A),Ys1: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys1) = append(A,Zs,Ts) )
    <=> ? [Us1: list(A)] :
          ( ( ( Xs = append(A,Zs,Us1) )
            & ( append(A,Us1,Ys1) = Ts ) )
          | ( ( append(A,Xs,Us1) = Zs )
            & ( Ys1 = append(A,Us1,Ts) ) ) ) ) ).

tff(fact_85_append__Nil,axiom,
    ! [A: $tType,Ys3: list(A)] : ( append(A,nil(A),Ys3) = Ys3 ) ).

tff(fact_86_append__Nil2,axiom,
    ! [A: $tType,Xs1: list(A)] : ( append(A,Xs1,nil(A)) = Xs1 ) ).

tff(fact_87_eq__Nil__appendI,axiom,
    ! [A: $tType,Ys3: list(A),Xs1: list(A)] :
      ( ( Xs1 = Ys3 )
     => ( Xs1 = append(A,nil(A),Ys3) ) ) ).

tff(fact_88_append__step1I,axiom,
    ! [A: $tType,Us: list(A),Vs: list(A),Xs: list(A),Ys1: list(A),Ra: fun(A,fun(A,bool))] :
      ( ( ( step1(A,Ra,Ys1,Xs)
          & ( Vs = Us ) )
        | ( ( Ys1 = Xs )
          & step1(A,Ra,Vs,Us) ) )
     => step1(A,Ra,append(A,Ys1,Vs),append(A,Xs,Us)) ) ).

tff(fact_89_append__eq__Cons__conv,axiom,
    ! [A: $tType,Xs: list(A),X: A,Zs: list(A),Ys1: list(A)] :
      ( ( append(A,Ys1,Zs) = cons(A,X,Xs) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( Zs = cons(A,X,Xs) ) )
        | ? [Ys2: list(A)] :
            ( ( Ys1 = cons(A,X,Ys2) )
            & ( append(A,Ys2,Zs) = Xs ) ) ) ) ).

tff(fact_90_Cons__eq__append__conv,axiom,
    ! [A: $tType,Zs: list(A),Ys1: list(A),Xs: list(A),X: A] :
      ( ( cons(A,X,Xs) = append(A,Ys1,Zs) )
    <=> ( ( ( Ys1 = nil(A) )
          & ( cons(A,X,Xs) = Zs ) )
        | ? [Ys2: list(A)] :
            ( ( cons(A,X,Ys2) = Ys1 )
            & ( Xs = append(A,Ys2,Zs) ) ) ) ) ).

tff(fact_91_Snoc__step1__SnocD,axiom,
    ! [A: $tType,X: A,Xs: list(A),Y1: A,Ys1: list(A),Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,append(A,Ys1,cons(A,Y1,nil(A))),append(A,Xs,cons(A,X,nil(A))))
     => ( ( step1(A,Ra,Ys1,Xs)
          & ( Y1 = X ) )
        | ( ( Ys1 = Xs )
          & pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y1),X)) ) ) ) ).

tff(fact_92_app__last,axiom,
    ! [U: dB,Ts: list(dB),T: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,foldl(dB,dB,app,T,Ts)),U) = foldl(dB,dB,app,T,append(dB,Ts,cons(dB,U,nil(dB)))) ) ).

tff(fact_93_rev__cases,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ~ ! [Ys: list(A),Y: A] : ( Xs1 != append(A,Ys,cons(A,Y,nil(A))) ) ) ).

tff(fact_94_rev__induct,axiom,
    ! [A: $tType,Xs: list(A),P: fun(list(A),bool)] :
      ( pp(aa(list(A),bool,P,nil(A)))
     => ( ! [X2: A,Xs2: list(A)] :
            ( pp(aa(list(A),bool,P,Xs2))
           => pp(aa(list(A),bool,P,append(A,Xs2,cons(A,X2,nil(A))))) )
       => pp(aa(list(A),bool,P,Xs)) ) ) ).

tff(fact_95_rev__exhaust2,axiom,
    ! [A: $tType,Xs1: list(A)] :
      ( ( Xs1 != nil(A) )
     => ~ ! [Ys: list(A),Y: A] : ( Xs1 != append(A,Ys,cons(A,Y,nil(A))) ) ) ).

tff(fact_96_rotate__simps,axiom,
    ! [A: $tType,B: $tType,Xs1: list(B),X1: B] :
      ( ( rotate1(A,nil(A)) = nil(A) )
      & ( rotate1(B,cons(B,X1,Xs1)) = append(B,Xs1,cons(B,X1,nil(B))) ) ) ).

tff(fact_97_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X: B,F: fun(B,list(A))] : ( maps(B,A,F,cons(B,X,Xs)) = append(A,aa(B,list(A),F,X),maps(B,A,F,Xs)) ) ).

tff(fact_98_rotate1__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( rotate1(A,Xs) = nil(A) )
    <=> ( Xs = nil(A) ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (5)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,foldl(dB,dB,app,subst(ra,s,zero_zero(nat)),ss))) ).

tff(conj_1,hypothesis,
    ! [I: nat,J: nat] : pp(aa(dB,bool,it,subst(foldl(dB,dB,app,subst(ra,s,zero_zero(nat)),ss),var(I),J))) ).

tff(conj_2,hypothesis,
    pp(aa(dB,bool,it,s)) ).

tff(conj_3,hypothesis,
    ! [I: nat,J: nat] : pp(aa(dB,bool,it,subst(s,var(I),J))) ).

tff(conj_4,conjecture,
    pp(aa(dB,bool,it,subst(foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(ra)),s),ss),var(ia),ja))) ).

%------------------------------------------------------------------------------
