%------------------------------------------------------------------------------
% File     : LCL756_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 54
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_54 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v7.5.0, 0.33 v7.4.0, 0.00 v6.4.0
% Syntax   : Number of formulae    :  151 (  39 unt;  33 typ;   0 def)
%            Number of atoms       :  294 (  68 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  215 (  39   ~;   6   |;   6   &)
%                                         (  19 <=>; 145  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   31 (  14   >;  17   *;   0   +;   0  <<)
%            Number of predicates  :   15 (  14 usr;   0 prp; 1-3 aty)
%            Number of functors    :   16 (  16 usr;   5 con; 0-5 aty)
%            Number of variables   :  334 ( 311   !;   5   ?; 334   :)
%                                         (  18  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:16
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (29)
tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,fun(T1,fun(T1,T1)))) * fun(dB,fun(T1,T1)) * dB ) > T1 ) ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_ja,type,
    ja: nat ).

tff(sy_v_ra,type,
    ra: dB ).

%----Relevant facts (99)
tff(fact_0_dB_Osimps_I1_J,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_1_nat_Oinject,axiom,
    ! [Nat1: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat1) )
    <=> ( Nat = Nat1 ) ) ).

tff(fact_2_subst__eq,axiom,
    ! [U: dB,K2: nat] : ( subst(var(K2),U,K2) = U ) ).

tff(fact_3_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_4_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_5_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_6_lift__IT,axiom,
    ! [I1: nat,T: dB] :
      ( it(T)
     => it(lift(T,I1)) ) ).

tff(fact_7_of__nat__aux_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Ia: A,N1: nat,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,suc(N1),Ia) = semiri532925092at_aux(A,Inc,N1,aa(A,A,Inc,Ia)) ) ) ).

tff(fact_8_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_9_subst__lt,axiom,
    ! [U: dB,I1: nat,J1: nat] :
      ( ord_less(nat,J1,I1)
     => ( subst(var(J1),U,I1) = var(J1) ) ) ).

tff(fact_10_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_11_Suc__mono,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less(nat,suc(M),suc(N)) ) ).

tff(fact_12_Suc__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,suc(M1),suc(N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_13_not__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ~ ord_less(nat,M1,N1)
    <=> ord_less(nat,N1,suc(M1)) ) ).

tff(fact_14_lessI,axiom,
    ! [N: nat] : ord_less(nat,N,suc(N)) ).

tff(fact_15_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_16_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_17_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_18_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_19_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_20_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_21_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) ) ) ) ).

tff(fact_22_Suc__less__SucD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,suc(M),suc(N))
     => ord_less(nat,M,N) ) ).

tff(fact_23_Suc__lessD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,suc(M),N)
     => ord_less(nat,M,N) ) ).

tff(fact_24_less__SucE,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,suc(N))
     => ( ~ ord_less(nat,M,N)
       => ( M = N ) ) ) ).

tff(fact_25_less__trans__Suc,axiom,
    ! [K2: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ( ord_less(nat,J1,K2)
       => ord_less(nat,suc(I1),K2) ) ) ).

tff(fact_26_Suc__lessI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( ( suc(M) != N )
       => ord_less(nat,suc(M),N) ) ) ).

tff(fact_27_less__SucI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less(nat,M,suc(N)) ) ).

tff(fact_28_less__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ~ ord_less(nat,N,M)
     => ( ord_less(nat,N,suc(M))
       => ( M = N ) ) ) ).

tff(fact_29_not__less__less__Suc__eq,axiom,
    ! [M1: nat,N1: nat] :
      ( ~ ord_less(nat,N1,M1)
     => ( ord_less(nat,N1,suc(M1))
      <=> ( N1 = M1 ) ) ) ).

tff(fact_30_less__Suc__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,suc(N1))
    <=> ( ord_less(nat,M1,N1)
        | ( M1 = N1 ) ) ) ).

tff(fact_31_subst__lift,axiom,
    ! [S: dB,K2: nat,T: dB] : ( subst(lift(T,K2),S,K2) = T ) ).

tff(fact_32_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [M1: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N3: nat] : ord_less(A,aa(nat,A,F,N3),aa(nat,A,F,suc(N3)))
         => ( ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,M1))
          <=> ord_less(nat,N1,M1) ) ) ) ).

tff(fact_33_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [N2: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N3: nat] : ord_less(A,aa(nat,A,F,N3),aa(nat,A,F,suc(N3)))
         => ( ord_less(nat,N1,N2)
           => ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,N2)) ) ) ) ).

tff(fact_34_Suc__lessE,axiom,
    ! [K2: nat,I1: nat] :
      ( ord_less(nat,suc(I1),K2)
     => ~ ! [J2: nat] :
            ( ord_less(nat,I1,J2)
           => ( K2 != suc(J2) ) ) ) ).

tff(fact_35_lessE,axiom,
    ! [K2: nat,I1: nat] :
      ( ord_less(nat,I1,K2)
     => ( ( K2 != suc(I1) )
       => ~ ! [J2: nat] :
              ( ord_less(nat,I1,J2)
             => ( K2 != suc(J2) ) ) ) ) ).

tff(fact_36_liftn__lift,axiom,
    ! [K2: nat,T: dB,N: nat] : ( liftn(suc(N),T,K2) = lift(liftn(N,T,K2),K2) ) ).

tff(fact_37_less__Suc__induct,axiom,
    ! [P: fun(nat,fun(nat,bool)),Ja: nat,Ia: nat] :
      ( ord_less(nat,Ia,Ja)
     => ( ! [I2: nat] : pp(aa(nat,bool,aa(nat,fun(nat,bool),P,I2),suc(I2)))
       => ( ! [I2: nat,J2: nat,K: nat] :
              ( ord_less(nat,I2,J2)
             => ( ord_less(nat,J2,K)
               => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),P,I2),J2))
                 => ( pp(aa(nat,bool,aa(nat,fun(nat,bool),P,J2),K))
                   => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,I2),K)) ) ) ) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,Ia),Ja)) ) ) ) ).

tff(fact_38_strict__inc__induct,axiom,
    ! [P: fun(nat,bool),Ja: nat,Ia: nat] :
      ( ord_less(nat,Ia,Ja)
     => ( ! [I2: nat] :
            ( ( Ja = suc(I2) )
           => pp(aa(nat,bool,P,I2)) )
       => ( ! [I2: nat] :
              ( ord_less(nat,I2,Ja)
             => ( pp(aa(nat,bool,P,suc(I2)))
               => pp(aa(nat,bool,P,I2)) ) )
         => pp(aa(nat,bool,P,Ia)) ) ) ) ).

tff(fact_39_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_40_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X1: A] :
          ( ( X1 != Y2 )
        <=> ( ord_less(A,X1,Y2)
            | ord_less(A,Y2,X1) ) ) ) ).

tff(fact_41_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ( ( X != Y )
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_42_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_43_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less(A,Y,Z)
           => ord_less(A,X,Z) ) ) ) ).

tff(fact_44_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ( B = C )
           => ord_less(A,A1,C) ) ) ) ).

tff(fact_45_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C: A,B: A,A1: A] :
          ( ( A1 = B )
         => ( ord_less(A,B,C)
           => ord_less(A,A1,C) ) ) ) ).

tff(fact_46_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ~ ord_less(A,B,A1) ) ) ).

tff(fact_47_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P: bool,Y2: A,X1: A] :
          ( ord_less(A,X1,Y2)
         => ( ord_less(A,Y2,X1)
           => pp(P) ) ) ) ).

tff(fact_48_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( Y != X ) ) ) ).

tff(fact_49_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_50_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_51_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_52_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_53_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_54_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y2: A] :
          ( ~ ord_less(A,Y2,X1)
         => ( ~ ord_less(A,X1,Y2)
          <=> ( X1 = Y2 ) ) ) ) ).

tff(fact_55_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

tff(fact_56_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y2: A,X1: A] :
          ( ~ ord_less(A,X1,Y2)
        <=> ( ord_less(A,Y2,X1)
            | ( X1 = Y2 ) ) ) ) ).

tff(fact_57_order__less__subst1,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( order(B2)
        & order(A) )
     => ! [C1: B2,B1: B2,F: fun(B2,A),A2: A] :
          ( ord_less(A,A2,aa(B2,A,F,B1))
         => ( ord_less(B2,B1,C1)
           => ( ! [X2: B2,Y1: B2] :
                  ( ord_less(B2,X2,Y1)
                 => ord_less(A,aa(B2,A,F,X2),aa(B2,A,F,Y1)) )
             => ord_less(A,A2,aa(B2,A,F,C1)) ) ) ) ) ).

tff(fact_58_ord__eq__less__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ord(B2)
        & ord(A) )
     => ! [C1: B2,B1: B2,F: fun(B2,A),A2: A] :
          ( ( A2 = aa(B2,A,F,B1) )
         => ( ord_less(B2,B1,C1)
           => ( ! [X2: B2,Y1: B2] :
                  ( ord_less(B2,X2,Y1)
                 => ord_less(A,aa(B2,A,F,X2),aa(B2,A,F,Y1)) )
             => ord_less(A,A2,aa(B2,A,F,C1)) ) ) ) ) ).

tff(fact_59_order__less__subst2,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( order(B2)
        & order(A) )
     => ! [C1: B2,F: fun(A,B2),B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ord_less(B2,aa(A,B2,F,B1),C1)
           => ( ! [X2: A,Y1: A] :
                  ( ord_less(A,X2,Y1)
                 => ord_less(B2,aa(A,B2,F,X2),aa(A,B2,F,Y1)) )
             => ord_less(B2,aa(A,B2,F,A2),C1) ) ) ) ) ).

tff(fact_60_ord__less__eq__subst,axiom,
    ! [A: $tType,B2: $tType] :
      ( ( ord(B2)
        & ord(A) )
     => ! [C1: B2,F: fun(A,B2),B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ( aa(A,B2,F,B1) = C1 )
           => ( ! [X2: A,Y1: A] :
                  ( ord_less(A,X2,Y1)
                 => ord_less(B2,aa(A,B2,F,X2),aa(A,B2,F,Y1)) )
             => ord_less(B2,aa(A,B2,F,A2),C1) ) ) ) ) ).

tff(fact_61_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ? [Z1: A] :
              ( ord_less(A,X,Z1)
              & ord_less(A,Z1,Y) ) ) ) ).

tff(fact_62_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X1: A] :
        ? [X11: A] : ord_less(A,X1,X11) ) ).

tff(fact_63_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [Y1: A] : ord_less(A,Y1,X) ) ).

tff(fact_64_liftn_Osimps_I1_J,axiom,
    ! [N: nat,K2: nat,I1: nat] :
      ( ( ord_less(nat,I1,K2)
       => ( liftn(N,var(I1),K2) = var(I1) ) )
      & ( ~ ord_less(nat,I1,K2)
       => ( liftn(N,var(I1),K2) = var(plus_plus(nat,I1,N)) ) ) ) ).

tff(fact_65_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K3: nat] :
      ( ( plus_plus(nat,K3,M1) = plus_plus(nat,K3,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_66_nat__add__right__cancel,axiom,
    ! [N1: nat,K3: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K3) = plus_plus(nat,N1,K3) )
    <=> ( M1 = N1 ) ) ).

tff(fact_67_add__Suc,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_68_add__Suc__right,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,suc(N)) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_69_nat__add__left__cancel__less,axiom,
    ! [N1: nat,M1: nat,K3: nat] :
      ( ord_less(nat,plus_plus(nat,K3,M1),plus_plus(nat,K3,N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_70_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_71_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_72_nat__add__assoc,axiom,
    ! [K2: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K2) = plus_plus(nat,M,plus_plus(nat,N,K2)) ) ).

tff(fact_73_not__add__less1,axiom,
    ! [J1: nat,I1: nat] : ~ ord_less(nat,plus_plus(nat,I1,J1),I1) ).

tff(fact_74_not__add__less2,axiom,
    ! [I1: nat,J1: nat] : ~ ord_less(nat,plus_plus(nat,J1,I1),I1) ).

tff(fact_75_trans__less__add1,axiom,
    ! [M: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ord_less(nat,I1,plus_plus(nat,J1,M)) ) ).

tff(fact_76_trans__less__add2,axiom,
    ! [M: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ord_less(nat,I1,plus_plus(nat,M,J1)) ) ).

tff(fact_77_add__less__mono1,axiom,
    ! [K2: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ord_less(nat,plus_plus(nat,I1,K2),plus_plus(nat,J1,K2)) ) ).

tff(fact_78_add__less__mono,axiom,
    ! [L: nat,K2: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ( ord_less(nat,K2,L)
       => ord_less(nat,plus_plus(nat,I1,K2),plus_plus(nat,J1,L)) ) ) ).

tff(fact_79_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K2: nat] :
      ( ord_less(nat,K2,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K2,N) )
       => ord_less(nat,M,N) ) ) ).

tff(fact_80_add__lessD1,axiom,
    ! [K2: nat,J1: nat,I1: nat] :
      ( ord_less(nat,plus_plus(nat,I1,J1),K2)
     => ord_less(nat,I1,K2) ) ).

tff(fact_81_add__Suc__shift,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = plus_plus(nat,M,suc(N)) ) ).

tff(fact_82_less__iff__Suc__add,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
    <=> ? [K1: nat] : ( N1 = suc(plus_plus(nat,M1,K1)) ) ) ).

tff(fact_83_less__add__Suc2,axiom,
    ! [M: nat,I1: nat] : ord_less(nat,I1,suc(plus_plus(nat,M,I1))) ).

tff(fact_84_less__add__Suc1,axiom,
    ! [M: nat,I1: nat] : ord_less(nat,I1,suc(plus_plus(nat,I1,M))) ).

tff(fact_85_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B1,C1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_86_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A2: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_87_less__imp__Suc__add,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ? [K: nat] : ( N = suc(plus_plus(nat,M,K)) ) ) ).

tff(fact_88_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_89_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ( plus_plus(A,B1,A2) = plus_plus(A,C1,A2) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_90_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_91_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_92_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_93_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_94_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C)) ) ) ).

tff(fact_95_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B)) ) ) ).

tff(fact_96_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C,D)
           => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ) ).

tff(fact_97_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
         => ord_less(A,A1,B) ) ) ).

tff(fact_98_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
         => ord_less(A,A1,B) ) ) ).

%----Arities (14)
tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    it(ra) ).

tff(conj_1,hypothesis,
    ! [I: nat,J: nat] : it(subst(ra,var(I),J)) ).

tff(conj_2,conjecture,
    it(subst(ra,var(suc(ia)),suc(ja))) ).

%------------------------------------------------------------------------------
