%------------------------------------------------------------------------------
% File     : LCL755_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 53
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_53 [Bla13]

% Status   : Theorem
% Rating   : 0.00 v6.4.0
% Syntax   : Number of formulae    :  151 (  47 unt;  38 typ;   0 def)
%            Number of atoms       :  226 (  80 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  141 (  28   ~;   2   |;   2   &)
%                                         (  18 <=>;  91  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   10 (   5 avg)
%            Maximal term depth    :    5 (   1 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   41 (  18   >;  23   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-3 aty)
%            Number of functors    :   22 (  22 usr;   5 con; 0-5 aty)
%            Number of variables   :  306 ( 283   !;   2   ?; 306   :)
%                                         (  21  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:15
%------------------------------------------------------------------------------
%----Should-be-implicit typings (4)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (34)
tff(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__cancel__ab__semigroup__add,type,
    ordere223160158up_add: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,fun(T1,fun(T1,T1)))) * fun(dB,fun(T1,T1)) * dB ) > T1 ) ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Nat_Onat_Onat__case,type,
    nat_case: 
      !>[T1: $tType] : ( ( T1 * fun(nat,T1) * nat ) > T1 ) ).

tff(sy_c_Nat_Onat_Onat__rec,type,
    nat_rec: 
      !>[T1: $tType] : ( ( T1 * fun(nat,fun(T1,T1)) * nat ) > T1 ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat__aux,type,
    semiri532925092at_aux: 
      !>[A: $tType] : ( ( fun(A,A) * nat * A ) > A ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_ja,type,
    ja: nat ).

tff(sy_v_ra,type,
    ra: dB ).

%----Relevant facts (98)
tff(fact_0_Lambda,axiom,
    ! [R: dB] :
      ( it(R)
     => it(abs(R)) ) ).

tff(fact_1_dB_Osimps_I3_J,axiom,
    ! [DB2: dB,DB: dB] :
      ( ( abs(DB) = abs(DB2) )
    <=> ( DB = DB2 ) ) ).

tff(fact_2_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat2) )
    <=> ( Nat = Nat2 ) ) ).

tff(fact_3_nat_Oinject,axiom,
    ! [Nat2: nat,Nat: nat] :
      ( ( suc(Nat) = suc(Nat2) )
    <=> ( Nat = Nat2 ) ) ).

tff(fact_4_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_5_dB_Osimps_I7_J,axiom,
    ! [Nat1: nat,DB1: dB] : ( abs(DB1) != var(Nat1) ) ).

tff(fact_6_dB_Osimps_I6_J,axiom,
    ! [DB1: dB,Nat1: nat] : ( var(Nat1) != abs(DB1) ) ).

tff(fact_7_n__not__Suc__n,axiom,
    ! [N: nat] : ( N != suc(N) ) ).

tff(fact_8_Suc__n__not__n,axiom,
    ! [N: nat] : ( suc(N) != N ) ).

tff(fact_9_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_10_lift__IT,axiom,
    ! [I1: nat,T: dB] :
      ( it(T)
     => it(lift(T,I1)) ) ).

tff(fact_11_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( subst(lift(T,K),S,K) = T ) ).

tff(fact_12_liftn__lift,axiom,
    ! [K: nat,T: dB,N: nat] : ( liftn(suc(N),T,K) = lift(liftn(N,T,K),K) ) ).

tff(fact_13_of__nat__aux_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [Ia: A,N1: nat,Inc: fun(A,A)] : ( semiri532925092at_aux(A,Inc,suc(N1),Ia) = semiri532925092at_aux(A,Inc,N1,aa(A,A,Inc,Ia)) ) ) ).

tff(fact_14_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_15_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_16_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB)) = aa(A,A,aa(dB,fun(A,A),F3,DB),dB_rec(A,F1,F2,F3,DB)) ) ).

tff(fact_17_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_18_nat__case__Suc,axiom,
    ! [A: $tType,Nat: nat,F2: fun(nat,A),F1: A] : ( nat_case(A,F1,F2,suc(Nat)) = aa(nat,A,F2,Nat) ) ).

tff(fact_19_subst__lt,axiom,
    ! [U: dB,I1: nat,J1: nat] :
      ( ord_less(nat,J1,I1)
     => ( subst(var(J1),U,I1) = var(J1) ) ) ).

tff(fact_20_nat__rec__Suc,axiom,
    ! [A: $tType,Nat: nat,F2: fun(nat,fun(A,A)),F1: A] : ( nat_rec(A,F1,F2,suc(Nat)) = aa(A,A,aa(nat,fun(A,A),F2,Nat),nat_rec(A,F1,F2,Nat)) ) ).

tff(fact_21_lessI,axiom,
    ! [N: nat] : ord_less(nat,N,suc(N)) ).

tff(fact_22_not__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ~ ord_less(nat,M1,N1)
    <=> ord_less(nat,N1,suc(M1)) ) ).

tff(fact_23_Suc__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,suc(M1),suc(N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_24_Suc__mono,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less(nat,suc(M),suc(N)) ) ).

tff(fact_25_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_26_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_27_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_28_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_29_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_30_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_31_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) ) ) ) ).

tff(fact_32_less__Suc__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,suc(N1))
    <=> ( ord_less(nat,M1,N1)
        | ( M1 = N1 ) ) ) ).

tff(fact_33_not__less__less__Suc__eq,axiom,
    ! [M1: nat,N1: nat] :
      ( ~ ord_less(nat,N1,M1)
     => ( ord_less(nat,N1,suc(M1))
      <=> ( N1 = M1 ) ) ) ).

tff(fact_34_less__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ~ ord_less(nat,N,M)
     => ( ord_less(nat,N,suc(M))
       => ( M = N ) ) ) ).

tff(fact_35_less__SucI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ord_less(nat,M,suc(N)) ) ).

tff(fact_36_Suc__lessI,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( ( suc(M) != N )
       => ord_less(nat,suc(M),N) ) ) ).

tff(fact_37_less__trans__Suc,axiom,
    ! [K: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ( ord_less(nat,J1,K)
       => ord_less(nat,suc(I1),K) ) ) ).

tff(fact_38_less__SucE,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,suc(N))
     => ( ~ ord_less(nat,M,N)
       => ( M = N ) ) ) ).

tff(fact_39_Suc__lessD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,suc(M),N)
     => ord_less(nat,M,N) ) ).

tff(fact_40_Suc__less__SucD,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,suc(M),suc(N))
     => ord_less(nat,M,N) ) ).

tff(fact_41_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [M1: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N2: nat] : ord_less(A,aa(nat,A,F,N2),aa(nat,A,F,suc(N2)))
         => ( ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,M1))
          <=> ord_less(nat,N1,M1) ) ) ) ).

tff(fact_42_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [N3: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N2: nat] : ord_less(A,aa(nat,A,F,N2),aa(nat,A,F,suc(N2)))
         => ( ord_less(nat,N1,N3)
           => ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,N3)) ) ) ) ).

tff(fact_43_def__nat__rec__Suc,axiom,
    ! [A: $tType,N1: nat,H: fun(nat,fun(A,A)),C1: A,F: fun(nat,A)] :
      ( ! [N2: nat] : ( aa(nat,A,F,N2) = nat_rec(A,C1,H,N2) )
     => ( aa(nat,A,F,suc(N1)) = aa(A,A,aa(nat,fun(A,A),H,N1),aa(nat,A,F,N1)) ) ) ).

tff(fact_44_lessE,axiom,
    ! [K: nat,I1: nat] :
      ( ord_less(nat,I1,K)
     => ( ( K != suc(I1) )
       => ~ ! [J2: nat] :
              ( ord_less(nat,I1,J2)
             => ( K != suc(J2) ) ) ) ) ).

tff(fact_45_Suc__lessE,axiom,
    ! [K: nat,I1: nat] :
      ( ord_less(nat,suc(I1),K)
     => ~ ! [J2: nat] :
            ( ord_less(nat,I1,J2)
           => ( K != suc(J2) ) ) ) ).

tff(fact_46_liftn_Osimps_I1_J,axiom,
    ! [N: nat,K: nat,I1: nat] :
      ( ( ord_less(nat,I1,K)
       => ( liftn(N,var(I1),K) = var(I1) ) )
      & ( ~ ord_less(nat,I1,K)
       => ( liftn(N,var(I1),K) = var(plus_plus(nat,I1,N)) ) ) ) ).

tff(fact_47_strict__inc__induct,axiom,
    ! [P: fun(nat,bool),Ja: nat,Ia: nat] :
      ( ord_less(nat,Ia,Ja)
     => ( ! [I2: nat] :
            ( ( Ja = suc(I2) )
           => pp(aa(nat,bool,P,I2)) )
       => ( ! [I2: nat] :
              ( ord_less(nat,I2,Ja)
             => ( pp(aa(nat,bool,P,suc(I2)))
               => pp(aa(nat,bool,P,I2)) ) )
         => pp(aa(nat,bool,P,Ia)) ) ) ) ).

tff(fact_48_nat__add__right__cancel,axiom,
    ! [N1: nat,K3: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K3) = plus_plus(nat,N1,K3) )
    <=> ( M1 = N1 ) ) ).

tff(fact_49_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K3: nat] :
      ( ( plus_plus(nat,K3,M1) = plus_plus(nat,K3,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_50_add__Suc,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_51_add__Suc__right,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,suc(N)) = suc(plus_plus(nat,M,N)) ) ).

tff(fact_52_nat__add__left__cancel__less,axiom,
    ! [N1: nat,M1: nat,K3: nat] :
      ( ord_less(nat,plus_plus(nat,K3,M1),plus_plus(nat,K3,N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_53_nat__add__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( plus_plus(nat,plus_plus(nat,M,N),K) = plus_plus(nat,M,plus_plus(nat,N,K)) ) ).

tff(fact_54_nat__add__left__commute,axiom,
    ! [Z: nat,Y: nat,X: nat] : ( plus_plus(nat,X,plus_plus(nat,Y,Z)) = plus_plus(nat,Y,plus_plus(nat,X,Z)) ) ).

tff(fact_55_nat__add__commute,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,M,N) = plus_plus(nat,N,M) ) ).

tff(fact_56_add__Suc__shift,axiom,
    ! [N: nat,M: nat] : ( plus_plus(nat,suc(M),N) = plus_plus(nat,M,suc(N)) ) ).

tff(fact_57_add__lessD1,axiom,
    ! [K: nat,J1: nat,I1: nat] :
      ( ord_less(nat,plus_plus(nat,I1,J1),K)
     => ord_less(nat,I1,K) ) ).

tff(fact_58_less__add__eq__less,axiom,
    ! [N: nat,M: nat,L: nat,K: nat] :
      ( ord_less(nat,K,L)
     => ( ( plus_plus(nat,M,L) = plus_plus(nat,K,N) )
       => ord_less(nat,M,N) ) ) ).

tff(fact_59_add__less__mono,axiom,
    ! [L: nat,K: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ( ord_less(nat,K,L)
       => ord_less(nat,plus_plus(nat,I1,K),plus_plus(nat,J1,L)) ) ) ).

tff(fact_60_add__less__mono1,axiom,
    ! [K: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ord_less(nat,plus_plus(nat,I1,K),plus_plus(nat,J1,K)) ) ).

tff(fact_61_trans__less__add2,axiom,
    ! [M: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ord_less(nat,I1,plus_plus(nat,M,J1)) ) ).

tff(fact_62_trans__less__add1,axiom,
    ! [M: nat,J1: nat,I1: nat] :
      ( ord_less(nat,I1,J1)
     => ord_less(nat,I1,plus_plus(nat,J1,M)) ) ).

tff(fact_63_not__add__less2,axiom,
    ! [I1: nat,J1: nat] : ~ ord_less(nat,plus_plus(nat,J1,I1),I1) ).

tff(fact_64_not__add__less1,axiom,
    ! [J1: nat,I1: nat] : ~ ord_less(nat,plus_plus(nat,I1,J1),I1) ).

tff(fact_65_less__iff__Suc__add,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,N1)
    <=> ? [K2: nat] : ( N1 = suc(plus_plus(nat,M1,K2)) ) ) ).

tff(fact_66_less__add__Suc2,axiom,
    ! [M: nat,I1: nat] : ord_less(nat,I1,suc(plus_plus(nat,M,I1))) ).

tff(fact_67_less__add__Suc1,axiom,
    ! [M: nat,I1: nat] : ord_less(nat,I1,suc(plus_plus(nat,I1,M))) ).

tff(fact_68_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A2: A,C1: A] :
          ( ord_less(A,plus_plus(A,C1,A2),plus_plus(A,C1,B1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_69_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C1: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C1),plus_plus(A,B1,C1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_70_less__imp__Suc__add,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ? [K1: nat] : ( N = suc(plus_plus(nat,M,K1)) ) ) ).

tff(fact_71_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C1) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_72_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A2: A,B1: A] :
          ( ( plus_plus(A,B1,A2) = plus_plus(A,C1,A2) )
        <=> ( B1 = C1 ) ) ) ).

tff(fact_73_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A1: A,B: A] :
          ( ( plus_plus(A,B,A1) = plus_plus(A,C,A1) )
         => ( B = C ) ) ) ).

tff(fact_74_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_75_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ( plus_plus(A,A1,B) = plus_plus(A,A1,C) )
         => ( B = C ) ) ) ).

tff(fact_76_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C: A,B: A,A1: A] : ( plus_plus(A,plus_plus(A,A1,B),C) = plus_plus(A,A1,plus_plus(A,B,C)) ) ) ).

tff(fact_77_add__strict__right__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C)) ) ) ).

tff(fact_78_add__strict__left__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B)) ) ) ).

tff(fact_79_add__strict__mono,axiom,
    ! [A: $tType] :
      ( ordere223160158up_add(A)
     => ! [D: A,C: A,B: A,A1: A] :
          ( ord_less(A,A1,B)
         => ( ord_less(A,C,D)
           => ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,D)) ) ) ) ).

tff(fact_80_add__less__imp__less__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,C: A,A1: A] :
          ( ord_less(A,plus_plus(A,A1,C),plus_plus(A,B,C))
         => ord_less(A,A1,B) ) ) ).

tff(fact_81_add__less__imp__less__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B: A,A1: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A1),plus_plus(A,C,B))
         => ord_less(A,A1,B) ) ) ).

tff(fact_82_termination__basic__simps_I1_J,axiom,
    ! [Z: nat,Y: nat,X: nat] :
      ( ord_less(nat,X,Y)
     => ord_less(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_83_termination__basic__simps_I2_J,axiom,
    ! [Y: nat,Z: nat,X: nat] :
      ( ord_less(nat,X,Z)
     => ord_less(nat,X,plus_plus(nat,Y,Z)) ) ).

tff(fact_84_subst__subst,axiom,
    ! [U: dB,V: dB,T: dB,J1: nat,I1: nat] :
      ( ord_less(nat,I1,plus_plus(nat,J1,one_one(nat)))
     => ( subst(subst(T,lift(V,I1),suc(J1)),subst(U,V,J1),I1) = subst(subst(T,U,I1),V,J1) ) ) ).

tff(fact_85_lift_Osimps_I1_J,axiom,
    ! [K: nat,I1: nat] :
      ( ( ord_less(nat,I1,K)
       => ( lift(var(I1),K) = var(I1) ) )
      & ( ~ ord_less(nat,I1,K)
       => ( lift(var(I1),K) = var(plus_plus(nat,I1,one_one(nat))) ) ) ) ).

tff(fact_86_lift_Osimps_I3_J,axiom,
    ! [K: nat,S: dB] : ( lift(abs(S),K) = abs(lift(S,plus_plus(nat,K,one_one(nat)))) ) ).

tff(fact_87_liftn_Osimps_I3_J,axiom,
    ! [K: nat,S: dB,N: nat] : ( liftn(N,abs(S),K) = abs(liftn(N,S,plus_plus(nat,K,one_one(nat)))) ) ).

tff(fact_88_Suc__eq__plus1,axiom,
    ! [N: nat] : ( suc(N) = plus_plus(nat,N,one_one(nat)) ) ).

tff(fact_89_Suc__eq__plus1__left,axiom,
    ! [N: nat] : ( suc(N) = plus_plus(nat,one_one(nat),N) ) ).

tff(fact_90_one__reorient,axiom,
    ! [A: $tType] :
      ( one(A)
     => ! [X1: A] :
          ( ( one_one(A) = X1 )
        <=> ( X1 = one_one(A) ) ) ) ).

tff(fact_91_lift__lift,axiom,
    ! [T: dB,K: nat,I1: nat] :
      ( ord_less(nat,I1,plus_plus(nat,K,one_one(nat)))
     => ( lift(lift(T,I1),suc(K)) = lift(lift(T,K),I1) ) ) ).

tff(fact_92_lift__subst,axiom,
    ! [S: dB,T: dB,I1: nat,J1: nat] :
      ( ord_less(nat,J1,plus_plus(nat,I1,one_one(nat)))
     => ( lift(subst(T,S,J1),I1) = subst(lift(T,plus_plus(nat,I1,one_one(nat))),lift(S,I1),J1) ) ) ).

tff(fact_93_lift__subst__lt,axiom,
    ! [S: dB,T: dB,J1: nat,I1: nat] :
      ( ord_less(nat,I1,plus_plus(nat,J1,one_one(nat)))
     => ( lift(subst(T,S,J1),I1) = subst(lift(T,I1),lift(S,I1),plus_plus(nat,J1,one_one(nat))) ) ) ).

tff(fact_94_less__add__one,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [A1: A] : ord_less(A,A1,plus_plus(A,A1,one_one(A))) ) ).

tff(fact_95_substn_Osimps_I3_J,axiom,
    ! [K: nat,S: dB,T: dB] : ( substn(abs(T),S,K) = abs(substn(T,S,plus_plus(nat,K,one_one(nat)))) ) ).

tff(fact_96_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_97_subst__Abs,axiom,
    ! [K: nat,S: dB,T: dB] : ( subst(abs(T),S,K) = abs(subst(T,lift(S,zero_zero(nat)),plus_plus(nat,K,one_one(nat)))) ) ).

%----Arities (10)
tff(arity_Nat_Onat___Groups_Oordered__cancel__ab__semigroup__add,axiom,
    ordere223160158up_add(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Groups_Oone,axiom,
    one(nat) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    it(ra) ).

tff(conj_1,hypothesis,
    ! [I: nat,J: nat] : it(subst(ra,var(I),J)) ).

tff(conj_2,conjecture,
    it(abs(subst(ra,var(suc(ia)),suc(ja)))) ).

%------------------------------------------------------------------------------
