%------------------------------------------------------------------------------
% File     : LCL754_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 52
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_52 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  177 (  57 unt;  43 typ;   0 def)
%            Number of atoms       :  305 (  73 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  211 (  40   ~;   6   |;  15   &)
%                                         (  30 <=>; 120  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   5 avg)
%            Maximal term depth    :    4 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   33 (  18   >;  15   *;   0   +;   0  <<)
%            Number of predicates  :   21 (  20 usr;   0 prp; 1-4 aty)
%            Number of functors    :   19 (  19 usr;   5 con; 0-5 aty)
%            Number of variables   :  311 ( 278   !;   4   ?; 311   :)
%                                         (  29  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:13
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Int_Oint,type,
    int: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Int_Onumber,type,
    number: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__ring,type,
    number_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Int_Onumber__semiring,type,
    number_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Odense__linorder,type,
    dense_linorder: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_If,type,
    if: 
      !>[A: $tType] : ( ( bool * A * A ) > A ) ).

tff(sy_c_InductTermi_OIT,type,
    it: dB > $o ).

tff(sy_c_Int_Onat,type,
    nat1: int > nat ).

tff(sy_c_Int_Onumber__class_Onumber__of,type,
    number_number_of: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Int_Oring__1__class_Oof__int,type,
    ring_1_of_int: 
      !>[A: $tType] : ( int > A ) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,T1)) * fun(dB,T1) * dB ) > T1 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T1: $tType] : ( ( fun(nat,T1) * fun(dB,fun(dB,fun(T1,fun(T1,T1)))) * fun(dB,fun(T1,T1)) * dB ) > T1 ) ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat__Transfer_Otransfer__morphism,type,
    nat_tr1645093318rphism: 
      !>[B: $tType,A: $tType] : ( ( fun(B,A) * fun(B,bool) ) > $o ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Orderings_Oorder__class_Ostrict__mono,type,
    order_strict_mono: 
      !>[A: $tType,B: $tType] : ( fun(A,B) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_ja,type,
    ja: nat ).

tff(sy_v_ra,type,
    ra: dB ).

%----Relevant facts (98)
tff(fact_0_Lambda,axiom,
    ! [R: dB] :
      ( it(R)
     => it(abs(R)) ) ).

tff(fact_1_dB_Osimps_I3_J,axiom,
    ! [DB2: dB,DB: dB] :
      ( ( abs(DB) = abs(DB2) )
    <=> ( DB = DB2 ) ) ).

tff(fact_2_dB_Osimps_I1_J,axiom,
    ! [Nat2: nat,Nat: nat] :
      ( ( var(Nat) = var(Nat2) )
    <=> ( Nat = Nat2 ) ) ).

tff(fact_3_subst__eq,axiom,
    ! [U: dB,K: nat] : ( subst(var(K),U,K) = U ) ).

tff(fact_4_dB_Osimps_I7_J,axiom,
    ! [Nat1: nat,DB1: dB] : ( abs(DB1) != var(Nat1) ) ).

tff(fact_5_dB_Osimps_I6_J,axiom,
    ! [DB1: dB,Nat1: nat] : ( var(Nat1) != abs(DB1) ) ).

tff(fact_6_lift__IT,axiom,
    ! [I1: nat,T: dB] :
      ( it(T)
     => it(lift(T,I1)) ) ).

tff(fact_7_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB)) = aa(dB,A,F3,DB) ) ).

tff(fact_8_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_9_subst__lt,axiom,
    ! [U: dB,I1: nat,J1: nat] :
      ( ord_less(nat,J1,I1)
     => ( subst(var(J1),U,I1) = var(J1) ) ) ).

tff(fact_10_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat)) = aa(nat,A,F1,Nat) ) ).

tff(fact_11_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB)) = aa(A,A,aa(dB,fun(A,A),F3,DB),dB_rec(A,F1,F2,F3,DB)) ) ).

tff(fact_12_subst__lift,axiom,
    ! [S: dB,K: nat,T: dB] : ( subst(lift(T,K),S,K) = T ) ).

tff(fact_13_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_14_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_15_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_16_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_17_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_18_less__not__refl3,axiom,
    ! [T: nat,S: nat] :
      ( ord_less(nat,S,T)
     => ( S != T ) ) ).

tff(fact_19_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) ) ) ) ).

tff(fact_20_order__less__irrefl,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [X: A] : ~ ord_less(A,X,X) ) ).

tff(fact_21_linorder__neq__iff,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ( X1 != Y1 )
        <=> ( ord_less(A,X1,Y1)
            | ord_less(A,Y1,X1) ) ) ) ).

tff(fact_22_linorder__cases,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ~ ord_less(A,X,Y)
         => ( ( X != Y )
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_23_order__less__asym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_24_order__less__trans,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Z2: A,Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( ord_less(A,Y,Z2)
           => ord_less(A,X,Z2) ) ) ) ).

tff(fact_25_ord__less__eq__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A3: A] :
          ( ord_less(A,A3,B2)
         => ( ( B2 = C1 )
           => ord_less(A,A3,C1) ) ) ) ).

tff(fact_26_ord__eq__less__trans,axiom,
    ! [A: $tType] :
      ( ord(A)
     => ! [C1: A,B2: A,A3: A] :
          ( ( A3 = B2 )
         => ( ord_less(A,B2,C1)
           => ord_less(A,A3,C1) ) ) ) ).

tff(fact_27_order__less__asym_H,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [B2: A,A3: A] :
          ( ord_less(A,A3,B2)
         => ~ ord_less(A,B2,A3) ) ) ).

tff(fact_28_order__less__imp__triv,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [P1: bool,Y1: A,X1: A] :
          ( ord_less(A,X1,Y1)
         => ( ord_less(A,Y1,X1)
           => pp(P1) ) ) ) ).

tff(fact_29_order__less__imp__not__eq2,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( Y != X ) ) ) ).

tff(fact_30_order__less__imp__not__eq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_31_order__less__imp__not__less,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_32_order__less__not__sym,axiom,
    ! [A: $tType] :
      ( preorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ~ ord_less(A,Y,X) ) ) ).

tff(fact_33_less__imp__neq,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ( X != Y ) ) ) ).

tff(fact_34_linorder__neqE,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_35_linorder__antisym__conv3,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [X1: A,Y1: A] :
          ( ~ ord_less(A,Y1,X1)
         => ( ~ ord_less(A,X1,Y1)
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_36_linorder__less__linear,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
          | ( X = Y )
          | ord_less(A,Y,X) ) ) ).

tff(fact_37_not__less__iff__gr__or__eq,axiom,
    ! [A: $tType] :
      ( linorder(A)
     => ! [Y1: A,X1: A] :
          ( ~ ord_less(A,X1,Y1)
        <=> ( ord_less(A,Y1,X1)
            | ( X1 = Y1 ) ) ) ) ).

tff(fact_38_order__less__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,B1: B,F: fun(B,A),A2: A] :
          ( ord_less(A,A2,aa(B,A,F,B1))
         => ( ord_less(B,B1,C)
           => ( ! [X2: B,Y3: B] :
                  ( ord_less(B,X2,Y3)
                 => ord_less(A,aa(B,A,F,X2),aa(B,A,F,Y3)) )
             => ord_less(A,A2,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_39_ord__eq__less__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,B1: B,F: fun(B,A),A2: A] :
          ( ( A2 = aa(B,A,F,B1) )
         => ( ord_less(B,B1,C)
           => ( ! [X2: B,Y3: B] :
                  ( ord_less(B,X2,Y3)
                 => ord_less(A,aa(B,A,F,X2),aa(B,A,F,Y3)) )
             => ord_less(A,A2,aa(B,A,F,C)) ) ) ) ) ).

tff(fact_40_order__less__subst2,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order(B)
        & order(A) )
     => ! [C: B,F: fun(A,B),B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ord_less(B,aa(A,B,F,B1),C)
           => ( ! [X2: A,Y3: A] :
                  ( ord_less(A,X2,Y3)
                 => ord_less(B,aa(A,B,F,X2),aa(A,B,F,Y3)) )
             => ord_less(B,aa(A,B,F,A2),C) ) ) ) ) ).

tff(fact_41_ord__less__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ord(B)
        & ord(A) )
     => ! [C: B,F: fun(A,B),B1: A,A2: A] :
          ( ord_less(A,A2,B1)
         => ( ( aa(A,B,F,B1) = C )
           => ( ! [X2: A,Y3: A] :
                  ( ord_less(A,X2,Y3)
                 => ord_less(B,aa(A,B,F,X2),aa(A,B,F,Y3)) )
             => ord_less(B,aa(A,B,F,A2),C) ) ) ) ) ).

tff(fact_42_dense,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [Y: A,X: A] :
          ( ord_less(A,X,Y)
         => ? [Z1: A] :
              ( ord_less(A,X,Z1)
              & ord_less(A,Z1,Y) ) ) ) ).

tff(fact_43_lt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X: A] :
        ? [Y3: A] : ord_less(A,Y3,X) ) ).

tff(fact_44_gt__ex,axiom,
    ! [A: $tType] :
      ( dense_linorder(A)
     => ! [X1: A] :
        ? [X11: A] : ord_less(A,X1,X11) ) ).

tff(fact_45_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Y: A,X: A] :
          ( ( X != Y )
         => ( ~ ord_less(A,X,Y)
           => ord_less(A,Y,X) ) ) ) ).

tff(fact_46_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,M1,N1) ) ) ).

tff(fact_47_strict__mono__less,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder(A)
        & order(B) )
     => ! [Y1: A,X1: A,F: fun(A,B)] :
          ( order_strict_mono(A,B,F)
         => ( ord_less(B,aa(A,B,F,X1),aa(A,B,F,Y1))
          <=> ord_less(A,X1,Y1) ) ) ) ).

tff(fact_48_strict__monoD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( order(A)
        & order(B) )
     => ! [Y1: A,X1: A,F: fun(A,B)] :
          ( order_strict_mono(A,B,F)
         => ( ord_less(A,X1,Y1)
           => ord_less(B,aa(A,B,F,X1),aa(A,B,F,Y1)) ) ) ) ).

tff(fact_49_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N1: nat,M1: nat] :
          ( ( semiring_1_of_nat(A,M1) = semiring_1_of_nat(A,N1) )
        <=> ( M1 = N1 ) ) ) ).

tff(fact_50_strict__mono__eq,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder(A)
        & order(B) )
     => ! [Y1: A,X1: A,F: fun(A,B)] :
          ( order_strict_mono(A,B,F)
         => ( ( aa(A,B,F,X1) = aa(A,B,F,Y1) )
          <=> ( X1 = Y1 ) ) ) ) ).

tff(fact_51_of__nat__less__imp__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N))
         => ord_less(nat,M,N) ) ) ).

tff(fact_52_less__imp__of__nat__less,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N: nat,M: nat] :
          ( ord_less(nat,M,N)
         => ord_less(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N)) ) ) ).

tff(fact_53_strict__monoI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( order(A)
        & order(B) )
     => ! [F: fun(A,B)] :
          ( ! [X2: A,Y3: A] :
              ( ord_less(A,X2,Y3)
             => ord_less(B,aa(A,B,F,X2),aa(A,B,F,Y3)) )
         => order_strict_mono(A,B,F) ) ) ).

tff(fact_54_transfer__int__nat__relations_I2_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,X1),semiring_1_of_nat(int,Y1))
    <=> ord_less(nat,X1,Y1) ) ).

tff(fact_55_zless__int,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(int,semiring_1_of_nat(int,M1),semiring_1_of_nat(int,N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_56_infinite__descent__measure,axiom,
    ! [A: $tType,X1: A,V1: fun(A,nat),P1: fun(A,bool)] :
      ( ! [X2: A] :
          ( ~ pp(aa(A,bool,P1,X2))
         => ? [Y2: A] :
              ( ord_less(nat,aa(A,nat,V1,Y2),aa(A,nat,V1,X2))
              & ~ pp(aa(A,bool,P1,Y2)) ) )
     => pp(aa(A,bool,P1,X1)) ) ).

tff(fact_57_int__if__cong,axiom,
    ! [Y1: nat,X1: nat,P1: bool] :
      ( ( pp(P1)
       => ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( semiring_1_of_nat(int,Y1) = semiring_1_of_nat(int,if(nat,P1,X1,Y1)) ) ) ) ).

tff(fact_58_transfer__int__nat__relations_I1_J,axiom,
    ! [Y1: nat,X1: nat] :
      ( ( semiring_1_of_nat(int,X1) = semiring_1_of_nat(int,Y1) )
    <=> ( X1 = Y1 ) ) ).

tff(fact_59_int__int__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ( semiring_1_of_nat(int,M1) = semiring_1_of_nat(int,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_60_transfer__morphismI,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),F: fun(A,B)] : nat_tr1645093318rphism(A,B,F,A1) ).

tff(fact_61_of__int__of__nat__eq,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ! [N: nat] : ( ring_1_of_int(A,semiring_1_of_nat(int,N)) = semiring_1_of_nat(A,N) ) ) ).

tff(fact_62_zless__nat__eq__int__zless,axiom,
    ! [Z: int,M1: nat] :
      ( ord_less(nat,M1,nat1(Z))
    <=> ord_less(int,semiring_1_of_nat(int,M1),Z) ) ).

tff(fact_63_of__int__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int,W1: int] :
          ( ( ring_1_of_int(A,W1) = ring_1_of_int(A,Z) )
        <=> ( W1 = Z ) ) ) ).

tff(fact_64_of__int__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int,W1: int] :
          ( ord_less(A,ring_1_of_int(A,W1),ring_1_of_int(A,Z))
        <=> ord_less(int,W1,Z) ) ) ).

tff(fact_65_of__int__int__eq,axiom,
    ! [N: nat] : ( ring_1_of_int(int,semiring_1_of_nat(int,N)) = semiring_1_of_nat(int,N) ) ).

tff(fact_66_nat__int,axiom,
    ! [N: nat] : ( nat1(semiring_1_of_nat(int,N)) = N ) ).

tff(fact_67_transfer__morphism__def,axiom,
    ! [B: $tType,A: $tType,A1: fun(A,bool),F: fun(A,B)] : nat_tr1645093318rphism(A,B,F,A1) ).

tff(fact_68_nat__if__cong,axiom,
    ! [Y1: int,X1: int,P1: bool] :
      ( ( pp(P1)
       => ( nat1(X1) = nat1(if(int,P1,X1,Y1)) ) )
      & ( ~ pp(P1)
       => ( nat1(Y1) = nat1(if(int,P1,X1,Y1)) ) ) ) ).

tff(fact_69_zless__nat__conj,axiom,
    ! [Z: int,W1: int] :
      ( ord_less(nat,nat1(W1),nat1(Z))
    <=> ( ord_less(int,zero_zero(int),Z)
        & ord_less(int,W1,Z) ) ) ).

tff(fact_70_nat__mono__iff,axiom,
    ! [W1: int,Z: int] :
      ( ord_less(int,zero_zero(int),Z)
     => ( ord_less(nat,nat1(W1),nat1(Z))
      <=> ord_less(int,W1,Z) ) ) ).

tff(fact_71_less__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & linordered_idom(A) )
     => ! [Y1: int,X1: int] :
          ( ord_less(A,number_number_of(A,X1),number_number_of(A,Y1))
        <=> ord_less(int,X1,Y1) ) ) ).

tff(fact_72_eq__number__of,axiom,
    ! [A: $tType] :
      ( ( number_ring(A)
        & ring_char_0(A) )
     => ! [Y1: int,X1: int] :
          ( ( number_number_of(A,X1) = number_number_of(A,Y1) )
        <=> ( X1 = Y1 ) ) ) ).

tff(fact_73_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_74_of__int__number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [V: int] : ( ring_1_of_int(A,number_number_of(int,V)) = number_number_of(A,V) ) ) ).

tff(fact_75_of__int__0,axiom,
    ! [A: $tType] :
      ( ring_1(A)
     => ( ring_1_of_int(A,zero_zero(int)) = zero_zero(A) ) ) ).

tff(fact_76_of__int__0__eq__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( zero_zero(A) = ring_1_of_int(A,Z) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_77_of__int__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_char_0(A)
     => ! [Z: int] :
          ( ( ring_1_of_int(A,Z) = zero_zero(A) )
        <=> ( Z = zero_zero(int) ) ) ) ).

tff(fact_78_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,zero_zero(nat),N1) ) ) ).

tff(fact_79_of__int__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,zero_zero(A),ring_1_of_int(A,Z))
        <=> ord_less(int,zero_zero(int),Z) ) ) ).

tff(fact_80_of__int__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_idom(A)
     => ! [Z: int] :
          ( ord_less(A,ring_1_of_int(A,Z),zero_zero(A))
        <=> ord_less(int,Z,zero_zero(int)) ) ) ).

tff(fact_81_number__of__eq,axiom,
    ! [A: $tType] :
      ( number_ring(A)
     => ! [K: int] : ( number_number_of(A,K) = ring_1_of_int(A,K) ) ) ).

tff(fact_82_int__number__of__def,axiom,
    ! [W: int] : ( number_number_of(int,W) = ring_1_of_int(int,W) ) ).

tff(fact_83_number__of__reorient,axiom,
    ! [A: $tType] :
      ( number(A)
     => ! [X1: A,W1: int] :
          ( ( number_number_of(A,W1) = X1 )
        <=> ( X1 = number_number_of(A,W1) ) ) ) ).

tff(fact_84_less__number__of__int__code,axiom,
    ! [L: int,K1: int] :
      ( ord_less(int,number_number_of(int,K1),number_number_of(int,L))
    <=> ord_less(int,K1,L) ) ).

tff(fact_85_number__of__int,axiom,
    ! [A: $tType] :
      ( number_semiring(A)
     => ! [N: nat] : ( number_number_of(A,semiring_1_of_nat(int,N)) = semiring_1_of_nat(A,N) ) ) ).

tff(fact_86_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ ord_less(A,semiring_1_of_nat(A,M),zero_zero(A)) ) ).

tff(fact_87_int__less__0__conv,axiom,
    ! [K: nat] : ~ ord_less(int,semiring_1_of_nat(int,K),zero_zero(int)) ).

tff(fact_88_nat__number__of,axiom,
    ! [W: int] : ( nat1(number_number_of(int,W)) = number_number_of(nat,W) ) ).

tff(fact_89_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_90_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_91_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_92_nat__0,axiom,
    nat1(zero_zero(int)) = zero_zero(nat) ).

tff(fact_93_zero__less__nat__eq,axiom,
    ! [Z: int] :
      ( ord_less(nat,zero_zero(nat),nat1(Z))
    <=> ord_less(int,zero_zero(int),Z) ) ).

tff(fact_94_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_95_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_96_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_97_number__of__is__id,axiom,
    ! [K: int] : ( number_number_of(int,K) = K ) ).

%----Arities (28)
tff(arity_Int_Oint___Rings_Olinordered__semidom,axiom,
    linordered_semidom(int) ).

tff(arity_Int_Oint___Rings_Olinordered__idom,axiom,
    linordered_idom(int) ).

tff(arity_Int_Oint___Nat_Osemiring__char__0,axiom,
    semiring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__semiring,axiom,
    number_semiring(int) ).

tff(arity_Int_Oint___Orderings_Opreorder,axiom,
    preorder(int) ).

tff(arity_Int_Oint___Orderings_Olinorder,axiom,
    linorder(int) ).

tff(arity_Int_Oint___Rings_Osemiring__1,axiom,
    semiring_1(int) ).

tff(arity_Int_Oint___Orderings_Oorder,axiom,
    order(int) ).

tff(arity_Int_Oint___Int_Oring__char__0,axiom,
    ring_char_0(int) ).

tff(arity_Int_Oint___Int_Onumber__ring,axiom,
    number_ring(int) ).

tff(arity_Int_Oint___Orderings_Oord,axiom,
    ord(int) ).

tff(arity_Int_Oint___Rings_Oring__1,axiom,
    ring_1(int) ).

tff(arity_Int_Oint___Groups_Ozero,axiom,
    zero(int) ).

tff(arity_Int_Oint___Int_Onumber,axiom,
    number(int) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Int_Onumber__semiring,axiom,
    number_semiring(nat) ).

tff(arity_Nat_Onat___Orderings_Opreorder,axiom,
    preorder(nat) ).

tff(arity_Nat_Onat___Orderings_Olinorder,axiom,
    linorder(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Orderings_Oord,axiom,
    ord(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_Nat_Onat___Int_Onumber,axiom,
    number(nat) ).

tff(arity_HOL_Obool___Orderings_Opreorder,axiom,
    preorder(bool) ).

tff(arity_HOL_Obool___Orderings_Olinorder,axiom,
    linorder(bool) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

tff(arity_HOL_Obool___Orderings_Oord,axiom,
    ord(bool) ).

%----Helper facts (5)
tff(help_If_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fTrue,X,Y) = X ) ).

tff(help_If_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] : ( if(A,fFalse,X,Y) = Y ) ).

tff(help_If_3_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (3)
tff(conj_0,hypothesis,
    it(ra) ).

tff(conj_1,hypothesis,
    ! [I: nat,J: nat] : it(subst(ra,var(I),J)) ).

tff(conj_2,conjecture,
    it(subst(abs(ra),var(ia),ja)) ).

%------------------------------------------------------------------------------
