%------------------------------------------------------------------------------
% File     : LCL752_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 41
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_41 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  151 (  44 unt;  37 typ;   0 def)
%            Number of atoms       :  234 (  95 equ)
%            Maximal formula atoms :    7 (   1 avg)
%            Number of connectives :  168 (  48   ~;  12   |;   7   &)
%                                         (  25 <=>;  76  =>;   0  <=;   0 <~>)
%            Maximal formula depth :    9 (   5 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   24 (  14   >;  10   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-3 aty)
%            Number of functors    :   27 (  27 usr;  12 con; 0-5 aty)
%            Number of variables   :  284 ( 255   !;   4   ?; 284   :)
%                                         (  25  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:16:10
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (32)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__group__add,type,
    ordered_ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: fun(nat,dB) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_ja,type,
    ja: nat ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_rs,type,
    rs: list(dB) ).

%----Relevant facts (98)
tff(fact_0_IT_OVar,axiom,
    ! [N1: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,var,N1),Rs))) ) ).

tff(fact_1_subst__map,axiom,
    ! [Ia: nat,U1: dB,Ts: list(dB),T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,T,Ts)),U1),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),U1),Ia),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,U1),Ia),Ts)) ) ).

tff(fact_2_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss: list(dB),N1: nat,Rs: list(dB),M1: nat] :
      ( ( foldl(dB,dB,app,aa(nat,dB,var,M1),Rs) = foldl(dB,dB,app,aa(nat,dB,var,N1),Ss) )
    <=> ( ( M1 = N1 )
        & ( Rs = Ss ) ) ) ).

tff(fact_3_zero__less__diff,axiom,
    ! [M1: nat,N1: nat] :
      ( ord_less(nat,zero_zero(nat),minus_minus(nat,N1,M1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_4_zero__less__Suc,axiom,
    ! [N2: nat] : ord_less(nat,zero_zero(nat),suc(N2)) ).

tff(fact_5_less__Suc0,axiom,
    ! [N1: nat] :
      ( ord_less(nat,N1,suc(zero_zero(nat)))
    <=> ( N1 = zero_zero(nat) ) ) ).

tff(fact_6_subst__App,axiom,
    ! [K: nat,S1: dB,U: dB,T1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T1),U)),S1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U),S1),K)) ) ).

tff(fact_7_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( Ra = S ) ) ).

tff(fact_8_diff__Suc__Suc,axiom,
    ! [N2: nat,M2: nat] : ( minus_minus(nat,suc(M2),suc(N2)) = minus_minus(nat,M2,N2) ) ).

tff(fact_9_Suc__diff__diff,axiom,
    ! [K: nat,N2: nat,M2: nat] : ( minus_minus(nat,minus_minus(nat,suc(M2),N2),suc(K)) = minus_minus(nat,minus_minus(nat,M2,N2),K) ) ).

tff(fact_10_diff__0__eq__0,axiom,
    ! [N2: nat] : ( minus_minus(nat,zero_zero(nat),N2) = zero_zero(nat) ) ).

tff(fact_11_diff__self__eq__0,axiom,
    ! [M2: nat] : ( minus_minus(nat,M2,M2) = zero_zero(nat) ) ).

tff(fact_12_nat_Oinject,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( suc(Nat4) = suc(Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_13_dB_Osimps_I2_J,axiom,
    ! [DB23: dB,DB13: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) )
    <=> ( ( DB12 = DB13 )
        & ( DB22 = DB23 ) ) ) ).

tff(fact_14_dB_Osimps_I1_J,axiom,
    ! [Nat5: nat,Nat4: nat] :
      ( ( aa(nat,dB,var,Nat4) = aa(nat,dB,var,Nat5) )
    <=> ( Nat4 = Nat5 ) ) ).

tff(fact_15_less__zeroE,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_16_less__nat__zero__code,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_17_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_18_Suc__mono,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,M2,N2)
     => ord_less(nat,suc(M2),suc(N2)) ) ).

tff(fact_19_Suc__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,suc(M1),suc(N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_20_not__less__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ~ ord_less(nat,M1,N1)
    <=> ord_less(nat,N1,suc(M1)) ) ).

tff(fact_21_lessI,axiom,
    ! [N2: nat] : ord_less(nat,N2,suc(N2)) ).

tff(fact_22_Suc__inject,axiom,
    ! [Y: nat,X: nat] :
      ( ( suc(X) = suc(Y) )
     => ( X = Y ) ) ).

tff(fact_23_Suc__n__not__n,axiom,
    ! [N2: nat] : ( suc(N2) != N2 ) ).

tff(fact_24_n__not__Suc__n,axiom,
    ! [N2: nat] : ( N2 != suc(N2) ) ).

tff(fact_25_nat__less__cases,axiom,
    ! [P1: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P1,N1),M1)) ) ) ) ).

tff(fact_26_less__not__refl3,axiom,
    ! [T1: nat,S1: nat] :
      ( ord_less(nat,S1,T1)
     => ( S1 != T1 ) ) ).

tff(fact_27_less__not__refl2,axiom,
    ! [M2: nat,N2: nat] :
      ( ord_less(nat,N2,M2)
     => ( M2 != N2 ) ) ).

tff(fact_28_less__irrefl__nat,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_29_linorder__neqE__nat,axiom,
    ! [Y: nat,X: nat] :
      ( ( X != Y )
     => ( ~ ord_less(nat,X,Y)
       => ord_less(nat,Y,X) ) ) ).

tff(fact_30_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_31_less__not__refl,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,N2) ).

tff(fact_32_diff__commute,axiom,
    ! [K: nat,J1: nat,I: nat] : ( minus_minus(nat,minus_minus(nat,I,J1),K) = minus_minus(nat,minus_minus(nat,I,K),J1) ) ).

tff(fact_33_Suc__neq__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_34_Zero__neq__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_35_nat_Osimps_I3_J,axiom,
    ! [Nat3: nat] : ( suc(Nat3) != zero_zero(nat) ) ).

tff(fact_36_Suc__not__Zero,axiom,
    ! [M2: nat] : ( suc(M2) != zero_zero(nat) ) ).

tff(fact_37_nat_Osimps_I2_J,axiom,
    ! [Nat2: nat] : ( zero_zero(nat) != suc(Nat2) ) ).

tff(fact_38_Zero__not__Suc,axiom,
    ! [M2: nat] : ( zero_zero(nat) != suc(M2) ) ).

tff(fact_39_gr0I,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N2) ) ).

tff(fact_40_gr__implies__not0,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,M2,N2)
     => ( N2 != zero_zero(nat) ) ) ).

tff(fact_41_not__less0,axiom,
    ! [N2: nat] : ~ ord_less(nat,N2,zero_zero(nat)) ).

tff(fact_42_Suc__less__SucD,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,suc(M2),suc(N2))
     => ord_less(nat,M2,N2) ) ).

tff(fact_43_Suc__lessD,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,suc(M2),N2)
     => ord_less(nat,M2,N2) ) ).

tff(fact_44_less__SucE,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,M2,suc(N2))
     => ( ~ ord_less(nat,M2,N2)
       => ( M2 = N2 ) ) ) ).

tff(fact_45_less__trans__Suc,axiom,
    ! [K: nat,J1: nat,I: nat] :
      ( ord_less(nat,I,J1)
     => ( ord_less(nat,J1,K)
       => ord_less(nat,suc(I),K) ) ) ).

tff(fact_46_Suc__lessI,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,M2,N2)
     => ( ( suc(M2) != N2 )
       => ord_less(nat,suc(M2),N2) ) ) ).

tff(fact_47_less__SucI,axiom,
    ! [N2: nat,M2: nat] :
      ( ord_less(nat,M2,N2)
     => ord_less(nat,M2,suc(N2)) ) ).

tff(fact_48_less__antisym,axiom,
    ! [M2: nat,N2: nat] :
      ( ~ ord_less(nat,N2,M2)
     => ( ord_less(nat,N2,suc(M2))
       => ( M2 = N2 ) ) ) ).

tff(fact_49_not__less__less__Suc__eq,axiom,
    ! [M1: nat,N1: nat] :
      ( ~ ord_less(nat,N1,M1)
     => ( ord_less(nat,N1,suc(M1))
      <=> ( N1 = M1 ) ) ) ).

tff(fact_50_less__Suc__eq,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,suc(N1))
    <=> ( ord_less(nat,M1,N1)
        | ( M1 = N1 ) ) ) ).

tff(fact_51_diffs0__imp__equal,axiom,
    ! [N2: nat,M2: nat] :
      ( ( minus_minus(nat,M2,N2) = zero_zero(nat) )
     => ( ( minus_minus(nat,N2,M2) = zero_zero(nat) )
       => ( M2 = N2 ) ) ) ).

tff(fact_52_minus__nat_Odiff__0,axiom,
    ! [M2: nat] : ( minus_minus(nat,M2,zero_zero(nat)) = M2 ) ).

tff(fact_53_diff__less__mono2,axiom,
    ! [L: nat,N2: nat,M2: nat] :
      ( ord_less(nat,M2,N2)
     => ( ord_less(nat,M2,L)
       => ord_less(nat,minus_minus(nat,L,N2),minus_minus(nat,L,M2)) ) ) ).

tff(fact_54_less__imp__diff__less,axiom,
    ! [N2: nat,K: nat,J1: nat] :
      ( ord_less(nat,J1,K)
     => ord_less(nat,minus_minus(nat,J1,N2),K) ) ).

tff(fact_55_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != aa(nat,dB,var,Nat) ) ).

tff(fact_56_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( aa(nat,dB,var,Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_57_subst__eq,axiom,
    ! [U: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,var,K)),U),K) = U ) ).

tff(fact_58_less__Suc__eq__0__disj,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,M1,suc(N1))
    <=> ( ( M1 = zero_zero(nat) )
        | ? [J2: nat] :
            ( ( M1 = suc(J2) )
            & ord_less(nat,J2,N1) ) ) ) ).

tff(fact_59_gr0__conv__Suc,axiom,
    ! [N1: nat] :
      ( ord_less(nat,zero_zero(nat),N1)
    <=> ? [M3: nat] : ( N1 = suc(M3) ) ) ).

tff(fact_60_diff__less,axiom,
    ! [M2: nat,N2: nat] :
      ( ord_less(nat,zero_zero(nat),N2)
     => ( ord_less(nat,zero_zero(nat),M2)
       => ord_less(nat,minus_minus(nat,M2,N2),M2) ) ) ).

tff(fact_61_diff__less__Suc,axiom,
    ! [N2: nat,M2: nat] : ord_less(nat,minus_minus(nat,M2,N2),suc(M2)) ).

tff(fact_62_subst__lt,axiom,
    ! [U: dB,I: nat,J1: nat] :
      ( ord_less(nat,J1,I)
     => ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,var,J1)),U),I) = aa(nat,dB,var,J1) ) ) ).

tff(fact_63_diff__Suc__less,axiom,
    ! [I: nat,N2: nat] :
      ( ord_less(nat,zero_zero(nat),N2)
     => ord_less(nat,minus_minus(nat,N2,suc(I)),N2) ) ).

tff(fact_64_Suc__pred,axiom,
    ! [N2: nat] :
      ( ord_less(nat,zero_zero(nat),N2)
     => ( suc(minus_minus(nat,N2,suc(zero_zero(nat)))) = N2 ) ) ).

tff(fact_65_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( minus_minus(A,A2,A2) = zero_zero(A) ) ) ).

tff(fact_66_listsp__conj__eq,axiom,
    ! [A: $tType,B2: fun(A,bool),A3: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A3),B2),X3)
    <=> ( listsp(A,A3,X3)
        & listsp(A,B2,X3) ) ) ).

tff(fact_67_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_68_gr0__implies__Suc,axiom,
    ! [N2: nat] :
      ( ord_less(nat,zero_zero(nat),N2)
     => ? [M: nat] : ( N2 = suc(M) ) ) ).

tff(fact_69_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [N3: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N: nat] : ord_less(A,aa(nat,A,F,N),aa(nat,A,F,suc(N)))
         => ( ord_less(nat,N1,N3)
           => ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,N3)) ) ) ) ).

tff(fact_70_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( order(A)
     => ! [M1: nat,N1: nat,F: fun(nat,A)] :
          ( ! [N: nat] : ord_less(A,aa(nat,A,F,N),aa(nat,A,F,suc(N)))
         => ( ord_less(A,aa(nat,A,F,N1),aa(nat,A,F,M1))
          <=> ord_less(nat,N1,M1) ) ) ) ).

tff(fact_71_less__iff__diff__less__0,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [B1: A,A1: A] :
          ( ord_less(A,A1,B1)
        <=> ord_less(A,minus_minus(A,A1,B1),zero_zero(A)) ) ) ).

tff(fact_72_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A1: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A1,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),A1,Xs) ) ).

tff(fact_73_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_74_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_75_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D: A,C1: A,B1: A,A1: A] :
          ( ( minus_minus(A,A1,B1) = minus_minus(A,C1,D) )
         => ( ( A1 = B1 )
          <=> ( C1 = D ) ) ) ) ).

tff(fact_76_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A2: A] : ( minus_minus(A,A2,zero_zero(A)) = A2 ) ) ).

tff(fact_77_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( A1 = B1 )
        <=> ( minus_minus(A,A1,B1) = zero_zero(A) ) ) ) ).

tff(fact_78_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A1: A] :
          ( ( minus_minus(A,A1,B1) = zero_zero(A) )
        <=> ( A1 = B1 ) ) ) ).

tff(fact_79_diff__eq__diff__less,axiom,
    ! [A: $tType] :
      ( ordered_ab_group_add(A)
     => ! [D: A,C1: A,B1: A,A1: A] :
          ( ( minus_minus(A,A1,B1) = minus_minus(A,C1,D) )
         => ( ord_less(A,A1,B1)
          <=> ord_less(A,C1,D) ) ) ) ).

tff(fact_80_zero__induct__lemma,axiom,
    ! [Ia: nat,K1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K1))
     => ( ! [N: nat] :
            ( pp(aa(nat,bool,P1,suc(N)))
           => pp(aa(nat,bool,P1,N)) )
       => pp(aa(nat,bool,P1,minus_minus(nat,K1,Ia))) ) ) ).

tff(fact_81_lessE,axiom,
    ! [K: nat,I: nat] :
      ( ord_less(nat,I,K)
     => ( ( K != suc(I) )
       => ~ ! [J: nat] :
              ( ord_less(nat,I,J)
             => ( K != suc(J) ) ) ) ) ).

tff(fact_82_Suc__lessE,axiom,
    ! [K: nat,I: nat] :
      ( ord_less(nat,suc(I),K)
     => ~ ! [J: nat] :
            ( ord_less(nat,I,J)
           => ( K != suc(J) ) ) ) ).

tff(fact_83_nat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y != zero_zero(nat) )
     => ~ ! [Nat1: nat] : ( Y != suc(Nat1) ) ) ).

tff(fact_84_not0__implies__Suc,axiom,
    ! [N2: nat] :
      ( ( N2 != zero_zero(nat) )
     => ? [M: nat] : ( N2 = suc(M) ) ) ).

tff(fact_85_nat__induct,axiom,
    ! [N1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,zero_zero(nat)))
     => ( ! [N: nat] :
            ( pp(aa(nat,bool,P1,N))
           => pp(aa(nat,bool,P1,suc(N))) )
       => pp(aa(nat,bool,P1,N1)) ) ) ).

tff(fact_86_zero__induct,axiom,
    ! [K1: nat,P1: fun(nat,bool)] :
      ( pp(aa(nat,bool,P1,K1))
     => ( ! [N: nat] :
            ( pp(aa(nat,bool,P1,suc(N)))
           => pp(aa(nat,bool,P1,N)) )
       => pp(aa(nat,bool,P1,zero_zero(nat))) ) ) ).

tff(fact_87_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(aa(nat,dB,var,Nat)) = zero_zero(nat) ) ).

tff(fact_88_Beta,axiom,
    ! [Ss: list(dB),S: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S),zero_zero(nat)),Ss)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S),Ss))) ) ) ).

tff(fact_89_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_90_dB_Osimps_I3_J,axiom,
    ! [DB4: dB,DB3: dB] :
      ( ( abs(DB3) = abs(DB4) )
    <=> ( DB3 = DB4 ) ) ).

tff(fact_91_lift_Osimps_I2_J,axiom,
    ! [K: nat,T1: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),K)) ) ).

tff(fact_92_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_93_lift__IT,axiom,
    ! [I: nat,T1: dB] :
      ( pp(aa(dB,bool,it,T1))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T1),I))) ) ).

tff(fact_94_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss: list(dB),S: dB,Rs: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs) = foldl(dB,dB,app,abs(S),Ss) )
    <=> ( ( Ra = S )
        & ( Rs = Ss ) ) ) ).

tff(fact_95_lift__map,axiom,
    ! [Ia: nat,Ts: list(dB),T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,T,Ts)),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),Ia),map(dB,dB,combc(dB,nat,dB,lift,Ia),Ts)) ) ).

tff(fact_96_dB_Osimps_I9_J,axiom,
    ! [DB2: dB,DB1: dB,DB: dB] : ( abs(DB) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) ) ).

tff(fact_97_dB_Osimps_I8_J,axiom,
    ! [DB: dB,DB2: dB,DB1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) != abs(DB) ) ).

%----Arities (4)
tff(arity_fun___Orderings_Oorder,axiom,
    ! [T_1: $tType,T_2: $tType] :
      ( order(T_2)
     => order(fun(T_1,T_2)) ) ).

tff(arity_Nat_Onat___Orderings_Oorder,axiom,
    order(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

tff(arity_HOL_Obool___Orderings_Oorder,axiom,
    order(bool) ).

%----Helper facts (10)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    listsp(dB,combs(dB,bool,bool,aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it),aa(fun(dB,fun(nat,bool)),fun(dB,bool),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat)),aa(fun(dB,fun(nat,fun(nat,bool))),fun(dB,fun(nat,bool)),aa(fun(fun(nat,fun(nat,bool)),fun(nat,bool)),fun(fun(dB,fun(nat,fun(nat,bool))),fun(dB,fun(nat,bool))),combb(fun(nat,fun(nat,bool)),fun(nat,bool),dB),aa(fun(fun(nat,bool),bool),fun(fun(nat,fun(nat,bool)),fun(nat,bool)),combb(fun(nat,bool),bool,nat),fAll(nat))),aa(fun(dB,fun(nat,fun(nat,dB))),fun(dB,fun(nat,fun(nat,bool))),aa(fun(fun(nat,fun(nat,dB)),fun(nat,fun(nat,bool))),fun(fun(dB,fun(nat,fun(nat,dB))),fun(dB,fun(nat,fun(nat,bool)))),combb(fun(nat,fun(nat,dB)),fun(nat,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(nat,fun(nat,dB)),fun(nat,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),nat),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),combc(dB,fun(nat,dB),fun(nat,fun(nat,dB)),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(fun(nat,dB),fun(nat,fun(nat,dB)))),aa(fun(fun(dB,fun(nat,dB)),fun(fun(nat,dB),fun(nat,fun(nat,dB)))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(fun(nat,dB),fun(nat,fun(nat,dB))))),combb(fun(dB,fun(nat,dB)),fun(fun(nat,dB),fun(nat,fun(nat,dB))),dB),combb(dB,fun(nat,dB),nat)),subst),var))))),rs) ).

tff(conj_1,conjecture,
    ( ( ( n != ja )
      | pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,var,ia),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,aa(nat,dB,var,ia)),ja),rs)))) )
    & ( ( n = ja )
      | ( ( ~ ord_less(nat,ja,n)
          | pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,var,minus_minus(nat,n,suc(zero_zero(nat)))),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,aa(nat,dB,var,ia)),ja),rs)))) )
        & ( ~ ord_less(nat,n,suc(ja))
          | pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,var,n),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,aa(nat,dB,var,ia)),ja),rs)))) ) ) ) ) ).

%------------------------------------------------------------------------------
