%------------------------------------------------------------------------------
% File     : LCL751_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 40
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_40 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  171 (  59 unt;  52 typ;   0 def)
%            Number of atoms       :  235 ( 136 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  169 (  53   ~;  18   |;  27   &)
%                                         (  26 <=>;  45  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   14 (   6 avg)
%            Maximal term depth    :   13 (   2 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :   55 (  27   >;  28   *;   0   +;   0  <<)
%            Number of predicates  :    8 (   7 usr;   0 prp; 1-4 aty)
%            Number of functors    :   42 (  42 usr;  15 con; 0-5 aty)
%            Number of variables   :  444 ( 386   !;  20   ?; 444   :)
%                                         (  38  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:52
%------------------------------------------------------------------------------
%----Should-be-implicit typings (5)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : fun(fun(B,C),fun(fun(A,B),fun(A,C))) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: fun(dB,fun(dB,bool)) ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: fun(nat,dB) ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T3: $tType] : ( ( fun(nat,T3) * fun(dB,fun(dB,T3)) * fun(dB,T3) * dB ) > T3 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: fun(dB,fun(dB,fun(nat,dB))) ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_ListOrder_Ostep1,type,
    step1: 
      !>[A: $tType] : ( ( fun(A,fun(A,bool)) * list(A) * list(A) ) > $o ) ).

tff(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list(A) * list(A) ) > list(A) ) ).

tff(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( list(list(A)) > list(A) ) ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B: $tType,A: $tType] : ( ( fun(B,fun(A,B)) * B * list(A) ) > B ) ).

tff(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( ( A * list(A) ) > list(A) ) ).

tff(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : fun(A,fun(list(A),list(A))) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olist_Olist__case,type,
    list_case: 
      !>[T3: $tType,A: $tType] : ( ( T3 * fun(A,fun(list(A),T3)) * list(A) ) > T3 ) ).

tff(sy_c_List_Olist_Olist__rec,type,
    list_rec: 
      !>[T3: $tType,A: $tType] : ( ( T3 * fun(A,fun(list(A),fun(T3,T3))) * list(A) ) > T3 ) ).

tff(sy_c_List_Olist_Olist__size,type,
    list_size: 
      !>[A: $tType] : ( ( fun(A,nat) * list(A) ) > nat ) ).

tff(sy_c_List_Olist__all,type,
    list_all: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olist__ex1,type,
    list_ex1: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Osublist,type,
    sublist: 
      !>[A: $tType] : ( ( list(A) * fun(nat,bool) ) > list(A) ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fAll,type,
    fAll: 
      !>[A: $tType] : fun(fun(A,bool),bool) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fNot,type,
    fNot: fun(bool,bool) ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fdisj,type,
    fdisj: fun(bool,fun(bool,bool)) ).

tff(sy_c_fequal,type,
    fequal: 
      !>[A: $tType] : ( A > fun(A,bool) ) ).

tff(sy_c_member,type,
    member: 
      !>[A: $tType] : ( ( A * fun(A,bool) ) > $o ) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ia,type,
    ia: nat ).

tff(sy_v_ja,type,
    ja: nat ).

tff(sy_v_n,type,
    n: nat ).

tff(sy_v_rs,type,
    rs: list(dB) ).

%----Relevant facts (99)
tff(fact_0_IT_OVar,axiom,
    ! [N: nat,Rs: list(dB)] :
      ( listsp(dB,it,Rs)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,var,N),Rs))) ) ).

tff(fact_1_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss2: list(dB),N: nat,Rs: list(dB),M: nat] :
      ( ( foldl(dB,dB,app,aa(nat,dB,var,M),Rs) = foldl(dB,dB,app,aa(nat,dB,var,N),Ss2) )
    <=> ( ( M = N )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_2_subst__App,axiom,
    ! [K: nat,S1: dB,U1: dB,T2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1)),S1),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T2),S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,U1),S1),K)) ) ).

tff(fact_3_apps__eq__tail__conv,axiom,
    ! [S: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S,Ts) )
    <=> ( Ra = S ) ) ).

tff(fact_4_listsp__conj__eq,axiom,
    ! [A: $tType,B1: fun(A,bool),A1: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fconj),A1),B1),X3)
    <=> ( listsp(A,A1,X3)
        & listsp(A,B1,X3) ) ) ).

tff(fact_5_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( aa(nat,dB,var,Nat2) = aa(nat,dB,var,Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_6_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB12 = DB14 )
        & ( DB22 = DB24 ) ) ) ).

tff(fact_7_subst__eq,axiom,
    ! [U1: dB,K: nat] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,var,K)),U1),K) = U1 ) ).

tff(fact_8_dB_Osimps_I4_J,axiom,
    ! [DB23: dB,DB13: dB,Nat: nat] : ( aa(nat,dB,var,Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_9_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != aa(nat,dB,var,Nat) ) ).

tff(fact_10_Var__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,M: nat] :
      ( ( aa(nat,dB,var,M) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( aa(nat,dB,var,M) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_11_subst__map,axiom,
    ! [Ia: nat,U2: dB,Ts: list(dB),T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,T,Ts)),U2),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T),U2),Ia),map(dB,dB,combc(dB,nat,dB,combc(dB,dB,fun(nat,dB),subst,U2),Ia),Ts)) ) ).

tff(fact_12_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_13_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_14_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_15_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_16_listsp_ONil,axiom,
    ! [A: $tType,A1: fun(A,bool)] : listsp(A,A1,nil(A)) ).

tff(fact_17_foldl__Nil,axiom,
    ! [B: $tType,A: $tType,A3: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A3,nil(B)) = A3 ) ).

tff(fact_18_foldl__map,axiom,
    ! [A: $tType,B: $tType,C: $tType,Xs: list(C),F: fun(C,B),A3: A,G: fun(A,fun(B,A))] : ( foldl(A,B,G,A3,map(C,B,F,Xs)) = foldl(A,C,combc(A,fun(C,B),fun(C,A),aa(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A))),aa(fun(fun(B,A),fun(fun(C,B),fun(C,A))),fun(fun(A,fun(B,A)),fun(A,fun(fun(C,B),fun(C,A)))),combb(fun(B,A),fun(fun(C,B),fun(C,A)),A),combb(B,A,C)),G),F),A3,Xs) ) ).

tff(fact_19_lift__map,axiom,
    ! [Ia: nat,Ts: list(dB),T: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,foldl(dB,dB,app,T,Ts)),Ia) = foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),Ia),map(dB,dB,combc(dB,nat,dB,lift,Ia),Ts)) ) ).

tff(fact_20_foldl__fun__comm,axiom,
    ! [B: $tType,A: $tType,X1: A,Xs: list(A),S: B,F: fun(B,fun(A,B))] :
      ( ! [X2: A,Y1: A,S2: B] : ( aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),X2)),Y1) = aa(A,B,aa(B,fun(A,B),F,aa(A,B,aa(B,fun(A,B),F,S2),Y1)),X2) )
     => ( aa(A,B,aa(B,fun(A,B),F,foldl(B,A,F,S,Xs)),X1) = foldl(B,A,F,aa(A,B,aa(B,fun(A,B),F,S),X1),Xs) ) ) ).

tff(fact_21_apps__eq__Abs__conv,axiom,
    ! [Ra: dB,Ss2: list(dB),S: dB] :
      ( ( foldl(dB,dB,app,S,Ss2) = abs(Ra) )
    <=> ( ( S = abs(Ra) )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_22_Abs__eq__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,Ra: dB] :
      ( ( abs(Ra) = foldl(dB,dB,app,S,Ss2) )
    <=> ( ( abs(Ra) = S )
        & ( Ss2 = nil(dB) ) ) ) ).

tff(fact_23_list_Osimps_I4_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_24_list__ex1__simps_I1_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : ~ list_ex1(A,P1,nil(A)) ).

tff(fact_25_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(nat,dB,var,Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_26_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB22: dB,DB12: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB12),DB22) ) ).

tff(fact_27_substn_Osimps_I2_J,axiom,
    ! [K: nat,S1: dB,U1: dB,T2: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1),S1,K) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T2,S1,K)),substn(U1,S1,K)) ) ).

tff(fact_28_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB4: dB] :
      ( ( abs(DB4) = abs(DB5) )
    <=> ( DB4 = DB5 ) ) ).

tff(fact_29_lift_Osimps_I2_J,axiom,
    ! [K: nat,T2: dB,S1: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),lift,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T2)),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),K)),aa(nat,dB,aa(dB,fun(nat,dB),lift,T2),K)) ) ).

tff(fact_30_Lambda,axiom,
    ! [R2: dB] :
      ( pp(aa(dB,bool,it,R2))
     => pp(aa(dB,bool,it,abs(R2))) ) ).

tff(fact_31_lift__IT,axiom,
    ! [I: nat,T2: dB] :
      ( pp(aa(dB,bool,it,T2))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T2),I))) ) ).

tff(fact_32_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss2: list(dB),S: dB,Rs: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs) = foldl(dB,dB,app,abs(S),Ss2) )
    <=> ( ( Ra = S )
        & ( Rs = Ss2 ) ) ) ).

tff(fact_33_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB4)) = aa(dB,A,F3,DB4) ) ).

tff(fact_34_dB_Osimps_I9_J,axiom,
    ! [DB21: dB,DB11: dB,DB3: dB] : ( abs(DB3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_35_dB_Osimps_I8_J,axiom,
    ! [DB3: dB,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != abs(DB3) ) ).

tff(fact_36_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB3: dB] : ( abs(DB3) != aa(nat,dB,var,Nat) ) ).

tff(fact_37_dB_Osimps_I6_J,axiom,
    ! [DB3: dB,Nat: nat] : ( aa(nat,dB,var,Nat) != abs(DB3) ) ).

tff(fact_38_subst__lift,axiom,
    ! [S1: dB,K: nat,T2: dB] : ( aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,aa(nat,dB,aa(dB,fun(nat,dB),lift,T2),K)),S1),K) = T2 ) ).

tff(fact_39_Abs__App__neq__Var__apps,axiom,
    ! [Ss2: list(dB),N: nat,T: dB,S: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S)),T) != foldl(dB,dB,app,aa(nat,dB,var,N),Ss2) ) ).

tff(fact_40_Var__apps__neq__Abs__apps,axiom,
    ! [Ss2: list(dB),Ra: dB,Ts: list(dB),N: nat] : ( foldl(dB,dB,app,aa(nat,dB,var,N),Ts) != foldl(dB,dB,app,abs(Ra),Ss2) ) ).

tff(fact_41_Beta,axiom,
    ! [Ss2: list(dB),S: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,Ra),S),zero_zero(nat)),Ss2)))
     => ( pp(aa(dB,bool,it,S))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S),Ss2))) ) ) ).

tff(fact_42_lifts__IT,axiom,
    ! [Ts: list(dB)] :
      ( listsp(dB,it,Ts)
     => listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),Ts)) ) ).

tff(fact_43_IT_Osimps,axiom,
    ! [A3: dB] :
      ( pp(aa(dB,bool,it,A3))
    <=> ( ? [Rs2: list(dB),N3: nat] :
            ( ( A3 = foldl(dB,dB,app,aa(nat,dB,var,N3),Rs2) )
            & listsp(dB,it,Rs2) )
        | ? [R3: dB] :
            ( ( A3 = abs(R3) )
            & pp(aa(dB,bool,it,R3)) )
        | ? [R3: dB,S3: dB,Ss: list(dB)] :
            ( ( A3 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R3)),S3),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R3),S3),zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S3)) ) ) ) ).

tff(fact_44_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat1: nat] : ( Y != aa(nat,dB,var,Nat1) )
     => ( ! [DB1: dB,DB2: dB] : ( Y != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) )
       => ~ ! [DB: dB] : ( Y != abs(DB) ) ) ) ).

tff(fact_45_ex__head__tail,axiom,
    ! [T: dB] :
    ? [Ts1: list(dB),H: dB] :
      ( ( T = foldl(dB,dB,app,H,Ts1) )
      & ( ? [N2: nat] : ( H = aa(nat,dB,var,N2) )
        | ? [U: dB] : ( H = abs(U) ) ) ) ).

tff(fact_46_list_Orecs_I1_J,axiom,
    ! [B: $tType,A: $tType,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,nil(B)) = F1 ) ).

tff(fact_47_substn__subst__0,axiom,
    ! [S1: dB,T2: dB] : ( substn(T2,S1,zero_zero(nat)) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T2),S1),zero_zero(nat)) ) ).

tff(fact_48_substn__subst__n,axiom,
    ! [N1: nat,S1: dB,T2: dB] : ( substn(T2,S1,N1) = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T2),liftn(N1,S1,zero_zero(nat))),N1) ) ).

tff(fact_49_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(aa(nat,dB,var,Nat)) = zero_zero(nat) ) ).

tff(fact_50_beta,axiom,
    ! [T2: dB,S1: dB] : pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T2)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T2),zero_zero(nat)))) ).

tff(fact_51_appL,axiom,
    ! [U1: dB,T2: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),U1)),aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1))) ) ).

tff(fact_52_appR,axiom,
    ! [U1: dB,T2: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S1)),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T2))) ) ).

tff(fact_53_abs,axiom,
    ! [T2: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T2))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(S1)),abs(T2))) ) ).

tff(fact_54_beta__cases_I1_J,axiom,
    ! [T2: dB,I: nat] : ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,var,I)),T2)) ).

tff(fact_55_liftn_Osimps_I2_J,axiom,
    ! [K: nat,T2: dB,S1: dB,N1: nat] : ( liftn(N1,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T2),K) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N1,S1,K)),liftn(N1,T2,K)) ) ).

tff(fact_56_subst__preserves__beta,axiom,
    ! [I: nat,T2: dB,S1: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,R2),T2),I)),aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S1),T2),I))) ) ).

tff(fact_57_lift__preserves__beta,axiom,
    ! [I: nat,S1: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),S1))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(nat,dB,aa(dB,fun(nat,dB),lift,R2),I)),aa(nat,dB,aa(dB,fun(nat,dB),lift,S1),I))) ) ).

tff(fact_58_liftn__0,axiom,
    ! [K: nat,T2: dB] : ( liftn(zero_zero(nat),T2,K) = T2 ) ).

tff(fact_59_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_60_beta__cases_I2_J,axiom,
    ! [S1: dB,R2: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,abs(R2)),S1))
     => ~ ! [T1: dB] :
            ( ( S1 = abs(T1) )
           => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,R2),T1)) ) ) ).

tff(fact_61_apps__preserves__beta,axiom,
    ! [Ss2: list(dB),S: dB,Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),S))
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Ss2)),foldl(dB,dB,app,S,Ss2))) ) ).

tff(fact_62_beta__cases_I3_J,axiom,
    ! [U1: dB,T2: dB,S1: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T2)),U1))
     => ( ! [S2: dB] :
            ( ( U1 = aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,S2),T2),zero_zero(nat)) )
           => ( S1 != abs(S2) ) )
       => ( ! [T1: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T1),T2) )
             => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,S1),T1)) )
         => ~ ! [T1: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T1) )
               => ~ pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,T2),T1)) ) ) ) ) ).

tff(fact_63_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,aa(nat,dB,var,Nat)) = zero_zero(nat) ) ).

tff(fact_64_list_Osize_I1_J,axiom,
    ! [A: $tType,Fa: fun(A,nat)] : ( list_size(A,Fa,nil(A)) = zero_zero(nat) ) ).

tff(fact_65_apps__preserves__betas,axiom,
    ! [Ra: dB,Ss2: list(dB),Rs: list(dB)] :
      ( step1(dB,beta,Rs,Ss2)
     => pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),foldl(dB,dB,app,Ra,Ss2))) ) ).

tff(fact_66_head__Var__reduction,axiom,
    ! [V: dB,Rs: list(dB),N: nat] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,aa(nat,dB,var,N),Rs)),V))
     => ? [Ss1: list(dB)] :
          ( step1(dB,beta,Rs,Ss1)
          & ( V = foldl(dB,dB,app,aa(nat,dB,var,N),Ss1) ) ) ) ).

tff(fact_67_not__Nil__step1,axiom,
    ! [A: $tType,Xs: list(A),Ra: fun(A,fun(A,bool))] : ~ step1(A,Ra,nil(A),Xs) ).

tff(fact_68_not__step1__Nil,axiom,
    ! [A: $tType,Xs: list(A),Ra: fun(A,fun(A,bool))] : ~ step1(A,Ra,Xs,nil(A)) ).

tff(fact_69_apps__betasE,axiom,
    ! [S: dB,Rs: list(dB),Ra: dB] :
      ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,foldl(dB,dB,app,Ra,Rs)),S))
     => ( ! [R1: dB] :
            ( pp(aa(dB,bool,aa(dB,fun(dB,bool),beta,Ra),R1))
           => ( S != foldl(dB,dB,app,R1,Rs) ) )
       => ( ! [Rs1: list(dB)] :
              ( step1(dB,beta,Rs,Rs1)
             => ( S != foldl(dB,dB,app,Ra,Rs1) ) )
         => ~ ! [T1: dB] :
                ( ( Ra = abs(T1) )
               => ! [U: dB,Us: list(dB)] :
                    ( ( Rs = aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),U),Us) )
                   => ( S != foldl(dB,dB,app,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,T1),U),zero_zero(nat)),Us) ) ) ) ) ) ) ).

tff(fact_70_list_Oinject,axiom,
    ! [A: $tType,List3: list(A),A6: A,List1: list(A),A3: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A3),List1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A6),List3) )
    <=> ( ( A3 = A6 )
        & ( List1 = List3 ) ) ) ).

tff(fact_71_map_Osimps_I2_J,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,F: fun(B,A)] : ( map(B,A,F,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xs)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),aa(B,A,F,X1)),map(B,A,F,Xs)) ) ).

tff(fact_72_Cons__step1__Cons,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Ys: list(A),Y3: A,Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y3),Ys),aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs))
    <=> ( ( pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y3),X1))
          & ( Xs = Ys ) )
        | ( ( X1 = Y3 )
          & step1(A,Ra,Ys,Xs) ) ) ) ).

tff(fact_73_list_Osimps_I5_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A3: B,F2: fun(B,fun(list(B),A)),F1: A] : ( list_case(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A3),List1)) = aa(list(B),A,aa(B,fun(list(B),A),F2,A3),List1) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X2: A] : ( aa(A,B,F,X2) = aa(A,B,G,X2) )
     => ( F = G ) ) ).

tff(fact_75_mem__def,axiom,
    ! [A: $tType,A1: fun(A,bool),X1: A] :
      ( member(A,X1,A1)
    <=> pp(aa(A,bool,A1,X1)) ) ).

tff(fact_76_not__Cons__self2,axiom,
    ! [A: $tType,Xs1: list(A),X: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) != Xs1 ) ).

tff(fact_77_not__Cons__self,axiom,
    ! [A: $tType,X: A,Xs1: list(A)] : ( Xs1 != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),Xs1) ) ).

tff(fact_78_foldl__Cons,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),X1: B,A3: A,F: fun(A,fun(B,A))] : ( foldl(A,B,F,A3,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),X1),Xs)) = foldl(A,B,F,aa(B,A,aa(A,fun(B,A),F,A3),X1),Xs) ) ).

tff(fact_79_list_Osimps_I3_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) != nil(A) ) ).

tff(fact_80_list_Osimps_I2_J,axiom,
    ! [A: $tType,List2: list(A),A5: A] : ( nil(A) != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A5),List2) ) ).

tff(fact_81_list_Orecs_I2_J,axiom,
    ! [A: $tType,B: $tType,List1: list(B),A3: B,F2: fun(B,fun(list(B),fun(A,A))),F1: A] : ( list_rec(A,B,F1,F2,aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),A3),List1)) = aa(A,A,aa(list(B),fun(A,A),aa(B,fun(list(B),fun(A,A)),F2,A3),List1),list_rec(A,B,F1,F2,List1)) ) ).

tff(fact_82_listsp_Osimps,axiom,
    ! [A: $tType,A3: list(A),A1: fun(A,bool)] :
      ( listsp(A,A1,A3)
    <=> ( ( A3 = nil(A) )
        | ? [A4: A,L: list(A)] :
            ( ( A3 = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A4),L) )
            & pp(aa(A,bool,A1,A4))
            & listsp(A,A1,L) ) ) ) ).

tff(fact_83_map__eq__Cons__conv,axiom,
    ! [B: $tType,A: $tType,Ys: list(A),Y3: A,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y3),Ys) )
    <=> ? [Z: B,Zs3: list(B)] :
          ( ( Xs = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs3) )
          & ( aa(B,A,F,Z) = Y3 )
          & ( map(B,A,F,Zs3) = Ys ) ) ) ).

tff(fact_84_Cons__eq__map__conv,axiom,
    ! [A: $tType,B: $tType,Ys: list(B),F: fun(B,A),Xs: list(A),X1: A] :
      ( ( aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs) = map(B,A,F,Ys) )
    <=> ? [Z: B,Zs3: list(B)] :
          ( ( Ys = aa(list(B),list(B),aa(B,fun(list(B),list(B)),cons(B),Z),Zs3) )
          & ( X1 = aa(B,A,F,Z) )
          & ( Xs = map(B,A,F,Zs3) ) ) ) ).

tff(fact_85_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list(A)] :
      ( ( Xs != nil(A) )
    <=> ? [Y2: A,Ys2: list(A)] : ( Xs = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y2),Ys2) ) ) ).

tff(fact_86_list_Oexhaust,axiom,
    ! [A: $tType,Y: list(A)] :
      ( ( Y != nil(A) )
     => ~ ! [A2: A,List: list(A)] : ( Y != aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),A2),List) ) ) ).

tff(fact_87_Cons__step1E,axiom,
    ! [A: $tType,Xs: list(A),X1: A,Ys: list(A),Ra: fun(A,fun(A,bool))] :
      ( step1(A,Ra,Ys,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs))
     => ( ! [Y1: A] :
            ( ( Ys = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),Y1),Xs) )
           => ~ pp(aa(A,bool,aa(A,fun(A,bool),Ra,Y1),X1)) )
       => ~ ! [Zs2: list(A)] :
              ( ( Ys = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Zs2) )
             => ~ step1(A,Ra,Zs2,Xs) ) ) ) ).

tff(fact_88_insert__Nil,axiom,
    ! [A: $tType,X: A] : ( insert(A,X,nil(A)) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X),nil(A)) ) ).

tff(fact_89_list__ex1__simps_I2_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,P1: fun(A,bool)] :
      ( list_ex1(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs))
    <=> ( ( pp(aa(A,bool,P1,X1))
         => list_all(A,combs(A,bool,bool,aa(fun(A,bool),fun(A,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(A,bool),fun(A,fun(bool,bool))),combb(bool,fun(bool,bool),A),fdisj),aa(fun(A,bool),fun(A,bool),aa(fun(bool,bool),fun(fun(A,bool),fun(A,bool)),combb(bool,bool,A),fNot),P1)),fequal(A,X1)),Xs) )
        & ( ~ pp(aa(A,bool,P1,X1))
         => list_ex1(A,P1,Xs) ) ) ) ).

tff(fact_90_sublist__singleton,axiom,
    ! [A: $tType,X1: A,A1: fun(nat,bool)] :
      ( ( member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)),A1) = aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)) ) )
      & ( ~ member(nat,zero_zero(nat),A1)
       => ( sublist(A,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),nil(A)),A1) = nil(A) ) ) ) ).

tff(fact_91_list__all__simps_I1_J,axiom,
    ! [A: $tType,Xs: list(A),X1: A,P1: fun(A,bool)] :
      ( list_all(A,P1,aa(list(A),list(A),aa(A,fun(list(A),list(A)),cons(A),X1),Xs))
    <=> ( pp(aa(A,bool,P1,X1))
        & list_all(A,P1,Xs) ) ) ).

tff(fact_92_sublist__nil,axiom,
    ! [A: $tType,A1: fun(nat,bool)] : ( sublist(A,nil(A),A1) = nil(A) ) ).

tff(fact_93_list__all__simps_I2_J,axiom,
    ! [A: $tType,P1: fun(A,bool)] : list_all(A,P1,nil(A)) ).

tff(fact_94_concat__map__singleton,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] : ( concat(A,map(B,list(A),combc(B,list(A),list(A),aa(fun(B,A),fun(B,fun(list(A),list(A))),aa(fun(A,fun(list(A),list(A))),fun(fun(B,A),fun(B,fun(list(A),list(A)))),combb(A,fun(list(A),list(A)),B),cons(A)),F),nil(A)),Xs)) = map(B,A,F,Xs) ) ).

tff(fact_95_App__eq__foldl__conv,axiom,
    ! [Ts: list(dB),T: dB,S: dB,Ra: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,Ra),S) = foldl(dB,dB,app,T,Ts) )
    <=> ( ( ( Ts = nil(dB) )
         => ( aa(dB,dB,aa(dB,fun(dB,dB),app,Ra),S) = T ) )
        & ( ( Ts != nil(dB) )
         => ? [Ss: list(dB)] :
              ( ( Ts = append(dB,Ss,aa(list(dB),list(dB),aa(dB,fun(list(dB),list(dB)),cons(dB),S),nil(dB))) )
              & ( Ra = foldl(dB,dB,app,T,Ss) ) ) ) ) ) ).

tff(fact_96_append__assoc,axiom,
    ! [A: $tType,Zs1: list(A),Ys1: list(A),Xs1: list(A)] : ( append(A,append(A,Xs1,Ys1),Zs1) = append(A,Xs1,append(A,Ys1,Zs1)) ) ).

tff(fact_97_same__append__eq,axiom,
    ! [A: $tType,Zs: list(A),Ys: list(A),Xs: list(A)] :
      ( ( append(A,Xs,Ys) = append(A,Xs,Zs) )
    <=> ( Ys = Zs ) ) ).

tff(fact_98_append__same__eq,axiom,
    ! [A: $tType,Zs: list(A),Xs: list(A),Ys: list(A)] :
      ( ( append(A,Ys,Xs) = append(A,Zs,Xs) )
    <=> ( Ys = Zs ) ) ).

%----Arities (1)
tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (17)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_fAll_1_1_U,axiom,
    ! [A: $tType,X: A,P: fun(A,bool)] :
      ( ~ pp(aa(fun(A,bool),bool,fAll(A),P))
      | pp(aa(A,bool,P,X)) ) ).

tff(help_fNot_1_1_U,axiom,
    ! [P: bool] :
      ( ~ pp(aa(bool,bool,fNot,P))
      | ~ pp(P) ) ).

tff(help_fNot_2_1_U,axiom,
    ! [P: bool] :
      ( pp(P)
      | pp(aa(bool,bool,fNot,P)) ) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,aa(fun(A,B),fun(A,C),aa(fun(B,C),fun(fun(A,B),fun(A,C)),combb(B,C,A),P),Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fdisj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_2_1_U,axiom,
    ! [P: bool,Q: bool] :
      ( ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q)) ) ).

tff(help_fdisj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fdisj,P),Q))
      | pp(P)
      | pp(Q) ) ).

tff(help_fequal_1_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ~ pp(aa(A,bool,fequal(A,X),Y))
      | ( X = Y ) ) ).

tff(help_fequal_2_1_T,axiom,
    ! [A: $tType,Y: A,X: A] :
      ( ( X != Y )
      | pp(aa(A,bool,fequal(A,X),Y)) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    listsp(dB,combs(dB,bool,bool,aa(fun(dB,bool),fun(dB,fun(bool,bool)),aa(fun(bool,fun(bool,bool)),fun(fun(dB,bool),fun(dB,fun(bool,bool))),combb(bool,fun(bool,bool),dB),fconj),it),aa(fun(dB,fun(nat,bool)),fun(dB,bool),aa(fun(fun(nat,bool),bool),fun(fun(dB,fun(nat,bool)),fun(dB,bool)),combb(fun(nat,bool),bool,dB),fAll(nat)),aa(fun(dB,fun(nat,fun(nat,bool))),fun(dB,fun(nat,bool)),aa(fun(fun(nat,fun(nat,bool)),fun(nat,bool)),fun(fun(dB,fun(nat,fun(nat,bool))),fun(dB,fun(nat,bool))),combb(fun(nat,fun(nat,bool)),fun(nat,bool),dB),aa(fun(fun(nat,bool),bool),fun(fun(nat,fun(nat,bool)),fun(nat,bool)),combb(fun(nat,bool),bool,nat),fAll(nat))),aa(fun(dB,fun(nat,fun(nat,dB))),fun(dB,fun(nat,fun(nat,bool))),aa(fun(fun(nat,fun(nat,dB)),fun(nat,fun(nat,bool))),fun(fun(dB,fun(nat,fun(nat,dB))),fun(dB,fun(nat,fun(nat,bool)))),combb(fun(nat,fun(nat,dB)),fun(nat,fun(nat,bool)),dB),aa(fun(fun(nat,dB),fun(nat,bool)),fun(fun(nat,fun(nat,dB)),fun(nat,fun(nat,bool))),combb(fun(nat,dB),fun(nat,bool),nat),aa(fun(dB,bool),fun(fun(nat,dB),fun(nat,bool)),combb(dB,bool,nat),it))),combc(dB,fun(nat,dB),fun(nat,fun(nat,dB)),aa(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(fun(nat,dB),fun(nat,fun(nat,dB)))),aa(fun(fun(dB,fun(nat,dB)),fun(fun(nat,dB),fun(nat,fun(nat,dB)))),fun(fun(dB,fun(dB,fun(nat,dB))),fun(dB,fun(fun(nat,dB),fun(nat,fun(nat,dB))))),combb(fun(dB,fun(nat,dB)),fun(fun(nat,dB),fun(nat,fun(nat,dB))),dB),combb(dB,fun(nat,dB),nat)),subst),var))))),rs) ).

tff(conj_1,conjecture,
    pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),aa(dB,fun(dB,fun(nat,dB)),subst,foldl(dB,dB,app,aa(nat,dB,var,n),rs)),aa(nat,dB,var,ia)),ja))) ).

%------------------------------------------------------------------------------
