%------------------------------------------------------------------------------
% File     : LCL750_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 38
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_38 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  154 (  44 unt;  44 typ;   0 def)
%            Number of atoms       :  227 (  95 equ)
%            Maximal formula atoms :    8 (   1 avg)
%            Number of connectives :  158 (  41   ~;   4   |;  10   &)
%                                         (  26 <=>;  77  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   11 (   5 avg)
%            Maximal term depth    :    8 (   1 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   52 (  24   >;  28   *;   0   +;   0  <<)
%            Number of predicates  :   14 (  13 usr;   0 prp; 1-3 aty)
%            Number of functors    :   27 (  27 usr;   7 con; 0-5 aty)
%            Number of variables   :  335 ( 307   !;   6   ?; 335   :)
%                                         (  22  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:25
%------------------------------------------------------------------------------
%----Should-be-implicit typings (6)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_Type_Otype,type,
    type: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (38)
tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__1,type,
    semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__semidom,type,
    linordered_semidom: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__comm__monoid__add,type,
    ordere216010020id_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oordered__ab__semigroup__add__imp__le,type,
    ordere236663937imp_le: 
      !>[A: $tType] : $o ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : ( ( A * A ) > A ) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Obeta,type,
    beta: ( dB * dB ) > $o ).

tff(sy_c_Lambda_OdB_OAbs,type,
    abs: dB > dB ).

tff(sy_c_Lambda_OdB_OApp,type,
    app: fun(dB,fun(dB,dB)) ).

tff(sy_c_Lambda_OdB_OVar,type,
    var: nat > dB ).

tff(sy_c_Lambda_OdB_OdB__case,type,
    dB_case: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(dB,fun(dB,T6)) * fun(dB,T6) * dB ) > T6 ) ).

tff(sy_c_Lambda_OdB_OdB__rec,type,
    dB_rec: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(dB,fun(dB,fun(T6,fun(T6,T6)))) * fun(dB,fun(T6,T6)) * dB ) > T6 ) ).

tff(sy_c_Lambda_OdB_OdB__size,type,
    dB_size: dB > nat ).

tff(sy_c_Lambda_Olift,type,
    lift: ( dB * nat ) > dB ).

tff(sy_c_Lambda_Oliftn,type,
    liftn: ( nat * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubst,type,
    subst: ( dB * dB * nat ) > dB ).

tff(sy_c_Lambda_Osubstn,type,
    substn: ( dB * dB * nat ) > dB ).

tff(sy_c_List_Ofoldl,type,
    foldl: 
      !>[B2: $tType,A: $tType] : ( ( fun(B2,fun(A,B2)) * B2 * list(A) ) > B2 ) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_Nat_Osemiring__1__class_Oof__nat,type,
    semiring_1_of_nat: 
      !>[A: $tType] : ( nat > A ) ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( ( A * A ) > $o ) ).

tff(sy_c_Type_Oshift,type,
    shift: 
      !>[A: $tType] : ( ( fun(nat,A) * nat * A ) > fun(nat,A) ) ).

tff(sy_c_Type_Otype_OFun,type,
    fun1: ( type * type ) > type ).

tff(sy_c_Type_Otype_Otype__case,type,
    type_case: 
      !>[T6: $tType] : ( ( fun(nat,T6) * fun(type,fun(type,T6)) * type ) > T6 ) ).

tff(sy_c_Type_Otyping,type,
    typing: ( fun(nat,type) * dB * type ) > $o ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B2: $tType] : ( ( fun(A,B2) * A ) > B2 ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_i,type,
    i: nat ).

tff(sy_v_j,type,
    j: nat ).

tff(sy_v_r,type,
    r: dB ).

%----Relevant facts (99)
tff(fact_0_dB_Osimps_I1_J,axiom,
    ! [Nat3: nat,Nat2: nat] :
      ( ( var(Nat2) = var(Nat3) )
    <=> ( Nat2 = Nat3 ) ) ).

tff(fact_1_subst__eq,axiom,
    ! [U1: dB,K1: nat] : ( subst(var(K1),U1,K1) = U1 ) ).

tff(fact_2_lift__IT,axiom,
    ! [I: nat,T2: dB] :
      ( pp(aa(dB,bool,it,T2))
     => pp(aa(dB,bool,it,lift(T2,I))) ) ).

tff(fact_3_dB_Osimps_I10_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_4_subst__lt,axiom,
    ! [U1: dB,I: nat,J: nat] :
      ( ord_less(nat,J,I)
     => ( subst(var(J),U1,I) = var(J) ) ) ).

tff(fact_5_dB_Orecs_I1_J,axiom,
    ! [A: $tType,Nat2: nat,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,var(Nat2)) = aa(nat,A,F1,Nat2) ) ).

tff(fact_6_Lambda,axiom,
    ! [R1: dB] :
      ( pp(aa(dB,bool,it,R1))
     => pp(aa(dB,bool,it,abs(R1))) ) ).

tff(fact_7_typing_OVar,axiom,
    ! [T1: type,X1: nat,Env: fun(nat,type)] :
      ( ( aa(nat,type,Env,X1) = T1 )
     => typing(Env,var(X1),T1) ) ).

tff(fact_8_typing__elims_I1_J,axiom,
    ! [T1: type,Ia: nat,E: fun(nat,type)] :
      ( typing(E,var(Ia),T1)
     => ( aa(nat,type,E,Ia) = T1 ) ) ).

tff(fact_9_beta__cases_I1_J,axiom,
    ! [T2: dB,I: nat] : ~ beta(var(I),T2) ).

tff(fact_10_subst__lift,axiom,
    ! [S2: dB,K1: nat,T2: dB] : ( subst(lift(T2,K1),S2,K1) = T2 ) ).

tff(fact_11_subst__App,axiom,
    ! [K1: nat,S2: dB,U1: dB,T2: dB] : ( subst(aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1),S2,K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,subst(T2,S2,K1)),subst(U1,S2,K1)) ) ).

tff(fact_12_dB_Osimps_I2_J,axiom,
    ! [DB24: dB,DB14: dB,DB22: dB,DB12: dB] :
      ( ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22) = aa(dB,dB,aa(dB,fun(dB,dB),app,DB14),DB24) )
    <=> ( ( DB12 = DB14 )
        & ( DB22 = DB24 ) ) ) ).

tff(fact_13_dB_Osimps_I3_J,axiom,
    ! [DB5: dB,DB4: dB] :
      ( ( abs(DB4) = abs(DB5) )
    <=> ( DB4 = DB5 ) ) ).

tff(fact_14_appL,axiom,
    ! [U1: dB,T2: dB,S2: dB] :
      ( beta(S2,T2)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S2),U1),aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1)) ) ).

tff(fact_15_appR,axiom,
    ! [U1: dB,T2: dB,S2: dB] :
      ( beta(S2,T2)
     => beta(aa(dB,dB,aa(dB,fun(dB,dB),app,U1),S2),aa(dB,dB,aa(dB,fun(dB,dB),app,U1),T2)) ) ).

tff(fact_16_abs,axiom,
    ! [T2: dB,S2: dB] :
      ( beta(S2,T2)
     => beta(abs(S2),abs(T2)) ) ).

tff(fact_17_lift_Osimps_I2_J,axiom,
    ! [K1: nat,T2: dB,S2: dB] : ( lift(aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,lift(S2,K1)),lift(T2,K1)) ) ).

tff(fact_18_dB_Osimps_I9_J,axiom,
    ! [DB23: dB,DB13: dB,DB3: dB] : ( abs(DB3) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) ) ).

tff(fact_19_dB_Osimps_I8_J,axiom,
    ! [DB3: dB,DB23: dB,DB13: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB13),DB23) != abs(DB3) ) ).

tff(fact_20_dB_Osimps_I12_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,abs(DB4)) = aa(dB,A,F3,DB4) ) ).

tff(fact_21_dB_Orecs_I3_J,axiom,
    ! [A: $tType,DB4: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,abs(DB4)) = aa(A,A,aa(dB,fun(A,A),F3,DB4),dB_rec(A,F1,F2,F3,DB4)) ) ).

tff(fact_22_dB_Osimps_I11_J,axiom,
    ! [A: $tType,DB22: dB,DB12: dB,F3: fun(dB,A),F2: fun(dB,fun(dB,A)),F1: fun(nat,A)] : ( dB_case(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22)) = aa(dB,A,aa(dB,fun(dB,A),F2,DB12),DB22) ) ).

tff(fact_23_dB_Orecs_I2_J,axiom,
    ! [A: $tType,DB22: dB,DB12: dB,F3: fun(dB,fun(A,A)),F2: fun(dB,fun(dB,fun(A,fun(A,A)))),F1: fun(nat,A)] : ( dB_rec(A,F1,F2,F3,aa(dB,dB,aa(dB,fun(dB,dB),app,DB12),DB22)) = aa(A,A,aa(A,fun(A,A),aa(dB,fun(A,fun(A,A)),aa(dB,fun(dB,fun(A,fun(A,A))),F2,DB12),DB22),dB_rec(A,F1,F2,F3,DB12)),dB_rec(A,F1,F2,F3,DB22)) ) ).

tff(fact_24_lift__preserves__beta,axiom,
    ! [I: nat,S2: dB,R1: dB] :
      ( beta(R1,S2)
     => beta(lift(R1,I),lift(S2,I)) ) ).

tff(fact_25_subject__reduction,axiom,
    ! [T5: dB,T1: type,T: dB,E: fun(nat,type)] :
      ( typing(E,T,T1)
     => ( beta(T,T5)
       => typing(E,T5,T1) ) ) ).

tff(fact_26_dB_Osimps_I5_J,axiom,
    ! [Nat: nat,DB21: dB,DB11: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) != var(Nat) ) ).

tff(fact_27_dB_Osimps_I4_J,axiom,
    ! [DB21: dB,DB11: dB,Nat: nat] : ( var(Nat) != aa(dB,dB,aa(dB,fun(dB,dB),app,DB11),DB21) ) ).

tff(fact_28_dB_Osimps_I6_J,axiom,
    ! [DB3: dB,Nat: nat] : ( var(Nat) != abs(DB3) ) ).

tff(fact_29_dB_Osimps_I7_J,axiom,
    ! [Nat: nat,DB3: dB] : ( abs(DB3) != var(Nat) ) ).

tff(fact_30_subst__preserves__beta,axiom,
    ! [I: nat,T2: dB,S2: dB,R1: dB] :
      ( beta(R1,S2)
     => beta(subst(R1,T2,I),subst(S2,T2,I)) ) ).

tff(fact_31_beta__cases_I2_J,axiom,
    ! [S2: dB,R1: dB] :
      ( beta(abs(R1),S2)
     => ~ ! [T3: dB] :
            ( ( S2 = abs(T3) )
           => ~ beta(R1,T3) ) ) ).

tff(fact_32_beta,axiom,
    ! [T2: dB,S2: dB] : beta(aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S2)),T2),subst(S2,T2,zero_zero(nat))) ).

tff(fact_33_lift__type,axiom,
    ! [U: type,Ia: nat,T1: type,T: dB,E: fun(nat,type)] :
      ( typing(E,T,T1)
     => typing(shift(type,E,Ia,U),lift(T,Ia),T1) ) ).

tff(fact_34_dB_Oexhaust,axiom,
    ! [Y: dB] :
      ( ! [Nat1: nat] : ( Y != var(Nat1) )
     => ( ! [DB1: dB,DB2: dB] : ( Y != aa(dB,dB,aa(dB,fun(dB,dB),app,DB1),DB2) )
       => ~ ! [DB: dB] : ( Y != abs(DB) ) ) ) ).

tff(fact_35_App,axiom,
    ! [T: dB,U: type,T1: type,S1: dB,Env: fun(nat,type)] :
      ( typing(Env,S1,fun1(T1,U))
     => ( typing(Env,T,T1)
       => typing(Env,aa(dB,dB,aa(dB,fun(dB,dB),app,S1),T),U) ) ) ).

tff(fact_36_substn_Osimps_I2_J,axiom,
    ! [K1: nat,S2: dB,U1: dB,T2: dB] : ( substn(aa(dB,dB,aa(dB,fun(dB,dB),app,T2),U1),S2,K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,substn(T2,S2,K1)),substn(U1,S2,K1)) ) ).

tff(fact_37_subst__lemma,axiom,
    ! [Ia: nat,U: type,U3: dB,E1: fun(nat,type),T1: type,T: dB,E: fun(nat,type)] :
      ( typing(E,T,T1)
     => ( typing(E1,U3,U)
       => ( ( E = shift(type,E1,Ia,U) )
         => typing(E1,subst(T,U3,Ia),T1) ) ) ) ).

tff(fact_38_less__not__refl,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_39_nat__neq__iff,axiom,
    ! [N1: nat,M1: nat] :
      ( ( M1 != N1 )
    <=> ( ord_less(nat,M1,N1)
        | ord_less(nat,N1,M1) ) ) ).

tff(fact_40_type_Osimps_I2_J,axiom,
    ! [Type21: type,Type11: type,Type2: type,Type1: type] :
      ( ( fun1(Type1,Type2) = fun1(Type11,Type21) )
    <=> ( ( Type1 = Type11 )
        & ( Type2 = Type21 ) ) ) ).

tff(fact_41_less__zeroE,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_42_less__nat__zero__code,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_43_neq0__conv,axiom,
    ! [N1: nat] :
      ( ( N1 != zero_zero(nat) )
    <=> ord_less(nat,zero_zero(nat),N1) ) ).

tff(fact_44_Abs,axiom,
    ! [U: type,T: dB,T1: type,Env: fun(nat,type)] :
      ( typing(shift(type,Env,zero_zero(nat),T1),T,U)
     => typing(Env,abs(T),fun1(T1,U)) ) ).

tff(fact_45_shift__eq,axiom,
    ! [A: $tType,T1: A,E: fun(nat,A),Ja: nat,Ia: nat] :
      ( ( Ia = Ja )
     => ( aa(nat,A,shift(A,E,Ia,T1),Ja) = T1 ) ) ).

tff(fact_46_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero(nat) )
     => ord_less(nat,zero_zero(nat),N) ) ).

tff(fact_47_gr__implies__not0,axiom,
    ! [N: nat,M: nat] :
      ( ord_less(nat,M,N)
     => ( N != zero_zero(nat) ) ) ).

tff(fact_48_not__less0,axiom,
    ! [N: nat] : ~ ord_less(nat,N,zero_zero(nat)) ).

tff(fact_49_substn__subst__0,axiom,
    ! [S2: dB,T2: dB] : ( substn(T2,S2,zero_zero(nat)) = subst(T2,S2,zero_zero(nat)) ) ).

tff(fact_50_shift__gt,axiom,
    ! [A: $tType,T1: A,E: fun(nat,A),Ia: nat,Ja: nat] :
      ( ord_less(nat,Ja,Ia)
     => ( aa(nat,A,shift(A,E,Ia,T1),Ja) = aa(nat,A,E,Ja) ) ) ).

tff(fact_51_nat__less__cases,axiom,
    ! [P: fun(nat,fun(nat,bool)),N1: nat,M1: nat] :
      ( ( ord_less(nat,M1,N1)
       => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
     => ( ( ( M1 = N1 )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
       => ( ( ord_less(nat,N1,M1)
           => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) )
         => pp(aa(nat,bool,aa(nat,fun(nat,bool),P,N1),M1)) ) ) ) ).

tff(fact_52_less__not__refl3,axiom,
    ! [T2: nat,S2: nat] :
      ( ord_less(nat,S2,T2)
     => ( S2 != T2 ) ) ).

tff(fact_53_less__not__refl2,axiom,
    ! [M: nat,N: nat] :
      ( ord_less(nat,N,M)
     => ( M != N ) ) ).

tff(fact_54_less__irrefl__nat,axiom,
    ! [N: nat] : ~ ord_less(nat,N,N) ).

tff(fact_55_linorder__neqE__nat,axiom,
    ! [Y: nat,X2: nat] :
      ( ( X2 != Y )
     => ( ~ ord_less(nat,X2,Y)
       => ord_less(nat,Y,X2) ) ) ).

tff(fact_56_typing__elims_I3_J,axiom,
    ! [T1: type,T: dB,E: fun(nat,type)] :
      ( typing(E,abs(T),T1)
     => ~ ! [T4: type,U2: type] :
            ( ( T1 = fun1(T4,U2) )
           => ~ typing(shift(type,E,zero_zero(nat),T4),T,U2) ) ) ).

tff(fact_57_typing__elims_I2_J,axiom,
    ! [T1: type,U3: dB,T: dB,E: fun(nat,type)] :
      ( typing(E,aa(dB,dB,aa(dB,fun(dB,dB),app,T),U3),T1)
     => ~ ! [T4: type] :
            ( typing(E,T,fun1(T4,T1))
           => ~ typing(E,U3,T4) ) ) ).

tff(fact_58_abs__typeE,axiom,
    ! [T1: type,T: dB,E: fun(nat,type)] :
      ( typing(E,abs(T),T1)
     => ~ ! [U2: type,V: type] : ~ typing(shift(type,E,zero_zero(nat),U2),T,V) ) ).

tff(fact_59_substn__subst__n,axiom,
    ! [N: nat,S2: dB,T2: dB] : ( substn(T2,S2,N) = subst(T2,liftn(N,S2,zero_zero(nat)),N) ) ).

tff(fact_60_beta__cases_I3_J,axiom,
    ! [U1: dB,T2: dB,S2: dB] :
      ( beta(aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2),U1)
     => ( ! [S3: dB] :
            ( ( U1 = subst(S3,T2,zero_zero(nat)) )
           => ( S2 != abs(S3) ) )
       => ( ! [T3: dB] :
              ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,T3),T2) )
             => ~ beta(S2,T3) )
         => ~ ! [T3: dB] :
                ( ( U1 = aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T3) )
               => ~ beta(T2,T3) ) ) ) ) ).

tff(fact_61_liftn_Osimps_I2_J,axiom,
    ! [K1: nat,T2: dB,S2: dB,N: nat] : ( liftn(N,aa(dB,dB,aa(dB,fun(dB,dB),app,S2),T2),K1) = aa(dB,dB,aa(dB,fun(dB,dB),app,liftn(N,S2,K1)),liftn(N,T2,K1)) ) ).

tff(fact_62_liftn__0,axiom,
    ! [K1: nat,T2: dB] : ( liftn(zero_zero(nat),T2,K1) = T2 ) ).

tff(fact_63_dB_Osize_I1_J,axiom,
    ! [Nat: nat] : ( dB_size(var(Nat)) = zero_zero(nat) ) ).

tff(fact_64_Beta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( pp(aa(dB,bool,it,foldl(dB,dB,app,subst(Ra,S1,zero_zero(nat)),Ss1)))
     => ( pp(aa(dB,bool,it,S1))
       => pp(aa(dB,bool,it,foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(Ra)),S1),Ss1))) ) ) ).

tff(fact_65_var__app__type__eq,axiom,
    ! [U: type,T1: type,Ts: list(dB),Ia: nat,E: fun(nat,type)] :
      ( typing(E,foldl(dB,dB,app,var(Ia),Ts),T1)
     => ( typing(E,foldl(dB,dB,app,var(Ia),Ts),U)
       => ( T1 = U ) ) ) ).

tff(fact_66_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_67_Abs__apps__eq__Abs__apps__conv,axiom,
    ! [Ss1: list(dB),S1: dB,Rs1: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,abs(Ra),Rs1) = foldl(dB,dB,app,abs(S1),Ss1) )
    <=> ( ( Ra = S1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_68_Var__apps__eq__Var__apps__conv,axiom,
    ! [Ss1: list(dB),N1: nat,Rs1: list(dB),M1: nat] :
      ( ( foldl(dB,dB,app,var(M1),Rs1) = foldl(dB,dB,app,var(N1),Ss1) )
    <=> ( ( M1 = N1 )
        & ( Rs1 = Ss1 ) ) ) ).

tff(fact_69_apps__eq__tail__conv,axiom,
    ! [S1: dB,Ts: list(dB),Ra: dB] :
      ( ( foldl(dB,dB,app,Ra,Ts) = foldl(dB,dB,app,S1,Ts) )
    <=> ( Ra = S1 ) ) ).

tff(fact_70_Abs__App__neq__Var__apps,axiom,
    ! [Ss1: list(dB),N1: nat,T: dB,S1: dB] : ( aa(dB,dB,aa(dB,fun(dB,dB),app,abs(S1)),T) != foldl(dB,dB,app,var(N1),Ss1) ) ).

tff(fact_71_Var__apps__neq__Abs__apps,axiom,
    ! [Ss1: list(dB),Ra: dB,Ts: list(dB),N1: nat] : ( foldl(dB,dB,app,var(N1),Ts) != foldl(dB,dB,app,abs(Ra),Ss1) ) ).

tff(fact_72_apps__preserves__beta,axiom,
    ! [Ss1: list(dB),S1: dB,Ra: dB] :
      ( beta(Ra,S1)
     => beta(foldl(dB,dB,app,Ra,Ss1),foldl(dB,dB,app,S1,Ss1)) ) ).

tff(fact_73_IT_OVar,axiom,
    ! [N1: nat,Rs1: list(dB)] :
      ( listsp(dB,it,Rs1)
     => pp(aa(dB,bool,it,foldl(dB,dB,app,var(N1),Rs1))) ) ).

tff(fact_74_ext,axiom,
    ! [B2: $tType,A: $tType,G: fun(A,B2),F: fun(A,B2)] :
      ( ! [X: A] : ( aa(A,B2,F,X) = aa(A,B2,G,X) )
     => ( F = G ) ) ).

tff(fact_75_type_Osimps_I6_J,axiom,
    ! [A: $tType,Type2: type,Type1: type,F2: fun(type,fun(type,A)),F1: fun(nat,A)] : ( type_case(A,F1,F2,fun1(Type1,Type2)) = aa(type,A,aa(type,fun(type,A),F2,Type1),Type2) ) ).

tff(fact_76_IT_Osimps,axiom,
    ! [A2: dB] :
      ( pp(aa(dB,bool,it,A2))
    <=> ( ? [Rs: list(dB),N2: nat] :
            ( ( A2 = foldl(dB,dB,app,var(N2),Rs) )
            & listsp(dB,it,Rs) )
        | ? [R: dB] :
            ( ( A2 = abs(R) )
            & pp(aa(dB,bool,it,R)) )
        | ? [R: dB,S: dB,Ss: list(dB)] :
            ( ( A2 = foldl(dB,dB,app,aa(dB,dB,aa(dB,fun(dB,dB),app,abs(R)),S),Ss) )
            & pp(aa(dB,bool,it,foldl(dB,dB,app,subst(R,S,zero_zero(nat)),Ss)))
            & pp(aa(dB,bool,it,S)) ) ) ) ).

tff(fact_77_dB_Osize_I4_J,axiom,
    ! [Nat: nat] : ( size_size(dB,var(Nat)) = zero_zero(nat) ) ).

tff(fact_78_of__nat__0__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat] :
          ( ord_less(A,zero_zero(A),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,zero_zero(nat),N1) ) ) ).

tff(fact_79_liftn_Osimps_I1_J,axiom,
    ! [N: nat,K1: nat,I: nat] :
      ( ( ord_less(nat,I,K1)
       => ( liftn(N,var(I),K1) = var(I) ) )
      & ( ~ ord_less(nat,I,K1)
       => ( liftn(N,var(I),K1) = var(plus_plus(nat,I,N)) ) ) ) ).

tff(fact_80_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,B1: A,A2: A] :
          ( ( plus_plus(A,A2,B1) = plus_plus(A,A2,C) )
        <=> ( B1 = C ) ) ) ).

tff(fact_81_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C: A,A2: A,B1: A] :
          ( ( plus_plus(A,B1,A2) = plus_plus(A,C,A2) )
        <=> ( B1 = C ) ) ) ).

tff(fact_82_nat__add__left__cancel,axiom,
    ! [N1: nat,M1: nat,K: nat] :
      ( ( plus_plus(nat,K,M1) = plus_plus(nat,K,N1) )
    <=> ( M1 = N1 ) ) ).

tff(fact_83_nat__add__right__cancel,axiom,
    ! [N1: nat,K: nat,M1: nat] :
      ( ( plus_plus(nat,M1,K) = plus_plus(nat,N1,K) )
    <=> ( M1 = N1 ) ) ).

tff(fact_84_of__nat__eq__iff,axiom,
    ! [A: $tType] :
      ( semiring_char_0(A)
     => ! [N1: nat,M1: nat] :
          ( ( semiring_1_of_nat(A,M1) = semiring_1_of_nat(A,N1) )
        <=> ( M1 = N1 ) ) ) ).

tff(fact_85_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = plus_plus(A,A2,A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_86_add__less__cancel__left,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,A2: A,C: A] :
          ( ord_less(A,plus_plus(A,C,A2),plus_plus(A,C,B1))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_87_add__less__cancel__right,axiom,
    ! [A: $tType] :
      ( ordere236663937imp_le(A)
     => ! [B1: A,C: A,A2: A] :
          ( ord_less(A,plus_plus(A,A2,C),plus_plus(A,B1,C))
        <=> ord_less(A,A2,B1) ) ) ).

tff(fact_88_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( plus_plus(nat,M1,N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_89_nat__add__left__cancel__less,axiom,
    ! [N1: nat,M1: nat,K: nat] :
      ( ord_less(nat,plus_plus(nat,K,M1),plus_plus(nat,K,N1))
    <=> ord_less(nat,M1,N1) ) ).

tff(fact_90_zero__less__double__add__iff__zero__less__single__add,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,zero_zero(A),plus_plus(A,A2,A2))
        <=> ord_less(A,zero_zero(A),A2) ) ) ).

tff(fact_91_double__add__less__zero__iff__single__add__less__zero,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ord_less(A,plus_plus(A,A2,A2),zero_zero(A))
        <=> ord_less(A,A2,zero_zero(A)) ) ) ).

tff(fact_92_of__nat__0,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ( semiring_1_of_nat(A,zero_zero(nat)) = zero_zero(A) ) ) ).

tff(fact_93_of__nat__less__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [N1: nat,M1: nat] :
          ( ord_less(A,semiring_1_of_nat(A,M1),semiring_1_of_nat(A,N1))
        <=> ord_less(nat,M1,N1) ) ) ).

tff(fact_94_add__gr__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ord_less(nat,zero_zero(nat),plus_plus(nat,M1,N1))
    <=> ( ord_less(nat,zero_zero(nat),M1)
        | ord_less(nat,zero_zero(nat),N1) ) ) ).

tff(fact_95_of__nat__add,axiom,
    ! [A: $tType] :
      ( semiring_1(A)
     => ! [N: nat,M: nat] : ( semiring_1_of_nat(A,plus_plus(nat,M,N)) = plus_plus(A,semiring_1_of_nat(A,M),semiring_1_of_nat(A,N)) ) ) ).

tff(fact_96_add__pos__pos,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,zero_zero(A),A1)
         => ( ord_less(A,zero_zero(A),B)
           => ord_less(A,zero_zero(A),plus_plus(A,A1,B)) ) ) ) ).

tff(fact_97_add__neg__neg,axiom,
    ! [A: $tType] :
      ( ordere216010020id_add(A)
     => ! [B: A,A1: A] :
          ( ord_less(A,A1,zero_zero(A))
         => ( ord_less(A,B,zero_zero(A))
           => ord_less(A,plus_plus(A,A1,B),zero_zero(A)) ) ) ) ).

tff(fact_98_of__nat__less__0__iff,axiom,
    ! [A: $tType] :
      ( linordered_semidom(A)
     => ! [M: nat] : ~ ord_less(A,semiring_1_of_nat(A,M),zero_zero(A)) ) ).

%----Arities (7)
tff(arity_Nat_Onat___Groups_Oordered__ab__semigroup__add__imp__le,axiom,
    ordere236663937imp_le(nat) ).

tff(arity_Nat_Onat___Groups_Oordered__comm__monoid__add,axiom,
    ordere216010020id_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Olinordered__semidom,axiom,
    linordered_semidom(nat) ).

tff(arity_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__1,axiom,
    semiring_1(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (2)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    pp(aa(dB,bool,it,r)) ).

tff(conj_1,conjecture,
    pp(aa(dB,bool,it,subst(r,var(i),j))) ).

%------------------------------------------------------------------------------
