%------------------------------------------------------------------------------
% File     : LCL749_5 : TPTP v9.2.0. Released v6.0.0.
% Domain   : Logic Calculi
% Problem  : Strong normalization of typed lambda calculus line 35
% Version  : Especial.
% English  : 

% Refs     : [BN10]  Boehme & Nipkow (2010), Sledgehammer: Judgement Day
%          : [Bla13] Blanchette (2011), Email to Geoff Sutcliffe
% Source   : [Bla13]
% Names    : sn_35 [Bla13]

% Status   : Unknown
% Rating   : 1.00 v6.4.0
% Syntax   : Number of formulae    :  184 (  55 unt;  55 typ;   0 def)
%            Number of atoms       :  237 ( 147 equ)
%            Maximal formula atoms :    5 (   1 avg)
%            Number of connectives :  120 (  12   ~;  11   |;   5   &)
%                                         (  21 <=>;  71  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   4 avg)
%            Maximal term depth    :    8 (   2 avg)
%            Number of types       :    7 (   6 usr)
%            Number of type conns  :   24 (  16   >;   8   *;   0   +;   0  <<)
%            Number of predicates  :   24 (  23 usr;   0 prp; 1-3 aty)
%            Number of functors    :   26 (  26 usr;   6 con; 0-5 aty)
%            Number of variables   :  356 ( 311   !;   0   ?; 356   :)
%                                         (  45  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TF1_UNK_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2011-12-13 16:15:24
%------------------------------------------------------------------------------
%----Should-be-implicit typings (8)
tff(ty_tc_HOL_Obool,type,
    bool: $tType ).

tff(ty_tc_Lambda_OdB,type,
    dB: $tType ).

tff(ty_tc_List_Olist,type,
    list: $tType > $tType ).

tff(ty_tc_Nat_Onat,type,
    nat: $tType ).

tff(ty_tc_String_Ochar,type,
    char1: $tType ).

tff(ty_tc_String_Oliteral,type,
    literal: $tType ).

tff(ty_tc_String_Onibble,type,
    nibble: $tType ).

tff(ty_tc_fun,type,
    fun: ( $tType * $tType ) > $tType ).

%----Explicit typings (47)
tff(sy_cl_Rings_Oring,type,
    ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring,type,
    semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__ring,type,
    comm_ring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Omult__zero,type,
    mult_zero: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ogroup__add,type,
    group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Osemiring__0,type,
    semiring_0: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Omonoid__add,type,
    monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__group__add,type,
    ab_group_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring,type,
    comm_semiring: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocomm__monoid__add,type,
    comm_monoid_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Ono__zero__divisors,type,
    no_zero_divisors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__add,type,
    ab_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Oab__semigroup__mult,type,
    ab_semigroup_mult: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__semigroup__add,type,
    cancel_semigroup_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

tff(sy_cl_Rings_Olinordered__ring__strict,type,
    linord581940658strict: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Ocancel__ab__semigroup__add,type,
    cancel146912293up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Groups_Olinordered__ab__group__add,type,
    linord219039673up_add: 
      !>[A: $tType] : $o ).

tff(sy_cl_Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,type,
    semiri456707255roduct: 
      !>[A: $tType] : $o ).

tff(sy_c_COMBB,type,
    combb: 
      !>[B: $tType,C: $tType,A: $tType] : ( ( fun(B,C) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_COMBC,type,
    combc: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * B ) > fun(A,C) ) ).

tff(sy_c_COMBI,type,
    combi: 
      !>[A: $tType] : fun(A,A) ).

tff(sy_c_COMBK,type,
    combk: 
      !>[A: $tType,B: $tType] : ( A > fun(B,A) ) ).

tff(sy_c_COMBS,type,
    combs: 
      !>[A: $tType,B: $tType,C: $tType] : ( ( fun(A,fun(B,C)) * fun(A,B) ) > fun(A,C) ) ).

tff(sy_c_Groups_Ominus__class_Ominus,type,
    minus_minus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Oplus__class_Oplus,type,
    plus_plus: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Otimes__class_Otimes,type,
    times_times: 
      !>[A: $tType] : fun(A,fun(A,A)) ).

tff(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

tff(sy_c_HOL_Obool_Obool__size,type,
    bool_size: bool > nat ).

tff(sy_c_InductTermi_OIT,type,
    it: fun(dB,bool) ).

tff(sy_c_Lambda_Olift,type,
    lift: fun(dB,fun(nat,dB)) ).

tff(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : list(A) ).

tff(sy_c_List_Olistsp,type,
    listsp: 
      !>[A: $tType] : ( ( fun(A,bool) * list(A) ) > $o ) ).

tff(sy_c_List_Omap,type,
    map: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * list(A) ) > list(B) ) ).

tff(sy_c_List_Omonoid__add__class_Olistsum,type,
    monoid_add_listsum: 
      !>[A: $tType] : ( list(A) > A ) ).

tff(sy_c_Nat_Onat_Onat__size,type,
    nat_size: nat > nat ).

tff(sy_c_Nat_Osize__class_Osize,type,
    size_size: 
      !>[A: $tType] : ( A > nat ) ).

tff(sy_c_String_Ochar_OChar,type,
    char: ( nibble * nibble ) > char1 ).

tff(sy_c_String_Ochar_Ochar__size,type,
    char_size: char1 > nat ).

tff(sy_c_aa,type,
    aa: 
      !>[A: $tType,B: $tType] : ( ( fun(A,B) * A ) > B ) ).

tff(sy_c_fFalse,type,
    fFalse: bool ).

tff(sy_c_fTrue,type,
    fTrue: bool ).

tff(sy_c_fconj,type,
    fconj: fun(bool,fun(bool,bool)) ).

tff(sy_c_pp,type,
    pp: bool > $o ).

tff(sy_v_ts,type,
    ts: list(dB) ).

%----Relevant facts (99)
tff(fact_0_lift__IT,axiom,
    ! [I: nat,T: dB] :
      ( pp(aa(dB,bool,it,T))
     => pp(aa(dB,bool,it,aa(nat,dB,aa(dB,fun(nat,dB),lift,T),I))) ) ).

tff(fact_1_listsp__conj__eq,axiom,
    ! [A: $tType,B3: fun(A,bool),A3: fun(A,bool),X3: list(A)] :
      ( listsp(A,combs(A,bool,bool,combb(bool,fun(bool,bool),A,fconj,A3),B3),X3)
    <=> ( listsp(A,A3,X3)
        & listsp(A,B3,X3) ) ) ).

tff(fact_2_map__ident,axiom,
    ! [A: $tType,X3: list(A)] : ( map(A,A,combi(A),X3) = X3 ) ).

tff(fact_3_zero__reorient,axiom,
    ! [A: $tType] :
      ( zero(A)
     => ! [X1: A] :
          ( ( zero_zero(A) = X1 )
        <=> ( X1 = zero_zero(A) ) ) ) ).

tff(fact_4_bool_Osize_I1_J,axiom,
    bool_size(fTrue) = zero_zero(nat) ).

tff(fact_5_bool_Osize_I2_J,axiom,
    bool_size(fFalse) = zero_zero(nat) ).

tff(fact_6_char__size,axiom,
    ! [C1: char1] : ( char_size(C1) = zero_zero(nat) ) ).

tff(fact_7_listsum__0,axiom,
    ! [B: $tType,A: $tType] :
      ( monoid_add(A)
     => ! [Xs: list(B)] : ( monoid_add_listsum(A,map(B,A,combk(A,B,zero_zero(A)),Xs)) = zero_zero(A) ) ) ).

tff(fact_8_nat_Osize_I1_J,axiom,
    nat_size(zero_zero(nat)) = zero_zero(nat) ).

tff(fact_9_size__char,axiom,
    ! [C1: char1] : ( size_size(char1,C1) = zero_zero(nat) ) ).

tff(fact_10_bool_Osize_I3_J,axiom,
    size_size(bool,fTrue) = zero_zero(nat) ).

tff(fact_11_bool_Osize_I4_J,axiom,
    size_size(bool,fFalse) = zero_zero(nat) ).

tff(fact_12_size__bool,axiom,
    ! [B1: bool] : ( size_size(bool,B1) = zero_zero(nat) ) ).

tff(fact_13_size__literal__def,axiom,
    ! [S: literal] : ( size_size(literal,S) = zero_zero(nat) ) ).

tff(fact_14_nat_Osize_I3_J,axiom,
    size_size(nat,zero_zero(nat)) = zero_zero(nat) ).

tff(fact_15_char_Osize_I2_J,axiom,
    ! [Nibble22: nibble,Nibble12: nibble] : ( size_size(char1,char(Nibble12,Nibble22)) = zero_zero(nat) ) ).

tff(fact_16_char_Osize_I1_J,axiom,
    ! [Nibble22: nibble,Nibble12: nibble] : ( char_size(char(Nibble12,Nibble22)) = zero_zero(nat) ) ).

tff(fact_17_listsum__simps_I1_J,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ( monoid_add_listsum(A,nil(A)) = zero_zero(A) ) ) ).

tff(fact_18_listsum__mult__const,axiom,
    ! [B: $tType,A: $tType] :
      ( semiring_0(A)
     => ! [Xs: list(B),C2: A,F: fun(B,A)] : ( monoid_add_listsum(A,map(B,A,combc(B,A,A,combb(A,fun(A,A),B,times_times(A),F),C2),Xs)) = aa(A,A,aa(A,fun(A,A),times_times(A),monoid_add_listsum(A,map(B,A,F,Xs))),C2) ) ) ).

tff(fact_19_listsum__const__mult,axiom,
    ! [A: $tType,B: $tType] :
      ( semiring_0(A)
     => ! [Xs: list(B),F: fun(B,A),C2: A] : ( monoid_add_listsum(A,map(B,A,combb(A,A,B,aa(A,fun(A,A),times_times(A),C2),F),Xs)) = aa(A,A,aa(A,fun(A,A),times_times(A),C2),monoid_add_listsum(A,map(B,A,F,Xs))) ) ) ).

tff(fact_20_listsum__addf,axiom,
    ! [A: $tType,B: $tType] :
      ( comm_monoid_add(A)
     => ! [Xs: list(B),G: fun(B,A),F: fun(B,A)] : ( monoid_add_listsum(A,map(B,A,combs(B,A,A,combb(A,fun(A,A),B,plus_plus(A),F),G),Xs)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),monoid_add_listsum(A,map(B,A,F,Xs))),monoid_add_listsum(A,map(B,A,G,Xs))) ) ) ).

tff(fact_21_listsum__subtractf,axiom,
    ! [A: $tType,B: $tType] :
      ( ab_group_add(A)
     => ! [Xs: list(B),G: fun(B,A),F: fun(B,A)] : ( monoid_add_listsum(A,map(B,A,combs(B,A,A,combb(A,fun(A,A),B,minus_minus(A),F),G),Xs)) = aa(A,A,aa(A,fun(A,A),minus_minus(A),monoid_add_listsum(A,map(B,A,F,Xs))),monoid_add_listsum(A,map(B,A,G,Xs))) ) ) ).

tff(fact_22_add__left__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,B1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),B1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),C2) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_23_add__right__cancel,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C2: A,A2: A,B1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C2),A2) )
        <=> ( B1 = C2 ) ) ) ).

tff(fact_24_char_Oinject,axiom,
    ! [Nibble21: nibble,Nibble11: nibble,Nibble2: nibble,Nibble1: nibble] :
      ( ( char(Nibble1,Nibble2) = char(Nibble11,Nibble21) )
    <=> ( ( Nibble1 = Nibble11 )
        & ( Nibble2 = Nibble21 ) ) ) ).

tff(fact_25_double__zero__sym,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( zero_zero(A) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_26_diff__self,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),A1) = zero_zero(A) ) ) ).

tff(fact_27_Nil__is__map__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( nil(A) = map(B,A,F,Xs) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_28_map_Osimps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: fun(B,A)] : ( map(B,A,F,nil(B)) = nil(A) ) ).

tff(fact_29_map__is__Nil__conv,axiom,
    ! [A: $tType,B: $tType,Xs: list(B),F: fun(B,A)] :
      ( ( map(B,A,F,Xs) = nil(A) )
    <=> ( Xs = nil(B) ) ) ).

tff(fact_30_listsp_ONil,axiom,
    ! [A: $tType,A3: fun(A,bool)] : listsp(A,A3,nil(A)) ).

tff(fact_31_diff__add__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),B2)),B2) = A1 ) ) ).

tff(fact_32_add__diff__cancel,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),B2) = A1 ) ) ).

tff(fact_33_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_34_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: $tType] :
      ( ab_semigroup_mult(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),times_times(A),A1),aa(A,A,aa(A,fun(A,A),times_times(A),B2),C1)) ) ) ).

tff(fact_35_add__left__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_36_add__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel146912293up_add(A)
     => ! [C1: A,B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_37_add__right__imp__eq,axiom,
    ! [A: $tType] :
      ( cancel_semigroup_add(A)
     => ! [C1: A,A1: A,B2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),A1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) )
         => ( B2 = C1 ) ) ) ).

tff(fact_38_diff__eq__diff__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [D1: A,C2: A,B1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B1) = aa(A,A,aa(A,fun(A,A),minus_minus(A),C2),D1) )
         => ( ( A2 = B1 )
          <=> ( C2 = D1 ) ) ) ) ).

tff(fact_39_nat__size,axiom,
    ! [N: nat] : ( size_size(nat,N) = N ) ).

tff(fact_40_diff__0__right,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_41_eq__iff__diff__eq__0,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A2: A] :
          ( ( A2 = B1 )
        <=> ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B1) = zero_zero(A) ) ) ) ).

tff(fact_42_right__minus__eq,axiom,
    ! [A: $tType] :
      ( group_add(A)
     => ! [B1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B1) = zero_zero(A) )
        <=> ( A2 = B1 ) ) ) ).

tff(fact_43_add__0__left,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_44_add__0,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_45_add__0__right,axiom,
    ! [A: $tType] :
      ( monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_46_add_Ocomm__neutral,axiom,
    ! [A: $tType] :
      ( comm_monoid_add(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_47_mult__zero__left,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),zero_zero(A)),A1) = zero_zero(A) ) ) ).

tff(fact_48_mult__zero__right,axiom,
    ! [A: $tType] :
      ( mult_zero(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),zero_zero(A)) = zero_zero(A) ) ) ).

tff(fact_49_mult__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ring_n68954251visors(A)
     => ! [B1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),times_times(A),A2),B1) = zero_zero(A) )
        <=> ( ( A2 = zero_zero(A) )
            | ( B1 = zero_zero(A) ) ) ) ) ).

tff(fact_50_double__eq__0__iff,axiom,
    ! [A: $tType] :
      ( linord219039673up_add(A)
     => ! [A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A2),A2) = zero_zero(A) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_51_eq__add__iff1,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [D1: A,B1: A,C2: A,E1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A2),E1)),C2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),B1),E1)),D1) )
        <=> ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),A2),B1)),E1)),C2) = D1 ) ) ) ).

tff(fact_52_eq__add__iff2,axiom,
    ! [A: $tType] :
      ( ring(A)
     => ! [D1: A,B1: A,C2: A,E1: A,A2: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A2),E1)),C2) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),B1),E1)),D1) )
        <=> ( C2 = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),minus_minus(A),B1),A2)),E1)),D1) ) ) ) ).

tff(fact_53_square__diff__square__factored,axiom,
    ! [A: $tType] :
      ( comm_ring(A)
     => ! [Y1: A,X2: A] : ( aa(A,A,aa(A,fun(A,A),minus_minus(A),aa(A,A,aa(A,fun(A,A),times_times(A),X2),X2)),aa(A,A,aa(A,fun(A,A),times_times(A),Y1),Y1)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),X2),Y1)),aa(A,A,aa(A,fun(A,A),minus_minus(A),X2),Y1)) ) ) ).

tff(fact_54_no__zero__divisors,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B2: A,A1: A] :
          ( ( A1 != zero_zero(A) )
         => ( ( B2 != zero_zero(A) )
           => ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),B2) != zero_zero(A) ) ) ) ) ).

tff(fact_55_divisors__zero,axiom,
    ! [A: $tType] :
      ( no_zero_divisors(A)
     => ! [B2: A,A1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),B2) = zero_zero(A) )
         => ( ( A1 = zero_zero(A) )
            | ( B2 = zero_zero(A) ) ) ) ) ).

tff(fact_56_comm__semiring__class_Odistrib,axiom,
    ! [A: $tType] :
      ( comm_semiring(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),C1)),aa(A,A,aa(A,fun(A,A),times_times(A),B2),C1)) ) ) ).

tff(fact_57_combine__common__factor,axiom,
    ! [A: $tType] :
      ( semiring(A)
     => ! [C1: A,B2: A,E: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),A1),E)),aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),B2),E)),C1)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),E)),C1) ) ) ).

tff(fact_58_add__scale__eq__noteq,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [D: A,C1: A,B2: A,A1: A,R1: A] :
          ( ( R1 != zero_zero(A) )
         => ( ( ( A1 = B2 )
              & ( C1 != D ) )
           => ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),times_times(A),R1),C1)) != aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),aa(A,A,aa(A,fun(A,A),times_times(A),R1),D)) ) ) ) ) ).

tff(fact_59_sum__squares__eq__zero__iff,axiom,
    ! [A: $tType] :
      ( linord581940658strict(A)
     => ! [Y: A,X1: A] :
          ( ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),times_times(A),X1),X1)),aa(A,A,aa(A,fun(A,A),times_times(A),Y),Y)) = zero_zero(A) )
        <=> ( ( X1 = zero_zero(A) )
            & ( Y = zero_zero(A) ) ) ) ) ).

tff(fact_60_mult__cancel2,axiom,
    ! [N1: nat,K1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),K1) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N1),K1) )
    <=> ( ( M1 = N1 )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_61_mult__cancel1,axiom,
    ! [N1: nat,M1: nat,K1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),M1) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K1),N1) )
    <=> ( ( M1 = N1 )
        | ( K1 = zero_zero(nat) ) ) ) ).

tff(fact_62_diff__0__eq__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_63_diff__self__eq__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),M) = zero_zero(nat) ) ).

tff(fact_64_add__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M1),N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        & ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_65_mult__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),zero_zero(nat)),N) = zero_zero(nat) ) ).

tff(fact_66_mult__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),zero_zero(nat)) = zero_zero(nat) ) ).

tff(fact_67_mult__is__0,axiom,
    ! [N1: nat,M1: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M1),N1) = zero_zero(nat) )
    <=> ( ( M1 = zero_zero(nat) )
        | ( N1 = zero_zero(nat) ) ) ) ).

tff(fact_68_nat__mult__commute,axiom,
    ! [N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),M) ) ).

tff(fact_69_add__mult__distrib2,axiom,
    ! [N: nat,M: nat,K: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),N)) ) ).

tff(fact_70_diff__mult__distrib2,axiom,
    ! [N: nat,M: nat,K: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N)) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),M)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),K),N)) ) ).

tff(fact_71_nat__mult__assoc,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_72_add__mult__distrib,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_73_diff__mult__distrib,axiom,
    ! [K: nat,N: nat,M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N)),K) = aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),M),K)),aa(nat,nat,aa(nat,fun(nat,nat),times_times(nat),N),K)) ) ).

tff(fact_74_ext,axiom,
    ! [B: $tType,A: $tType,G: fun(A,B),F: fun(A,B)] :
      ( ! [X: A] : ( aa(A,B,F,X) = aa(A,B,G,X) )
     => ( F = G ) ) ).

tff(fact_75_comm__semiring__1__class_Onormalizing__semiring__rules_I20_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),D)) ) ) ).

tff(fact_76_comm__semiring__1__class_Onormalizing__semiring__rules_I23_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),B2) ) ) ).

tff(fact_77_comm__semiring__1__class_Onormalizing__semiring__rules_I21_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),B2)),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),B2),C1)) ) ) ).

tff(fact_78_comm__semiring__1__class_Onormalizing__semiring__rules_I25_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1)),D) ) ) ).

tff(fact_79_comm__semiring__1__class_Onormalizing__semiring__rules_I22_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [D: A,C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),D)) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),D)) ) ) ).

tff(fact_80_comm__semiring__1__class_Onormalizing__semiring__rules_I24_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [C1: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),C1) = aa(A,A,aa(A,fun(A,A),plus_plus(A),C1),A1) ) ) ).

tff(fact_81_comm__semiring__1__class_Onormalizing__semiring__rules_I13_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Ry)) ) ) ).

tff(fact_82_comm__semiring__1__class_Onormalizing__semiring__rules_I15_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Ry)) ) ) ).

tff(fact_83_comm__semiring__1__class_Onormalizing__semiring__rules_I14_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry))) ) ) ).

tff(fact_84_comm__semiring__1__class_Onormalizing__semiring__rules_I16_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ly) ) ) ).

tff(fact_85_comm__semiring__1__class_Onormalizing__semiring__rules_I17_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Rx: A,Ly: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ly)),Rx) = aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Ly),Rx)) ) ) ).

tff(fact_86_comm__semiring__1__class_Onormalizing__semiring__rules_I18_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Rx)),Ry) ) ) ).

tff(fact_87_comm__semiring__1__class_Onormalizing__semiring__rules_I19_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [Ry: A,Rx: A,Lx: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),Lx),aa(A,A,aa(A,fun(A,A),times_times(A),Rx),Ry)) = aa(A,A,aa(A,fun(A,A),times_times(A),Rx),aa(A,A,aa(A,fun(A,A),times_times(A),Lx),Ry)) ) ) ).

tff(fact_88_comm__semiring__1__class_Onormalizing__semiring__rules_I7_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [B2: A,A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),B2) = aa(A,A,aa(A,fun(A,A),times_times(A),B2),A1) ) ) ).

tff(fact_89_diff__add__0,axiom,
    ! [M: nat,N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),N),aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),N),M)) = zero_zero(nat) ) ).

tff(fact_90_diffs0__imp__equal,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),N) = zero_zero(nat) )
     => ( ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),N),M) = zero_zero(nat) )
       => ( M = N ) ) ) ).

tff(fact_91_minus__nat_Odiff__0,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),minus_minus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_92_add__eq__self__zero,axiom,
    ! [N: nat,M: nat] :
      ( ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),N) = M )
     => ( N = zero_zero(nat) ) ) ).

tff(fact_93_Nat_Oadd__0__right,axiom,
    ! [M: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),M),zero_zero(nat)) = M ) ).

tff(fact_94_plus__nat_Oadd__0,axiom,
    ! [N: nat] : ( aa(nat,nat,aa(nat,fun(nat,nat),plus_plus(nat),zero_zero(nat)),N) = N ) ).

tff(fact_95_add__0__iff,axiom,
    ! [A: $tType] :
      ( semiri456707255roduct(A)
     => ! [A2: A,B1: A] :
          ( ( B1 = aa(A,A,aa(A,fun(A,A),plus_plus(A),B1),A2) )
        <=> ( A2 = zero_zero(A) ) ) ) ).

tff(fact_96_comm__semiring__1__class_Onormalizing__semiring__rules_I6_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),A1),zero_zero(A)) = A1 ) ) ).

tff(fact_97_comm__semiring__1__class_Onormalizing__semiring__rules_I5_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),plus_plus(A),zero_zero(A)),A1) = A1 ) ) ).

tff(fact_98_comm__semiring__1__class_Onormalizing__semiring__rules_I10_J,axiom,
    ! [A: $tType] :
      ( comm_semiring_1(A)
     => ! [A1: A] : ( aa(A,A,aa(A,fun(A,A),times_times(A),A1),zero_zero(A)) = zero_zero(A) ) ) ).

%----Arities (14)
tff(arity_Nat_Onat___Semiring__Normalization_Ocomm__semiring__1__cancel__crossproduct,axiom,
    semiri456707255roduct(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__ab__semigroup__add,axiom,
    cancel146912293up_add(nat) ).

tff(arity_Nat_Onat___Groups_Ocancel__semigroup__add,axiom,
    cancel_semigroup_add(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__mult,axiom,
    ab_semigroup_mult(nat) ).

tff(arity_Nat_Onat___Groups_Oab__semigroup__add,axiom,
    ab_semigroup_add(nat) ).

tff(arity_Nat_Onat___Rings_Ono__zero__divisors,axiom,
    no_zero_divisors(nat) ).

tff(arity_Nat_Onat___Groups_Ocomm__monoid__add,axiom,
    comm_monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1(nat) ).

tff(arity_Nat_Onat___Rings_Ocomm__semiring,axiom,
    comm_semiring(nat) ).

tff(arity_Nat_Onat___Groups_Omonoid__add,axiom,
    monoid_add(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring__0,axiom,
    semiring_0(nat) ).

tff(arity_Nat_Onat___Rings_Omult__zero,axiom,
    mult_zero(nat) ).

tff(arity_Nat_Onat___Rings_Osemiring,axiom,
    semiring(nat) ).

tff(arity_Nat_Onat___Groups_Ozero,axiom,
    zero(nat) ).

%----Helper facts (14)
tff(help_pp_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_pp_2_1_U,axiom,
    pp(fTrue) ).

tff(help_COMBB_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(B,C)] : ( aa(A,C,combb(B,C,A,P,Q),R) = aa(B,C,P,aa(A,B,Q,R)) ) ).

tff(help_COMBC_1_1_U,axiom,
    ! [A: $tType,C: $tType,B: $tType,R: A,Q: B,P: fun(A,fun(B,C))] : ( aa(A,C,combc(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),Q) ) ).

tff(help_COMBI_1_1_U,axiom,
    ! [A: $tType,P: A] : ( aa(A,A,combi(A),P) = P ) ).

tff(help_COMBK_1_1_U,axiom,
    ! [B: $tType,A: $tType,Q: B,P: A] : ( aa(B,A,combk(A,B,P),Q) = P ) ).

tff(help_COMBS_1_1_U,axiom,
    ! [C: $tType,B: $tType,A: $tType,R: A,Q: fun(A,B),P: fun(A,fun(B,C))] : ( aa(A,C,combs(A,B,C,P,Q),R) = aa(B,C,aa(A,fun(B,C),P,R),aa(A,B,Q,R)) ) ).

tff(help_fTrue_1_1_U,axiom,
    pp(fTrue) ).

tff(help_fTrue_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

tff(help_fconj_1_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(P)
      | ~ pp(Q)
      | pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q)) ) ).

tff(help_fconj_2_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(P) ) ).

tff(help_fconj_3_1_U,axiom,
    ! [Q: bool,P: bool] :
      ( ~ pp(aa(bool,bool,aa(bool,fun(bool,bool),fconj,P),Q))
      | pp(Q) ) ).

tff(help_fFalse_1_1_U,axiom,
    ~ pp(fFalse) ).

tff(help_fFalse_1_1_T,axiom,
    ! [P: bool] :
      ( ( P = fTrue )
      | ( P = fFalse ) ) ).

%----Conjectures (2)
tff(conj_0,hypothesis,
    listsp(dB,it,ts) ).

tff(conj_1,conjecture,
    listsp(dB,it,map(dB,dB,combc(dB,nat,dB,lift,zero_zero(nat)),ts)) ).

%------------------------------------------------------------------------------
